;
;  Seen Script v1.2
;                  by Danaria (dany@mindless.com)
;
;       If you need help, then look for me on DALnet. I can usually be found in #HelpDesk
;   or #IRCHelp. You can always look into the Help File (README.TXT) first though ^_^
;
; Note: If this is run in a very big channel, it might be preferable to clear out the .ini file every
;       once in a while
;
On 1:LOAD:{
  .echo -a 4Hi there! :) Thanks for installing this ~seen script.
  .echo -a If you need any assistance, then look into the Text File that was included in this package.
  .echo -a To see your options, just right click in your Status or any Channel Window. You can also take a look in the Menubar at the top.
  .echo -a I wish you happy IRC'ing :) Enjoy yourself!
}
; The following are the popups in the Status, Menubar and Channel
menu status,menubar,channel {
  Seen Script
  .SeenScript On: .enable #seenscript | .echo -a 9Notice: Seen Script was enabled.
  .SeenScript Off: .disable #seenscript | .echo -a 9Notice: Seen Script was disabled.
  .SeenRecord On: .enable #seenrecord | .echo -a 9Notice: All actions in all channels are now being recorded into seen.ini.
  .SeenRecord Off: .disable #seenrecord | .echo -a 9Notice: No actions will be recorded into seen.ini
}
#seenscript on
; ----------- Checking The Seen.ini File -------------------
On 1:TEXT:!seen *:#:{
  ; if the person looked for is the person running the script
  if ($2 == $me) { 
    /msg $chan $nick $+ , I really think that you need some glasses =) 
    .goto end 
  }
  ; if the person looked for it the searcher
  elseif ($2 == $nick) { 
    /msg $chan $nick $+ , don't tell me that you don't even know what your own nick is?!? 
    .goto end 
  } 
  ; if the person looked for is already in the channel
  elseif ($2 ison $chan) { 
    /msg $chan $nick $+ , why don't you take a look around the channel before looking to me for help? :) $2 is right here in $chan $+ ! 
    .goto end 
  }
  ; otherwise checking into the seen.ini file
  else { 
    if (($right($2,1) == ]) || ($left($2,1) == [)) { .set %seennick $replace($2,[,@) | .set %seennick $replace(%seennick,],~) }
    else { .set %seennick $2 }
    ; [ will turn into @ and ] into ~
    :inifile {
      ; if there is no entry
      .set -u5 %seenaction $readini seen.ini %seennick Action
      if (%seenaction == $null) { /msg $chan Sorry $nick $+ , but I have not seen $2 }
      ; if the last action performed was joining a channel
      if (%seenaction == join) { 
        .set -u5 %jointime $readini seen.ini %seennick Time
        .set -u5 %joinchannel $readini seen.ini %seennick Channel
        /msg $chan $nick $+ , $2 joined %joinchannel $duration($calc($ctime - %jointime)) ago.
      }
      ; if the last action performed was parting a channel
      if (%seenaction == part) { 
        .set -u5 %parttime $readini seen.ini %seennick Time
        .set -u5 %partchannel $readini seen.ini %seennick Channel
        /msg $chan $nick $+ , $2 parted %partchannel $duration($calc($ctime - %parttime)) ago.
      }
      ; if the last action performed was quitting IRC
      if (%seenaction == quit) { 
        .set -u5 %quittime $readini seen.ini %seennick Time
        .set -u5 %quitmessage $readini seen.ini %seennick Message
        /msg $chan $nick $+ , $2 quit IRC with the message %quitmessage $duration($calc($ctime - %quittime)) ago.
      }
      ; if the last action was being kicked from a channel
      if (%seenaction == kick) { 
        .set -u5 %kicktime $readini seen.ini %seennick Time
        .set -u5 %kickchannel $readini seen.ini %seennick Channel
        /msg $chan $nick $+ , $2 was kicked from %kickchannel $duration($calc($ctime - %kicktime)) ago.
      }
      ; if the last action was a nick change
      if (%seenaction == nick) { 
        .set -u5 %nicktime $readini seen.ini %seennick Time
        .set -u5 %nicknew $readini seen.ini %seennick Nick
        /msg $chan $nick $+ , $2 changed his/her nick to %nicknew $duration($calc($ctime - %nicktime)) ago.
      }
      ; if the last action was saying something in a channel
      if (%seenaction == text) { 
        .set -u5 %texttime $readini seen.ini %seennick Time
        .set -u5 %textchannel $readini seen.ini %seennick Channel
        /msg $chan $nick $+ , $2 was last seen saying something in %textchannel $duration($calc($ctime - %texttime)) ago.
      }
      ; if the last action was performing an action in a channel
      if (%seenaction == action) { 
        .set -u5 %actiontime $readini seen.ini %seennick Time
        .set -u5 %actionchannel $readini seen.ini %seennick Channel
        /msg $chan $nick $+ , $2 was last seen performing an action in %actionchannel $duration($calc($ctime - %actiontime)) ago.
      }
    }
  }
  :end
}   
#seenscript end
; ----------- Writing in the Seen.ini File ---------------------
#seenrecord on
; whenever someone joins
On 1:JOIN:#:{
  if (($right($nick,1) == ]) || ($left($nick,1) == [)) { .set %seennick $replace($nick,[,@) | .set %seennick $replace(%seennick,],~) }
  else { .set %seennick $nick }
  ; [ will turn into @ and ] into ~
  .remini seen.ini %seennick
  .writeini seen.ini %seennick Action join
  .writeini seen.ini %seennick Channel $chan 
  .writeini seen.ini %seennick Time $ctime
}
; whenever someone leaves a channel
On 1:PART:#:{
  if (($right($nick,1) == ]) || ($left($nick,1) == [)) { .set %seennick $replace($nick,[,@) | .set %seennick $replace(%seennick,],~) }
  else { .set %seennick $nick }
  .remini seen.ini %seennick
  .writeini seen.ini %seennick Action part
  .writeini seen.ini %seennick Channel $chan
  .writeini seen.ini %seennick Time $ctime
}
; whenever someone quits IRC
On 1:QUIT:{
  if (($right($nick,1) == ]) || ($left($nick,1) == [)) { .set %seennick $replace($nick,[,@) | .set %seennick $replace(%seennick,],~) }
  else { .set %seennick $nick }
  .remini seen.ini %seennick
  .writeini seen.ini %seennick Action quit
  .writeini seen.ini %seennick Time $ctime
  .writeini seen.ini %seennick Message $1-
}
; whenever someone gets kicked
On 1:KICK:#:{
  if (($right($nick,1) == ]) || ($left($nick,1) == [)) { .set %seennick $replace($nick,[,@) | .set %seennick $replace(%seennick,],~) }
  else { .set %seennick $nick }
  .remini seen.ini %seennick
  .writeini seen.ini %seennick Action kick
  .writeini seen.ini %seennick Channel $chan
  .writeini seen.ini %seennick Time $ctime
}
; whenever someone changes nick
On 1:NICK:{
  if (($right($nick,1) == ]) || ($left($nick,1) == [)) { .set %seennick $replace($nick,[,@) | .set %seennick $replace(%seennick,],~) }
  else { .set %seennick $nick }
  .remini seen.ini %seennick
  .writeini seen.ini %seennick Action nick
  .writeini seen.ini %seennick Time $ctime
  .writeini seen.ini %seennick Nick $newnick 
}
; whenever someone says something in a channel
On 1:TEXT:*:#:{
  if (($right($nick,1) == ]) || ($left($nick,1) == [)) { .set %seennick $replace($nick,[,@) | .set %seennick $replace(%seennick,],~) }
  else { .set %seennick $nick }
  .remini seen.ini %seennick
  .writeini seen.ini %seennick Action text
  .writeini seen.ini %seennick Time $ctime
  .writeini seen.ini %seennick Channel $chan
}
; whenever someone performs an action in a channel
On 1:ACTION:*:#:{
  if (($right($nick,1) == ]) || ($left($nick,1) == [)) { .set %seennick $replace($nick,[,@) | .set %seennick $replace(%seennick,],~) }
  else { .set %seennick $nick }
  .remini seen.ini %seennick
  .writeini seen.ini %seennick Action action
  .writeini seen.ini %seennick Time $ctime
  .writeini seen.ini %seennick Channel $chan
}
#seenrecord end
