// spot.c
// Demonstrates a spot light

#include <windows.h>            // Window defines
#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>             // GLU library
#include <gl\glaux.h>			// AUX library objects
#include <math.h>				// Define for sqrt
#include <ddraw.h>
#include "texture.h"
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
//#include "resource.h"           // About box resource identifiers.

#define glRGB(x, y, z)	glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)

struct _POSITION
	{
	GLfloat xPos;				// X position on world grid
	GLfloat zPos;				// Z position on world grid
	GLfloat yPos;
	GLdouble radsFromEast;      // Orientation from direct line east
	};
struct _POSITION Viewer;
HPALETTE hPalette = NULL;
double	 PI =  3.14159265359;
// Application name and instance storeage
static LPCTSTR lpszAppName = "3D Game";
static HINSTANCE hInstance;
int speed = 5;
char text[20];
struct _POSITION LastMouse;
struct _POSITION ThisMouse;
int windowsizex,windowsizey;
int fps = 0;
int lasttime = 0, currenttime = 0;
BOOL justmoved = TRUE;
float lookheight = 0;
// Light values and coordinates
GLfloat	 lightPos[] = { 0.0f, 0.0f, 75.0f, 1.0f };
GLfloat  specular[] = { 1.0f, 1.0f, 1.0f, 1.0f};
GLfloat  specref[] =  { 1.0f, 1.0f, 1.0f, 1.0f };
GLfloat  ambientLight[] = { 0.5f, 0.5f, 0.5f, 1.0f};
GLfloat  spotDir[] = { 0.0f, 0.0f, -1.0f };
LPDIRECTDRAW			Direct;

// Declaration for Window procedure
LRESULT CALLBACK WndProc(   HWND    hWnd,
							UINT    message,
							WPARAM  wParam,
							LPARAM  lParam);

// Dialog procedure for about box
//BOOL APIENTRY AboutDlgProc (HWND hDlg, UINT message, UINT wParam, LONG lParam);

// Set Pixel Format function - forward declaration
void SetDCPixelFormat(HDC hDC);
/*
BOOL InitInput( void )
{
    HRESULT     hr;

    // Create DirectInput object.
    hr = DirectInputCreate( hInstance, DIRECTINPUT_VERSION, &DirectInput, NULL );
    if ( FAILED( hr ) )
    {
        MessageBox( g_hMainWnd, "Failed to initialize DirectInput.", "Error", 
                    MB_ICONERROR | MB_OK );
        return FALSE;
    }

    return TRUE;    
}  // InitInput()
*/
void MoveViewer(GLdouble dStep)
	{
	GLdouble xDelta,zDelta;

	/*xDelta = dStep*cos(Viewer.radsFromEast);
	zDelta = -dStep*sin(Viewer.radsFromEast);

	Viewer.xPos += (float)xDelta;
	Viewer.zPos += (float)zDelta;*/

	Viewer.yPos += (float)dStep*sin(atan(lookheight/50));
	xDelta = (float)dStep*cos(atan(lookheight/50));
	Viewer.xPos += (float)xDelta*cos(Viewer.radsFromEast);
	Viewer.zPos += (float)-xDelta*sin(Viewer.radsFromEast);

	if(Viewer.xPos > 1000.0f)
		Viewer.xPos = 1000.0f;

	if(Viewer.xPos < -1000.0f)
		Viewer.xPos = -1000.0f;

	
	if(Viewer.zPos > 1000.0f)
		Viewer.zPos = 1000.0f;

	if(Viewer.zPos < -1000.0f)
		Viewer.zPos = -1000.0f;

	if(Viewer.yPos > 1000.0f)
		Viewer.yPos = 1000.0f;

	if(Viewer.yPos < -1000.0f)
		Viewer.yPos = -1000.0f;


	}
// Change viewing volume and viewport.  Called when window is resized
void ChangeSize(GLsizei w, GLsizei h)
{
	int nWidth,nHeight;
	double dAspect;
	
	nWidth = w;  // width of client area 
	nHeight = h; // height of client area 
	
	if(nHeight == 0)                  // Don't allow divide by zero
		nHeight = 1;
	
	dAspect = (double)nWidth/(double)nHeight;
	
	// Make this rendering context current
	
	// Set the viewport to be the entire window
	glViewport(0, 0, nWidth, nHeight);
	
	// Setup Perspective
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	
	// Establish viewing volume
	gluPerspective(35.0, dAspect,1, 2000);
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

void DrawGround(void)
	{
	int r,c;
	int nStep = 30;

	glBegin(GL_LINES);

	for(r = -1000; r  <= 1000; r += nStep)
		{
		glVertex3f((float)r, 0.0f, -1000.0f);
		glVertex3f((float)r, 0.0f, 1000.0f);
		}

	for(c = -1000; c <= 1000; c += nStep)
		{
		glVertex3f(1000.0f, 0.0f, (float)c);
		glVertex3f(-1000.0f, 0.0f, (float)c);
		}
	for(r = -1000; r  <= 1000; r += nStep)
		{
		glVertex3f((float)r, -1000.0f, 0.0f);
		glVertex3f((float)r, 1000.0f, 0.0f);
		}

	for(c = -1000; c <= 1000; c += nStep)
		{
		glVertex3f(1000.0f, (float)c, 0);
		glVertex3f(-1000.0f, (float)c, 0);
		}

	glEnd();
	}





// This function does any needed initialization on the rendering
// context.  Here it sets up and initializes the lighting for
// the scene.
void SetupRC()
	{
	// Black background
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f );


	// Just draw the outlines of the polygons
	glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
	glEnable(GL_DEPTH_TEST);
	// Enable color tracking
	glEnable(GL_COLOR_MATERIAL);
	
	// Set Material properties to follow glColor values
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
	glNewList(1,GL_COMPILE);
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glRGB(0,255,0);
	glShadeModel(GL_SMOOTH);
	//glDisable(GL_DEPTH_TEST);
	DrawGround();

	glEnable(GL_TEXTURE_2D);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	if(TextureLoadBitmap("rock.bmp") != 0)
		MessageBox(NULL,"Could not load Texture",NULL,MB_OK | MB_ICONINFORMATION);

	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
	/*static GLint s_vector[4] = {1,0,0,0};
	static GLint t_vector[4] = {0,0,0,0};
	//static GLint r_vector[4] = {1,1,0,0};

	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
	glTexGeniv(GL_S, GL_OBJECT_PLANE, s_vector);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
	glTexGeniv(GL_T, GL_OBJECT_PLANE, t_vector);
	//glTexGeni(GL_R, GL_TEXTURE_GEN_MODE, GL_OBJECT_LINEAR);
	//glTexGeniv(GL_R, GL_OBJECT_PLANE, r_vector);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
	//glEnable(GL_TEXTURE_GEN_R);
	//glEnable(GL_DEPTH_TEST);*/
	glBegin(GL_QUADS);
		//glColor3ub(0,0,255);
		int size = 4;
		glTexCoord2f(0.0f,0.0f);
		glVertex3f(0, 0.0f, 0);
		glTexCoord2f(50.0f/size,0.0f);
		glVertex3f(0, 0.0f, 50);
		glTexCoord2f(50.0f/size,10.0f/size);
		glVertex3f(0, 10, 50);
		glTexCoord2f(0.0f,10.0f/size);
		glVertex3f(0, 10.0f, 0);
		//glTexCoord2f(0.0f,0.0f);
		////////////////////////
		//glColor3ub(255,0,255);
	glEnd();
	glBegin(GL_QUADS);
		if(TextureLoadBitmap("rock2.bmp") != 0)
			MessageBox(NULL,"Could not load Texture",NULL,MB_OK | MB_ICONINFORMATION);
		glTexCoord2f(0.0f,0.0f);
		glVertex3f(0, 0, 0);
		glTexCoord2f(0.0f,10.0f/size);
		glVertex3f(0, 10, 0);
		glTexCoord2f(200.0f/size,10.0f/size);
		glVertex3f(200, 10, 0);
		glTexCoord2f(200.0f/size,0.0f);
		glVertex3f(200, 0, 0);
		////////////////////////
		//glColor3ub(0,255,255);
		glTexCoord2f(0.0f,0.0f);
		glVertex3f(0, 0, 50);
		glTexCoord2f(0.0f,10.0f/size);
		glVertex3f(0, 10, 50);
		glTexCoord2f(200.0f/size,10.0f/size);
		glVertex3f(200, 10, 50);
		glTexCoord2f(200.0f/size,0.0f);
		glVertex3f(200, 0, 50);
		////////////////////////
		//glColor3ub(255,0,0);
	glEnd();
	glBegin(GL_QUADS);
		if(TextureLoadBitmap("rock3.bmp") != 0)
			MessageBox(NULL,"Could not load Texture",NULL,MB_OK | MB_ICONINFORMATION);
		glTexCoord2f(0.0f,0.0f);
		glVertex3f(0, 10, 0);
		glTexCoord2f(200.0f/size,0.0f);
		glVertex3f(200, 10, 0);
		glTexCoord2f(200.0f/size,50.0f/size);
		glVertex3f(200, 10, 50);
		glTexCoord2f(0.0f,50.0f/size);
		glVertex3f(0, 10, 50);
		////////////////////////
		glTexCoord2f(0.0f,0.0f);
		glVertex3f(0, 0, 100);
		glTexCoord2f(200.0f/size,0.0f);
		glVertex3f(0, 0, 200);
		glTexCoord2f(200.0f/size,sqrt(2*(50*50))/size);
		glVertex3f(50, 50, 200);
		glTexCoord2f(0.0f,sqrt(2*(50*50))/size);
		glVertex3f(50, 50, 100);
	glEnd();
	glEndList();
	}
// Called to draw scene
void RenderScene(void)
	{
	glCallList(1);
	// Flush drawing commands
	glFlush();
	glDisable(GL_TEXTURE_2D);
	}


// Select the pixel format for a given device context
void SetDCPixelFormat(HDC hDC)
	{
	int nPixelFormat;

	static PIXELFORMATDESCRIPTOR pfd = {
		sizeof(PIXELFORMATDESCRIPTOR),  // Size of this structure
		1,                                                              // Version of this structure    
		PFD_DRAW_TO_WINDOW |                    // Draw to Window (not to bitmap)
		PFD_SUPPORT_OPENGL |					// Support OpenGL calls in window
		PFD_DOUBLEBUFFER,                       // Double buffered
		PFD_TYPE_RGBA,                          // RGBA Color mode
		24,                                     // Want 24bit color 
		0,0,0,0,0,0,                            // Not used to select mode
		0,0,                                    // Not used to select mode
		0,0,0,0,0,                              // Not used to select mode
		32,                                     // Size of depth buffer
		0,                                      // Not used to select mode
		0,                                      // Not used to select mode
		PFD_MAIN_PLANE,                         // Draw in main plane
		0,                                      // Not used to select mode
		0,0,0 };                                // Not used to select mode

	// Choose a pixel format that best matches that described in pfd
	nPixelFormat = ChoosePixelFormat(hDC, &pfd);

	// Set the pixel format for the device context
	SetPixelFormat(hDC, nPixelFormat, &pfd);
	}



// If necessary, creates a 3-3-2 palette for the device context listed.
HPALETTE GetOpenGLPalette(HDC hDC)
	{
	HPALETTE hRetPal = NULL;	// Handle to palette to be created
	PIXELFORMATDESCRIPTOR pfd;	// Pixel Format Descriptor
	LOGPALETTE *pPal;			// Pointer to memory for logical palette
	int nPixelFormat;			// Pixel format index
	int nColors;				// Number of entries in palette
	int i;						// Counting variable
	BYTE RedRange,GreenRange,BlueRange;
								// Range for each color entry (7,7,and 3)


	// Get the pixel format index and retrieve the pixel format description
	nPixelFormat = GetPixelFormat(hDC);
	DescribePixelFormat(hDC, nPixelFormat, sizeof(PIXELFORMATDESCRIPTOR), &pfd);

	// Does this pixel format require a palette?  If not, do not create a
	// palette and just return NULL
	if(!(pfd.dwFlags & PFD_NEED_PALETTE))
		return NULL;

	// Number of entries in palette.  8 bits yeilds 256 entries
	nColors = 1 << pfd.cColorBits;	

	// Allocate space for a logical palette structure plus all the palette entries
	pPal = (LOGPALETTE*)malloc(sizeof(LOGPALETTE) +nColors*sizeof(PALETTEENTRY));

	// Fill in palette header 
	pPal->palVersion = 0x300;		// Windows 3.0
	pPal->palNumEntries = nColors; // table size

	// Build mask of all 1's.  This creates a number represented by having
	// the low order x bits set, where x = pfd.cRedBits, pfd.cGreenBits, and
	// pfd.cBlueBits.  
	RedRange = (1 << pfd.cRedBits) -1;
	GreenRange = (1 << pfd.cGreenBits) - 1;
	BlueRange = (1 << pfd.cBlueBits) -1;

	// Loop through all the palette entries
	for(i = 0; i < nColors; i++)
		{
		// Fill in the 8-bit equivalents for each component
		pPal->palPalEntry[i].peRed = (i >> pfd.cRedShift) & RedRange;
		pPal->palPalEntry[i].peRed = (unsigned char)(
			(double) pPal->palPalEntry[i].peRed * 255.0 / RedRange);

		pPal->palPalEntry[i].peGreen = (i >> pfd.cGreenShift) & GreenRange;
		pPal->palPalEntry[i].peGreen = (unsigned char)(
			(double)pPal->palPalEntry[i].peGreen * 255.0 / GreenRange);

		pPal->palPalEntry[i].peBlue = (i >> pfd.cBlueShift) & BlueRange;
		pPal->palPalEntry[i].peBlue = (unsigned char)(
			(double)pPal->palPalEntry[i].peBlue * 255.0 / BlueRange);

		pPal->palPalEntry[i].peFlags = (unsigned char) NULL;
		}
		

	// Create the palette
	hRetPal = CreatePalette(pPal);

	// Go ahead and select and realize the palette for this device context
	SelectPalette(hDC,hRetPal,FALSE);
	RealizePalette(hDC);

	// Free the memory used for the logical palette structure
	free(pPal);

	// Return the handle to the new palette
	return hRetPal;
	}


// Entry point of all Windows programs
int APIENTRY WinMain(   HINSTANCE       hInst,
						HINSTANCE       hPrevInstance,
						LPSTR           lpCmdLine,
						int                     nCmdShow)
	{
	MSG                     msg;            // Windows message structure
	WNDCLASS        wc;                     // Windows class structure
	HWND            hWnd;           // Storeage for window handle

	hInstance = hInst;

	// Register Window style
	wc.style                        = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc          = (WNDPROC) WndProc;
	wc.cbClsExtra           = 0;
	wc.cbWndExtra           = 0;
	wc.hInstance            = hInstance;
	wc.hIcon                        = NULL;
	wc.hCursor                      = LoadCursor(NULL, IDC_ARROW);
	
	// No need for background brush for OpenGL window
	wc.hbrBackground        = NULL;         
	
	//wc.lpszMenuName         = MAKEINTRESOURCE(IDR_MENU);
	wc.lpszClassName        = lpszAppName;

	// Register the window class
	if(RegisterClass(&wc) == 0)
		return FALSE;
	DEVMODE deviceMode;
	HWND hDesktop = GetDesktopWindow();
	HDC  hDCDesk = GetDC(hDesktop);
	deviceMode.dmSize = sizeof(DEVMODE);
	deviceMode.dmBitsPerPel = GetDeviceCaps(hDCDesk,BITSPIXEL);
	ReleaseDC(hDesktop,hDCDesk);
	deviceMode.dmPelsWidth = 640;
	deviceMode.dmPelsHeight = 480;
	deviceMode.dmFields = DM_BITSPERPEL	| DM_PELSWIDTH | DM_PELSHEIGHT;
	
	ChangeDisplaySettings(&deviceMode,0) == DISP_CHANGE_SUCCESSFUL;

	// Create the main application window
	hWnd = CreateWindow(
				lpszAppName,
				lpszAppName,
				
				// OpenGL requires WS_CLIPCHILDREN and WS_CLIPSIBLINGS
				WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_POPUP | WS_VISIBLE,
	
				// Window position and size
				0, 0,
				640, 480,
				NULL,
				NULL,
				hInstance,
				NULL);

	// If window was not created, quit
	if(hWnd == NULL)
		return FALSE;
	Viewer.xPos = 0.0f;
	Viewer.zPos = 0.0f;
	Viewer.yPos = 5;
	LastMouse.xPos = 0;
	LastMouse.zPos = 0;
	Viewer.radsFromEast = 0.0;	// Facing due east
	

	// Display the window
	ShowWindow(hWnd,SW_SHOW);
	UpdateWindow(hWnd);
	ShowCursor(FALSE);
	// Process application messages until the application closes
	while( GetMessage(&msg, NULL, 0, 0))
		{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		InvalidateRect(hWnd,NULL,FALSE);
		}

	return msg.wParam;
	}




// Window procedure, handles all messages for this program
LRESULT CALLBACK WndProc(       HWND    hWnd,
							UINT    message,
							WPARAM  wParam,
							LPARAM  lParam)
	{
	static HGLRC hRC;               // Permenant Rendering context
	static HDC hDC;                 // Private GDI Device context

	switch (message)
		{
		// Window creation, setup for OpenGL
		case WM_CREATE:
			// Store the device context
			hDC = GetDC(hWnd);              

			// Select the pixel format
			SetDCPixelFormat(hDC);          

			hPalette = GetOpenGLPalette(hDC);

			// Create the rendering context and make it current
			hRC = wglCreateContext(hDC);
			wglMakeCurrent(hDC, hRC);
			SetupRC();

			break;

		// Window is being destroyed, cleanup
		case WM_DESTROY:
			// Deselect the current rendering context and delete it
			wglMakeCurrent(hDC,NULL);
			wglDeleteContext(hRC);

			if(hPalette != NULL)
				DeleteObject(hPalette);
			ReleaseDC(hWnd,hDC);

			// Restores the display settings
			ChangeDisplaySettings(NULL,0);
			// Tell the application to terminate after the window
			// is gone.
			PostQuitMessage(0);
			break;

		// Window is resized.
		case WM_SIZE:
			// Call our function which modifies the clipping
			// volume and viewport
			wglMakeCurrent(hDC, hRC);
			ChangeSize(LOWORD(lParam), HIWORD(lParam));
			windowsizex = LOWORD(lParam);
			windowsizey = HIWORD(lParam);
			wglMakeCurrent(hDC,NULL);
			break;


		// The painting function.  This message sent by Windows 
		// whenever the screen needs updating.
		case WM_PAINT:
			{
			fps++;
			currenttime = (unsigned)time(NULL);
			if (currenttime - lasttime >= 1)
			{
				SetBkColor (hDC, RGB(0,0,0));
				SetTextColor(hDC, RGB(255,255,255));
				itoa(fps,text, 10);
				fps = 0;
				lasttime = currenttime;
			}
			TextOut(hDC,0,windowsizey-20,text,strlen(text));
			float fRadius = 50.0f;

			wglMakeCurrent(hDC, hRC);

			// Clear the window with current clearing color
			glClear(GL_COLOR_BUFFER_BIT);

			glPushMatrix();

			// Handy dandy little function
			gluLookAt(Viewer.xPos, Viewer.yPos, Viewer.zPos,   // Eye Position (x,y,z)
				Viewer.xPos + (fRadius*(float)cos(Viewer.radsFromEast)), // Center X
				Viewer.yPos+lookheight,                                                                                                                   // Center Y
				Viewer.zPos - (fRadius*(float)sin(Viewer.radsFromEast)), // Center Z
	
				0.0f, 1.0f, 0.0f);                                                 // Up is straight up Y axis


			RenderScene();

			glPopMatrix();

			SwapBuffers(hDC);

			// Validate the newly painted client area
			ValidateRect(hWnd,NULL);
			}
			break;

		// Windows is telling the application that it may modify
		// the system palette.  This message in essance asks the 
		// application for a new palette.
		case WM_QUERYNEWPALETTE:
			// If the palette was created.
			if(hPalette)
				{
				int nRet;

				// Selects the palette into the current device context
				SelectPalette(hDC, hPalette, FALSE);

				// Map entries from the currently selected palette to
				// the system palette.  The return value is the number 
				// of palette entries modified.
				nRet = RealizePalette(hDC);

				// Repaint, forces remap of palette in current window
				InvalidateRect(hWnd,NULL,FALSE);

				return nRet;
				}
			break;

	
		// This window may set the palette, even though it is not the 
		// currently active window.
		case WM_PALETTECHANGED:
			// Don't do anything if the palette does not exist, or if
			// this is the window that changed the palette.
			if((hPalette != NULL) && ((HWND)wParam != hWnd))
				{
				// Select the palette into the device context
				SelectPalette(hDC,hPalette,FALSE);

				// Map entries to system palette
				RealizePalette(hDC);
				
				// Remap the current colors to the newly realized palette
				UpdateColors(hDC);
				return 0;
				}
			break;

		// Key press, check for arrow keys to do cube rotation.
		case WM_KEYDOWN:
			{
				switch(wParam)
				{
				case VK_UP:		// Up arrow, move forward
					{
					MoveViewer(speed);					
					break;
					}

				case VK_DOWN: // Down arrow, move backward
					{
					MoveViewer(-speed);
					break;
					}

				case VK_LEFT:		// Left arrow, turn left
					{
					Viewer.radsFromEast += PI/30.0f; 

					if(Viewer.radsFromEast > (2.0*PI))		// Keep in bounds
						Viewer.radsFromEast = 0.0;
			
					break;
					}
		
				case VK_RIGHT:		// Right Arrow, turn right
					{
					Viewer.radsFromEast -= PI/30.0; 
				
					if(Viewer.radsFromEast < 0.0)
						Viewer.radsFromEast = (2.0*PI);	// Keep in bounds
					
					break;
					}
				case VK_F1:		// Right Arrow, turn right
					{
					speed++;
					break;
					}
				case VK_F2:		// Right Arrow, turn right
					{
					speed--;
					if(speed < 1)
						speed = 1;
					break;
					}
				}
			InvalidateRect(hWnd,NULL,FALSE);
			if(wParam == VK_F12)
				DestroyWindow(hWnd);
			}
			break;
		case WM_MOUSEMOVE:
			{
				if(!justmoved)
				{
					ThisMouse.xPos = LOWORD(lParam);
					ThisMouse.zPos = HIWORD(lParam);
					if(ThisMouse.xPos<LastMouse.xPos)
					{
						Viewer.radsFromEast += PI/720.0f*(LastMouse.xPos-ThisMouse.xPos); 
						
						if(Viewer.radsFromEast > (2.0*PI))		// Keep in bounds
							Viewer.radsFromEast = 0.0;
						
					}
					if(ThisMouse.xPos>LastMouse.xPos)
					{
						Viewer.radsFromEast -= PI/720.0*(ThisMouse.xPos-LastMouse.xPos); 
						
						if(Viewer.radsFromEast < 0.0)
							Viewer.radsFromEast = (2.0*PI);	// Keep in bounds
						
					}
					if(ThisMouse.zPos<LastMouse.zPos)
					{
						lookheight+=(LastMouse.zPos-ThisMouse.zPos)/10;
						
					}
					if(ThisMouse.zPos>LastMouse.zPos)
					{
						lookheight-=(ThisMouse.zPos-LastMouse.zPos)/10;
						
					}
					LastMouse.xPos = (int)(windowsizex/2);//ThisMouse.xPos;
					LastMouse.zPos = (int)(windowsizey/2);//ThisMouse.zPos;
					SetCursorPos(windowsizex/2,windowsizey/2);
					InvalidateRect(hWnd,NULL,FALSE);
					justmoved = TRUE;
				}
				else
					justmoved = FALSE;
				
			}
			break;
	default:   // Passes it on if unproccessed
	    return (DefWindowProc(hWnd, message, wParam, lParam));

	}

    return (0L);
	}
