#include<stdio.h>
#include<conio.h>
#include<stdlib.h>

unsigned char TGAHdrData[2048];
int width;
int height;


struct TGAHdrType {
	short int       NumOfBytInId;
	short int       ColorMapType;
	short int       ImageTypeCode;
	unsigned int    ColorMapOrigin;
	unsigned int    ColorMapLength;
	short int       ColorMapEntrySize;
	unsigned int    XStart;
	unsigned int    YStart;
	unsigned int    Width;
	unsigned int    Height;
	short int       PixelSize;
	short int       ImageDescriptor;
	unsigned int    PaletteStart;
	unsigned int    DataStart;

};


void putpixel(int x,int y,unsigned char color)
{
asm{
	mov     ax,0a000h
	mov     es,ax
	mov     ax,y
	mov     di,ax
	xchg ah,al
	shl  di,6
	add  di,ax
	add  di,x
	mov     al,color
	stosb
}
}

unsigned char getpixel(int x,int y)
{
asm{
	mov     ax,0a000h
	mov     es,ax
	mov     ax,[y]
	mov     di,ax
	xchg ah,al
	shl  di,6
	add  di,ax
	add  di,[x]
	mov  al,[es:di]
}
return(_AL);
}


void setpal(unsigned char*palett)
{
int i;

outp(0x3c8,0);
for(i=0;i<256*3;i++)
	outp(0x3c9,palett[i]);
}


void read_TGAHdr(struct TGAHdrType * TGAHdr, char * filename)
{
	 FILE *fs;

	 if (!(fs = fopen(filename, "rb")))
		{
		printf("Can't open the file %s\n",filename);
		exit(1);
		}

	 if (fread(TGAHdrData, 786, 1, fs) != 1)
		{
		printf("Can't read the TGA-header");
		exit(1);
		}

	 TGAHdr->NumOfBytInId      = TGAHdrData[0];
	 TGAHdr->ColorMapType      = TGAHdrData[1];
	 TGAHdr->ImageTypeCode     = TGAHdrData[2];
	 TGAHdr->ColorMapOrigin    = TGAHdrData[3]+256*TGAHdrData[4];
	 TGAHdr->ColorMapLength    = TGAHdrData[5]+256*TGAHdrData[6];
	 TGAHdr->ColorMapEntrySize = TGAHdrData[7];
	 TGAHdr->XStart            = TGAHdrData[8]+256*TGAHdrData[9];
	 TGAHdr->YStart            = TGAHdrData[10]+256*TGAHdrData[11];
	 TGAHdr->Width             = TGAHdrData[12]+256*TGAHdrData[13];
	 TGAHdr->Height            = TGAHdrData[14]+256*TGAHdrData[15];
	 TGAHdr->PixelSize         = TGAHdrData[16];
	 TGAHdr->ImageDescriptor   = TGAHdrData[17];
	 TGAHdr->PaletteStart      = 18 + TGAHdr->NumOfBytInId;
	 TGAHdr->DataStart         = 18 + TGAHdr->NumOfBytInId + 3 * TGAHdr->ColorMapLength;

	 fclose(fs);
}


void TGAHdr_to_pal_256(struct TGAHdrType TGAHdr,unsigned char*pal)
{
	 int p; /* loopcounter */
	 int red, green, blue; /* to set the palett */

	 for (p=0; p<256; p++)
	 {
		red   = (TGAHdrData[TGAHdr.PaletteStart+2+(p*3)]);
		green = (TGAHdrData[TGAHdr.PaletteStart+1+(p*3)]);
		blue  = (TGAHdrData[TGAHdr.PaletteStart+0+(p*3)]);

		pal[p*3]=red>>2;         /* red/4 */
		pal[p*3+1]=green>>2;
		pal[p*3+2]=blue>>2;
	 }
setpal(pal);
}



void show_TGA_image_256_uncom(struct TGAHdrType TGAHdr, char * filename, int xpos, int ypos)
{
	 int i, j, rad; /* loopcounters */

	 FILE *fs;

	 if (!(fs = fopen(filename, "rb")))
		{
		printf("Can't open the file\n");
		exit(1);
		}

	/* set the file pointer */
	fseek(fs, TGAHdr.DataStart, SEEK_SET);

	if ((TGAHdr.ImageDescriptor&32)==32) {
		/* draw down up */
		rad=ypos;
		for (i=ypos; i<ypos+TGAHdr.Height; i++)
		{
			/* read one row */
			fread(TGAHdrData, TGAHdr.Width, 1, fs);
			/* draw the row */
			for (j=0; j < TGAHdr.Width; j++)
			{
				putpixel(xpos+j,i,TGAHdrData[j]);
			}
		}
	}
	else {
		rad=ypos+TGAHdr.Height;
		for (i=rad; i>rad-TGAHdr.Height; i--)
		{

			fread(TGAHdrData, TGAHdr.Width, 1, fs);
			for (j=0; j < TGAHdr.Width; j++)
			{
				putpixel(xpos+j,i-1,TGAHdrData[j]);
			}
		}
	}
	fclose(fs);
}

void show_TGA_image_256_rle(struct TGAHdrType TGAHdr, char * filename, int xpos, int ypos)
{
	int rad, kol, dir, i;
	char pakethdr;
	short int pakettyp;
	short int hdrnumber;
	short int rlecolor;

	FILE *fs;

	if (!(fs = fopen(filename, "rb")))
	{
		printf("can't open the file\n");
		exit(1);
	}

	fseek(fs, TGAHdr.DataStart, SEEK_SET);

	/* Brja i vre eller undre vnstra hrnet;Kolla bit 5 */
	if ((TGAHdr.ImageDescriptor&32)==32) {
		rad=ypos;
		dir=1;
	}
	else {
		rad=ypos+TGAHdr.Height;
		dir=-1;
	}

	kol=0;

	while (!feof(fs)) {
		/* read packet head */
		fread(&pakethdr, 1, 1, fs);
		pakettyp = pakethdr&128;
		hdrnumber = pakethdr&127;
		if (pakettyp==0) {
			/* Read raw_body */
			fread(TGAHdrData, hdrnumber+1, 1, fs);
			/* Draw packet */
			for (i=0; i<hdrnumber+1; i++) {
				putpixel(xpos+kol,rad,TGAHdrData[i]);
				kol++;
				if ((kol%TGAHdr.Width==0) && (kol!=0)) {
					rad=rad+dir;
					kol=0;
				}
			}
		}
		else {
			/* Read rle_body */
			fread(&rlecolor, 1, 1, fs);
			/* Draw packet */
			for (i=0; i<hdrnumber+1; i++) {
				putpixel(xpos+kol,rad,rlecolor);
				kol++;
				if ((kol%TGAHdr.Width==0) && (kol!=0)) {
					rad=rad+dir;
					kol=0;
				}
			}
		}
	}
	fclose(fs);
}


void ViewTgaNGetPal(char*image, unsigned char*pal)
{
	struct TGAHdrType TGAHdr;

	/* read tga header */
	read_TGAHdr(&TGAHdr,image);
	width=TGAHdr.Width;
	height=TGAHdr.Height;

	switch (TGAHdr.ImageTypeCode)
	{
		case 1:
			TGAHdr_to_pal_256(TGAHdr,pal);
			show_TGA_image_256_uncom(TGAHdr,image,0,0);
			break;
		case 9:
			TGAHdr_to_pal_256(TGAHdr,pal);
			show_TGA_image_256_rle(TGAHdr,image,0,0);
			break;

		default:
			printf("\nI can't handle this TGA format!\n");
	}
}
