        .MODEL small

        .DATA

	foo     dw      ?       ;foo & bar are temporary variables
	bar     dw      ?       ;they are used if the registers aint enough
	string  db      2000 dup (?)     ;used by outstr

        .CODE
        .386                   ;allow 386 instr. (movsd)
				;functions begins with _ then the name
	PUBLIC  _show32spr      ;call with   show32spr(x,y,sprite,dest);
	PUBLIC  _showspr      	;   ' '      showspr(x,y,sprite,dest);
	PUBLIC  _showtrans      ;   ' '      showtrans(x,y,sprite,dest);
	PUBLIC  _erase32bit     ;   ' '      erase32bit(x,y,width,height,dest);
	PUBLIC  _getback32      ;   ' '      getback32(x,y,wijd,hoog,source,dest);
	PUBLIC  _wtsync         ;   ' '      wtsync();
	PUBLIC  _setmode        ;   ' '      setmode(grafixmode);
	PUBLIC  _putpixel       ;   ' '      putpixel(x,y,color,dest);
	PUBLIC  _loadpalett     ;   ' '      loadpalett("name", pal);
	PUBLIC  _loadsprite     ;   ' '      loadsprite("name", spr);
	PUBLIC  _flip64k        ;   ' '      flip64k(source,dest);
	PUBLIC  _alloc          ;   ' '      virt=malloc(64000);
	PUBLIC  _vrij           ;   ' '      free(virt);
	PUBLIC  _outstr
	PUBLIC  _screenadr


_screenadr PROC  NEAR
        xor     ax,ax
        mov     dx,0a000h
        ret
ENDP    _screenadr
        
;outstr prints a string on the screen using dos int 21h function 9
;The string ends with $ or 0 (if 0, it is changed to a $)
;void outstr(char far*str);
_outstr PROC strin:Dword
	push    bp
	mov     bp,sp
	push    ds              ;save these registers
	push    si
	push    di
        lds     si,[strin]        ;ds:si = str
        mov     di,OFFSET string
	mov     dx,di
	mov     ax,SEG string   ;es:di = string
	mov     es,ax
@@lp:   mov     al,[si]         ;copy str to local array string
        SEGES   mov [di],al
	cmp     al,0            ;copy until a 0 or a $ sign appears
	jz      @@ch
	cmp     al,'$'
	jz      @@print
	inc     si
	inc     di
	jmp     @@lp
@@ch:   mov     al,'$'          ;if it was 0 replace with $ in string
        SEGES mov [di],al
@@print:push    es
	pop     ds              ;ds:dx = beginning of string
	mov     ah,9            ;call dos int 21 func 9, print string
	int     21h
	pop     di              ;restore di, si, ds & bp
	pop     si
	pop     ds
	pop     bp
	ret
ENDP    _outstr

;**************************************************************************
;*** int loadpalett(char far*name,char far*pal);                        ***
;*** Destroys: ax,bx,cx,dx   return:1 OK 0:error                        ***
;**************************************************************************
_loadpalett PROC NEAR naam:Dword, pal:Dword
	push    bp
	mov     bp,sp
	push    ds
	lds     dx,[naam]       ;ds:dx points to the filename
	mov     ax,3d00h        ;open for reading only
	int     21h             ;open
	jc      @@errr          ;if error jump to errr
	mov     bx,ax           ;bx=filehandle
	lds     dx,[pal]        ;read to pal
	mov     cx,256*3        ;read the entire palette to pal
	mov     ah,3fh          ;dos read file
	int     21h
	jc      @@errr
	mov     ah,3eh          ;dos close file
	int     21h
	mov     ax,1            ;ax = 1, no error
	jmp     @@exit
@@errr: xor     ax,ax           ;ax = 0 error
@@exit: pop     ds
	pop     bp
	ret
ENDP    _loadpalett

;**************************************************************************
;*** int loadsprite(char far*name,char far*spr);                        ***
;*** Destroys: ax,bx,cx,dx   return:1 OK 0:error                        ***
;**************************************************************************
_loadsprite PROC naam:Dword, spr:Dword
	push    bp
	mov     bp,sp
	push    ds
	push    si

	lds     dx,[naam]       ;ds:dx points to the filename
	mov     ax,3d00h        ;open for reading
	int     21h             ;open
	jc      @@err           ;if error, jump to err
	mov     bx,ax           ;bx=filehandle

	lds     dx,[spr]        ;read to spr
volgend:mov     cx,4            ;read the head of spr
	mov     ah,3fh          ;dos read file
	int     21h
	jc      @@err
	mov     si,dx
	mov     ax,[si]         ;height to ax
	inc     dx
	inc     dx
	mov     si,dx
	mov     cx,[si]
	xchg    ax,cx
	mul     cl              ;ax=height*width
	cmp	ax,0
	jz	einde
	mov     cx,ax
	mov     ax,3f00h        ;dos readfile
	inc     dx
	inc     dx
	int     21h
	jc      @@err
	add	dx,cx		;add dx woth the number of bytes read

	jmp	volgend

einde:	mov     ah,3eh          ;dos close file
	int     21h
	mov     ax,1            ;ax = 1, no error
        jmp     @@exit1
@@err:  xor     ax,ax           ;ax = 0 error
@@exit1: pop     si
	pop     ds
	pop     bp
	ret
ENDP    _loadsprite


;************************************************************************
;* void putpixel(int x, int y,char color,char far*dest);                *
;* Register: ax                                                         *
;************************************************************************
_putpixel PROC xpos:Word, ypos:Word, color:Byte, dest:Dword
        push    bp
        mov     bp,sp
        push    di
        les     di,[dest]
        mov     di,[xpos]
	mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di
        mov     al,[color]
        SEGES mov [di],al
        pop     di
        pop     bp
        ret
ENDP    _putpixel

;************************************************************************
;* void show32spr( int xpos, int ypos, char far*sprite, char far*dest); *
;* Register: ax,bx,cx,dx                                                *
;* width of dest must be 320 bytes                                      *
;* draws sprite at dest at (xpos,ypos)                                  *
;************************************************************************
_show32spr PROC xpos:Word, ypos:Word, sprite:Dword, dest:Dword        
        push    bp
	mov     bp,sp
        push    ds    
        push    si
        push    di
        lds     si,[sprite]     ;ds:si = sprite
        les     di,[dest]       ;es:di = destination
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di

;get the proportions from the head
        lodsw                   ;height to ax
        mov     dx,ax           ;height to dx
        or      ax,ax
        jz      @@endspr        ;if height 0 draw nothing
        lodsw                   ;width to ax
        mov     bx,320          ;bx = pix/row
        sub     bx,ax           ;bx = incr (# of bytes to next row)
        shr     ax,2            ;ax = width/4

;draw the sprite
@@Loop32:
        mov     cx,ax           ;# of Dword per row to cx
        rep     movsd           ;move one spriterow from ds:si to es:di
        add     di,bx           ;di:=next row
        dec     dx
        jnz     @@Loop32        ;loopa through all rows
@@endspr:
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _show32spr

;************************************************************************
;* void showspr( int xpos, int ypos, char far*sprite, char far*dest); *
;* Register: ax,bx,cx,dx                                                *
;* width of dest must be 320 bytes                                      *
;* draws sprite at dest at (xpos,ypos)                                  *
;************************************************************************
_showspr PROC xpos:Word, ypos:Word, sprite:Dword, dest:Dword        
        push    bp
	mov     bp,sp
        push    ds    
        push    si
        push    di
        lds     si,[sprite]     ;ds:si = sprite
        les     di,[dest]       ;es:di = destination
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di

;get the proportions from the head
        lodsw                   ;height to ax
        mov     dx,ax           ;height to dx
        or      ax,ax
        jz      @@endspr1        ;if height 0 draw nothing
        lodsw                   ;width to ax
        mov     bx,320          ;bx = pix/row
        sub     bx,ax           ;bx = incr (# of bytes to next row)

        shl     eax,16          ;save width in high word of eax
;draw sprite
@@Lp1:  shr     eax,16          ;width => ax
        mov     cx,ax           ;bytes/row => cx
        shl     eax,16          ;save in high word
@@Lp2:  SEGDS   mov al,[si]      ;load one byte
	or      al,al
        SEGES   mov [di],al      ;draw it
	inc     di
        inc     si
        loop    @@Lp2           ;to next pixel
        
        add     di,bx           ;di:=next row
        dec     dx
        jnz     @@Lp1           ;loop through all rows
@@endspr1:
        pop     di
	pop     si
        pop     ds
        pop     bp
        ret

ENDP    _showspr

;************************************************************************
;* void showtrans(int xpos, int ypos, char far*sprite, char far*dest);  *
;* Register: ax,bx,cx,dx                                                *
;* width on dest must be 320 bytes                                      *
;* shows sprite with color 0 transparent, slower than show32spr         *
;************************************************************************
_showtrans PROC xpos:Word, ypos:Word, sprite:Dword, dest:Dword
        push    bp
        mov     bp,sp
	push    ds
        push    si
        push    di
        lds     si,[sprite]     ;ds:si = sprite
        les     di,[dest]       ;es:di = destination
        mov     di,[xpos]
        mov     ax,[ypos]
        xchg    ah,al           ;ax=256*y
        add     di,ax           ;di=256*y+x
        shr     ax,2            ;ax=64*y
        add     di,ax           ;di=320*y+x     offset to di
        lodsw                   ;height to ax
	mov     dx,ax           ;height to dx
        or      ax,ax
        jz      @@error         ;if height 0 draw nothing
        lodsw                   ;width to ax
        mov     bx,320          ;bx = pix/screenrow
        sub     bx,ax           ;bx = incr (bytes to next row)
        shl     eax,16          ;save width in high word of eax
;draw sprite
@@Lp1a:  shr     eax,16          ;width => ax
        mov     cx,ax           ;bytes/row => cx
        shl     eax,16          ;save in high word
@@Lp2a:  SEGDS   mov al,[si]      ;load one byte
	or      al,al
        jz      @@itsz          ;if 0 jump to itsz
        SEGES   mov     [di],al      ;if not 0 draw it
@@itsz: inc     di
        inc     si
        loop    @@Lp2a           ;to next pixel
        
        add     di,bx           ;di:=next row
        dec     dx
        jnz     @@Lp1a           ;loop through all rows
@@error:
        pop     di
	pop     si
        pop     ds
        pop     bp
        ret
ENDP    _showtrans


;************************************************************************
;* void erase32bit(int x, int y, int width, int height,char far*dest);  *
;* Register: eax, ebx, cx, dx,                                          *
;* erases (draws color 0) on a rectangle in dest                        *
;************************************************************************
_erase32bit PROC xpos:Word, ypos:Word, wijd:Word, height:Word, dest:Dword
	push    bp
	mov     bp,sp
	push    di
	les     di,[dest]
	mov     di,[xpos]
	mov     ax,[ypos]
	xchg    ah,al           ;ax=256*y
	add     di,ax           ;di=256*y+x
	shr     ax,2            ;ax=64*y
	add     di,ax           ;di=320*y+x
	mov     ax,[wijd]
	mov     dx,[height]
	mov     bx,320
	sub     bx,ax
	shr     ax,2
	shl     ebx,16
	mov     bx,ax           ;ebx=offset to next row, width in Dword
	xor     eax,eax         ;eax = 0
@@sudda:
	mov     cx,bx           ;Dword/row to cx
	rep     stosd           ;erase one row at es:di
	ror     ebx,16          ;rotate offset to bx
	add     di,bx           ;di = next row
	rol     ebx,16          ;rotate back to high word
	dec     dx
	jnz     @@sudda         ;loopa through all rows
	pop     di
	pop     bp
	ret
ENDP    _erase32bit

;************************************************************************
;* void getback32(int xpos, int ypos, int width, int height,            *
;* char far*source, char far*spr);                                      *
;* Register: ax, bx, cx, dx,                                            *
;************************************************************************
; make a sprite out of source at x,y with width width and height height
_getback32 PROC xpos:Word, ypos:Word, wijd:Word, hoog:Word, source:Dword, sprite:Dword
	push    bp
	mov     bp,sp
	push    di
	push    si
	push    ds
	lds     si,[source]     ;ds:si => source
	les     di,[sprite]     ;es:di => sprite
	mov     si,[xpos]
	mov     ax,[ypos]
	xchg    ah,al
	add     si,ax
	shr     ax,2
	add     si,ax           ;si=320*y+x
	mov     ax,[hoog]     ;save height and width
	stosw                   ;first height
	mov     dx,ax           ;dx height counter
	mov     ax,[wijd]
	stosw                   ;then width
	mov     bx,320
	sub     bx,ax           ;bx=bytes to next row
	shr     ax,2            ;ax = width/4
@@loop: mov     cx,ax           ;number of Dwords to cx per row
	rep     movsd           ;move one row to sprite
	add     si,bx           ;next row
	dec     dx              ;was it the last?
	jnz     @@loop          ;not, one more
	pop     ds
	pop     si
	pop     di
	pop     bp
	ret
ENDP    _getback32

;****************************************
;* void wtsync(void);     Reg: inga     *
;* waits for vertical retrace           *
;****************************************
_wtsync PROC
        push    ax
        push    dx
        mov     dx,3DAh
@@wt1:  in      al,dx
        test    al,8
        jne     @@wt1
@@wt2:  in      al,dx
        test    al,8
        je      @@wt2
        pop     dx
        pop     ax
        ret
ENDP    _wtsync

;*** void setmode(int mode) ***
_setmode PROC mode:Word
	push    bp
	mov     bp,sp
	mov     ax,[mode]
	int     10h
	pop     bp
	ret
ENDP    _setmode


;***   void flip64k(char far*source, char far*dest)     ***
;***   register: cx                                     ***
;copies 64000 bytes from source to dest
_flip64k PROC source:Dword, dest:Dword
        push    bp
        mov     bp,sp
        push    ds
        push    si
        push    di
        lds     si,[source]
        les     di,[dest]
	mov     cx,16000        ;64000/4
        rep     movsd
        pop     di
        pop     si
        pop     ds
        pop     bp
        ret
ENDP    _flip64k

;*** char far* alloc(unsigned int bytes) ***
;allocates bytes bytes, returnes far char pointer to memoryblock
;ex:    char far* virt;
;       virt=malloc(64000);
;if out of memory, return 0
_alloc  PROC bytes:Word
	push    bp
	mov     bp,sp
	mov     bx,[bytes]
	shr     bx,4
	inc     bx
	mov     ah,48h          ;funk 48 allocates ah number of paragraphs
	int     21h             ;1 paragraph = 16 bytes, segment in ax
	mov     dx,ax           ;move the segment to dx
	jnc     @@nerr          ;if no carry, no error
	xor     dx,dx           ;an error occured . . .
@@nerr: xor     ax,ax           ;offset always 0
	pop     bp
	ret
ENDP    _alloc


;*** int vrij(char far* block) ***
;frees memory allocated with malloc (routine above)
;send the pointer as parameter ex: free(virt);
_vrij  PROC block:Dword
	push    bp
	mov     bp,sp
	les     ax,[block]
	mov     ah,49h
	int     21h
        jnc     @@nerr1
	xor     ax,ax           ;an error occured . . .
@@nerr1: pop     bp
	ret
ENDP    _vrij

	END                     ;Just END no label
