#include <ctype.h>
#include <conio.h>

#include "..\Bsp_Gen\io.hpp"


#define DIFF(x,y)   ( (x)>(y) ? (x)-(y) : (y)-(x) )
#define ABS(x)  ( (x)<0 ? -(x) : (x) )
#define LEAST(x,y)	( (x)<(y) ? (x) : (y) )
#define GREATEST(x,y)	( (x)>(y) ? (x) : (y) )



// This will probably end up being called by LastWolf to generate the tree
// from a level file.
CLine *GenerateBspTree(BspCommandLine *pCommandLine, CLineArray *pLinesToFill, CPointArray *pPointsToFill);

// The high-level recursive function to split and generate the BSP.
CLine *GenerateSubTree( CLineArray * );

// Does the real work in the BSP generator.  Tries to find the best line out of pLines,
// and splits pLines by that line, creating pLeftSide, and pRightSide.  Returns the Line
// it split everything by.  IMPORTANT:  It assumes pNewLeft and pNewRight are blank when
// passed to it.
CLine *Split_Tree( CLineArray *pLines, CLineArray *pNewLeft, CLineArray *pNewRight );

// Tries to find the best line in the array to split everything by.
CLine *BestSplit( CLineArray *pLineList, WORD *pNLeft, WORD *pNRight, WORD *pNSplits );

// Returns which side pTestLine is on pMainLine.
SideDir LineSide( CLine *pMainLine, CLine *pTestLine );

// Splits pToSplit on pMainLine.  Sets pNewLeft and pNewRight to point to the new Lines.
BOOL SplitLine( CLine *pMainLine, CLine *pToSplit, CLine **pNewLeft, CLine **pNewRight );

// Gets the angle between two angles in a certain direction.
Angle DirectionDiff( Angle compass1, Angle compass2, SideDir diffDir );

// Just skips any number of comment lines.
void SkipComments( FILE * );

// Just fills in normalX and normalY for all of the Lines.
BOOL PrecalculateData( CLineArray *pLineList );

// Used for debugging .. checks overlapping vertices, bad tree structure, etc.
BOOL CheckTreeValidity();



