/* zconst.h */

/* zmodem constants */
#define ZPAD     0x2a  /* '*' */
#define ZDLE     0x18  /* ^X  */
#define ZDLEE    0x58
#define ZBIN     0x41  /* 'A' */
#define ZHEX     0x42  /* 'B' */
#define ZBIN32   0x43  /* 'C' */

/* header types */
#define ZRQINIT  0x00
#define ZRINIT   0x01
#define ZSINIT   0x02
#define ZACK     0x03
#define ZFILE    0x04
#define ZSKIP    0x05
#define ZNAK     0x06
#define ZABORT   0x07
#define ZFIN     0x08
#define ZRPOS    0x09
#define ZDATA    0x0a
#define ZEOF     0x0b
#define ZFERR    0x0c
#define ZCRC     0x0d
#define ZCHALLENGE  0x0e
#define ZCOMPL   0x0f
#define ZCAN     0x10
#define ZFREECNT 0x11
#define ZCOMMAND 0x12
#define ZSTDERR  0x13

/* frame ends */
#define ZCRCE    0x68
#define ZCRCG    0x69
#define ZCRCQ    0x6a
#define ZCRCW    0x6b
#define GOTOR    0x100
#define GOTCRCE  (GOTOR|ZCRCE)
#define GOTCRCG  (GOTOR|ZCRCG)
#define GOTCRCQ  (GOTOR|ZCRCQ)
#define GOTCRCW  (GOTOR|ZCRCW)
#define GOTCAN   (GOTOR|CAN)

/* more zmodem constants */
#define ZRUB0    0x6c
#define ZRUB1    0x6d
#define ZOK      0
#define ZTIMEOUT  -1
#define ZERROR   -40
#define RCDO     -41

/* byte positions */
#define ZF0      3
#define ZF1      2
#define ZF2      1
#define ZF3      0
#define ZP0      0
#define ZP1      1
#define ZP2      2
#define ZP3      3

/* bit masks for ZRINIT */
#define CANFDX   0x01    /* handle full duplex  - YES */
#define CANOVIO  0x02    /* overlay disk and serial I/O - YES */
#define CANBRK   0x04    /* send a break - YES */
#define CANCRY   0x08    /* encrypt/decrypt - NO */
#define CANLZW   0x10    /* LZW compress - NO */
#define CANFC32  0x20    /* use 32 bit CRCs - YES */
#define ESCALL   0x40    /* escapes all control chars - NO */
#define ESC8     0x80    /* escapes the 8th bit - NO */

/* bit masks for ZSINIT */
#define TESCCTL  0x40
#define TESC8    0x80

/* ZFILE ZF0 */
#define ZCBIN    0x01
#define ZCNL     0x02
#define ZCRESUM  0x03

/* ZFILE ZF1 */
#define ZMNEW    0x01
#define ZMCRC    0x02
#define ZMAPND   0x03
#define ZMCLOB   0x04
#define ZMSPARS  0x05
#define ZMDIfF   0x06
#define ZMPROT   0x07

/* ZFILE ZF2 */
#define ZTLZW    0x01
#define ZTCRYPT  0x02
#define ZTRLE    0x03

/* ZFILE ZF3 */
#define ZCACK1   0x01
