#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#ifdef __BORLANDC__
	#include <mem.h>
	// Normaalisti grafiikkamuisti alkaa osoitteesta A0000h
	char *puskuri,*ruutu=(char *)(0xA0000000);
	#define random rand
	#define int long
#else
	#include <djgppstd.h>
	#include <pc.h>
	// DJGPP:ss grafiikkamuisti alkaa osoitteesta D0000h
	char *puskuri,*ruutu=(char *)(0xD0000000);
	#define CLK_TCK 1000000
#endif

#define LEVEYS	 320		// Ruudun mitat
#define KORKEUS  200
#define TRANS	     0  	// Vri 0 mritetn lpinkyvksi
#define SPRITENUM  2 		// Tehdn 4 spriten taulukko

#define TOP        1		// Ruudun laitojen arvot
#define BOTTOM     2		//   trmystarkistuksia varten
#define LEFT       4
#define RIGHT      8


/************************************************************************/
/*                           LUOKKA: BitMap                             */
/************************************************************************/

class BitMap {
	unsigned short w,h;				// Leveys ja korkeus
	char *kuva;								// Osoitin kuvatietoihin
public:
	BitMap(char *);
	~BitMap(void);
	int Leveys(void) { return(w); }
	int Korkeus(void) { return(h); }
	unsigned char Pixel(short x,short y);
	void Ruudulle(short,short,short tr=-1);
};

// Konstruktori: parametrina PCX-tiedoston nimi
BitMap::BitMap(char *tiedosto) {
	unsigned int p;
 	short tavu,tavu2;
	FILE *pcx=fopen(tiedosto,"rb");		// Avataan tiedosto
	if (!pcx) {												// Tarkistetaan
		textmode(0x3);
		fprintf(stderr,"Tiedosto %s puuttuu!",tiedosto);
		exit(1);
	}
	fseek(pcx,8,SEEK_SET);							// Kohdassa 8 on (leveys-1)
	w=fgetc(pcx) + (fgetc(pcx)<<8) +1;	// Luetaan integer
	h=fgetc(pcx) + (fgetc(pcx)<<8) +1;	// Seuraavana on (korkeus-1)
	kuva=(char *)malloc(w*h);						// Varataan muistia kuvalle
	if (kuva==NULL) {
		textmode(0x3);
		fprintf(stderr,"Muisti loppui tiedoston %s kohdalla!",tiedosto);
		exit(1);
	}
	fseek(pcx,128,SEEK_SET);				// Kohdassa 128 alkaa kuvatieto
	for(p=0; p<w*h;) {						// Luetaan korkeus*leveys tavua
		tavu=fgetc(pcx);						// Luetaan tavu
		if (tavu>192) {						// Jos tavu>192, sen perss
			tavu2=fgetc(pcx);					//   oleva tavu2 on toistettava
			for(;tavu>192; tavu--)        //   (tavu-192) kertaa
				kuva[p++]=tavu2;
		} else kuva[p++]=tavu;				// Muussa tapauksessa tavu
	}												//   esiintyy vain kerran
	fclose(pcx);
}

// Destruktori, vapauttaa kuvalle varatun muistin
BitMap::~BitMap(void) {
	free(kuva);
}

// Palauttaa pikselin vrin haetussa kohdassa
unsigned char BitMap::Pixel(short x,short y) {
	if (x<0 || x>=w || y<0 || y>=h) return(TRANS);
	return(kuva[y*w+x]);
}

// Piirt bittikartan ruudulle kohtaan (x,y)
void BitMap::Ruudulle(short x,short y,short tr) {
	unsigned short xx,yy,o0,o1,o2,ww,hh;
	if (y + h > KORKEUS) hh=KORKEUS-y; else hh=h;
	if (x + w > LEVEYS) ww=LEVEYS-x; else ww=w;
	if (tr==TRANS) {			// Piirretn lpinkyvn
		for(yy=0,o0=y*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
			for(xx=0,o1=x; xx<ww; xx++,o1++,o2++)
				if (kuva[o2]!=TRANS)
					puskuri[o0+o1]=kuva[o2];
	} else {						// Piirretn tydellisen
		for(yy=0,o0=y*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
			for(xx=0,o1=x; xx<ww; xx++,o1++,o2++)
				puskuri[o0+o1]=kuva[o2];
	}
}

/************************************************************************/
/*                           LUOKKA: Animation                          */
/************************************************************************/

#define MAXANIM 20
#define HERO 1
#define ENEMY 2
#define ENEMY2 3
#define ENEMY3 4
#define UP 1
#define DOWN 2
#define R 3
#define L 4
#define UPRIGHT 5
#define UPLEFT 6
#define DOWNLEFT 7
#define DOWNRIGHT 8
#define LOOP 1					// Animaatiotyyppi: looppaava

class Animation {
	BitMap *bitmap[MAXANIM];
	short nopeus,loop;
public:
	short hahmo;
	short tyyppi;
	Animation (short h=0,short t=0,short s=1,short l=0);
	void Rakenna(BitMap *);
	short Seuraava(short n,long laskuri);
	BitMap *Kuva(short n) { return(bitmap[n]); };
};

// Konstruktori: parametreina tyyppi, nopeus ja looppaus
Animation::Animation(short h,short t,short s,short l) {
	for(short n=0;n<MAXANIM;n++) bitmap[n]=NULL;
	hahmo=h;  tyyppi=t; nopeus=s; loop=l;
}

// Lis bittikartan "bm" animaatioketjun pern
void Animation::Rakenna(BitMap *bm) {
	for(short n=0;n<MAXANIM;n++) if (bitmap[n]==NULL) {
		bitmap[n]=bm;
		break;
	}
}

// Palauttaa animaatioketjun seuraavan kuvan numeron
short Animation::Seuraava(short n,long laskuri) {
	if (laskuri%nopeus!=0) return(n);
	if (n+1<MAXANIM && bitmap[n+1]!=NULL) return(n+1);
	if (loop) return(0);
	return(n);
}

/************************************************************************/
/*                           LUOKKA: Sprite                             */
/************************************************************************/

class Sprite {
	short x,y,bx,by;				// Koordinaatit (uudet ja vanhat)
	short dirx,diry;    		// Liikkumasuunnat
	unsigned short w,h;			// Spriten koko (taustaa varten)
	Animation *animation;		// Osoitin animaatiosarjaan
	char *tausta; 					// Osoitin taustan varastotilaan
public:
	int anim;

	void Animoi(long laskuri) { anim=animation->Seuraava(anim,laskuri); }
	void Link(Animation *a) { animation=a; anim=0; }
	BitMap *Kuva(void) { return(animation->Kuva(anim)); }
	int Tyyppi(void) { return(animation->tyyppi); }
	int Hahmo(void) { return(animation->hahmo); }

	// Tietojenpalautusfunktiot
	short GetX(void) { return(x); }
	short GetY(void) { return(y); }
	short GetXSuunta(void) { return(dirx); }
	short GetYSuunta(void) { return(diry); }
	// Liikkumasuuntien mrittelyfunktiot
	void XSuunta(short dx) { dirx=dx; }
	void YSuunta(short dy) { diry=dy; }
	void XYSuunta(short dx,short dy) { dirx=dx; diry=dy; }

	// Siirt spriten paikkaan (nx,ny)
	void Paikka(short nx,short ny) { x=nx; y=ny; }
	// Siirt sprite liikkumasuuntien mukaan
	void Siirry(void) { x+=dirx; y+=diry; }

	Sprite(short,short);			// Konstruktori, luo uuden spriten
	~Sprite(void);						// Destruktori, poistaa spriten

	// Tarkistukset ruudun laitaan ja toisiin spriteihin
	short Laidassa(void);
	short Osuma(Sprite *s);

	// Piirto- ja pyyhintfunktiot
	void Ruudulle(void);
	void Pyyhi(void);
};

// Konstruktori: parametreina spriten leveys ja korkeus
Sprite::Sprite(short leveys,short korkeus) {
	w=leveys; h=korkeus; 						// Talletetaan kokotiedot
	tausta=(char *)malloc(w*h);			// Varataan taustavarasto
	if (tausta==NULL) {  						// Tarkistetaan ett muistia riitti
		textmode(0x3);
		fprintf(stderr,"Muisti loppui spritess!");
		exit(3);
	}
	x=0; y=0; bx=0; by=0; dirx=0; diry=0;	// Alustetaan muuttujat
}

// Destruktori: vapauttaa taustavaraston
Sprite::~Sprite(void) { free(tausta); }

// Tarkistaa trmk kaksi sprite toisiinsa seuraavalla pivityksell
// Parametrina osoitin spriteen jonka kanssa trmys tarkistetaan
// Palauttaa 1 jos trmys tapahtuu, muuten 0
short Sprite::Osuma(Sprite *s) {
	unsigned short xx,yy;
		// Lasketaan spritejen vliset etisyydet
	unsigned int dx=abs(x + dirx - (s->x + s->GetXSuunta()));
	unsigned int dy=abs(y + diry - (s->y + s->GetXSuunta()));
		// Ovatko spritet osittain toisensa pll?
	if (dx > w && dx > s->w) return(0);
	if (dy > h && dy > s->h) return(0);
		// Jos ovat, niin kydn ne lpi pikseli pikselilt
		// Jos kaksi pllekkist pikseli on lpinkymttmi,
		//   on trmys tapahtunut
	for(yy=0; yy<h; yy++) for(xx=0; xx<w; xx++)
		if (yy-dy < s->h && xx-dx < s->w)
			if (Kuva()->Pixel(yy,xx)!=TRANS &&
				 s->Kuva()->Pixel(yy-dy,xx-dx)!=TRANS) return(1);
	return(0);
}

// Tarkistaa trmk sprite ruudun laitaan seuraavalla pivityksell
// Palauttaa bittikentn jossa on tiedot kaikista laidoista
short Sprite::Laidassa(void) {
	short res=0;
	if (x + dirx < 0) res|=LEFT;
	else if (x + dirx + w>=LEVEYS) res|=RIGHT;
	if (y + diry < 0) res|=TOP;
	else if (y + diry + h>=KORKEUS) res|=BOTTOM;
	return(res);
}

// Poistaa spriten ruudulta ja palauttaa taustan entiselleen
void Sprite::Pyyhi(void) {
	unsigned short xx,yy,o0,o1,o2,hh,ww;
	if (by + h > KORKEUS) hh=KORKEUS-by; else hh=h;
	if (bx + w > LEVEYS) ww=LEVEYS-bx; else ww=w;
	for(yy=0,o0=by*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
		for(xx=0,o1=bx; xx<ww; xx++,o1++,o2++)
				puskuri[o0+o1]=tausta[o2];
}

// Piirt spriten ruudulle ja ottaa sen ylikirjoittaman taustan talteen
void Sprite::Ruudulle(void) {
	unsigned short xx,yy,hh,ww,o0,o1,o2;
	unsigned char pixel;
	bx=x; by=y;		 // Pivitetn vanhoille koordinaateille uudet arvot
	if (y + h > KORKEUS) hh=KORKEUS-y; else hh=h;
	if (x + w > LEVEYS) ww=LEVEYS-x; else ww=w;
	for(yy=0,o0=by*LEVEYS,o2=0; yy<hh; yy++,o0+=LEVEYS)
		for(xx=0,o1=bx; xx<ww; xx++,o1++,o2++)
				tausta[o2]=puskuri[o0+o1];
	Kuva()->Ruudulle(x,y,TRANS);	// Piirretn sprite lpinkyvn
}

/************************************************************************/
/*                                Pkoodi                              */
/************************************************************************/

// Muuttaa Nytnohjaimen paletin PCX-tiedoston mukaan
void Paletti(char *tiedosto) {
	short c;
	unsigned char paletti[256*3];		// Tilaa 256 vrin RGB-arvoille
	FILE *pcx=fopen(tiedosto,"rb");	// Avataan tiedosto
	fseek(pcx,-768l,SEEK_END);			// Paletti alkaa 768 tavua lopusta lukien
	for(c=0;c<256;c++) {						// Luetaan kaikki 256 vri
		paletti[c*3+0]=fgetc(pcx)/4;
		paletti[c*3+1]=fgetc(pcx)/4;	// Saatu arvo jaetaan neljll koska
		paletti[c*3+2]=fgetc(pcx)/4;	//   VGA-paletissa on vain arvot 0..63
	}
	fclose(pcx);
	outportb(0x3C8,0);
	for(c=0;c<256*3;c++) outportb(0x03C9,paletti[c]);
}

// Kopioi kaksoispuskurin sislln ruudulle
void Puskuri(void) {
	// Odotetaan nytnohjaimen pystypalautusta
	while(inportb(0x03DA)&8!=0);
	while(inportb(0x03DA)&8==0);
	#ifdef __BORLANDC__
	asm {		// Kopioidaan kaksoispuskuri nytlle
		push ds
		les di,[ruutu]
		lds si,[puskuri]
		mov cx,64000/4
		db 0x66
		rep movsw
		pop ds
	}
	#else
	memcpy(ruutu,puskuri,64000);
	#endif
}

short main(void) {
	short d,l,n,x,y,viive,ulos;
		  short a,b,q,w,e,r,t,u;
		  short kaasu=0;
		  short kaasu2=0;
		  short ratti=0;
		  short ratti2=0;
		  short keula=0;
		  short keula2=0;
		  short joe=0;
		  short joe2=0;
		  short crash=0;
		  short crash2=0;
		  short AI=1;
                  short redlap=0;
                  short bluelap=0;
                  short redmark=0;
                  short bluemark=0; 
		unsigned long frames=0;
	// Varataan kaksoispuskurille muistia
	puskuri=(char *)malloc(64000);
	if (puskuri==NULL) {
		textmode(0x3);
		fprintf(stderr,"Muisti loppui puskurissa!");
		exit(3);
	}
	// Luodaan animaatio-, bittikartta- ja spritetaulukot
	Animation anim_car1l(HERO,L,3),anim_car1r(HERO,R,3),anim_car1ul(HERO,UPLEFT,3),
		  anim_car1u(HERO,UP,3),anim_car1ur(HERO,UPRIGHT,3),anim_car1dr(HERO,DOWNRIGHT,3),
		  anim_car1d(HERO,DOWN,3),anim_car1dl(HERO,DOWNLEFT,3),anim_car2l(ENEMY,LEFT,3),
		  anim_car2r(ENEMY,RIGHT,3),anim_car2ul(ENEMY,UPLEFT,3),anim_car2u(ENEMY,UP,3),
		  anim_car2ur(ENEMY,UPRIGHT,3),anim_car2dr(ENEMY,DOWNRIGHT,3),anim_car2d(ENEMY,DOWN,3),
		  anim_car2dl(ENEMY,DOWNLEFT,3);
	BitMap *tausta,*car1l[1],*car1r[1],*car1ul[1],*car1u[1],*car1ur[1],*car1dr[1],*car1d[1],*car1dl[1],
	       *car2l[1],*car2dl[1],*car2d[1],*car2dr[1],*car2r[1],*car2ur[1],*car2u[1],*car2ul[1];
        Sprite *kuvat[SPRITENUM];

	tausta=new BitMap("TRACK.PCX");		// Ladataan tausta,
	tausta->Ruudulle(0,0);          // piirretn puskuriin
	delete(tausta);									// ja poistetaan muistista

	// Ladataan bittikartat spriteille
	car1l[0]=new BitMap("CAR1L.PCX");
	car1r[0]=new BitMap("CAR1R.PCX");
	car1ul[0]=new BitMap("CAR1UL.PCX");
	car1u[0]=new BitMap("CAR1U.PCX");
	car1ur[0]=new BitMap("CAR1UR.PCX");
	car1dr[0]=new BitMap("CAR1DR.PCX");
	car1d[0]=new BitMap("CAR1D.PCX");
	car1dl[0]=new BitMap("CAR1DL.PCX");
	car2l[0]=new BitMap("CAR2L.PCX");
	car2dl[0]=new BitMap("CAR2DL.PCX");
	car2d[0]=new BitMap("CAR2D.PCX");
	car2dr[0]=new BitMap("CAR2DR.PCX");
	car2r[0]=new BitMap("CAR2R.PCX");
	car2ur[0]=new BitMap("CAR2UR.PCX");
	car2u[0]=new BitMap("CAR2U.PCX");
	car2ul[0]=new BitMap("CAR2UL.PCX");

	// Rakennetaan animaatioketjut
	for(n=0;n<1;n++) anim_car1l.Rakenna(car1l[n]);
	for(n=0;n<1;n++) anim_car1r.Rakenna(car1r[n]);
	for(n=0;n<1;n++) anim_car1ul.Rakenna(car1ul[n]);
	for(n=0;n<1;n++) anim_car1u.Rakenna(car1u[n]);
	for(n=0;n<1;n++) anim_car1ur.Rakenna(car1ur[n]);
	for(n=0;n<1;n++) anim_car1dr.Rakenna(car1dr[n]);
	for(n=0;n<1;n++) anim_car1d.Rakenna(car1d[n]);
	for(n=0;n<1;n++) anim_car1dl.Rakenna(car1dl[n]);
	for(n=0;n<1;n++) anim_car2l.Rakenna(car2l[n]);
	for(n=0;n<1;n++) anim_car2dl.Rakenna(car2dl[n]);
	for(n=0;n<1;n++) anim_car2d.Rakenna(car2d[n]);
	for(n=0;n<1;n++) anim_car2dr.Rakenna(car2dr[n]);
	for(n=0;n<1;n++) anim_car2r.Rakenna(car2r[n]);
	for(n=0;n<1;n++) anim_car2ur.Rakenna(car2ur[n]);
	for(n=0;n<1;n++) anim_car2u.Rakenna(car2u[n]);
	for(n=0;n<1;n++) anim_car2ul.Rakenna(car2ul[n]);

	x=car1l[0]->Leveys();
	y=car1l[0]->Korkeus();
	kuvat[0]=new Sprite(x,y);
	kuvat[0]->Link(&anim_car1l);
	kuvat[0]->Paikka((197-x),(28-y));

	x=car2l[0]->Leveys();
	y=car2l[0]->Korkeus();
	kuvat[1]=new Sprite(x,y);
	kuvat[1]->Link(&anim_car2l);
	kuvat[1]->Paikka((197-x),(45-y));
   
	textmode(0x13); 			// Siirrytn grafiikkatilaan 13h eli 320x200x256
	Paletti("TRACK.PCX");		// Luetaan paletti
	Puskuri();						// Kopioidaan puskuri (eli tausta) nytlle
	ulos=0; viive=25;
	clock_t start=clock();
	while(!ulos) {				// Plooppi
		frames++;
		for(n=0;n<SPRITENUM;n++) {	// Jokaiselle spritelle:
			kuvat[n]->Ruudulle();			//  Piirretn puskuriin,
			kuvat[n]->Siirry();				//  siirretn liikkumasuuntien mukaan
			kuvat[n]->Animoi(frames);	//  ja pivitetn animaatio
		}
		Puskuri();							// Kopioidaan puskuri nytlle
		delay(viive);						// Odotetaan
					 a=kuvat[0]->GetXSuunta();
					 b=kuvat[0]->GetYSuunta();
					 q=kuvat[0]->GetX();
					 w=kuvat[0]->GetY();
					 e=kuvat[1]->GetXSuunta();
					 r=kuvat[1]->GetYSuunta();
					 t=kuvat[1]->GetX();
					 u=kuvat[1]->GetY();
			if (q<182 && q>168 && w<53) {
				 if (redmark==2) {
				 redmark=1; } }
			if (q>182 && q<196 && w>140) {
				 redmark=2; }
			if (redmark==1) {
				redmark=0;
                                redlap=redlap+1; }
			if (redlap==0) {
				tausta=new BitMap("NR0.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1; }
			if (redlap==2) {
				tausta=new BitMap("NR1.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1; }
			if (redlap==4) {
				tausta=new BitMap("NR2.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1;   }
			if (redlap==6) {
				tausta=new BitMap("NR3.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta);
                                redlap=redlap+1;  }
			if (redlap==8) {
				tausta=new BitMap("NR4.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1; }
			if (redlap==10) {
				tausta=new BitMap("NR5.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1; }
			if (redlap==12) {
				tausta=new BitMap("NR6.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1; }
			if (redlap==14) {
				tausta=new BitMap("NR7.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1;   }
			if (redlap==16) {
				tausta=new BitMap("NR8.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1; }
			if (redlap==18) {
				tausta=new BitMap("NR9.PCX");
				tausta->Ruudulle(20,20);
				delete(tausta); 
                                redlap=redlap+1; }
                        if (redlap==20) {
                                redlap=0; }
			if (t<182 && t>168 && u<53) {
				 if (bluemark==2) {
				 bluemark=1; } }
			if (t>182 && t<196 && u>140) {
				 bluemark=2; }
			if (bluemark==1) {
				 bluemark=0;							bluemark=0;
				 bluelap=bluelap+1; }
			if (bluelap==0) {
				tausta=new BitMap("NB0.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta);
                                bluelap=bluelap+1;  }
			if (bluelap==2) {
				tausta=new BitMap("NB1.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta); 
                                bluelap=bluelap+1; }
			if (bluelap==4) {
				tausta=new BitMap("NB2.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta);  
                                bluelap=bluelap+1; }
			if (bluelap==6) {
				tausta=new BitMap("NB3.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta); 
                                bluelap=bluelap+1; }
			if (bluelap==8) {
				tausta=new BitMap("NB4.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta);  
                                bluelap=bluelap+1; }
			if (bluelap==10) {
				tausta=new BitMap("NB5.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta);  
                                bluelap=bluelap+1; }
			if (bluelap==12) {
				tausta=new BitMap("NB6.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta);  
                                bluelap=bluelap+1; }
			if (bluelap==14) {
				tausta=new BitMap("NB7.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta); 
                                bluelap=bluelap+1; }
			if (bluelap==16) {
				tausta=new BitMap("NB8.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta); 
                                bluelap=bluelap+1; }
			if (bluelap==18) {
				tausta=new BitMap("NB9.PCX");
				tausta->Ruudulle(300,20);
				delete(tausta); 
                                bluelap=bluelap+1;  }
                        if (bluelap==20) {
                                bluelap=0; }
 

			if (q>53 && q<244 && w>39 && w<140) {
						 crash=1;
						 kuvat[0]->XYSuunta((-a),(-b)); }
					 if (crash>0) {
						 crash=crash+1;
						 ratti=3;  }
					 if (crash>20) {
						 crash=0; }
					 if (ratti>=1) {
						 keula=keula+1;
						 joe=joe+1;
						 ratti=ratti-1; }
					 if (ratti<=-1) {
						 keula=keula-1;
						 joe=joe-1;
						 ratti=ratti+1; }
					 if (keula>7) {
						 keula=0; }
					 if (keula<0) {
						 keula=7; }
				 if (crash==0) {
					 if (keula==0) {
						 if (kaasu>0) {
							 kuvat[0]->XYSuunta((-kaasu),(ratti)); } }
					 if (keula==1) {
						 if (kaasu>0) {
							 if (ratti<0) {
								 kuvat[0]->XYSuunta((-kaasu-ratti),(kaasu)); }
							 else { kuvat[0]->XYSuunta((-kaasu),(kaasu-ratti)); } } }
					 if (keula==2) {
						 if (kaasu>0) {
							 kuvat[0]->XYSuunta((ratti),(kaasu)); } }
					 if (keula==3) {
						 if (kaasu>0) {
							 if (ratti<0) {
								 kuvat[0]->XYSuunta((kaasu),(kaasu-ratti)); }
							 else { kuvat[0]->XYSuunta((kaasu-ratti),(kaasu)); } } }
					 if (keula==4) {
						 if (kaasu>0) {
							 kuvat[0]->XYSuunta((kaasu),(ratti)); } }
					 if (keula==5) {
						 if (kaasu>0) {
							 if (ratti<0) {
								 kuvat[0]->XYSuunta((kaasu),(-kaasu+ratti)); }
							 else { kuvat[0]->XYSuunta((kaasu-ratti),(-kaasu)); }
									 } }
					 if (keula==6) {
						 if (kaasu>0) {
							 kuvat[0]->XYSuunta((ratti),(-kaasu)); } }
					 if (keula==7) {
						 if (kaasu>0) {
							 if (ratti<0) {
								 kuvat[0]->XYSuunta((-kaasu),(-kaasu-ratti)); }
							 else { kuvat[0]->XYSuunta((-kaasu+ratti),(-kaasu)); }
								 } }
					 if (kaasu==0) {
						 kuvat[0]->XYSuunta((0),(0)); } }
					 if (joe>7) {
						 joe=0; }
					 if (joe<0) {
						 joe=7; }
					 if (joe==0) {
						 kuvat[0]->Link(&anim_car1l); }
					 if (joe==1) {
						 kuvat[0]->Link(&anim_car1dl); }
					 if (joe==2) {
						 kuvat[0]->Link(&anim_car1d); }
					 if (joe==3) {
						 kuvat[0]->Link(&anim_car1dr); }
					 if (joe==4) {
						 kuvat[0]->Link(&anim_car1r); }
					 if (joe==5) {
						 kuvat[0]->Link(&anim_car1ur); }
					 if (joe==6) {
						 kuvat[0]->Link(&anim_car1u); }
					 if (joe==7) {
						 kuvat[0]->Link(&anim_car1ul); }
	 if (t>53 && t<244 && u>39 && u<140) {
						 crash2=1;
						 kuvat[1]->XYSuunta((-e),(-r)); }
					 if (crash2>0) {
						 crash2=crash2+1;
						 ratti2=3;  }
					 if (crash2>20) {
						 crash2=0; }
					 if (ratti2>=1) {
						 keula2=keula2+1;
						 joe2=joe2+1;
						 ratti2=ratti2-1; }
					 if (ratti2<=-1) {
						 keula2=keula2-1;
						 joe2=joe2-1;
						 ratti2=ratti2+1; }
					 if (keula2>7) {
						 keula2=0; }
					 if (keula2<0) {
						 keula2=7; }
				 if (crash2==0) {
					 if (keula2==0) {
						 if (kaasu2>0) {
							 kuvat[1]->XYSuunta((-kaasu2),(ratti2)); } }
					 if (keula2==1) {
						 if (kaasu2>0) {
							 if (ratti2<0) {
								 kuvat[1]->XYSuunta((-kaasu2-ratti2),(kaasu2)); }
							 else { kuvat[1]->XYSuunta((-kaasu2),(kaasu2-ratti2)); } } }
					 if (keula2==2) {
						 if (kaasu2>0) {
							 kuvat[1]->XYSuunta((ratti2),(kaasu2)); } }
					 if (keula2==3) {
						 if (kaasu2>0) {
							 if (ratti2<0) {
								 kuvat[1]->XYSuunta((kaasu2),(kaasu2-ratti2)); }
							 else { kuvat[1]->XYSuunta((kaasu2-ratti2),(kaasu2)); } } }
					 if (keula2==4) {
						 if (kaasu2>0) {
							 kuvat[1]->XYSuunta((kaasu2),(ratti2)); } }
					 if (keula2==5) {
						 if (kaasu2>0) {
							 if (ratti2<0) {
								 kuvat[1]->XYSuunta((kaasu2),(-kaasu2+ratti2)); }
							 else { kuvat[1]->XYSuunta((kaasu2-ratti2),(-kaasu2)); }
									 } }
					 if (keula2==6) {
						 if (kaasu2>0) {
							 kuvat[1]->XYSuunta((ratti2),(-kaasu2)); } }
					 if (keula2==7) {
						 if (kaasu2>0) {
							 if (ratti2<0) {
								 kuvat[1]->XYSuunta((-kaasu2),(-kaasu2-ratti2)); }
							 else { kuvat[1]->XYSuunta((-kaasu2+ratti2),(-kaasu2)); }
								 } }
					 if (kaasu2==0) {
						 kuvat[1]->XYSuunta((0),(0)); } }
					 if (joe2>7) {
						 joe2=0; }
					 if (joe2<0) {
						 joe2=7; }
					 if (joe2==0) {
						 kuvat[1]->Link(&anim_car2l); }
					 if (joe2==1) {
						 kuvat[1]->Link(&anim_car2dl); }
					 if (joe2==2) {
						 kuvat[1]->Link(&anim_car2d); }
					 if (joe2==3) {
						 kuvat[1]->Link(&anim_car2dr); }
					 if (joe2==4) {
						 kuvat[1]->Link(&anim_car2r); }
					 if (joe2==5) {
						 kuvat[1]->Link(&anim_car2ur); }
					 if (joe2==6) {
						 kuvat[1]->Link(&anim_car2u); }
					 if (joe2==7) {
						 kuvat[1]->Link(&anim_car2ul); }
					 if (AI==1 && crash2==0) {
						 if ((t<244 && t>80 && u<53) || (t>67 && t<224 && u>140)) {
							 if (kaasu2<4) {
								 kaasu2=kaasu2+1;  } }
						 if ((t<80 && u<53) || (t>224 && u>140)) {
							 if (kaasu2>3) {
								 kaasu2=kaasu2-1; } }
						 if ((u<40 && t>67 && keula2!=0) || (u>140 && t<240 && keula2!=4) || (t<50 && u<140 && keula2!=2) || (t>250 && u>53 && keula2!=6)) {
							 ratti2=1; } }

		for(x=0;x<SPRITENUM;x++) {
			n=kuvat[x]->Laidassa();		// Kimmotetaan sprite seinmist
			if      (n&TOP || n&BOTTOM) kuvat[x]->XSuunta(random()%(3)-1);
			else if (n&LEFT || n&RIGHT) kuvat[x]->YSuunta(random()%(3)-1);
			if      (n&TOP)             kuvat[x]->YSuunta(1);
			else if (n&BOTTOM)          kuvat[x]->YSuunta(-1);
			if      (n&LEFT)            kuvat[x]->XSuunta(1);
			else if (n&RIGHT)           kuvat[x]->XSuunta(-1);
				// Tarkistetaan spritejen vliset trmykset
			for(y=x+1; y<SPRITENUM; y++)
				if (kuvat[x]->Osuma(kuvat[y])) {
										  crash=1;
										  crash2=1;
			}
		}

		// Poistetaan spritet puskurista knteisess jrjestyksess
		for(n=SPRITENUM-1;n>=0;n--) kuvat[n]->Pyyhi();
					 while (kbhit()) {		// Nppimisttarkistus
			switch(getch()) {
										  case 'w': if (kaasu<5) {
						  kaasu=kaasu+1; }
														break;
										  case 'a': if (ratti<2) {
														ratti=ratti+1; }
														break;
										  case 's': if (kaasu>0) {
					  kaasu=kaasu-1; }
														break;
				case 'd': if (ratti>-2) {
														ratti=ratti-1; }
					  break;
				case '-': viive++; break;
										  case '+': if (viive) viive--; break;
				case 27: case 'q': case 'Q': case 'x': case 'X': ulos=1; break;
			}
		}
	}
	clock_t end=clock();
	for(n=0; n<SPRITENUM; n++) delete(kuvat[n]);	// Poistetaan spritet,
	for(n=0; n<1; n++) delete(car1l[n]);
	for(n=0; n<1; n++) delete(car1r[n]);
	for(n=0; n<1; n++) delete(car1ul[n]);
	for(n=0; n<1; n++) delete(car1u[n]);
	for(n=0; n<1; n++) delete(car1ur[n]);
	for(n=0; n<1; n++) delete(car1dr[n]);
	for(n=0; n<1; n++) delete(car1d[n]);
	for(n=0; n<1; n++) delete(car1dl[n]);
	for(n=0; n<1; n++) delete(car2l[n]);
	for(n=0; n<1; n++) delete(car2dl[n]);
	for(n=0; n<1; n++) delete(car2d[n]);
	for(n=0; n<1; n++) delete(car2dr[n]);
	for(n=0; n<1; n++) delete(car2r[n]);
	for(n=0; n<1; n++) delete(car2ur[n]);
	for(n=0; n<1; n++) delete(car2u[n]);
	for(n=0; n<1; n++) delete(car2ul[n]);
	 delete(&anim_car1l);  delete(&anim_car1r);  delete(&anim_car1ul);  delete(&anim_car1u);
		  delete(&anim_car1ur); delete(&anim_car1dr);  delete(&anim_car1d);  delete(&anim_car1dl);
		  delete(&anim_car2l); delete(&anim_car2r);  delete(&anim_car2ul);  delete(&anim_car2u);
		  delete(&anim_car2ur); delete(&anim_car2dr);  delete(&anim_car2d);  delete(&anim_car2dl);
   free(puskuri);																//  ja puskuri
	textmode(3);                              	  // Siirrytn tekstitilaan
	printf("\nPivityksi: %li\nTickej: %li",frames,end-start);
	printf("\nRuudunpivityksi %.2f sekunnissa",
		(float)frames/(end-start)*CLK_TCK);			// Nytetn pivitysnopeus
        return(0);
}