@ECHO OFF

REM -------------------------------------------------------------------------
REM INSTALL.BAT
REM
REM Installs DOS version of Link48 for PC
REM
REM Copyright 1994 Sparcom Corporation, Scott Burke
REM
REM 07/29/94	SB	Created file
REM 08/20/94	SB	Release version
REM -------------------------------------------------------------------------

REM --------------------------------------------------------------------------
REM Usage: INSTALL DRIVE LANGUAGE
REM   DRIVE parameter is drive to install software on, such as C:
REM   LANGUAGE parameter is language to use, such as ENG,FRN,GER,SPN,ITL,POR
REM --------------------------------------------------------------------------

IF '%1'=='' GOTO HELP
IF '%2'=='' GOTO HELP
IF NOT '%3'=='' GOTO HELP
IF EXIST %1\NUL GOTO INSTALL

ECHO 
ECHO ----- Error: %1 does not exist or is an invalid destination.
ECHO 
PAUSE

GOTO HELP

REM --------------------------------------------------------------------------
REM Install software
REM --------------------------------------------------------------------------

:INSTALL

CLS
ECHO 
ECHO ----- Step 1: Creating %1\LINK48 directory, if necessary...
ECHO 
MKDIR %1\LINK48

ECHO 
ECHO ----- Step 2: Expanding Filer...
ECHO 
EXPAND -R FILE48.EXE %1\LINK48

ECHO 
ECHO ----- Step 3: Expanding Screen Capture...
ECHO 
EXPAND -R SCRN48.EXE %1\LINK48

ECHO 
ECHO ----- Step 4: Installing resources...
ECHO 
EXPAND -R LINK48.DAT %1\LINK48
COPY ARCHIVE.BIN %1\LINK48\ARCHIVE.BIN
COPY RESTORE.BIN %1\LINK48\RESTORE.BIN
COPY README.TXT %1\LINK48\README.TXT

ECHO 
ECHO ----- Step 5: Installing messages...
ECHO 
COPY MESSAGES.ENG %1\LINK48\MESSAGES.DAT
COPY MESSAGES.%2 %1\LINK48\MESSAGES.DAT

GOTO COMPLETE

REM --------------------------------------------------------------------------
REM Help information
REM --------------------------------------------------------------------------

:HELP

ECHO 
ECHO Installing Link48
ECHO -----------------------------
ECHO English...     INSTALL C: ENG
ECHO French...      INSTALL C: FRN
ECHO German...      INSTALL C: GER
ECHO Spanish...     INSTALL C: SPN
ECHO Italian...     INSTALL C: ITL
ECHO Portuguese...  INSTALL C: POR
ECHO -----------------------------
ECHO If your hard drive is not C:, replace "C" with the correct drive letter.
ECHO 

GOTO DONE

REM --------------------------------------------------------------------------
REM Installation complete
REM --------------------------------------------------------------------------

:COMPLETE

ECHO 
ECHO ----- Installation of Link48 is complete!
ECHO 
PAUSE

CLS
ECHO 
ECHO Using Link48
ECHO -------------------------------------------
ECHO Filer...                %1\LINK48\FILE48
ECHO Filer Help...           %1\LINK48\FILE48 -?
ECHO 
ECHO Screen Capture...       %1\LINK48\SCRN48
ECHO Screen Capture Help...  %1\LINK48\SCRN48 -?
ECHO -------------------------------------------
ECHO 

REM --------------------------------------------------------------------------
REM DONE
REM --------------------------------------------------------------------------

:DONE
