;
; ALL APPLI NEAD TO START WITH THIS AND TO END WITH THE BOTTOM'S LABEL'S
;
; PILI BINARY MAIN  = main code, always called in first, need to be only once in memory
; PILI BINARY xxxx  = programme chain (maxi 9999), each header needs to exist only once
pili_header:
     JR start                   ; jump to start of prog
     dl pili_bottom-pili_header ; /* size of binary image */
     db "PILI BINARY MAIN "     ; header for beta, main application
     db 0                       ; null terminate
;   information on the program
DispInfo:
     db 0                       ; No button=0, OK button=1 (same as infobox function)
     db " ****** PILI CAR DEMO ****** "; infobox title
     db 0dh                     ; change line
     db "Written by P.Dehlinger            "; Informations
     db 0dh                     ; change line
     $DATE_TIME                 ; get date and time of compile, (null terminate)


; include file for library definitions and virtual registers assignement
 include fncall.inc

;-----------------------------------------------------------------------------
;
;
;
; YOU PROGRAMM START
;

start:

     FNCALL clearscreen,0         ; clear the screen
     FNCALL displayimg,picture    ; display the car picture
     FNCALL16 InfoBox,DispInfo,sto0    ; diplay the information window, no answers into registers if -1

     RLD16  sto0,12               ; usage x coord
     RLD16  sto1,24               ; usage y coord
     FNCALL locate,sto0           ; set cursor
     FNCALL setfont,0             ; select font
     FNCALL formatprint,usage     ; display explication text part 1
     RLD16  sto1,25               ; usage y coord2
     FNCALL locate,sto0           ; set cursor
     FNCALL formatprint,usage2    ; display explication text part 2


wloop3: ; attente
     FNCALL EventRead,0,sto0  ; read the incomming event (this event is cleared)
     CMP    sto0,20h           ; wait for pen up event
     JRNZ   wloop3

     FNCALL clearscreen,0     ; clear screen (white=0, black=1)

; affichage d'un sprite
     RLD16 x,0                ; reset x graphic coord
     RLD08 b,1                ; number of registers to write using the LOAD/STOR functions
     RLD32 cx,graphy          ; graphic x coord are in CX
     RLD32 dx,graphx          ; graphic y coord are in DX
     RLD16 y,8                ; graphic y coord = 8
     STOR16 y,cx,b            ; write y at graphy (store from y register up to y+(b) register)
     STOR16 x,dx,b            ; write x at graphx (store from x register up to x+(b) register)
     RLD16  sto9,8            ; prepare sto9 for x and y addition using the ADD instruction (add 2 registers)
grloop:
; get the pen input for changing car's direction
     FNCALL EventRead,0,sto0  ; read the incomming event (this event is cleared)
     CMP sto0,8               ; pen down event
     JRNZ noevent             ; not pen down event: ignore
     FNCALL GetInput,0,sto0   ; event structure is from sto0 up to sto6, read the pen event
                              ; for pen: sto0=posx
                              ; for pen: sto1=posy
                              ; for pen: sto2=start pos x
                              ; for pen: sto3=start pos y
                              ; for pen: sto4=button (not use on zaurus)
                              ; for pen: sto5=time of the event
                              ; for pen: sto6=event classification (8,16,32 down/stilldown/up)

                              ; for key: sto0=key
                              ; for key: sto1=attr
                              ; for key: sto2=n/a
                              ; for key: sto3=n/a
                              ; for key: sto4=n/a
                              ; for key: sto5=time of the event
                              ; for key: sto6=event classification (1,2,4 down/stilldown/up)
     RMV32 x,sto2             ; a=sto2
     RMV32 y,sto3             ; y=sto3
     STOR16 x,dx,b            ; write x
     STOR16 y,cx,b            ; write y

     FNCALL clearscreen,0     ; clear screen

noevent:

     LOAD16 x,dx,b             ; read x coord
     LOAD16 y,cx,b             ; read y coord
     FNCALL glocate,x          ; graphic x/y
     FNCALL gprint,graphics,GP_SET ; plot the picture (small car)
     ADD16  x,sto9             ; add to x coord 8 pixels
     STOR16 x,dx,b             ; write x coord
     CMP    x,320              ; end of line ?
     JRC    grloop             ; no, loop
     RLD16  x,0                ; yes, reset to strat of line, x=0
     STOR16 x,dx,b             ; write reset coord
     ADD16  y,sto9             ; y+sto9 -> y (y+8 -> y)   y=y+8
     STOR16 y,cx,b             ; write y coord
     CMP    y,240              ; bottom of screen ?
     JRC    grloop             ; no, then loop
     RLD16  y,0                ; yes, reset the y coord to top of screen y=0
     STOR16 y,cx,b             ; write
     JR     grloop             ; infinit loop (stop on 'break' (ON) ) key press

endprog:
     EXIT                      ; not usefull but just to show a 'normal' end
; program data's
usage: ; usage text
     db "Touch screen to move the car"
     db 0
usage2: ; usage text part 2
     db "**** PRESS 'ON' TO STOP ****"
     db 0
graphx: ; graphic coord are written there
     dw 0
graphy:
     dw 0
graphics: ; small car graphic (vertical arrangment, 0x01 is the top pixel on screen)
     db "0000000000000000FF878484F417171C"
     db 0dh
     db "00000000000000004040404040404040"   ; the road
     db 00h

; car first screen
picture:
     dw pict_bot-pict_data  ; size of picture
pict_data:

     DB 050h,057h,0AAh,055h,009h,050h,057h,000h,009h,026h,000h,0FFh,009h,001h,0FFh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh
     DB 0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h
     DB 0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh
     DB 0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h
     DB 0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh
     DB 0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h
     DB 0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh
     DB 0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h
     DB 0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh
     DB 0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h
     DB 0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh
     DB 0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0FFh,009h,001h,0FFh
     DB 000h,009h,052h,000h,0FFh,009h,001h,0FFh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,05Dh
     DB 0AEh,057h,0ADh,055h,0ADh,055h,0AAh,056h,0ABh,055h,0ABh,055h,0ABh,056h,0AAh,056h,0AAh,056h,0AAh,056h,0AAh
     DB 056h,0ACh,054h,0ACh,054h,0ACh,054h,0ACh,054h,0ACh,054h,0ACh,054h,0AAh,056h,0ABh,055h,0ABh,055h,0ABh,055h
     DB 0ABh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0FFh,009h,001h,0FFh,000h,009h,052h,000h,0FFh,009h,001h
     DB 0FFh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,05Dh,0EEh,07Bh,0BAh,093h,002h
     DB 003h,002h,003h,002h,003h,002h,003h,002h,003h,002h,003h,002h,003h,002h,005h,006h,005h,006h,005h,006h,005h
     DB 006h,005h,006h,005h,006h,005h,006h,005h,006h,005h,006h,005h,006h,003h,002h,083h,082h,043h,0C2h,063h,0A2h
     DB 051h,0B0h,051h,0A8h,058h,0A8h,054h,0ACh,054h,0AAh,056h,0AAh,055h,0ABh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0ABh,057h,0BCh,050h,0B0h,060h,0C0h,009h,001h,0C0h,080h,009h,005h,080h,0C0h,040h,0E0h,070h,0B8h
     DB 05Eh,0ABh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0ABh,055h,0ABh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0FFh,009h,001h,0FFh,000h,009h,052h,000h,0FFh,009h,001h,0FFh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0ABh,055h,0ABh,057h,0ABh,057h,0AFh,057h,0AFh,05Fh,0AFh,05Fh,0BFh
     DB 05Fh,0BFh,05Fh,0BFh,07Fh,0BFh,07Fh,0BFh,07Fh,0FFh,07Fh,0FFh,07Fh,0FFh,07Fh,0FFh,009h,008h,0FFh,03Fh,01Fh
     DB 017h,00Bh,085h,0C2h,043h,0A2h,063h,0B1h,070h,0B8h,0CCh,07Eh,084h,002h,009h,001h,002h,001h,009h,001h,001h
     DB 000h,009h,005h,000h,060h,07Ch,046h,043h,041h,040h,009h,001h,040h,050h,0F8h,05Fh,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0A0h,053h,0BFh,05Fh,0B8h,05Fh,0A0h,0D0h,0F0h,0FEh,0FFh,009h,004h,0FFh,07Fh,0BFh,05Fh,0AFh
     DB 05Fh,0AFh,057h,0AFh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0FFh,009h,001h,0FFh,000h,009h
     DB 052h,000h,0FFh,009h,001h,0FFh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0AAh,055h,0ABh,057h,0AFh,057h,0AFh,05Fh,0BFh,07Fh,0BFh,07Fh,0FFh,009h,02Ch,0FFh,07Fh
     DB 0BFh,05Fh,0AFh,057h,0ABh,0F5h,01Bh,001h,009h,001h,001h,000h,009h,004h,000h,080h,0C0h,009h,001h,0C0h,000h
     DB 009h,003h,000h,008h,078h,074h,01Ah,095h,0EAh,055h,0EAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0A8h,040h,000h
     DB 0FCh,0F8h,0C1h,07Bh,0F3h,003h,007h,009h,001h,007h,00Fh,0EFh,0FFh,009h,00Dh,0FFh,07Fh,0BFh,05Fh,0AFh,05Fh
     DB 0A9h,05Dh,0ADh,05Dh,0A9h,059h,0A9h,05Dh,0ADh,055h,0ACh,055h,0ADh,055h,0ADh,055h,0AFh,057h,0ABh,057h,0ABh
     DB 057h,0ABh,055h,0ABh,055h,0ABh,057h,0AFh,057h,0AFh,05Fh,0BFh,05Fh,0BFh,05Fh,0BFh,07Fh,0BFh,07Fh,0BFh,07Fh
     DB 0BFh,07Fh,0BFh,05Fh,0BFh,05Fh,0BFh,05Fh,0AFh,057h,0AFh,057h,0ABh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh
     DB 055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0FFh,009h,001h,0FFh,000h,009h,052h,000h,0FFh,009h,001h,0FFh,055h,0AAh,055h,0AAh,055h
     DB 0AAh,055h,0AAh,055h,0ABh,057h,0ABh,057h,0AFh,05Fh,0BFh,07Fh,0FFh,07Fh,0FFh,009h,01Ah,0FFh,0FEh,009h,001h
     DB 0FEh,0FCh,0FDh,009h,001h,0FDh,0FBh,009h,002h,0FBh,0FAh,0FBh,009h,002h,0FBh,0FDh,009h,001h,0FDh,0FCh,0FEh
     DB 009h,001h,0FEh,0FFh,009h,019h,0FFh,0FCh,009h,001h,0FCh,07Ch,009h,002h,07Ch,07Dh,039h,03Bh,009h,005h,03Bh
     DB 039h,0B9h,07Ch,0BCh,07Ch,0BEh,07Eh,0BFh,07Fh,0FFh,07Fh,009h,002h,07Fh,0FFh,009h,018h,0FFh,07Fh,009h,008h
     DB 07Fh,0BFh,009h,006h,0BFh,0FFh,009h,003h,0FFh,0EFh,0FFh,009h,00Fh,0FFh,0FEh,009h,001h,0FEh,0FCh,0FDh,009h
     DB 001h,0FDh,0FBh,009h,002h,0FBh,0FAh,0FBh,009h,002h,0FBh,0FDh,009h,001h,0FDh,0FCh,0FEh,009h,001h,0FEh,0FFh
     DB 009h,007h,0FFh,07Fh,0BFh,05Fh,0AFh,057h,0ABh,057h,0ABh,057h,0ABh,057h,0ABh,055h,0ABh,055h,0ABh,055h,0ABh
     DB 055h,0ABh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0FFh,009h,001h,0FFh,000h,009h,052h,000h
     DB 0FFh,009h,001h,0FFh,055h,0AAh,055h,0ABh,057h,0AFh,07Fh,0FFh,009h,021h,0FFh,0FEh,0F1h,0C7h,09Dh,03Dh,05Eh
     DB 0EFh,0F7h,07Bh,0BDh,0CEh,0F3h,0FFh,004h,0FCh,0F3h,0EEh,09Dh,0FBh,0F7h,0EFh,05Eh,03Dh,09Dh,0C7h,0F1h,0FEh
     DB 0FFh,009h,012h,0FFh,0C1h,080h,000h,009h,004h,000h,0C3h,009h,001h,0C3h,081h,000h,018h,009h,002h,018h,0BDh
     DB 0FFh,009h,001h,0FFh,0E7h,000h,009h,004h,000h,080h,0C1h,0F3h,0FFh,009h,03Ah,0FFh,0FEh,0F1h,0C7h,09Dh,03Dh
     DB 05Eh,0EFh,0F7h,07Bh,0BDh,0CEh,0F3h,0FFh,004h,0FCh,0F3h,0EEh,09Dh,0FBh,0F7h,0EFh,05Eh,03Dh,09Dh,0C7h,0F1h
     DB 0FEh,0FFh,009h,013h,0FFh,07Fh,009h,001h,07Fh,07Bh,0FFh,0FDh,009h,001h,0FDh,0FFh,07Bh,0FFh,07Fh,0BFh,05Fh
     DB 0BFh,055h,0FFh,009h,001h,0FFh,000h,009h,052h,000h,0FFh,009h,001h,0FFh,055h,0AAh,0FDh,0FEh,0FFh,0FEh,009h
     DB 001h,0FEh,0FDh,0FFh,009h,020h,0FFh,003h,0FCh,0DFh,0DEh,0DDh,0FDh,0DBh,05Fh,056h,0BDh,0DBh,07Eh,0DFh,08Ch
     DB 0DBh,076h,0DBh,0B5h,0D6h,05Bh,0DBh,0FDh,0DDh,0DEh,0DFh,0FCh,003h,0FFh,009h,014h,0FFh,03Fh,009h,003h,03Fh
     DB 01Fh,09Fh,009h,001h,09Fh,0CFh,009h,005h,0CFh,08Fh,009h,001h,08Fh,01Fh,009h,002h,01Fh,03Fh,009h,001h,03Fh
     DB 07Fh,0FFh,009h,03Dh,0FFh,003h,0FCh,0DFh,0DEh,0DDh,0FDh,0DBh,05Fh,056h,0BDh,0DBh,07Eh,0DFh,08Ch,0DBh,076h
     DB 0DBh,0B5h,0D6h,05Bh,0DBh,0FDh,0DDh,0DEh,0DFh,0FCh,003h,0FFh,009h,020h,0FFh,055h,0FFh,009h,001h,0FFh,000h
     DB 009h,052h,000h,0FFh,009h,001h,0FFh,055h,0AAh,055h,0AAh,055h,0AAh,0D5h,0EAh,0B5h,0FAh,0FDh,0FEh,0FFh,009h
     DB 01Dh,0FFh,07Fh,01Fh,0CFh,0E7h,0D3h,0BBh,079h,0FDh,0EDh,0BEh,0FEh,009h,001h,0FEh,012h,0FEh,07Eh,09Eh,0EDh
     DB 0FDh,079h,0BBh,0D3h,0E7h,0CFh,01Fh,07Fh,0FFh,009h,069h,0FFh,07Fh,01Fh,0CFh,0E7h,0D3h,0BBh,079h,0FDh,0EDh
     DB 0BEh,0FEh,009h,001h,0FEh,012h,0FEh,07Eh,09Eh,0EDh,0FDh,079h,0BBh,0D3h,0E7h,0CFh,01Fh,07Fh,0FFh,009h,01Ah
     DB 0FFh,0FEh,0FFh,0FEh,0FFh,009h,002h,0FFh,0BEh,055h,0FFh,009h,001h,0FFh,000h,009h,052h,000h,0FFh,009h,001h
     DB 0FFh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,0D5h,0AAh,0D5h,0AAh
     DB 0D5h,0AAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0FDh,0FEh,0FFh
     DB 0FEh,0FFh,009h,018h,0FFh,0FEh,0FFh,0FEh,0FDh,0FAh,0F5h,0EAh,0F5h,0EAh,0F5h,0EAh,0F5h,0FAh,0F5h,0FAh,0F5h
     DB 0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh
     DB 0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h
     DB 0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh
     DB 0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h,0FAh,0F5h
     DB 0FAh,0F5h,0FAh,0FDh,0FEh,0FFh,009h,01Ah,0FFh,0FEh,0FDh,0FAh,0F5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h,0EAh,0D5h
     DB 0EAh,0D5h,0EAh,0D5h,0AAh,0D5h,0AAh,0D5h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,055h,0AAh,0D5h,0AAh,055h,0AAh
     DB 055h,0FFh,009h,001h,0FFh,000h,009h,052h,000h,0FCh,009h,001h,0FCh,07Ch,02Ch,07Ch,02Ch,07Ch,02Ch,0FCh,0ACh
     DB 0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh
     DB 0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,02Ch,0FCh,0ACh,0FCh,0ECh,0DCh,0CCh
     DB 0FCh,0ECh,0FCh,0ECh,0FCh,0ECh,0FCh,0ECh,0FCh,0ECh,0DCh,0ECh,0FCh,0ACh,0FCh,02Ch,07Ch,02Ch,07Ch,02Ch,0FCh
     DB 0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh
     DB 0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh
     DB 0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh
     DB 0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh
     DB 0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,0ACh,0FCh,02Ch,07Ch,0ACh
     DB 0FCh,0ECh,0FCh,0CCh,0DCh,0ECh,0FCh,0ECh,0FCh,0ECh,0FCh,0ECh,0FCh,0ECh,0FCh,0CCh,0DCh,0CCh,0DCh,08Ch,05Ch
     DB 00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch
     DB 05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,00Ch,05Ch,0FCh,009h,001h,0FCh,000h,009h
     DB 0FFh,000h,009h,0FFh,000h,009h,0FFh,000h,009h,0FFh,000h,009h,0FFh,000h,009h,071h,000h,001h,009h,001h,001h
     DB 000h,009h,00Fh,000h,001h,009h,001h,001h,000h,009h,02Dh,000h,001h,009h,001h,001h,000h,009h,013h,000h,001h
     DB 009h,008h,001h,000h,001h,003h,009h,001h,003h,000h,009h,02Bh,000h,001h,009h,001h,001h,000h,009h,0AAh,000h
     DB 007h,03Fh,0F8h,0F0h,0E0h,009h,001h,0E0h,0C3h,0FFh,009h,007h,0FFh,0F0h,080h,0C0h,0F0h,0FFh,009h,001h,0FFh
     DB 0E0h,000h,009h,001h,000h,080h,087h,0FFh,009h,007h,0FFh,0F0h,080h,083h,0FFh,009h,007h,0FFh,0F8h,0C0h,080h
     DB 009h,001h,080h,000h,080h,08Fh,0FFh,009h,007h,0FFh,0F8h,0C0h,081h,08Fh,0CFh,0E0h,0F0h,0FFh,009h,001h,0FFh
     DB 0C0h,000h,009h,00Dh,000h,01Fh,03Fh,07Fh,0FFh,009h,005h,0FFh,09Fh,00Fh,007h,009h,001h,007h,003h,083h,0C1h
     DB 0FDh,0FCh,0F0h,000h,009h,004h,000h,087h,0FFh,0FEh,0FFh,009h,006h,0FFh,08Fh,038h,07Fh,0FFh,009h,006h,0FFh
     DB 0F8h,0C0h,080h,009h,001h,080h,000h,009h,005h,000h,003h,027h,03Ch,07Eh,07Fh,009h,002h,07Fh,0FFh,009h,004h
     DB 0FFh,003h,000h,009h,007h,000h,080h,087h,0FFh,009h,007h,0FFh,0F8h,0C0h,080h,009h,001h,080h,000h,009h,006h
     DB 000h,080h,087h,0FFh,009h,007h,0FFh,0F8h,0C0h,080h,009h,001h,080h,000h,009h,081h,000h,001h,01Fh,0FFh,009h
     DB 006h,0FFh,0F8h,000h,009h,008h,000h,003h,03Fh,0FFh,009h,006h,0FFh,0F8h,080h,081h,09Fh,0FFh,009h,006h,0FFh
     DB 0F8h,080h,000h,009h,003h,000h,003h,07Fh,0FFh,009h,006h,0FFh,0FCh,080h,009h,001h,080h,0CCh,0FCh,0F1h,001h
     DB 003h,007h,01Fh,018h,000h,009h,00Bh,000h,001h,03Fh,009h,001h,03Fh,087h,0C1h,0C0h,0E0h,009h,001h,0E0h,0F0h
     DB 009h,002h,0F0h,0F8h,0FFh,009h,007h,0FFh,0FEh,078h,000h,009h,002h,000h,003h,03Fh,0FFh,0C0h,000h,0FFh,009h
     DB 002h,0FFh,0FCh,0F8h,0F0h,0E0h,0C7h,0FFh,009h,006h,0FFh,0FCh,0C0h,000h,009h,004h,000h,003h,007h,00Fh,03Fh
     DB 0F8h,0D0h,010h,009h,002h,010h,0F8h,0FFh,009h,007h,0FFh,01Fh,001h,000h,009h,004h,000h,003h,03Fh,0FFh,009h
     DB 006h,0FFh,0FCh,0C0h,000h,009h,002h,000h,001h,003h,00Fh,01Fh,018h,000h,009h,001h,000h,003h,03Fh,0FFh,009h
     DB 006h,0FFh,0FCh,0C0h,000h,009h,002h,000h,001h,003h,00Fh,01Fh,018h,000h,009h,079h,000h,020h,009h,002h,020h
     DB 060h,0E0h,009h,008h,0E0h,020h,009h,002h,020h,000h,009h,003h,000h,020h,009h,001h,020h,060h,0E0h,009h,008h
     DB 0E0h,020h,009h,001h,020h,0E0h,009h,008h,0E0h,020h,009h,001h,020h,000h,020h,009h,001h,020h,060h,0E0h,009h
     DB 008h,0E0h,020h,009h,001h,020h,060h,009h,001h,060h,0E0h,009h,001h,0E0h,0F0h,009h,001h,0F0h,0C0h,000h,009h
     DB 00Dh,000h,0E0h,009h,001h,0E0h,0C0h,009h,003h,0C0h,060h,020h,009h,002h,020h,060h,009h,001h,060h,0E0h,009h
     DB 001h,0E0h,0C0h,009h,002h,0C0h,080h,000h,009h,003h,000h,020h,060h,0E0h,009h,003h,0E0h,060h,020h,080h,009h
     DB 001h,080h,000h,009h,001h,000h,020h,009h,001h,020h,0E0h,009h,008h,0E0h,020h,009h,003h,020h,060h,009h,001h
     DB 060h,0E0h,009h,004h,0E0h,060h,020h,000h,020h,009h,001h,020h,060h,0E0h,009h,009h,0E0h,060h,020h,009h,002h
     DB 020h,060h,0E0h,009h,008h,0E0h,020h,009h,001h,020h,060h,009h,001h,060h,0E0h,0F0h,009h,001h,0F0h,0E0h,000h
     DB 020h,009h,001h,020h,060h,0E0h,009h,008h,0E0h,020h,009h,001h,020h,060h,009h,001h,060h,0E0h,0F0h,009h,001h
     DB 0F0h,0E0h,000h,009h,0FFh,000h,009h,0FFh,000h,009h,0FDh,000h,003h,007h,00Fh,01Fh,03Fh,009h,001h,03Fh,07Fh
     DB 009h,001h,07Fh,0FFh,009h,001h,0FFh,0F0h,0C0h,080h,009h,001h,080h,0C0h,060h,078h,07Fh,0FFh,0F0h,000h,009h
     DB 007h,000h,001h,013h,01Eh,03Fh,009h,003h,03Fh,07Fh,009h,001h,07Fh,0FFh,009h,001h,0FFh,07Fh,001h,000h,009h
     DB 007h,000h,040h,043h,07Fh,009h,007h,07Fh,07Ch,060h,041h,07Fh,009h,006h,07Fh,03Fh,009h,001h,03Fh,000h,009h
     DB 00Fh,000h,040h,043h,07Fh,009h,007h,07Fh,07Ch,060h,040h,07Fh,009h,003h,07Fh,03Fh,009h,001h,03Fh,01Fh,00Fh
     DB 003h,000h,009h,002h,000h,040h,047h,07Fh,009h,007h,07Fh,07Ch,060h,040h,047h,067h,070h,078h,07Fh,0FFh,0E0h
     DB 000h,009h,003h,000h,043h,07Fh,009h,008h,07Fh,047h,01Ch,03Fh,07Fh,009h,006h,07Fh,07Ch,060h,040h,009h,001h
     DB 040h,003h,007h,00Fh,01Fh,03Fh,009h,001h,03Fh,07Fh,009h,001h,07Fh,0FFh,009h,001h,0FFh,0FCh,0C0h,080h,087h
     DB 0FFh,009h,002h,0FFh,07Fh,009h,001h,07Fh,03Fh,01Fh,00Fh,003h,000h,009h,087h,000h,07Eh,0FFh,009h,007h,0FFh
     DB 0F0h,000h,009h,006h,000h,003h,009h,001h,003h,002h,000h,009h,003h,000h,001h,003h,007h,01Fh,07Ch,0E8h,088h
     DB 008h,009h,001h,008h,0FCh,0FFh,009h,007h,0FFh,00Fh,000h,009h,005h,000h,001h,01Fh,0FFh,009h,006h,0FFh,0FEh
     DB 0C0h,07Ch,0FFh,009h,001h,0FFh,0DFh,009h,003h,0DFh,09Fh,0BFh,0A1h,000h,009h,010h,000h,001h,03Fh,0FFh,009h
     DB 006h,0FFh,0FEh,0C0h,000h,003h,07Fh,0FFh,009h,006h,0FFh,0FEh,0F0h,000h,009h,001h,000h,001h,03Fh,0FFh,009h
     DB 006h,0FFh,0FEh,0C0h,040h,066h,0FEh,0F8h,080h,001h,003h,08Fh,08Ch,000h,009h,002h,000h,001h,01Fh,0FFh,0E0h
     DB 000h,0FFh,009h,002h,0FFh,0FEh,0FCh,0F8h,0F0h,0E3h,07Fh,0FFh,009h,005h,0FFh,0FEh,0E0h,000h,009h,002h,000h
     DB 0FCh,0FFh,009h,007h,0FFh,0FEh,0C0h,000h,001h,03Fh,0FFh,009h,006h,0FFh,0FEh,0FCh,0F0h,000h,009h,088h,000h
     DB 080h,0C0h,009h,001h,0C0h,0E0h,009h,001h,0E0h,0F0h,009h,002h,0F0h,010h,009h,003h,010h,030h,020h,060h,0C0h
     DB 080h,000h,010h,009h,001h,010h,030h,009h,001h,030h,070h,0F0h,009h,003h,0F0h,030h,010h,000h,010h,009h,001h
     DB 010h,030h,0F0h,009h,009h,0F0h,030h,010h,009h,002h,010h,030h,0F0h,009h,008h,0F0h,010h,009h,001h,010h,000h
     DB 0F0h,009h,008h,0F0h,030h,010h,009h,001h,010h,000h,009h,00Ah,000h,010h,009h,001h,010h,030h,0F0h,009h,008h
     DB 0F0h,010h,030h,070h,0F0h,009h,001h,0F0h,0E0h,009h,002h,0E0h,0C0h,009h,001h,0C0h,080h,000h,009h,001h,000h
     DB 010h,009h,001h,010h,030h,0F0h,009h,008h,0F0h,010h,009h,001h,010h,030h,009h,001h,030h,070h,0F0h,0F8h,009h
     DB 001h,0F8h,0E0h,080h,000h,010h,030h,070h,0F0h,009h,002h,0F0h,030h,010h,0C0h,009h,001h,0C0h,080h,000h,010h
     DB 009h,001h,010h,070h,0F0h,009h,007h,0F0h,010h,009h,001h,010h,000h,009h,004h,000h,080h,0C0h,0E0h,009h,001h
     DB 0E0h,0F0h,009h,002h,0F0h,010h,009h,001h,010h,030h,0F0h,009h,001h,0F0h,0E0h,009h,002h,0E0h,0C0h,009h,001h
     DB 0C0h,080h,000h,009h,0FFh,000h,009h,0FFh,000h,009h,0FFh,000h,009h,0FFh,000h,009h,0FFh,000h,009h,0FFh,000h
     DB 009h,0FFh,000h,009h,0D5h,

pict_bot:



;-------------------------------------------------------------------------
;
;
;     *********************** END OF PROGRAMM *********************
;
;

pili_bottom: ; NEED TO BE THERE FOR HEADER

  end
