; include file for fncall and other definitions

; each register can be use in all of the instructions, refering to them by
; a label is more convenient but not oblige
a       equ     01h ; virtuel register a
b       equ     02h ; virtuel register b
x       equ     03h ; virtuel register x
y       equ     04h ; virtuel register y
cx      equ     05h ; virtuel register cx
dx      equ     06h ; virtuel register dx
si      equ     07h ; virtuel register si

sto0    equ     10h ; storage virtual register
sto1    equ     11h ; storage virtual register
sto2    equ     12h ; storage virtual register
sto3    equ     13h ; storage virtual register
sto4    equ     14h ; storage virtual register
sto5    equ     15h ; storage virtual register
sto6    equ     16h ; storage virtual register
sto7    equ     17h ; storage virtual register
sto8    equ     18h ; storage virtual register
sto9    equ     19h ; storage virtual register



; NOTE REMARQUED FUNCTIONS ARE NOT IMPLEMENTED FOR THE MOMENT

OutText      equ     01  ; base display function all strings are null terminate
FormatPrint  equ     02  ; sprintf like display function all strings are null terminate
Locate       equ     03  ; cursor move
Glocate      equ     04  ; graphic cursor move
SetFont      equ     05  ; font selection (0,1,2 for Zaurus)
ClearScreen  equ     06  ; clear screen (0=white, 1=black)
DisplayImg   equ     07  ; display a picture (full screen)
OutChar      equ     08  ; display a single char at cursor
DispCursor   equ     09  ; display or hide hardware cursor (block cursor)
Gprint       equ     10  ; draw a small picture at graphic cursor
KbHit        equ     11  ; detect keyboard hit
KeyEvent     equ     12  ; detect a keyboard input (key down(0x01)/still down(0x02)/up(0x04))
GetKey       equ     13  ; wait until a key up event
PenEvent     equ     14  ; wait for a pen event (pen down(0x08)/still down(0x10)/up(0x20))
GetPen       equ     15  ; wait until pen up event
GetInput     equ     16  ; wait for a input (key or pen) event, see KeyEvent and PenEvent for description
GetDate      equ     17  ; get Date
PushWindow   equ     18  ; push screen
PopWindow    equ     19  ; popscreen
Reverse      equ     20  ; reverse a area
ChainProg    equ     21  ; call and transfert control to an other program
RsOpen       equ     23  ; open serial port (15 pin)
RsRead       equ     24  ; read serial port buffer  (15 pin)
RsWrite      equ     25  ; write serial port  (15 pin)
RsClose      equ     26  ; close serial port  (15 pin)
RsClear      equ     27  ; clear the serial (15pin) buffer
BoxDraw      equ     28  ; draw a box
LineDraw     equ     29  ; draw a line
OnBreak      equ     30  ; handle the break event, if not the programm stop when pressed
OnPen        equ     31  ; handle Pen event
OnKey        equ     32  ; handle Key event
OnSerial     equ     33  ; handle Serial event
EventRead    equ     34  ; read if an event is there, but don't wait until an event comes
ScrollScreen equ     41  ; scroll part of the screen, x/y/x1/y1:nb line are stored in registers starting at p1
PlotPixel    equ     36  ; plot a pixel at gcurx/gcury , color and display mode of pixel is equ thrue p1 and p2
InfoBox      equ     37  ; display a text with 'I SEE' or 'OK/CANCEL' icons, works like outtext + p2 param is 1 or 2 for the 2 options
BoxPaint     equ     38  ; draw and paint a box
BoxMove      equ     39  ; move a screen part
ReadPixel    equ     40  ; read a pixel from screen
DispScroll   equ     41  ; scroll part of the screen, x/y/x1/y1:nb line are stored in registers starting at p1
AreaClear    equ     42  ; clear a screen part
IconMap      equ     43  ; Icon support:  dw xt,yt,xb,yb,retval,keyshortcut     (total len=12 per icon)
Wait16ms     equ     44  ; Wait the specified amount of time (time specified in register p2)
GetTime      equ     45  ; get time
PlaySound    equ     46  ; play the sound in register p2
MaskEdit     equ     47  ; Edit a string with mask
AtoL         equ     48  ; convert a string into a long
AtoF         equ     49  ; convert a string into a float
Fopen        equ     50  ; open a file
Fclose       equ     51  ; close a file
FcloseAll    equ     52  ; close all files
Fread        equ     53  ; read a buffer
Fwrite       equ     54  ; write a buffer
Fputc        equ     55  ; write a byte
Fgetc        equ     56  ; read a byte
Fgets        equ     57  ; read a string (ended with 0d/0a)
Fputs        equ     58  ; write a string
FDir         equ     59  ; create a file with the list of files of the disk
FUnlink      equ     60  ; supress a file
Ftell        equ     61  ; return the offset of the file pointer
Fseek        equ     62  ; set the offset of the file pointer
Frewind      equ     63  ; rewind a file (set the offset of the file pointer to 0)
Ftrunc       equ     64  ; truncatet a file a the curent file pointer offset
Fsize        equ     65  ; return the size of the file
Fprintf      equ     66  ; output a formated string to a file
StrCpy       equ     67  ; copy a string into an other
StrCmp       equ     68  ; compare a string to an other
StrChr       equ     69  ; search a single character into a string
StrCat       equ     70  ; join to string
StrLen       equ     71  ; calculate the number of car of the string
StrStr       equ     72  ; search a string into an other
ImportPcFile equ     73  ; copy a file from PC-FILE into internal PILI virtual disk
ExportPcFile equ     74  ; copy a file from internal PILI virtual disk  into PC-FILE
KillPcFile   equ     75  ; delete a specified PC-FILE
SaveProg2PcFile equ  76  ; copy a pili program contain into pili's virtual memory up to PC-FILE
SelectPcFile equ     77  ; get a pc-file name from a list
HyperHelp    equ     78  ; Activate and launch the hyper help interpretor
SetFontMode  equ     79  ; Set the display of the font (Italic/Bold/underlined/reversed) */
GetCursor    equ     80  ; return the cursor (x/y)
GetGCursor   equ     81  ; return the graphic cursor (x/y)
FormatVdisk  equ     82  ; format the internal vdisk
GetRandom    equ     83  ; read a 32 bit internal counter (cpu clock)
GetVersion   equ     84  ; return pili/mpl version
PcLink       equ     85  ; open pclink
PowerOff     equ     86  ; power off unit
Text2Graph   equ     87  ; convert text coordonates to graphic coordonates

; gprint display modes
GP_SET       equ 0
GP_XOR       equ 1
GP_AND       equ 2
GP_OR        equ 3
GP_REV       equ 4

; for scroll functions
GP_UP        equ 1
GP_DOWN      equ 0

; for line and box
GP_SOLID_LINE         equ     1   ;    /*      ---------- */
GP_DOTTED_LINE        equ     2   ;    /*      - - - - - -*/
GP_L_DOTTED_LINE      equ     3   ;    /*      -  -  -  - */
GP_REAL_BROKEN_LINE   equ     4   ;    /*      --  --  -- */
GP_DOT_CHAINED_LINE   equ     5   ;    /*      --  -  --  */
GP_BROKEN_LINE        equ     2   ;    /* dotted line */


; for box paint
GP_BLACK              equ     1
GP_DARK_GRAY          equ     2
GP_GRAY               equ     3
GP_L_GRAY             equ     4   ; GP_LIGHT_GRAY
GP_BORDER             equ     5
GP_STRIPE             equ     6
GP_RIGHT_INCLINE      equ     7
GP_LEFT_INCLINE       equ     8
GP_CHECKS             equ     9
GP_H_BRICK            equ     10
GP_HEART_SHAPED       equ     11

;------
; Serial parameters
;

BPS300                equ     0001h
BPS600                equ     0002h
BPS1200               equ     0003h
BPS2400               equ     0004h
BPS4800               equ     0005h
BPS9600               equ     0006h
BPS14400              equ     0084h
BPS19200              equ     0007h
BPS28800              equ     0085h
BPS38400              equ     0008h

P_EVEN                equ     0000h
P_ODD                 equ     0004h
P_NONE                equ     0008h

BIT_LEN8              equ     0000h
BIT_LEN7              equ     0002h

STP_BIT1              equ     0000h
STP_BIT2              equ     0001h

SEND_XON_OFF          equ     0001h
SEND_X_NONE           equ     0000h
RECV_XON_OFF          equ     0200h
RECV_X_NONE           equ     0100h
;---------------------------------------------------------------------------
 END
