;
; ALL APPLI NEAD TO START WITH THIS AND TO END WITH THE BOTTOM'S LABEL'S
;
; PILI BINARY MAIN  = main code, always called in first, need to be only once in memory
; PILI BINARY xxxx  = programme chain (maxi 9999), each header needs to exist only once
pili_header:
     JR start                   ; jump to start of prog
     dl pili_bottom-pili_header ; /* size of binary image */
     db "PILI BINARY MAIN "     ; header for beta, main application
     db 0                       ; null terminate
;   information on the program
DispInfo:
     db 1                       ; No button=0, OK button=1 (same as infobox function)
     db " ****** PILI GAME DEMO ****** "; infobox title
     db 0dh                     ; change line
     db "Written by P.Dehlinger            "; Informations
     db 0dh                     ; change line
     db "Graphics by Bo Lorentzen              "; Informations
     db 0dh                     ; change line
     db "Inspired from Franquin            "; Informations
     db 0dh                     ; change line
     $DATE_TIME                 ; get date and time of compile, (null terminate)


; other extensions
;     $MODULE               ; name of the module
;     $LINE                 ; line under compilation

;
; -------------- end of top header --------------
;
;





; include file for library definitions and virtual registers assignement
 include fncall.inc




;-----------------------------------------------------------------------------
;
;
;
; YOU PROGRAMM START
;

; essai de tire avec aquisition de point en colision
; deplacement d'une raquette par gestion d'evenement touche (< et >)


;
; event trap function to handle the move of the bar
;

ubartx set  050h ; top bar x
ubarty set  051h ; top bar y
ubarbx set  052h ; bottom bar x
ubarby set  053h ; bottom bar y
bartype set 054h ; apparence of the bar
sizeofbar set 055h ; number of pixels width of the bar

ballmx set 56h   ; x address of the ball
ballmy set 57h   ; y address of the ball
ballxc set 58h   ; x coord of the ball
ballyc set 59h   ; y coord of the ball
ballbxc set 5ah  ; x coord of the ball (bottom)
ballbyc set 5bh  ; y coord of the ball (bottom)
ballmde set 5ch  ; box shape
ballsize set 5dh ; ball size
ball_on set 5eh  ; ball on board (user did press start)

sound   set 5fh  ; sound register
MaxBall set 60h  ; number of balls available
score   set 61h  ; the score
Rboard  set 62h  ; the right boarder coord
Lboard  set 63h  ; the left boader coord
Scx     set 64h  ; the score x display coord
Scy     set 65h  ; the score y display coord


;
;  ------ macro's need to be on top, after declarations and before code ------
;


;
; move the ball
; need too add the colision detection
;

MoveBall    MACRO
     CMP16  ballxc,276         ; border ?
     JRNZ   @0                 ; no, continue
     CALL   BallSound          ; play touch sound
     RLD32  ballmx,-6          ; dec x
     JR     @1                 ; jump to y test
@0:
     CMP16  ballxc,42          ; border ?
     JRNZ   @1                 ; no, keep going
     CALL   BallSound          ; play touch sound
     RLD08  ballmx,6           ; inc x
@1:
     CMP16  ballyc,24
     JRNZ   @2
     CALL   BallSound          ; play touch sound
     RLD08  ballmy,6           ; inc y
@2:    ; display

     FNCALL08  BoxPaint,ballxc,GP_XOR

     ADD16  ballxc,ballmx           ; ball x move (x=x+ballmx)
     ADD16  ballyc,ballmy           ; ball y move (y=y+ballmy)
     ADD16  ballbxc,ballmx          ; ball x move (x=x+ballmx) (bottom)
     ADD16  ballbyc,ballmy          ; ball y move (y=y+ballmy) (bottom)
     FNCALL08  BoxPaint,ballxc,GP_XOR
;     RET  ; not use in macro, set if use under CALL method
 ENDM


WAIT  MACRO
     RLD16   sto0,?1
     loop    sto0,$        ; bug in vasm with $ if relative address
      ENDM
;
; -------------- end of macro's definitions ------
;


;
; start of application
;

start:

     FNCALL08 ClearScreen,0         ; clear the screen


     FNCALL DisplayImg,Gast1  ; display the picture
     WAIT 200                 ; wait to see the picture
     FNCALL DisplayImg,Gast2  ; display the picture
     WAIT 200                 ; wait to see the picture
     FNCALL DisplayImg,Gast4  ; display the picture
     WAIT 150                 ; wait to see the picture
     FNCALL DisplayImg,Gast5  ; display the picture

     WAIT 300                 ; wait to see the picture

     FNCALL16 InfoBox,DispInfo,sto0    ; diplay the information window, no answers into registers if -1

; game inits
      RLD08  MaxBall,3         ; maxi 3 balls
      RLD08  score,0           ; you start at 0 for the score
      CALL  PrintScore         ; will compare , display score and init registers
; set the bat registers (size and start)
     RLD08   sizeofbar,24     ; size of the bar
     RLD16   ubartx,155
     RLD16   ubarty,198+4
     RLD16   ubarbx,155
     ADD16   ubarbx,sizeofbar
     RLD16   ubarby,200+4
     RLD08   bartype,GP_BLACK

GameStart:
;??? don't work    FNCALL16 InfoBox,DispRestart,sto0    ; diplay a wait window

; Wait a key before starting
;     FNCALL  GetKey,0,sto0

; draw the border
     RLD08   sto0,41
     RLD08   sto1,23
     RLD16   sto2,282
     RLD16   sto3,220  ; rld08 is SIGNED so warning on char > 127, use RLD16
     RLD08   sto4,GP_BLACK
     FNCALL08  AreaClear,sto0,0      ; 0=white
     FNCALL08  BoxDraw,sto0,GP_SET

; set the left and right boarder limit
     RLD16  Rboard,281
     SUB16  Rboard,sizeofbar
     RLD16  Lboard,42

; draw the bar
     FNCALL08  BoxPaint,ubartx,GP_SET



; first print for the ball
     RLD08   ballmx,6        ; move start (go left)
     RLD32   ballmy,-6       ; move start (go up)
     RLD16   ballxc,60+54+54    ; ball x origine
     RLD16   ballyc,198      ; ball y origine
     RLD08   ballmde,GP_BLACK; ball shape
     RLD08   ballsize,3      ; ball size
     RMV16  ballbyc,ballyc
     ADD16  ballbyc,ballsize
     RMV16  ballbxc,ballxc
     ADD16  ballbxc,ballsize
     FNCALL08  BoxPaint,ballxc,GP_XOR

;  JR MoveDone

grloop:
; you must use 32bit data's when using signed
     FNCALL EventRead,-1,sto0 ; read the incomming event (this event NOT cleared)
     CMP08  sto0,010h         ; wait for pen up event (8/10h/20h)
     JRZ    kd1
     CMP08  sto0,0
     JRZ    MoveDone          ; no event to read !
     FNCALL08 EventRead,0,sto0  ; read the incomming event (this event IS cleared)
     JR     MoveDone          ; not a wanted event
kd1:
     FNCALL08 PenEvent,0,sto0   ; read the incomming pen event, wait if an event is specified
                              ; p2: 0 if whatever pen event, else the wanted one
                              ; for pen: sto0=posx
                              ; for pen: sto1=posy
                              ; for pen: sto2=start pos x
                              ; for pen: sto3=start pos y
                              ; for pen: sto4=button (not use on zaurus)
                              ; for pen: sto5=time of the event
                              ;        : sto6=event
     CMP16  sto6,010h         ; pen still down
     JRNZ   MoveDone
     FNCALL08  BoxPaint,ubartx,GP_XOR
     REGCMP sto0,Rboard       ; right boarder
     JRC    notrb
     RMV16  sto0,Rboard       ; max boarder
     JR     calcmove
notrb:
     REGCMP sto0,Lboard       ; left boarder
     JRNC   calcmove
     RMV16  sto0,Lboard       ; min boarder
calcmove:
     RMV16  ubartx,sto0       ; moves posx into ubartx (next pos x)
     RMV16  ubarbx,ubartx
     ADD16  ubarbx,sizeofbar
     FNCALL08  BoxPaint,ubartx,GP_SET
MoveDone:

; now need to move the ball
     MoveBall  ; display and move the ball

; test colision

; first with the bat
     CMP16  ballyc,198        ;
     JRC    TestBric          ; other test
     JRZ    BallOnBat         ; ball could be on the bat
     JR     BallOut           ; ball is out of game
BallOnBat:
     REGCMP ubarbx,ballxc     ; ball on the right of the bat ?
     JRC    BallOut           ; not on bat
     REGCMP ubartx,ballxc     ; ball on the left of the bat ?
     JRNC   BallOut           ; not on bat, so out !
; it is on the bat
     CALL   BallSound         ; play touch sound
     INC    score             ; score +1
; compare score to set difficulty
     CMP    sizeofbar,13
     JRC    NoDifChange       ; the bat can't be less than 12 pixels
     RLD08  sto0,5            ; each 5 hit will DEC the size of the bat
     RMV16  sto1,score
     MOD16  sto1,sto0         ; if modulo 5 then change difficulty
     CMP16  sto1,0
     JRNZ   NoDifChange
     DEC    sizeofbar
     RLD16  Rboard,281
     SUB16  Rboard,sizeofbar
     CALL   WallSound
NoDifChange:
; change ball y coord, now decrements (go to top)
     RLD32  ballmy,-6         ; dec y
     RMV16  sto0,ubartx       ;
     RLD16  sto1,9            ; detect if on 3 right pixels part of the bat
     ADD16  sto0,sto1         ;
     REGCMP sto0,ballxc
     JRNC   NotInvB
     RLD08  ballmx,6          ; yes inverse x
     JR     ScDisp
NotInvB:
     RMV16  sto0,ubarbx       ;
     RLD16  sto1,9            ; detect if on right part of the bat
     SUB16  sto0,sto1         ;
     REGCMP sto0,ballxc
     JRC    ScDisp            ; not on 3 left pixels
     RLD32  ballmx,-6         ; inverse x

ScDisp:
     CALL  PrintScore    ; will compare and display score
; second with the wall
TestBric:

; loop until break
     jr    grloop
BallOut:
     RLD16 sto0,8
OutSound:
     CALL  WallSound
     CALL  BallSound
     LOOP  sto0,OutSound



; test if there is a ball left
     DEC   MaxBall       ; ball=ball-1
     CMP   MaxBall,0     ; no more balls
     JRZ   EndGame
     JR    GameStart     ; new ball

; game over
EndGame:
     FNCALL DisplayImg,Gast6  ; display the picture
     WAIT 600                 ; wait to see the picture
     jr start      ; for the test
     EXIT
; sub functions
;

; compare and display score

PrintScore:
     RLD16  x,Hscore      ; address of hi-score
     RLD08  b,1           ; just one register
     LOAD16 y,x,b        ; read into y
     REGCMP y,score      ; compare with hi-score
     JRNC   NotHiScore
     STOR16 score,x,b    ; write the new hi-score
NotHiScore:
     RLD16  x,Yscore      ; address of Your score
     RLD08  b,1           ; just one register
     STOR16 score,x,b     ; write into y

     RLD16  x,BallNum     ; address of Ballnum (number of ball to go)
     RLD08  b,1           ; just one register
     RMV08  sto0,MaxBall
     DEC    sto0
     STOR16 sto0,x,b      ; write into y

     FNCALL08 SetFont,1   ; font 0 (small font)
     RLD08   Scx,7       ; x coord
     RLD08   Scy,17      ; y coord
     FNCALL08 Locate,Scx ; set position
     FNCALL  FormatPrint,ScoreDisp
     RET

; play the sound when ball touch a boarder
BallSound:
     RLD16  sound,0
     FNCALL08 PlaySound,sound
     RET

; play the sound when ball touch the wall
WallSound:
     RLD16  sound,1
     FNCALL08 PlaySound,sound
     RET


;
; test the edit function
;
Test_Edit:
    FNCALL08 SetFont,1    ; font 1: normal font
    RLD08 sto0,10         ; xcur
    RLD08 sto1,10         ; ycur
    FNCALL08 Locate,sto0  ; set position
    FNCALL08 DispCursor,1 ; set cursor to display

    RLD16 sto0,080h   ; text only
    RLD16 sto1,009h   ; tab exit | mode_insert
    RLD16 sto2,11     ; len (only up to 'n')
    RLD16 sto3,80     ; always 80 (reserved for future use)
    RLD32 sto4,strex  ; unallowed characters
    RLD32 sto5,stredit; string
    FNCALL08 MaskEdit,sto0,sto6   ; call edit function return is in sto6 register

    RET
; string to edit
stredit:     ; string to edit
DB "Ceci est un essai"
DB 0
strex:       ; exclude characters
DB "/-."
DB 0

; score display

ScoreDisp:  ; to display the score and high score
       db " [BALL: %01.01d] [SCORE: %05.05d]  [BEST: %05.05d] "
       db 0
BallNum: ; graphic coord are written there
     dw 0
Yscore: ; graphic coord are written there
     dw 0
Hscore:
     dw 0


DispRestart:
     db 1                       ; No button=0, OK button=1 (same as infobox function)
     db " ****** PILI GAME DEMO ****** "; infobox title
     db 0dh
     db "<<<    WALL BREAKER    >>>" ; infobox title
     db 0dh                     ; change line
     db "--- READY TO START ? ---"; infobox title
     db 0dh                     ; change line
     db " Press OK when ready   ";   Informations
     db 0
; pictures include
;


gast1:
     dw gast1_bot-gast1_data  ; size of image
gast1_data:
  binclude gaston1.bin
gast1_bot:

gast2:
     dw gast2_bot-gast2_data  ; size of image
gast2_data:
  binclude gaston2.bin
gast2_bot:

;gast3:
;     dw gast3_bot-gast3_data  ; size of image
;gast3_data:
;  binclude gaston3.bin
;gast3_bot:

gast4:
     dw gast4_bot-gast4_data  ; size of image
gast4_data:
  binclude gaston4.bin
gast4_bot:

gast5:
     dw gast5_bot-gast5_data  ; size of image
gast5_data:
  binclude gaston5.bin
gast5_bot:

gast6:
     dw gast6_bot-gast6_data  ; size of image
gast6_data:
  binclude gameover.bin
gast6_bot:

;-------------------------------------------------------------------------
;
;
;     *********************** END OF PROGRAMM *********************
;
;

pili_bottom: ; NEED TO BE THERE FOR HEADER

  end
