;Here is the OP-CODE list of PILI interpreter
;mainly it is 32 bit operations but end of opcode indicate the wide of operands
;example: MULT08 will do a 8 bit multiplication but MULT32 will do a 32 bit (long int) operation.
;also a MOVE operation (no specifications) will deal with 32bits.
;
;p1       : means the first parameter value
;(p1)     : means value of register indicate by the first parameter
;[p1]     : means address pointed by the direct value
;[(p1)]   : means address pointed by the register p1
;(p1)[p2] : means that the register p1 is considere as an array of 4 bytes and that
;         : we access at the p2 byte of this array
;         : ex: if (p1) is 12 34 56 78 h then (p1)[2] is 56h and (p1)[0] is 12h
;
;
;
;opcodes:
;

EXIT       00  01 00 ; end of program (stop PILI execution definitively)


MULT08    01  03 05 ;(p1)*(p2) -> (p1) (8 bits)
MULT16    02  03 05 ;(p1)*(p2) -> (p1) (16 bits)
MULT32    03  03 05 ;(p1)*(p2) -> (p1) (32 bits)
DIV08     04  03 05 ;(p1)/(p2) -> (p1)
DIV16     05  03 05 ;(p1)/(p2) -> (p1)
DIV32     06  03 05 ;(p1)/(p2) -> (p1)
MOD08     07  03 05 ;(p1)%(p2) -> (p1)
MOD16     08  03 05 ;(p1)%(p2) -> (p1)
MOD32     09  03 05 ;(p1)%(p2) -> (p1)
ADD08     0A  03 05 ;(p1)+(p2) -> (p1)
ADD16     0B  03 05 ;(p1)+(p2) -> (p1)
ADD32     0C  03 05 ;(p1)+(p2) -> (p1)
SUB08     0D  03 05 ;(p1)-(p2) -> (p1)
SUB16     0E  03 05 ;(p1)-(p2) -> (p1)
SUB32     0F  03 05 ;(p1)-(p2) -> (p1)



RMV08     10  03 05 ;(p2) -> (p1)
RMV16     11  03 05 ;(p2) -> (p1)
RMV32     12  03 05 ;(p2) -> (p1)
RLD08     13  03 05 ;p2 -> (p1)
RLD16     14  04 09 ;p2 -> (p1)
RLD32     15  06 0D ;p2 -> (p1)



RGMOVE     16  04 15 ;(p2) -> (p1) for (p3) moves (full registers moves)
RGSWAP     17  04 15 ;(p2) <-> (p1) for (p3) moves (full registers moves)
IMOVE      18  04 15 ;[(p2)] -> [(p1)] for (p3) bytes (p3 is 16bits)
MOVE       19  0B 2F ;[p2] -> [p1] for p3 bytes (p3 is 16bits)
LOAD08     1A  04 15 ;[(p2)] -> (p1) for (p3) registers (8 bits/registers)
LOAD16     1B  04 15 ;[(p2)] -> (p1) for (p3) registers (16 bits/registers)
LOAD32     1C  04 15 ;[(p2)] -> (p1) for (p3) registers (32 bits/registers)
STOR08     1D  04 15 ;(p1) -> [(p2)] for (p3) registers (8 bits/registers)
STOR16     1E  04 15 ;(p1) -> [(p2)] for (p3) registers (16 bits/registers)
STOR32     1F  04 15 ;(p1) -> [(p2)] for (p3) registers (32 bits/registers)



GBYTE      20  03 15 ;(p1)[p2]->(p3)         byte move
PBYTE      21  05 55 ;(p1)[p2]->(p3)[p4]     byte move
GWORD      22  03 15 ;(p1)[p2]->(p3)         word move
PWORD      23  05 55 ;(p1)[p2]->(p3)[p4]     word move
PMOVE      24  05 55 ; under redefinition



AND        25  06 0D ;(p1) and p2 flag Z is set if result = 0
AND08      26  03 05 ;(p1) and p2 flag Z is set if result = 0
AND16      27  04 09 ;(p1) and p2 flag Z is set if result = 0
REGAND     28  03 05 ;(p1) and (p2) flag Z is set if result = 0
REGAND08   29  05 55 ;(p1)[p2] and (p3)[p4] flag Z is set if result = 0
REGAND16   2A  05 55 ;(p1)[p2] and (p3)[p4] flag Z is set if result = 0

OR         2B  06 0D ;(p1) or p2
OR08       2C  03 05 ;(p1) or p2
OR16       2D  04 09 ;(p1) or p2
REGOR      2E  03 05 ;(p1) or (p2)
REGOR08    2F  05 55 ;(p1)[p2] or (p3)[p4]
REGOR16    30  05 55 ;(p1)[p2] or (p3)[p4]

XOR        31  06 0D ;(p1) xor p2
XOR08      32  03 05 ;(p1) xor p2
XOR16      33  04 09 ;(p1) xor p2
REGXOR     34  03 05 ;(p1) xor (p2)
REGXOR08   35  05 55 ;(p1)[p2] xor (p3)[p4]
REGXOR16   36  05 55 ;(p1)[p2] xor (p3)[p4]



SHL        37  02 01 ;(p1) << 1 ,last bit in Carry (flag C)
SHR        38  02 01 ;(p1) >> 1 ,last bit in Carry (flag C)
ROL        39  02 01 ;(p1) rol 1 ,bit shifted out is pushed in pos 1 and copied in Carry
ROR        3A  02 01 ;(p1) ror 1 ,bit shifted out is pushed in last pos and copied in Carry


; compare functions
; egal   => Z=1 C=0
; <      => Z=0 C=1
; >      => Z=0 C=0

CMP        3B  06 0D ;(p1) = p2 ? result with C and Z
CMP08      3C  03 05 ;(p1) = p2 ? result with C and Z (8bits comparaison)
CMP16      3D  04 09 ;(p1) = p2 ? result with C and Z (16 bit comparaison)
REGCMP     3E  03 05 ;(p1) = (p2) ? result with C and Z
REGCMP08   3F  05 55 ;(p1)[p2] = (p3)[p4] ? result with C and Z (8 bits)
REGCMP16   40  05 55 ;(p1)[p2] = (p3)[p4] ? result with C and Z (16 bits)
CMPMEM     41  04 15 ;[p1] = [p2] on (p3) bytes len (equ to memcmp(p1,p2,p3) function in C)



JP         42  05 03 ;jump to p1 (32 bits)
CALL       43  05 03 ;call p1 and return on a RET type instruction, SP (stack pointer) is touch


CALLZ      44  05 03 ;call p1 if Z=1 (zero flag)
CALLNZ     45  05 03 ;call p1 if Z=0
CALLC      46  05 03 ;call p1 if c=1 (carry)
CALLNC     47  05 03 ;call p1 if c=0 (carry)

JPZ        48  05 03 ;jump to p1 address if z=1
JPNZ       49  05 03 ;jump to p1 address if z=0
JPC        4A  05 03 ;jump to p1 address if c=1
JPNC       4B  05 03 ;jump to p1 address if c=0

JPRZ       4C  02 01 ;jump to [p1] address if z=1
JPRNZ      4D  02 01 ;jump to [p1] address if z=0
JPRC       4E  02 01 ;jump to [p1] address if c=1
JPRNC      4F  02 01 ;jump to [p1] address if c=0



JR         50  83 02 ;jump to relative address +/- p1  (IP=IP+/- p1)
RCALL      51  83 02 ;call to relative address +/- p1  (IP=IP+/- p1)

JRZ        52  83 02 ;jump to relative address +/- p1  (IP=IP+/- p1) if z=1
JRNZ       53  83 02 ;jump to relative address +/- p1  (IP=IP+/- p1) if Z=0
JRC        54  83 02 ;jump to relative address +/- p1  (IP=IP+/- p1) if C=1
JRNC       55  83 02 ;jump to relative address +/- p1  (IP=IP+/- p1) if C=0

JRRZ       56  82 01 ;jump to relative address +/- (p1)  (IP=IP+/- (p1)) if Z=1
JRRNZ      57  82 01 ;jump to relative address +/- (p1)  (IP=IP+/- (p1)) if Z=0
JRRC       58  82 01 ;jump to relative address +/- (p1)  (IP=IP+/- (p1)) if C=1
JRRNC      59  82 01 ;jump to relative address +/- (p1)  (IP=IP+/- (p1)) if C=0



RET        5A  01 00 ;return to previous address ((sp)->ip, sp=sp+4)
RETZ       5B  01 00 ;return to previous address ((sp)->ip, sp=sp+4) if Z=1
RETNZ      5C  01 00 ;return to previous address ((sp)->ip, sp=sp+4) if Z=0
RETC       5D  01 00 ;return to previous address ((sp)->ip, sp=sp+4) if C=1
RETNC      5E  01 00 ;return to previous address ((sp)->ip, sp=sp+4) if C=0



FNCALL     5F  0A 3D ;library call: call function # p1 parameters are at address p2, return is stored from register p3 up to 10 registers long or at address p3
FNREGCALL  60  04 15 ;library call: call function # p1 parameters are at [p2] return is to store at address [p3]
FNRCALL    61  85 19 ;library call: call function # p1 parameters are at ip+/-p2 (p2 is 16bit wide), return is stored from register p3 up to 10 registers long

USRCALL    62  0A 3D ;not available
USRREGCALL 63  04 15 ;not available
USRRCALL   64  85 19 ;not available



PUSH       65  02 01 ;Save (p1)  sp=sp-4 , [sp]=p1
POP        66  02 01 ;restore in (p1) p1=[sp] , sp=sp+4
ADDSP      67  02 01 ;sp=sp-(p1)
SUBSP      68  02 01 ;sp=sp+(p1)



SC         69  01 00 ; Set Carry (C)
RC         6A  01 00 ; Reset Carry (C)
NOTC       6B  01 00 ; Inverse C (if C=1, C=0 ; if c=0, c=1)
SZ         6C  01 00 ; Set Z
RZ         6D  01 00 ; Reset Z
NOTZ       6E  01 00 ; Inverse Z



LOOP       6F  84 09 ; loop at ip+/- p2 (16 bits) until (p1)=0, (p1)=(p1)-1
RLOOP      70  03 05 ; loop at [p2] until (p1)=0, (p1)=(p1)-1


RESET      71  01 00 ; Restart programm
OUTBYTE    72  04 15 ; write from PILI memory to COMPUTERS memory [p1]->[p2] for (p3) bytes WARNING p2 map a real computer memory address
INBYTE     73  04 15 ; read from COMPUTERS memory to PILI memory [p2]->[p1] for (p3) bytes WARNING p2 map a real computer memory address
INC        74  02 01 ; (p1)=(p1)+1
DEC        75  02 01 ; (p1)=(p1)-1

JRR        76  82 01 ;jp to relative address +/- (p1)  (IP=IP+/- (p1))
RRCALL     77  82 01 ;call to relative address +/- (p1)  (IP=IP+/- (p1))
LOADSP     78  03 02 ;sp = p1 (16 bit) (stack is limited to 8kbytes)
PUSHSP     79  01 00 ;push sp
POPSP      7A  01 00 ;pop  sp
PUSHIP     7B  01 00 ;push ip
POPIP      7C  01 00 ;pop  ip
FREESP     7D  02 01 ;copy the maximum free stack available in (p1)
FNCALL08   7E  04 15 ;library call: call function # p1 parameters are p2(8 bits), return is stored from register p3 (can be up to 10 registers long or more)
FNCALL16   7F  05 19 ;library call: call function # p1 parameters are p2(16 bits), return is stored from register p3 (can be up to 10 registers long or more)


TRACE      FD  03 05 ; display a debug trace with a wait loop p1 and a trace number (p2)
DEBUG      FE  03 05 ; display a debug trace with a wait loop p1 and the content of the p2 register

; floating point operands
FMULT      80  03 05 ;(p1)*(p2) -> (p1) (float/real)
FDIV       81  03 05 ;(p1)/(p2) -> (p1) (float/real)
FINT       82  03 05 ; integer part of (p2) in (p1)
FADD       83  03 05 ;(p1)+(p2) -> (p1) (float/real)
FSUB       84  03 05 ;(p1)-(p2) -> (p1) (float/real)
FREGCMP    85  03 05 ;(p1) = (p2) ? result with C and Z (float/real)
FREST      86  03 05 ; decimal part of (p2) in (p1)

; additional opcodes

ITOF       87  03 05 ; Convert integer to float (p2)->(p1)
LTOC       88  03 05 ;Convert signed long to signed char (p2)->(p1)
LTOI       89  03 05 ;Convert signed long to signed int  (p2)->(p1)
CTOL       8A  03 05 ;Convert signed char to signed long (p2)->(p1)
CTOI       8B  03 05 ;Convert signed int  to signed long (p2)->(p1)
MSHL       8C  03 05 ;Shift for (p2) bits the register (p1) (shift left)
MSHR       8D  03 05 ;Shift for (p2) bits the register (p1) (shift right)
SMODE      8E  01 00 ;Switch to signed mode for all operations (except fncall)
UMODE      8F  01 00 ;Switch to unsigned mode for all operations (except fncall)
CMODE      90  01 00 ;Switch to compatibility mode (default), only longs are signed
FPOW       91  03 05 ;(p1)  pow  (p2) -> (p1)
FSIN       92  02 01 ;      sin  (p1) -> (p1)
FCOS       93  02 01 ;      cos  (p1) -> (p1)
FTAN       94  02 01 ;      tan  (p1) -> (p1)
FLOG       95  02 01 ;      log  (p1) -> (p1)


