;
; LINE DEMO
; 
; Copyright (C) 1996 Model Systems
; All rights reserved
;
; H I S T O R Y
; =============
; 01/11/96 Initial coding (V1.00).
;
; ======================================================================
;
pili_header:
     JR start                   ; jump to start of prog
     dl pili_bottom-pili_header ; /* size of binary image */
     db "PILI BINARY MAIN "     ; header for beta, main application
     db 0                       ; null terminate

 include fncall.inc

;-----------------------------------------------------------------------------
;
; PROGRAM START
;

start:
    FNCALL      clearscreen,0           ; Clear the screen
    FNCALL16    InfoBox, welcome, sto0  ; Display an intro box
    FNCALL08    EventRead, 0, a         ; Clear any events

; Init starting position
    RLD32       sto0,8                  ; X coord of one end of the line
    RLD32       sto1,6                  ; Y coord of one end of the line
    RLD32       sto2,66                 ; X coord of the other end
    RLD32       sto3,12                 ; X coord of the other end
    RLD32       sto4,GP_SOLID_LINE      ; Draw solid lines

; Init starting directions
    RLD32       sto5,2                  ; X direction of one end of the line
    RLD32       sto6,2                  ; Y direction of one end of the line
    RLD32       sto7,-2                 ; X direction of the other end
    RLD32       sto8,-2                 ; Y direction of the other end

draw:
    FNCALL08    LineDraw,sto0,GP_XOR    ; Draw the line

; Move the line ends
    ADD32       sto0,sto5
    ADD32       sto1,sto6
    ADD32       sto2,sto7
    ADD32       sto3,sto8

; Check for hitting the edges of the screen
comp1:
    CMP         sto0,320
    JPNZ        comp2
    RLD32       sto5,-2

comp2:
    CMP         sto1,240
    JPNZ        comp3
    RLD32       sto6,-2

comp3:
    CMP         sto2,320
    JPNZ        comp4
    RLD32       sto7,-2

comp4:
    CMP         sto3,240
    JPNZ        comp5
    RLD32       sto8,-2

comp5:
    CMP         sto0,0
    JPNZ        comp6
    RLD32       sto5,2

comp6:
    CMP         sto1,0
    JPNZ        comp7
    RLD32       sto6,2

comp7:
    CMP         sto2,0
    JPNZ        comp8
    RLD32       sto7,2

comp8:
    CMP         sto3,0
    JPNZ        comp9
    RLD32       sto8,2

comp9:
    FNCALL08    EventRead, 0, a         ; Check for key press
    CMP08       a, 4                    ; Anything?
    JPNZ        draw                    ; Go back and start again
    EXIT

;-----------------------------------------------------------------------------
;
; DATA
;

welcome:
     DB 1
     DB "               -= LINE DEMO =-"
     DB 0Dh
     DB "Written by Murray Moffatt (100240,1477)"
     DB 0Dh
     DB "This is just a little demo of a line"
     DB 0Dh
     DB "bouncing around the screen."
     DB 0Dh
     DB "Press any key to exit the demo."
     DB 0Dh
     $DATE_TIME

;-------------------------------------------------------------------------

pili_bottom: ; NEED TO BE THERE FOR HEADER

    END
