;
; MESS DEMO
; 
; Copyright (C) 1996 Model Systems
; All rights reserved
;
; H I S T O R Y
; =============
; 16/11/96 Initial coding (V1.00).
;
; ======================================================================
;
pili_header:
    JR      Start              ; jump to start of prog
    DL pili_bottom-pili_header ; /* size of binary image */
    DB "PILI BINARY MAIN "     ; header for beta, main application
    DB 0                       ; null terminate

 include fncall.inc

;-----------------------------------------------------------------------------
;
; PROGRAM START
;

Start:
    FNCALL      clearscreen,0           ; Clear the screen
    FNCALL16    InfoBox,welcome,sto0    ; Display an intro box
    FNCALL08    EventRead, 0, a         ; Clear any events

; Init starting position
    RLD32       sto0,8                  ; X coord of one end of the line
    RLD32       sto1,6                  ; Y coord of one end of the line
    RLD32       sto2,66                 ; X coord of the other end
    RLD32       sto3,12                 ; X coord of the other end
    RLD32       sto4,GP_SOLID_LINE      ; Draw solid lines

; Init starting directions
    RLD32       sto5,2                  ; X direction of one end of the line
    RLD32       sto6,2                  ; Y direction of one end of the line
    RLD32       sto7,-2                 ; X direction of the other end
    RLD32       sto8,-2                 ; Y direction of the other end

Draw:
; Move the line ends
    ADD32       sto0,sto5
    ADD32       sto1,sto6
    ADD32       sto2,sto7
    ADD32       sto3,sto8
    FNCALL08    LineDraw, sto0, GP_SET  ; Draw the line
    RLD08       a, 5
    RGMOVE      20h, sto0, a
    INC         20h
    INC         22h
    FNCALL08    LineDraw, 20h, GP_SET  ; Draw another line

; Remember coords
    RLD08       a, 5
    RGMOVE      20h, sto0, a

; Check for hitting the edges of the screen
comp1:
    CMP         sto0,320
    JPNZ        comp2
    RLD32       sto5,-2
    CALL        RBounce
    RMV32       sto6, a

comp2:
    CMP         sto1,240
    JPNZ        comp3
    RLD32       sto6,-2
    CALL        RBounce
    RMV32       sto5, a

comp3:
    CMP         sto2,320
    JPNZ        comp4
    RLD32       sto7,-2
    CALL        RBounce
    RMV32       sto8, a

comp4:
    CMP         sto3,240
    JPNZ        comp5
    RLD32       sto8,-2
    CALL        RBounce
    RMV32       sto7, a

comp5:
    CMP         sto0,0
    JPNZ        comp6
    RLD32       sto5,2
    CALL        RBounce
    RMV32       sto6, a

comp6:
    CMP         sto1,0
    JPNZ        comp7
    RLD32       sto6,2
    CALL        RBounce
    RMV32       sto5, a

comp7:
    CMP         sto2,0
    JPNZ        comp8
    RLD32       sto7,2
    CALL        RBounce
    RMV32       sto8, a

comp8:
    CMP         sto3,0
    JPNZ        comp9
    RLD32       sto8,2
    CALL        RBounce
    RMV32       sto7, a

comp9:
    FNCALL08    LineDraw, 20h ,GP_XOR   ; Rub the line out
    INC         20h
    INC         22h
    FNCALL08    LineDraw, 20h, GP_XOR   ; Rub out the other line

    FNCALL08    EventRead, 0, a         ; Check for key press
    CMP08       a, 4                    ; Anything?
    JPNZ        draw                    ; Go back and start again
    EXIT

;=======================================================================
;
; S U B R O U T I N E S

; Randomly choose a direction to bounce the line
RBounce:
    FNCALL      GetRandom, 0, a         ; 16-bit random number in a
    CMP         a, 7FFFh
    JPC         Pos

Neg:
    RLD32       a, -2
    RLD08       b, 1
    FNCALL      PlaySound, b
    JP          RBExit

Pos:
    RLD32       a, 2
    RLD08       b, 0
    FNCALL      PlaySound, b

RBExit:
    RET

;=======================================================================
;
; D A T A
;
welcome:
     DB 1
     DB "               -= MESS DEMO =-"
     DB 0Dh
     DB "Written by Murray Moffatt (100240,1477)"
     DB 0Dh
     DB "This is just a little demo that makes a"
     DB 0Dh
     DB "mess of your screen (looks pretty though!)"
     DB 0Dh
     DB "Press any key to exit the demo."
     DB 0Dh
     $DATE_TIME

;-------------------------------------------------------------------------

pili_bottom: ; NEED TO BE THERE FOR HEADER

    END
