;
; ALL APPLI NEAD TO START WITH THIS AND TO END WITH THE BOTTOM'S LABEL'S
;
; PILI BINARY MAIN  = main code, always called in first, need to be only once in memory
; PILI BINARY xxxx  = programme chain (maxi 9999), each header needs to exist only once
pili_header:
     JR start                   ; jump to start of prog
     dl pili_bottom-pili_header ; /* size of binary image */
     db "PILI BINARY MAIN "     ; header for beta, main application
     db 0                       ; null terminate


; include file for library definitions and virtual registers assignement
 include fncall.inc

;-----------------------------------------------------------------------------
;
;
;
; YOU PROGRAMM START
;

start:

     FNCALL08 ClearScreen,0         ; clear the screen

     RLD16  sto0,12               ; usage x coord
     RLD16  sto1,24               ; usage y coord
     FNCALL08 Locate,sto0           ; set cursor
     FNCALL08 SetFont,0             ; select font
     FNCALL16 FormatPrint,usage     ; display explication text part 1

; init serial port
     RLD16  sto0,BPS2400|P_NONE
     FNCALL08 RsOpen,sto0       ; open serial port at 2400bps,8bits,no parity

; prepare the max byte to receive into x register
     RLD16 x,20
; prepare the receive adress into y register
     RLD32 y,rx_data
; misc preparation
     RLD32  cx,intprt             ; where to store an integer
     RLD08  b,1                   ; only one register
     RLD16  sto0,12               ; integer print x coord
     RLD16  sto1,5                ; integer print y coord
     FNCALL08 Locate,sto0           ; set cursor

wloop3: ; attente
     FNCALL08 RsRead,x,sto3     ; read x bytes, return the numb. of readed bytes
     RLD16  sto1,6                  ; integer print y coord
     FNCALL08 Locate,sto0           ; set cursor
     STOR16   sto3,cx,b             ; write the byte
     FNCALL16 FormatPrint,integer   ; display the byte in hexa format
;     CMP    sto3,0
;     JRZ    no_bytes              ; no bytes read
;     RLD08  sto4,y,b              ; read the byte
     RLD16  sto1,5                 ; data output y coord
     FNCALL08 Locate,sto0          ; set cursor
     FNCALL16 OutText,rx_data  ; display the readed string
no_bytes:
     FNCALL08 EventRead,0,sto8  ; read the incomming event (this event is cleared)
     CMP    sto8,20h           ; wait for pen up event
     JRNZ   wloop3

endprog:
     RLD08 x,12
     RLD32 y,usage
     FNCALL08 RsWrite,x          ; no return
     RLD16 sto0,400
     LOOP sto0,$       ; wait
; close serial port
     FNCALL08 RsClose
     EXIT                      ; not usefull but just to show a 'normal' end
integer: ;
     db " byte=%x "
     db 0
intprt:
     dw 0
usage: ; usage text
     db "Touch screen to stop"
     db 0
rx_data: ; rx buffer
     ds 30
     db 0


;-------------------------------------------------------------------------
;
;
;     *********************** END OF PROGRAMM *********************
;
;

pili_bottom: ; NEED TO BE THERE FOR HEADER

  end
