/*
	date: May. 30. 1999

	Copyright (c) by Collin R. Mulliner <collin@mulliner.org>
	http://www.mulliner.org/palm/

	Feel free to use this function in any of your programms, as long as you give credits !


	This function gets or sets the Palm UserName (the HostSync name) and UserID.
	
	get => get_or_set = 0
	set => get_or_set = 1

	palm_name is a pointer to 41 bytes of mem, UserName (max 40 chars) + the zero byte
	palm_id is a pointer to a word (2 bytes)
*/
void get_set_palm_name(int get_or_set, char *palm_name, Word *palm_id)
{
	DmOpenRef db_ref;
	VoidPtr res_ptr;
	VoidHand res_hand;
	ULong res_size;
	unsigned char *in_buffer, *out_buffer;
	UInt name_length;
	UInt i;
	int res_index;
	unsigned char ins_name_length;


	db_ref = DmOpenDatabaseByTypeCreator('pref', 'psys', dmModeReadWrite);

	res_index = DmFindResource(db_ref, 'psys', 4, NULL);	// it's a resource

	if (res_index != -1) {
		res_hand = DmGetResource('psys', 4);
		res_size = MemHandleSize(res_hand);
		res_ptr = MemHandleLock(res_hand);
	
		in_buffer = MemPtrNew(res_size);
	
		if (get_or_set == 1) {	// set it
			name_length = StrLen(palm_name);
			out_buffer = MemPtrNew(44+name_length+1);
		}
		MemMove(in_buffer, res_ptr, res_size);
		MemHandleUnlock(res_hand);
	
		if (get_or_set == 0) {	// get it
			i = 1;
			while (*(in_buffer+42+i) != '\0') {
				i++;
			}
			MemMove(palm_name, in_buffer+42, i+1);

			MemMove(palm_id, in_buffer+4, 2);	// the user id
		}
	
		if (get_or_set == 1) {	// set it
			DmResizeResource(res_hand, 44+name_length+1);
			res_ptr = MemHandleLock(res_hand);
	
			MemMove(out_buffer, in_buffer, 42);
			MemMove(out_buffer+42, palm_name, name_length+1);
			
			ins_name_length = (unsigned char) name_length + 1;

			MemMove(out_buffer+38, &ins_name_length, 1);
				
			MemMove(out_buffer+4, palm_id, 2);
			// this is the user ID 

			DmWrite(res_ptr, 0, out_buffer, 44+name_length+1);
			MemHandleUnlock(res_hand);
			MemPtrFree(out_buffer);
		}
	
		DmReleaseResource(res_hand);
		MemPtrFree(in_buffer);
	}
	else {		// resource not found
		if (get_or_set == 0) {	// get it
		//	*(palm_name) = '\0';
		}
		if (get_or_set == 1) {	// set it
			name_length = StrLen(palm_name);
			res_hand = DmNewResource(db_ref, 'psys', 4, 44+name_length+1);
			res_ptr = MemHandleLock(res_hand);
			out_buffer = MemPtrNew(44+name_length+1);
			MemSet(out_buffer, 0x00, 44+name_length+1);
			MemMove(out_buffer+42, palm_name, name_length+1);

			ins_name_length = (unsigned char) name_length + 1;

			MemMove(out_buffer+38, &ins_name_length, 1);

			MemMove(out_buffer+4, palm_id, 2);
			// this is the user ID 

			DmWrite(res_ptr, 0, out_buffer, 44+name_length+1);
			MemHandleUnlock(res_hand);
			MemPtrFree(out_buffer);
			DmReleaseResource(res_hand);
		}
	}
	
	DmCloseDatabase(db_ref);
}
