/*
	PalmID v1.0 Jun. 17. 1999 (c) Collin R. Mulliner
	EMail: collin@mulliner.org
	WebSite: www.mulliner.org/palm/


	PalmID displays the user information saved by the PalmDesktop software.
	
	informations: UserID, UserName, UserDir (the directory for the user files)

	If you are interested in the file format of users.dat read udff.txt.

	have fun ... Collin
*/

#include <stdio.h>
#include "palm_id.h"

int main(int argc, char *argv[])
{
	if (argc < 2) {
		printf(HELP_TEXT);
		return;
	}
	else {
		palm_id(argv[1]);
	}
}

int palm_id(char file_name[])
{
	FILE *fp;
	unsigned char c;
	int un_length;
	int i, i2;
	char user_name[42];
	char user_dir[50];
	int user_c;
	unsigned char tmp_id[2];
	unsigned long user_id;


	if ((fp = fopen(file_name, "rb")) == NULL) {
		printf(ERROR_TEXT);
		printf(HELP_TEXT);
		return;
	}
	else {
		c = fgetc(fp);
		
		printf("\nUsers listed in file: %d\n\n", c);

		user_c = (int) c;
		for (i = 0; i < user_c; i++) {
			for (i2 = 0; i2 < 12; i2++) {
				fgetc(fp);
			}	// read 12 bytes garbage
			
			tmp_id[0] = (unsigned char) fgetc(fp);
			tmp_id[1] = (unsigned char) fgetc(fp);

			user_id = (tmp_id[1] * 256) + tmp_id[0];

			printf("UserID: %u\n", user_id);

			fgetc(fp);
			fgetc(fp);
			// read 2 bytes garbage

			un_length = (int) fgetc(fp);

			for (i2 = 0; i2 < un_length; i2++) {
				user_name[i2] = fgetc(fp);
			}
			user_name[un_length] = '\0';

			printf("UserName: %s\n", user_name);

			un_length = (int) fgetc(fp);

			for (i2 = 0; i2 < un_length; i2++) {
				user_dir[i2] = fgetc(fp);
			}
			user_dir[un_length] = '\0';

			printf("UserDir: %s\n\n", user_dir);
		}

		fclose(fp);
	}
}
