{*******************************************************}
{                                                       }
{         IR Assistant plugin for Radiator              }
{                                                       }
{         Copyright (c) 2001, Andras Elso               }
{                        (ea333@freemail.hu)            }
{                                                       }
{*******************************************************}


library Radiator;

uses
  SysUtils,
  PlugIn_Util,
  Windows,
  messages,
  commands in 'commands.pas' {dlgCommands};

const
  WM_MyVolUp=WM_USER + 1001;
  WM_MyVolDown=WM_USER + 1002;
  WM_MyMute=WM_USER + 1003;
  WM_MyUnmute=WM_USER + 1004;
  WM_MyStatUp=WM_USER + 1005;
  WM_MyStatDown=WM_USER + 1006;
  WM_MyLastStat=WM_USER + 1007;
  WM_MySurf=WM_USER + 1008;
  WM_MyTuneStatNo=WM_USER + 1009;
  WM_MyTuneFr=WM_USER + 1010;
  WM_MyMin=WM_USER + 1011;
  WM_MyMax=WM_USER + 1012;
  WM_MyThin=WM_USER + 1013;
  WM_MyRecord=WM_USER + 1014;
  WM_MyRadClose=WM_USER + 1015;
  WM_MyRestore=WM_USER + 1016;
  WM_MyMonoStereo=WM_USER + 1017;

{
The name will be shown in the tree view of macro window
}
function getPluginName:TPluginName;
begin
   strCopy(result, 'Radiator commands');
end;

{
procedure is executed when the macro command is executed.
command: The command string of the plugin command
hWndTarget: Handle of the target window of the macro
}
procedure executePlugin(command:TPluginCommand;hWndTarget:integer);
begin
  if uppercase(command)='VOLUP' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyVolUp,0,0);
  if uppercase(command)='VOLDOWN' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyVolDown,0,0);
  if uppercase(command)='MUTE' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyMute,0,0);
  if uppercase(command)='UNMUTE' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyUnmute,0,0);
  if uppercase(command)='STATUP' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyStatUp,0,0);
  if uppercase(command)='STATDOWN' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyStatDown,0,0);
  if uppercase(command)='LASTSTAT' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyLastStat,0,0);
  if uppercase(command)='SURF' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MySurf,0,0);
  if copy(uppercase(command),1,10)='TUNESTATNO' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyTuneStatNo,StrtoInt(copy(command,11,255)),0);
  if copy(uppercase(command),1,6)='TUNEFR' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyTuneFr,StrtoInt(copy(command,7,255)),0);
  if uppercase(command)='MIN' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyMin,0,0);
  if uppercase(command)='MAX' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyMax,0,0);
  if uppercase(command)='THIN' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyThin,0,0);
  if uppercase(command)='RECORD' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyRecord,0,0);
  if uppercase(command)='RADCLOSE' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyRadClose,0,0);
  if uppercase(command)='RESTORE' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyRestore,0,0);
  if uppercase(command)='MONOSTEREO' then PostMessage(FindWindow('TMainRadioForm',nil),WM_MyMonoStereo,0,0);
end;

{
Function is executed when user presses "Add" button of macro window
}
function addPlugin:TPluginCommand;
var sResult:string;
begin
  result := '';
  sResult := selectCommmand;
  if sResult <> '' then
     strPLCopy(result, sResult, 255);
end;

exports
getPluginName index 1,
executePlugin index 2,
addPlugin index 3;

begin
end.
 