//////////////////////////////////////////////////////////////////////
// Main.cpp
// -------------------------------------------------------------------
//
// Author: FallNAngel					Last Updated: 16.02.02
// E-Mail: <gambit_dr@hotmail.com>
//////////////////////////////////////////////////////////////////////
#include "main.h"
//-----------------------------------------------------------------------------

struct GeneralInfo
{
	int ShowAll[(SECTIONSNUM-1)],
		 Invert[(SECTIONSNUM-1)];
}General;

bool Stop = true;
LinkedList *ItemTypes[SECTIONSNUM];
char Sections[9][9] = {"Lesser", "Normal", "Superior", "Magic", "Rare", "Set", "Unique", "Other", "All"};
//-----------------------------------------------------------------------------

CLIENTINFO
(
	0,70,							// Module version (Major, Minor)
	"FallNAngel",					// Author
	"",								// url (http:// is appended)
	"HideIt module",				// Short module description
	"gambit_dr@hotmail.com"			// Author eMail
)
//-----------------------------------------------------------------------------

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{
		"add",
		AddItem,
		"add [Lesser | Normal | Superior | Magic | Rare | Set | Unique | Other | All] [Item Code(s)]"
	},
	{
		"reload",
		Reload,
		"reload"
	},
	{	"show",
		ShowConfig,
		"config [Lesser | Normal | Superior | Magic | Rare | Set | Unique | Other | All]"
	},
	{
		"showall",
		ShowAll,
		"showall [Lesser | Normal | Superior | Magic | Rare | Set | Unique | Other | All] <true | false>\n"
		"        Toggles showing of an entire category.  This overrides the config"
	},
	{
		"invert",
		Invert,
		"invert [Lesser | Normal | Superior | Magic | Rare | Set | Unique | Other | All] <true | false>\n"
		"       This inverts the defaults for that config category."
	},
	{
		"status",
		ShowStatus,
		"status  : Shows  ShowAll / Invert status"	
	},
	{
		"stop",
		StartStop,
		"stop  : Stop module"
	},
	{
		"start",
		StartStop,
		"start  : Start module"
	},
	{
		"help",
		OnGameCommandHelp,
		"help  : List commands available in this module"
	},
	{NULL}	// No more commands
};
//-----------------------------------------------------------------------------

BOOL EXPORT OnClientStart() 
{ 
	for(int x = 0; x <= SECTIONSNUM ; ++x)
		ItemTypes[x] = NULL;
	server->GamePrintInfo("-- module is stopped, run .hideit start to begin --");
	return LoadConfig(); 
}
//-----------------------------------------------------------------------------

BOOL EXPORT OnClientStop() { return TRUE; }
//-----------------------------------------------------------------------------

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen)
{
//if the module should stop, then let all packets through
	if(Stop) return aLen;

	LinkedItem_t *cfg;
	int x;

// Only react to items on ground
	if ((aPacket[0] == ITEM_MESSAGEID_DROP) &&
		((aPacket[1] == ITEM_ACTION_NEW_GROUND) ||
		 (aPacket[1] == ITEM_ACTION_OLD_GROUND)))
	{
	//Parse the packet into usable data.
		ITEMSTRUCT *item = ParseItemDrop(aPacket, aLen);
	
	//if item == NULL, just send it through and let the client handle it
		if(item == NULL) 
			return aLen;

	//Here we check what kind of item it is.  
	//This way we can loop through the proper list
		switch(item->ItemLevel)
		{
			case ITEM_LEVEL_INFERIOR:
				x = 0; break;
			case ITEM_LEVEL_NORMAL:
				x = 1; break;
			case ITEM_LEVEL_SUPERIOR:
				x = 2; break;
			case ITEM_LEVEL_MAGIC:
				x = 3; break;
			case ITEM_LEVEL_SET:
				x = 4; break;
			case ITEM_LEVEL_RARE:
				x = 5; break;
			case ITEM_LEVEL_UNIQUE:
				x = 6; break;
			default:
				x = 7;
		}
   //if we should show all of the items in that category, 
   //   then return aLen
		if(General.ShowAll[x])
			return aLen;
/*
	Loop through the appropriate List looking for a match.
	If a match is not found, return 0 to hide it
	otherwise let it through to be shown.
*/
		cfg = ItemTypes[x]->GetFirstItem();		
	//if the list is empty, but we're inverting the category, show it.
		if((cfg == NULL) && (General.Invert[x]))
			return aLen;
		else if((cfg == NULL) && (!General.Invert[x]))			
			return 0;
		while(cfg != NULL)
		{
		// if we aren't inverting (showing items on list)
			if((General.Invert[x] == 0) && (strcmpi((char*)cfg->lpData, item->ItemCode) == 0))
				return aLen;
		// if we are inverting (hiding items on list)
			else if((General.Invert[x] == 1) && (strcmpi((char*)cfg->lpData, item->ItemCode) == 0))
				return 0;
			else
				cfg = ItemTypes[x]->GetNextItem(cfg);
		}
		return 0;
	}
//if it's not the type of 9C packet we're looking for, let it through
	return aLen;
}
//-----------------------------------------------------------------------------

BOOL PRIVATE AddItem(char** argv, int argc)
{
	//argc 1 (argv[0]) = <modulename>
	//argc 2 (argv[1]) = add
	//argc 3 (argv[2]) = [Normal, Magic, Rare, Set, Unique, Other]
	//argc 4... (argv[3]...) = [id]
	if(argc < 4)
		return false;
	int i, x = GetSection(argv, 2);
	if(x < 0) return false;
	char msg[128], value[2];	

	for(i = 0; i < SECTIONSNUM; ++i)
	{
		sprintf(msg, "ShowAll%s", Sections[x]);
		sprintf(value, "%d", General.ShowAll[x]);
		server->SetHackProfileString("HideIt", "General", msg, value);
	}

	for(i = 0; i < SECTIONSNUM; ++i)
	{
		sprintf(msg, "Invert%s", Sections[x]);
		sprintf(value, "%d", General.Invert[x]);
		server->SetHackProfileString("HideIt", "General", msg, value);
	}

	LinkedItem_t *cfg;
	int count, z = (x == SECTIONSNUM) ? SECTIONSNUM : x + 1;	
	for(x = (x == SECTIONSNUM) ? 0 : x; x < z; ++x)
	{
		count = 0;
		cfg = ItemTypes[x]->GetFirstItem();
		while(cfg != NULL)
		{
			++count;
			cfg = ItemTypes[x]->GetNextItem(cfg);
		}
		for(int y = 3; y < argc; ++y)
		{
			sprintf(msg, "item%d", count);
			server->SetHackProfileString("hideit", Sections[x], msg, argv[y]);
			sprintf(msg, "item: %s added to section %s", argv[y], Sections[x]);
		}
	}
	return Reload(NULL, 2);	
}
//-----------------------------------------------------------------------------

BOOL PRIVATE ShowConfig(char** argv, int argc)
{
	if(argc != 3)
		return false;

	int x = GetSection(argv, 2);
	if(x < 0) return false;
	char msg[128];
	LinkedItem_t *cfg;
	sprintf(msg, "%d", x);
	int y = (x == SECTIONSNUM) ? SECTIONSNUM : x + 1;
	for(x = (x == SECTIONSNUM) ? 0 : x; x < y; ++x)
	{		
		sprintf(msg, "[%s]", Sections[x]);
		server->GamePrintInfo(msg);		
		cfg = ItemTypes[x]->GetFirstItem();
		while(cfg != NULL)
		{
			server->GamePrintInfo((char *)cfg->lpData);
			cfg = ItemTypes[x]->GetNextItem(cfg);
		}
	}
	return true;
}
//-----------------------------------------------------------------------------

BOOL PRIVATE Reload(char** argv, int argc) 
{ 
	if(argc == 2)
	{
		server->GamePrintInfo("Reloading Config");
		return LoadConfig(); 
	}
	return false;
}
//-----------------------------------------------------------------------------

BOOL LoadConfig()
{		
	char key[7], *itemcode = new char[5];
	int x;	

//Clear out lists if they exist
	for(x = 0; x < 6; ++x)
		if(ItemTypes[x] != NULL)
			delete ItemTypes[x];

//Create new lists
	for(x = 0; x <= SECTIONSNUM; ++x)
		ItemTypes[x] = new LinkedList;

	char msg[128];
	for(x = 0; x < SECTIONSNUM; ++x)
	{
		sprintf(msg, "ShowAll%s", Sections[x]);
		General.ShowAll[x] = atoi(server->GetHackProfileString("HideIt", "General", msg));
	}

	for(x = 0; x < SECTIONSNUM; ++x)
	{
		sprintf(msg, "Invert%s", Sections[x]);
		General.Invert[0] = atoi(server->GetHackProfileString("HideIt", "General", msg));
	}

	for(x = 0; x < SECTIONSNUM; ++x)
		if((General.ShowAll[x] != 0) && (General.ShowAll[x] != 1))
			General.ShowAll[x] = 0;
	for(x = 0; x < SECTIONSNUM; ++x)
		if((General.Invert[x] != 0) && (General.Invert[x] != 1))
			General.Invert[x] = 0;
	
//Fill lists with data
	for(int i = 0; i < SECTIONSNUM; ++i) //for looping through sections
	{
		x = 0;
		do
		{
		//get key name we need
			sprintf(key, "%s%d","item",x++); 
		//actually get key here
	 		itemcode = server->GetHackProfileString("HideIt", Sections[i], key);
		//if we actually got something back add it to the list
			if(strlen(itemcode))
				ItemTypes[i]->AddItem(itemcode);	
		}while(strlen(itemcode));
	}
	return true;
}
//-----------------------------------------------------------------------------

BOOL PRIVATE StartStop(char** argv, int argc)
{
//if it's already stopped and they try to stop it again..
	if(Stop && (strcmp(argv[1], "stop") == 0 ))
		return true;
//or vice versa
	if(!Stop && (strcmp(argv[1], "start") == 0))
		return true;
// then just return and don't say anything..

//flip Stop and show a msg
	Stop = !Stop;
	char msg[64];
	sprintf(msg, "HideIt is: %s", Stop ? "stopped" : "running");
	server->GamePrintInfo(msg);
	return true;	
}
//-----------------------------------------------------------------------------

BOOL PRIVATE Invert(char** argv, int argc)
{
	if(argc < 2)
		return false;

	int x = GetSection(argv, 2);
	if(x < 0) return false;
	char msg[128];
	if(argc == 4)
	{
		if(strcmpi("true", argv[3]) == 0)
			General.Invert[x] = true; // set to true and return true
		else if(strcmpi("false", argv[3]) == 0)
			General.Invert[x] = false; // set to false and return true
		else
			return false;
	}
	else
		General.Invert[x] = !General.Invert[x];
	sprintf(msg, "Section: %s has been iverted to %d", Sections[x], General.Invert[x]);
	server->GamePrintInfo(msg);
	return true;
}
//-----------------------------------------------------------------------------

BOOL PRIVATE ShowStatus(char** argv, int argc)
{
	char msg[128];
	int x;
	for(x = 0; x < SECTIONSNUM; ++x)
	{
		sprintf(msg, "Show %s: %d", Sections[x], General.ShowAll[x]);
		server->GamePrintInfo(msg);
	}
	for(x = 0; x < SECTIONSNUM; ++x)
	{
		sprintf(msg, "Invert %s: %d", Sections[x], General.Invert[x]);
		server->GamePrintInfo(msg);
	}
	return true;
}
//-----------------------------------------------------------------------------

BOOL PRIVATE ShowAll(char** argv, int argc)
{
	if(argc < 3)
		return false;	

	int x = GetSection(argv, 2);
	if(x < 0) return false;
		
	if(argc == 4)
	{
		if(strcmpi("true", argv[3]) == 0)
			General.ShowAll[x] = true; // set to true and return true
		else if(strcmpi("false", argv[3]) == 0)
			General.ShowAll[x] = false; // set to false and return true
		else
			return false;
	}
	else
		General.ShowAll[x] = !General.ShowAll[x];
	char msg[128];
	sprintf(msg, "Show All %s: %s", Sections[x], 
								General.ShowAll[x] ? "true" : "false");
	server->GamePrintInfo(msg);
	return true;			
}
//-----------------------------------------------------------------------------
