//Main.h
// This code is from ackmed's pickit module.
// ackmed@gotwalls.com
#pragma once
#include <windows.h>
#include "pickit.h"

// defines
#define		ITEM_MESSAGEID_DROP				0x9C
	
#define		ITEM_ACTION_NEW_GROUND			0x00
#define		ITEM_ACTION_PICK_UP				0x01
#define		ITEM_ACTION_DROP				0x02
#define		ITEM_ACTION_OLD_GROUND			0x03
#define		ITEM_ACTION_PLACE_UNKNOWN		0x04 // cube? or inventory
#define		ITEM_ACTION_TO_STORE			0x0B //?
#define		ITEM_ACTION_FROM_STORE			0x0C
#define		ITEM_ACTION_PLACE_BELT			0x0E
	
#define		ITEM_ITEMTYPE_HELM				0x00
#define		ITEM_ITEMTYPE_ARMOR				0x01
#define		ITEM_ITEMTYPE_WEAPON			0x05
#define		ITEM_ITEMTYPE_BOW				0x06
#define		ITEM_ITEMTYPE_SHIELD			0x07
#define		ITEM_ITEMTYPE_EXPANSION			0x0A // heads
#define		ITEM_ITEMTYPE_OTHER				0x10

#define		ITEM_LOCAIION_STORED			0x00
#define		ITEM_LOCATION_WORN				0x01
#define		ITEM_LOCATION_BELT				0x02
#define		ITEM_LOCATION_GROUND			0x03
#define		ITEM_LOCATION_TOHAND			0x04

#define		ITEM_LEVEL_INFERIOR				0x01
#define		ITEM_LEVEL_NORMAL				0x02
#define		ITEM_LEVEL_SUPERIOR				0x03
#define		ITEM_LEVEL_MAGIC				0x04
#define		ITEM_LEVEL_SET					0x05
#define		ITEM_LEVEL_RARE					0x06
#define		ITEM_LEVEL_UNIQUE				0x07
#define		ITEM_LEVEL_CRAFT				0x08

#define		ITEM_INFERIORTYPE_CRUDE			0x00
#define		ITEM_INFERIORTYPE_CRACKED		0x01
#define		ITEM_INFERIORTYPE_DAMAGED		0x02
#define		ITEM_INFERIORTYPE_LOWQUALITY	0x04

#define		ITEM_SUPERIOR_AR				0x00 // attack rating
#define		ITEM_SUPERIOR_MAXDMG			0x01 // max damage
#define		ITEM_SUPERIOR_AC				0x02
#define		ITEM_SUPERIOR_AR_MAXDMG			0x03
#define		ITEM_SUPERIOR_DUR				0x04
#define		ITEM_SUPERIOR_DUR_AR			0x05
#define		ITEM_SUPERIOR_DUR_MAXDMG		0x06
#define		ITEM_SUPERIOR_DUR_AC			0x07

#define		ITEM_GOLDSIZE_12BIT				0x00
#define		ITEM_GOLDSIZE_32BIT				0x01

#define		ITEM_UNSET						0xFF
/*enum IBOOL {
	ITEM_FALSE = 0,
	ITEM_TRUE,
	ITEM_UNSET
}; */

// item struct
typedef struct ItemStruct_t {

	BYTE	MessageID;
	BYTE	Action;
	BYTE	MessageSize;
	BYTE	ItemType;
	DWORD	ItemID;
	
	// flags
	BOOL	isSocketsFull;
	BOOL	isIdentified;
	BOOL	isEthereal;
	BOOL	isSwitchin;
	BOOL	isSwitchout;
	BOOL	isBroken;
	BOOL	fromBelt;
	BOOL	hasSockets;
	BOOL	isJustGenerated;
	BOOL	isEar;
	BOOL	isStartitem;
	BOOL	isMiscItem;			// unverified
	BOOL	isPersonalized;
	BOOL	isGamble;
	BOOL	isRuneWord;			// unverified
	BOOL	isMagicExtra;		// unverified

	WORD	MPQVersionField;
	BYTE	Location;
	WORD	PositionX;
	WORD	PositionY;
	char	ItemCode[5];
	BYTE	ItemLevel;

	// gold specific
	BOOL	GoldSize;
	DWORD	GoldAmount;
	
} ITEMSTRUCT;
//-----------------------------------------------------------------------------

// function definations
extern char Sections[9][9];
// total amount in Sections[] - 1 (subtracting all).  
//Mainly use with <= SECTIONSNUM for testing for a section
#define SECTIONSNUM 8 
ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length);
void DebugItemBits(BYTE data, BYTE size, DWORD pos);
DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max);
BOOL PRIVATE Invert(char** argv, int argc);
BOOL PRIVATE ShowAll(char** argv, int argc);
BOOL PRIVATE ShowStatus(char** argv, int argc);
BOOL PRIVATE ShowConfig(char** argv, int argc);
BOOL PRIVATE StartStop(char** argv, int argc);
BOOL PRIVATE LoadConfig();
BOOL PRIVATE AddItem(char** argv, int argc);
BOOL PRIVATE Reload(char** argv, int argc);
INT PRIVATE GetSection(char*** argv, int sub);
//-----------------------------------------------------------------------------

// from mousepad with some small mods
struct BitFields {
	BYTE *data;
	DWORD pos;
	DWORD max;
	BitFields(BYTE *d, DWORD mx) {
		data = d; 
		pos = 0; 
		max = (mx * 8);  // convert to max bits
	}
	DWORD GetField(DWORD len) {
		return GetBitField(data, (pos+=len)-len, len, max);
	}
};
//-----------------------------------------------------------------------------

DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max) {
	// trying to read beyond the end of the packet

	if(pos + len > max) {

		// if we are already at or beyond the end of packet, return 0;
		if(pos >= max) {
			return 0;
		}
		// otherwise adjust len to all remaining bits
		len = max - pos;
	}

	return (DWORD)(*(unsigned __int64 *)(data+pos/8)<<(64-len-(pos&7))>>(64-len));
}
//-----------------------------------------------------------------------------

ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length) {
	ITEMSTRUCT *item = new ITEMSTRUCT;

	BitFields iPacket(Packet,Length);	

	// dump the packet
	
	item->MessageID = iPacket.GetField(8);

	if(item->MessageID != ITEM_MESSAGEID_DROP) 
	{
		delete item;
		return NULL;
	}
	
	item->Action = iPacket.GetField(8);
	if(item->Action != ITEM_ACTION_NEW_GROUND && item->Action != ITEM_ACTION_DROP
		&& item->Action != ITEM_ACTION_OLD_GROUND) {
		// we dont handle parsing these packets.
		delete item;
		return NULL;
	}

	item->MessageSize = iPacket.GetField(8);
	item->ItemType = iPacket.GetField(8);
	item->ItemID = iPacket.GetField(32);

	// flags
	item->isSocketsFull = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isIdentified = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isSwitchin = iPacket.GetField(1);
	item->isSwitchout = iPacket.GetField(1);
	item->isBroken = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->fromBelt = iPacket.GetField(1);
	item->hasSockets = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isJustGenerated = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
	item->isEar = iPacket.GetField(1);
	item->isStartitem = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isMiscItem = iPacket.GetField(1);
	item->isEthereal = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isPersonalized = iPacket.GetField(1);
	item->isGamble = iPacket.GetField(1);
	item->isRuneWord = iPacket.GetField(1);
	
	DebugItemBits(iPacket.GetField(5),5,iPacket.pos);
	item->MPQVersionField = iPacket.GetField(10);

	item->Location = iPacket.GetField(3);
	item->PositionX = iPacket.GetField(16);
	item->PositionY = iPacket.GetField(16);

	// isEar need to return now, until ear packets are decoded  
	if(item->isEar) {
		return item;
	}

	// read in itemcode, its a string;
	item->ItemCode[0] = iPacket.GetField(8);
	item->ItemCode[1] = iPacket.GetField(8);
	item->ItemCode[2] = iPacket.GetField(8);
	item->ItemCode[3] = iPacket.GetField(8);

	// chomp off the space if it exists
	if(item->ItemCode[3] == ' ') {
		item->ItemCode[3] = '\0';
	} else {
		item->ItemCode[4] = '\0';
	}

	// gold is a special case
	if(strcmp(item->ItemCode,"gld") == 0) {
		item->GoldSize = iPacket.GetField(1);
		if(item->GoldSize == ITEM_GOLDSIZE_12BIT) {
			item->GoldAmount = iPacket.GetField(12);
		} else {
			item->GoldAmount = iPacket.GetField(32);
		}
		item->ItemLevel = ITEM_UNSET;
		return item;
	}

	// more special cases need to look into properly decoding them
	if(strcmp(item->ItemCode,"ibk") == 0 ||
		strcmp(item->ItemCode,"tbk") == 0 ||
		strcmp(item->ItemCode,"key") == 0) {
		item->ItemLevel = ITEM_UNSET;
		return item;
	}
	

	// packet not long enough to read ItemLevel
	if(iPacket.pos + 14 >= iPacket.max) {
		// causes way to much spam
	/*	if(Debug == DEBUG_DEVEL) {
			server->GamePrintInfo("ParseItemDrop: Return before ItemLevel");
		}
		*/ 
		item->ItemLevel = ITEM_UNSET;
		return item;
	}

	DebugItemBits(iPacket.GetField(8),8,iPacket.pos);
	DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
	item->ItemLevel = iPacket.GetField(4);
	return item;
}
//-----------------------------------------------------------------------------

void DebugItemBits(BYTE data, BYTE size, DWORD pos) {
// fill me in!
	BYTE n;

	if(Debug == DEBUG_PACKET) 
	{
		server->GamePrintInfo("In DebugItemBits");
		sprintf(DebugBuffer,"%d: ",pos);
		if(size > 8)
			size = 8;
		if(size != 8) 
			data = data<<(8 - size);
		for(n = 0;n < size;n++) 
		{
			if((data & 0x80) !=0)
				sprintf(DebugBuffer,"%s1",DebugBuffer);
			else
				sprintf(DebugBuffer,"%s0",DebugBuffer);
			data = data<<1;
		}
		server->GamePrintInfo(DebugBuffer);
	}
}
//-----------------------------------------------------------------------------

INT PRIVATE GetSection(char** argv, int sub)
{
	int x = 0;
	while(x <= SECTIONSNUM)
	{
		if(strcmpi(argv[sub], Sections[x]) == 0)
			return x;
		else
			++x;
	}
	return -1;
}
//-----------------------------------------------------------------------------