#include "stdafx.h"
#include "DiabloCharacters.h"


CDiabloCharacters::CDiabloCharacters()
{
	m_Name = "" ;
	m_bItemPlayerID = -1 ;
}


// see if we have character data here.  this is not a member of the CDiabloCharacters class
//   but will create a CDiabloCharacters if we find char info
CDiabloCharacters::CDiabloCharacters( const unsigned char *pkt_data)
{
	m_Name = "" ;
	m_bItemPlayerID = -1 ;
	m_bDualUse = FALSE ;

	LoadCharacterAttributes( pkt_data) ;
}



// delete all the items and free up memory taken by item list
void CDiabloCharacters::RemoveAllItems()
{
	// delete all the memory taken up by the items
	while(!m_ItemList.IsEmpty()) {
		CDiabloItems* pItem = (CDiabloItems*)m_ItemList.RemoveHead();
		delete pItem ;
	}
}


void CDiabloCharacters::PrintCharacter()
{
	FILE* fout = fopen("dump.txt", "a") ;
	fprintf(fout, "\n\n-[%x] %s ------ ", m_bItemPlayerID, m_Name) ;

	//print the time
	CTime	theTime = CTime::GetCurrentTime() ;
	CString myTime = theTime.Format( "%B %d, %Y  %H:%M:%S" );
	fprintf( fout, "%s\n", myTime) ;

	fclose(fout) ;
}


// print the bytes that make up an item
CString CDiabloCharacters::PrintHex()
{
	CString sOutput, sTmp ;
//	for (DWORD count=0; count<m_bMessageLen; count++) {
	for (int count=0; count<25; count++) {
		if (m_sPacketMsg[count] < 0x10)
			sOutput += "0" ;
		sTmp.Format( "%X ", m_sPacketMsg[count]);
		sOutput += sTmp ;
	}
	return sOutput ;
}


CString CDiabloCharacters::getCharacterName( const unsigned char *pkt_data)
{
	// get the name
	int	tmp = CHARPOS_NAME ;
	CString	sCharName ;
	while (pkt_data[tmp] != 0x00) {
		sCharName = sCharName + (char)pkt_data[ tmp] ;
		tmp++ ;
	}
	return sCharName ;
}


BOOL CDiabloCharacters::LoadCharacterAttributes( const unsigned char *pkt_data)
{
	m_Name = getCharacterName( pkt_data) ;
	m_bItemPlayerID = pkt_data[ CHARPOS_PID1] ;
	m_itsMe = FALSE ;
	for (int i=0; i<26; i++)
		m_sPacketMsg[i] = pkt_data[i] ;

	// see if its me!, if the last four bytes are 0's, its me
	DWORD	charInfo ;
	memcpy(&charInfo, &pkt_data[ CHARPOS_TYPE],sizeof charInfo);
	if ( charInfo == 0)
		m_itsMe = TRUE ;

	return ( m_Name != "") ;
}


BOOL CDiabloCharacters::SocketGem( CDiabloItems* newItem)
{
 	// get the object this gem might be socketed in to
	POSITION	pos = m_ItemList.GetHeadPosition() ;
	while (pos != NULL) {
		// see if this is a match, and put gem into this item if so
//cn should also add the socketed mods to the item here
		CDiabloItems* pItem = (CDiabloItems*)m_ItemList.GetNext(pos);
		if ( pItem->m_bItemID == newItem->m_bPlayerID) {

			// see if we already have this item in our list
			POSITION pos1, pos2;
			for ( pos1 = pItem->m_pSocketItems.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ) {
				CDiabloItems* dupGem = (CDiabloItems*)pItem->m_pSocketItems.GetNext( pos1) ;

				// if already in the list, delete the old one and keep the new one
				if ( dupGem->m_bItemID == newItem->m_bItemID) {
					// Save the old pointer for deletion
					dupGem = (CDiabloItems*)pItem->m_pSocketItems.GetAt( pos2 );
					pItem->m_pSocketItems.RemoveAt( pos2 );

					delete dupGem ;
				}
			}
			// add this gem/rune to the item socket list
			newItem->m_iLeft = pItem->m_iLeft ;
			newItem->m_iTop = pItem->m_iTop + (pItem->m_iSocketsPlaced * PICPOSLEN) ;
			pItem->m_pSocketItems.AddTail( newItem) ;

			pItem->m_iSocketsPlaced++ ;
			return TRUE ;
		}
	}

	return FALSE ;
}



////////////////////////////////////////////////////////


CCharList::CCharList()
{
	m_iCharCount = 0 ;
}


// delete all the items and free up memory taken by character list
void CCharList::RemoveAllCharacters( BOOL bForceDelete)
{
	// delete all the memory taken up by the characters
	POSITION pos1, pos2;
	for ( pos1 = m_CharList.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ) {
		CDiabloCharacters* pChar = (CDiabloCharacters*)m_CharList.GetNext( pos1) ;

		// Save the old pointer for deletion
		pChar = (CDiabloCharacters*)m_CharList.GetAt( pos2 );
		m_CharList.RemoveAt( pos2 );

		// make sure we aren't deleting a memory we loaded from a file unless we mean to
		if ( (bForceDelete) || ( !pChar->m_bDualUse)) {
			pChar->RemoveAllItems() ;
			delete pChar ;
		}
	}
}


// add a character to our char list
void CCharList::AddCharacter( CDiabloCharacters* newCharacter)
{
	BOOL	bReturn = FALSE ;

	// if its me, its a new game so reset my player count
	if ( newCharacter->m_itsMe)
		m_iCharCount = 0 ;


	// add the new character data
	newCharacter->m_iPlayerCounter = m_iCharCount ;
	m_CharList.AddTail( newCharacter) ;
}


BOOL CCharList::FindMatch( CDiabloCharacters* newCharacter, BOOL onlyMe)
{
	// if we got a character, then handle if its me or some one else
	if ( newCharacter->m_Name == "") {
		return FALSE ;

	} else {

		// reset char list if got a "new me"; means we just entered a new game
		if ( newCharacter->m_itsMe )
			RemoveAllCharacters() ;

		// inventory manager will only care if its me
		else if ( onlyMe)
			return FALSE ;


		// see if this char is already on our list
		BOOL		gotMatch = FALSE ;
		POSITION	pos = m_CharList.GetHeadPosition() ;
		CDiabloCharacters* pCharacterOwner ;
		while ( pos != NULL) {
			pCharacterOwner = (CDiabloCharacters*)m_CharList.GetNext(pos) ;

//cn should really consider deleteing the old and start a new one
			// already have this valid char name, so reuse it
			if ( pCharacterOwner->m_Name == newCharacter->m_Name) {
				// blow away the items we currenly have listed in case there is some new stuff
				pCharacterOwner->RemoveAllItems() ;

				// maybe the player left and then came back in and has a new PID
				pCharacterOwner->m_bItemPlayerID = newCharacter->m_bItemPlayerID ;
				pCharacterOwner->m_itsMe = newCharacter->m_itsMe ;
				gotMatch = TRUE ;
				break ;
			}
		}

//newCharacter->PrintCharacter() ;

		if ( !gotMatch)
 			AddCharacter( newCharacter) ;

		return !gotMatch ;
	}
}


BOOL CCharList::FindOwnerMatch( CDiabloItems* newItem)
{
	// let's match this item with someone in our char list
	BOOL		bGotMatch = FALSE ;
	POSITION	pos = m_CharList.GetHeadPosition() ;
	CDiabloCharacters* pCharacterOwner ;
	while ( pos != NULL) {
		pCharacterOwner = (CDiabloCharacters*)m_CharList.GetNext(pos) ;

		// if it's a 9C message, you have to assume the ownerid
		if (( newItem->m_bActionID == MSG_TOINV) || ( newItem->m_bActionID == MSG_TOBELT))
			newItem->m_bPlayerID = pCharacterOwner->m_bItemPlayerID ;


		// if this is a socketed gem, find the item that owns it
		if (newItem->m_isInSocket) {

			// associate gem with a socketed item, the memory will be deleted in the calling
			//	function if we can't socket this gem/rune
			if ( pCharacterOwner->SocketGem( newItem))
				bGotMatch = TRUE ;
			break ;
		
		// found a match for this item
		} else if ( pCharacterOwner->m_bItemPlayerID == (int)newItem->m_bPlayerID ) {

			// see if we already have this item in our list
			POSITION pos1, pos2;
			for ( pos1 = pCharacterOwner->m_ItemList.GetHeadPosition(); ( pos2 = pos1 ) != NULL; ) {
				CDiabloItems* dupItem = (CDiabloItems*)pCharacterOwner->m_ItemList.GetNext( pos1) ;

				// if already in the list, delete the old one and keep the new one
				if ( dupItem->m_bItemID == newItem->m_bItemID) {
					// Save the old pointer for deletion
					dupItem = (CDiabloItems*)pCharacterOwner->m_ItemList.GetAt( pos2 );
					pCharacterOwner->m_ItemList.RemoveAt( pos2 );

					delete dupItem ;
				}
			}

			pCharacterOwner->m_ItemList.AddTail( newItem) ;
			bGotMatch = TRUE ;
//CN - ERRR... CONSIDER PUTTING THIS BACK IN LATER ;-)

			// print any debug info if there were flags
			if ( newItem->m_bDebug) {
				pCharacterOwner->PrintCharacter() ;
				newItem->DumpDebugInfo() ;
			}

			break ;
		}

	}


	// didn't match so we don't know who it belongs to
	return bGotMatch ;
}