// DiabloItems.cpp
//
/////////////////////////////

#include "stdafx.h"
#include "DiabloItems.h"

#include "D2MagicAffixes.h"
#include "D2Uniques.h"
#include "D2Sets.h"


/*
TO DO:
	i need a Buriza-Do Kyanon
	have pics, need pallette
	NOTE: i had to modify the Phase Blade to have a durability

DONE:
	write a bitfield to byte translator!!!!
	need to write to dump.txt whenever new or unexpected info comes up
	make the bitfield part of the class and break function into smaller pieces
	weapons (durability)
	magic items
	rare items
	other item attributes from tables
	set item stats
	why does uniques.txt NOT have all the attributes???

	further refine getting the magic attributes, disassociate from magic modifiers
		hmmm... b/c of lightning dam, poisdam, King's, etc. I like the association...
		just have a different way for remembering the params we will be using so that
		we can get extras and strip out duplicates
	can easily do superior, inferior, set, and unique now
	crafted?
	redo socketing (link list)
	what is going on with socketed items being isMagic but having no mods?
	make sure all isMagic's are ending in 111111111 or have a reason not to.

	make FILE* global so that we can open/close once per item
		need to make sure thohell's flags are right
	where does "% Fire Resist" come from?
??	considering having one for one mapping item to pos on char (no multi items per slot)



//BLAH://
	MPQ:
		autoprefix + magic level's on class specific
		draw weapon switch locations
		only weapons have to worry about "nodur"
		"gemapplytype" = 0 for anything in weapons.txt
		are there flags for useable and throwable? (pots are useable)
		no misc.txt items are throwable	
			autobelt as a flag?
			Hel Rune level was 0, changed to 33
			gemapplytype = 1 for ring and amulet
		component: 5,6=weapon.txt; 0,1,7,10,16 = armor.txt; 16=misc.txt
			torch=7 in misc.txt
		i stripped out the durability of the weapons b/c it's right in the record!

*/



/*
DIABLO II PACKET ITEM FORMAT

//////
//////  Common Byte (CB) accessible fields - all items have these
//////
BYTE(S)		BIT(S)		FIELD			VALUE(S)
[00]		000->007	MessageID		only 2 values, 9D messages have an owner id
										9C = standard item message (in storage, in a shop, on ground)
										9D = item message requiring an owner ID (extra 5 bits are added)

[01]		008->015	ActionID		what is going on with the item
										00 = (9c) new item created
										01 = (9c) I picked up from ground to cursor
										02 = (9c) dropped by any player, monster, or chest
										03 = (9c) existing item encountered (on ground when strolling about)
										04 = (9c) put in a storage place (inv, cube, stash)
										05 = (9c) I picked from storage place to cursor
										06 = (9D) a player (or me) is wearing
*****									07 ??????????
										08 = (9D) a player removed from worn to cursor
										09 = (9D) a player switched worn items (dropped one on top of other)
*****	could this be sell (add)???		0A ??????????
										0B = (**) in store
										0C = (**) buy (remove) from store
										0D = (9c) I switched stored items (dropped one on top of the other)
										0E = (9c) item is in my belt
*	(belt to hand?)						0F = (9c) item was removed my belt
										10 = (9c) switched items in belt (drop method)
*****									11 ??????????
										12 = (**) removed from merc
										13 = (9D) item is in the socket of another item
*****									14 ??????????
*										15 = (**) auto slide (potion auto drop in belt; filling a socket; getting identified?
*****									16 ??????????
										17 = (9D) a player preformed a weapon switch command

[02]		016->023	Message Len		the number of bytes to describe this item
[03]		024->031	Component		rough idea of item type; matches field in MPQ txt files (98% of the time)
										//weapons.txt
										05 = weapon, including throwing potions
										06 = bow (crossbows are 05); sometimes shields incorrectly end up here??
										//armor.txt
										00 = helm
										01 = torso armor
										07 = shield
										0A = necro's perserved heads
										//armor.txt -OR- misc.txt
										10 = misc item (everything else)

[04->07]	032->063	ItemID			DWORD for the item id; changes with every game


////
//// FOR 9D ONLY
////
[08]		064->071	Owner Action	explains what this owner id is for
										00 = id of the player that is wearing this item
										01 = id of the player who's MERC is wearing this item
										04 = id of the ITEM that this item is socketed into

[09->12]	072->063	ItemID			DWORD for the item id; changes with every game

/////// end CB



//////
////// FLAGS (FG) - regardless of 9C or 9D, flags would be next; reset the byte and bit counters for clarity
//////
CB+			CB+
[00->04]	000->031	Flags			switches for various things; not all these are confirmed

[00]		000			isMeWearing		true if I'm wearing this item; ** what about my merc wearing??
			001			isJustBought	I just bought this item from a store; ** what about if another player bought it?
			002			????			????
			003			isInSocket		this item is in a socket
			004			isIdentified	the item has been identified (not unidentified)
			005			isEtheral		this is an etheral item (** not tested)
			006			isSwitchIn		a weapon switch command was performed, and this item is now being used
			007			isSwitchOut		a weapon switch command was performed, and this item is no longer being used
[01]		008			isBroken		the durability is zero on this item
			009			????			????
			010			isPotionX		** not sure on this one; only seems to be on mana, health, and rejuvi potions
			011			isSocketed		the item has sockets (or can be socketed?) ** i've seen rings with this set!?!?
			012			????			????
			013			isJustGen		** not sure, i didn't discover this one
			014->015	????			????
[02]		016			isEar			a player ear
			017			isStartItem		an item that a new character starts with; like the Palidin sword and buckler
			018->020	????			????
			021			isMiscItem		a vanilla item like gold or a potion ** (need to verify more)
			022			isClassBonus	??** a player is wearing this item and getting the class specific bonus ** not sure
			023			isMagic			** err... seems to mean there are additional bits beyond on the item code (and durability)
[03]		024			isClassBonus2	??** once again, this could be class bonus or something?
			025			isGamble		this is an item in the gamble screen
			026->031	????			** could have something to do with crafted, named, or rune word

[04->05]	032->041	????			???? - this is always 0,1, or 100;  Maybe it is used for determining magic stuff??


////// end FG



//////
////// Location Type (LT) - if it's on the ground or 05, then we need large map coordinates, otherwise we can use smaller 4 bit ones
//////

CB+			CB+
[05]		042->044	Location Type	the general whereabouts of this item
										00 = in storage (inv, cube, stash)
										01 = being worn
										02 = on my belt
										03 = on the ground
										04 = in my hand ** what about for 08 message??
										05 = ????** - mousepad seems to know what this, something about with areaXY
										06 = in a socket

////
//// 16 bit map coordinates for 03 and 05
////
CB+			CB+
[05->07]	045->060	Area X			16 bit map x coordinate (the x-axis is tilted up at a 45 degree angle)
[07->09]	061->075	Area Y			16 bit map y coordinate (the x-axis is tilted up at a 45 degree angle)

////
//// 4 bit inventory coordinates for 0,1,2,4, and 6
////
CB+			CB+
[05->06]	045->048	Body Code		where on the body this item is
										00 = not worn (stored)
										01 = head
										02 = amulet
										03 = body
										04 = weapon1
										05 = shield1
										06 = left ring
										07 = right ring
										08 = belt
										09 = boots
										0A = gloves
										0B = weapon2
										0C = shield2

[06]		049->052	stored X		4 bit storage x location; ** not sure why these are not zero for worn items - maybe they are not zeroed
[06->07]	053->056	stored Y		4 bit storage y location
										NOTE: for pots in the belt, X=value from 0 to 15 indicating where in the belt it is
											and Y seems to always be 0x06, not sure why	

[07]		057->059	Storage Code	which storage place has this item
										// non-store item
										00 = wearing
										01 = inventory
										04 = cube
										05 = stash
										// store items (ActionID = 0B)
										01 = armor
										02 = weapon tab1
										03 = weapon tab2
										04 = misc tab

////// end LT



//////
//////  EAR - only if isEar is true; ears are different from any other record, having no item code but just the isEar flag
//////
LT+			LT+
[00]		000->002	Player Class	the class of the slain player
										00 = Amazon
										01 = Sorceress
										02 = Necromancer
										03 = Paladin
										04 = Barbarian
										05 = Druid
										06 = Assassin

[00->01]	003->009	Player Level	the level of the slain player
[01->END]	010->x*7	Player Name		name of the slain player; accessed 7 bits at a time until a null (0000000) is found

//// NOTE: at this point there are no more bytes remaining in message for an ear




//////
////// BASE ITEM (BI) - get the item code and other base attributes
//////
LT+			LT+
[00->03]	000->0031	Item Code		the way this item is index in the MPQ files; use the component field for best guess as to which file
										from the file from which you finally find the item, remember if it is an armor, a weapon, of a miscitem


////
//// GOLD - gold is like no other item (can't be in inv) and it's quantity is not calculated like any other item
////
[04]		032			Gold Size		if true, then use 32 bits instead of 12
//
[04->05]	033->044	Gold Amount		Gold Size = 0, then the amount for a smaller stack
// -OR-
[04->08]	033->064	Gold Amount		Gold Size = 1, then the amount for a larger stack



////
//// ISMISC - all armors, all weapons, and any miscitems that don't have isMisc flag set
////

//// NOTE: **(confirm) at this point there are no more bytes remaining in message for items with isMisc = TRUE



////
//// ALL OTHER ITEMS
////
[04]		032->034	Sockets Used	the number of sockets that are in use
[04->05]	035->041	Level			NOT REALLY USED - does not reflect the "required" level or monster level
[05]		042->044	Quality			the magic quality of the item
										01 = inferior
										02 = normal
										03 = superior
										04 = magic
										05 = set
										06 = rare
										07 = unique
										more??

////// end of BI




//////
////// IMAGE ATTRIBUTES (IA)
//////

////
//// ring, ammy, jewl, and charm pics - 2+4 bits			** only tested with MAGICS so far!!!
////
BI+			BI+
[00]		000->001	??????			??????
[00]		002->005	Image			for these items, pic the proper iteration of the image


////
//// all other items - 3 bits					** not sure what the hell it is for though!!
////
BI+			BI+
[00]		000->002	??????			??????


////// end if IA




//////
////// QUALITY ATTRIBUTES (QA)
//////

////
//// inferior
////
IA+			IA+
[00]		000->002	Inferior Type	what kind of inferior item is it?
										00 = Crude
										01 = Cracked
										02 = Damaged
										03 = Low Quality

////
//// normal
////

  There is no QA for normal items

////
//// superior				** need to figure out the mods for these!!!
////
IA+			IA+
[00]		000->002	Superior Type	what kind of superior item is it?
										00 = AR 
										01 = Max Dmg 
										02 = AC 
										03 = AR + Max Dmg 
										04 = Durability 
										05 = Durability + AR 
										06 = Durability + Max Dmg 
										07 = Durability + AC 

////
//// magic
////
IA+			IA+
[00->01]	000->011	Prefix			the line number to a prefix in magicprefix.txt (minus the header and the "expansion" line)
[01->02]	012->022	Suffix			the line number to a suffix in magicsuffix.txt (minus the header and the "expansion" line)

////
//// set
////

  need to figure these out still

////
//// rare			** i'm going to bet the names are found similarly to the magic affixes and perhaps 
////				**   a field for num mods or a NULL for no more mods


  need to figure these out still

////
//// unique
////

  need to figure these out still


////// end of QA






***
***
I think that next come and magical mods (for inf/sup, magic, sets, rare, uniques) followed by stackable and durability
   if they are applicable; not sure if there is anything else afterwards; also +10 if an armor to proceed anything

hmmmm.... mods could follow this stuff actually (ie. look at magic items)
***
***






/////////////////////////////////////////////////
////
//// stackable
////
BI+		BI+
[00]	000->001		??????			??????
stackable

// for misc
  // looks like weapons are 12 away!?!?
		if ( m_pMisc->m_Stackable) {
			if (m_ItemBits.GetField(3)) PrintDebug("U9 ! 0", FALSE) ;					// 173-175	// 190-192
			// for some reason, tombs have additional bits??
			if ((m_sBaseName == "Town Portal Book") || (m_sBaseName == "Identify Book"))
				// i have seen this be 1 on a ident book
				if (m_ItemBits.GetField(5)) PrintDebug("U9-2 ! 0", FALSE) ;					// 173-175	// 190-192

			DWORD quantity = m_ItemBits.GetField(9, "quantity");					// 159-165	// 176-182
			CString stemp ;
			stemp.Format("%s (%d)", m_sBaseName, quantity) ;
			m_sBaseName = stemp ;
		}
//

// for weapons
			// not /T says 3 bits for item design (rings), but I bet this is for superior+inferior
			//	as well.  I also bet that not every item has it.
			DWORD	iQualityType = m_ItemBits.GetField(3, "iQualityType") ;			// 170-172	// 187-189

			if (m_ItemBits.GetField(3)) PrintDebug("U9 ! 0", FALSE) ;					// 173-175	// 190-192


			//cn - I think offensive potions are stackable too
			// for stackable weapons like throwing knives and also pots like stangling gas
			if (( m_isStackable) && ( m_bComponent == TYPE_WEAPON)) {
				if (m_ItemBits.GetField(2)) PrintDebug("U9 ! 0", FALSE) ;					// 173-175	// 190-192
				// unknown 10
				m_ItemBits.GetField(10);					// 159-165	// 176-182
				DWORD quantity = m_ItemBits.GetField(9, "quantity");					// 159-165	// 176-182
				CString stemp ;
				stemp.Format("%s (%d)", m_sBaseName, quantity) ;
				m_sBaseName = stemp ;
			}
//
////
/////////////////////////////////////////////////



*/


CDiabloItems::CDiabloItems()
{
	m_iSocketsPlaced = 0 ;

	m_bDebug = FALSE ;
	m_isMercItem = FALSE ;
	m_isStackable = FALSE ;
	m_hasDurability = FALSE ;
	m_isIndestructable = FALSE ;

	m_iNumModDesc = 0 ;

	m_pArmor = NULL ;
	m_pWeapon = NULL ;
	m_pMisc = NULL ;

	m_iDefense = 0 ;
	m_iDurabilityCur = 0 ;
	m_iDurabilityMax = 0 ;
	m_iQuantity = 0 ;
	m_iUsedSockets = 0 ;
	m_iNumSockets = 0 ;
}


CDiabloItems::~CDiabloItems()
{
	// remove the info lines in this item
	while(!m_InfoLines.IsEmpty()) {
		COutputLine* pInfo = (COutputLine*)m_InfoLines.RemoveHead();
		delete pInfo ;
	}

	// remove the socketed items in the item
	while(!m_pSocketItems.IsEmpty()) {
		CDiabloItems* pGem = (CDiabloItems*)m_pSocketItems.RemoveHead();
		delete pGem ;
	}
}


// print the bytes that make up an item
CString CDiabloItems::PrintItemHex()
{
	CString sOutput, sTmp ;
	for (DWORD count=0; count<m_bMessageLen; count++) {
		if (m_sPacketMsg[count] < 0x10)
			sOutput += "0" ;
		sTmp.Format( "%X ", m_sPacketMsg[count]);
		sOutput += sTmp ;
	}
	return sOutput ;
}


CPoint CDiabloItems::getCoordinates()
{
	// potion in the belt
	if ( m_isMercItem) {
		switch (m_bBodyCode) {
			case BODY_HEAD:		return CPoint( PICPOS_MERCHEADX, PICPOS_MERCHEADY) ;
			case BODY_BODY:		return CPoint( PICPOS_MERCBODYX, PICPOS_MERCBODYY) ;
			case BODY_WEAPON:	return CPoint( PICPOS_MERCWEAPONX, PICPOS_MERCWEAPONY) ;
			case BODY_SHEILD:	return CPoint( PICPOS_MERCSHIELDX, PICPOS_MERCSHIELDY) ;
		}

	// inventory
	} else if ( m_bWhere == ITEM_INV) {
		return CPoint( PICPOS_INVX + (m_bPosX*PICPOSLEN), PICPOS_INVY + (m_bPosY*PICPOSLEN)) ;

	// stash
	} else if ( m_bWhere == ITEM_STASH) {
		return CPoint( PICPOS_STASHX + (m_bPosX*PICPOSLEN), PICPOS_STASHY + (m_bPosY*PICPOSLEN)) ;

	// cube
	} else if ( m_bWhere == ITEM_CUBE) {
		return CPoint( PICPOS_CUBEX + (m_bPosX*PICPOSLEN), PICPOS_CUBEY + (m_bPosY*PICPOSLEN)) ;

	// wearing
	} else if ( m_bWhere == ITEM_WEARING) {
		int	iCenterX = (PICPOS_MAXWEAPONX - m_iRight)/2 ;
		if (iCenterX < 0) iCenterX=0 ;
		int	iCenterY = (PICPOS_MAXWEAPONY - m_iBottom)/2 ;
		if (iCenterY < 0) iCenterY=0 ;
		switch (m_bBodyCode) {
			case BODY_HEAD:		return CPoint( PICPOS_HEADX, PICPOS_HEADY) ;
			case BODY_AMMY:		return CPoint( PICPOS_AMULETX, PICPOS_AMULETY) ;
			case BODY_BODY:		return CPoint( PICPOS_BODYX, PICPOS_BODYY) ;

			// center the shield and weapon slots
			case BODY_WEAPON:	
								return CPoint( PICPOS_WEAPONX+iCenterX, PICPOS_WEAPONY+iCenterY) ;
			case BODY_WEAPON2:	return CPoint( PICPOS_WEAPON2X+iCenterX, PICPOS_WEAPON2Y+iCenterY) ;
			case BODY_SHEILD:	return CPoint( PICPOS_SHIELDX+iCenterX, PICPOS_SHIELDY+iCenterY) ;
			case BODY_SHEILD2:	return CPoint( PICPOS_SHIELD2X+iCenterX, PICPOS_SHIELD2Y+iCenterY) ;

			case BODY_LRING:	return CPoint( PICPOS_RINGLEFTX, PICPOS_RINGLEFTY) ;
			case BODY_RRING:	return CPoint( PICPOS_RINGRIGHTX, PICPOS_RINGRIGHTY) ;
			case BODY_BELT:		return CPoint( PICPOS_BELTX, PICPOS_BELTY) ;
			case BODY_BOOT:		return CPoint( PICPOS_FOOTX, PICPOS_FOOTY) ;
			case BODY_GLOVES:	return CPoint( PICPOS_HANDX, PICPOS_HANDY) ;
			case BODY_NOTWORN:
				// potion in the belt
				if ( m_bActionID == MSG_TOBELT) {
					int y = m_bPosX / 4 ;
					int x = m_bPosX % 4 ;
					return CPoint( PICPOS_INBELTX + ( x *(PICPOSLEN+2)), PICPOS_INBELTY - ( y *(PICPOSLEN+2))) ;
				}
		}
	}

	return CPoint(0,0) ;
}


void CDiabloItems::PrintDebug(CString sDebugLine, BOOL bTriggerDebug)
{
	if (bTriggerDebug)
		m_bDebug = TRUE ;
	m_sDebugTriggers.AddTail( sDebugLine) ;
}


void CDiabloItems::CommonByteParsing()
{
	m_bMessageID =	m_sPacketMsg[ 0] ;
	m_bActionID =	m_sPacketMsg[ 1] ;
	m_bMessageLen =	m_sPacketMsg[ 2] ;
	m_bComponent =	m_sPacketMsg[ 3] ;
	// 4,5,6,7
	memcpy(&m_bItemID,&m_sPacketMsg[ 4],sizeof m_bItemID);	// m_bItemID

//cn
// for 9C, I'm thinking there is no "owner id"
// for 9D, the first byte is some kind of action and the next 4 are the owner ID
//		at least the next 2 are any way (probably 4 though)
//	04=socketed; 00=wearing; 01=merc wearing (only for your own merc *sigh*)


	// if it's 9C, then it is obvious who the owner is; for 9D, get the owner
	if ( m_bMessageID == 0x9D) {
		DWORD	bOwnerAction = m_sPacketMsg[8] ;
		memcpy(&m_bPlayerID,&m_sPacketMsg[ 9],sizeof m_bPlayerID);	// m_bItemID
		m_isMercItem = ( bOwnerAction == OACT_MERC) ;
	}

//cn-debug
	if ((m_bActionID == 0x07) || (m_bActionID == 0x0A) || (m_bActionID == 0x11) || (m_bActionID == 0x14) || (m_bActionID == 0x16) || (m_bActionID > 0x17)) {
		PrintDebug("ACTIONID") ;
	}
/*
	if ((m_bActionID > MSG_TOWORN) && (m_bActionID < MSG_INSTORE)) {
		PrintDebug("ACTIONID") ;
	} else if ((m_bActionID > MSG_TOBELT) && (m_bActionID != MSG_TOSOCKET) && (m_bActionID != MSG_WEAPSWITCH)) {
		PrintDebug("ACTIONID") ;
	}
*/

//cn-debug
	if (!((m_bComponent == TYPE_HELM) || (m_bComponent == TYPE_ARMOR) || (m_bComponent == TYPE_WEAPON) || (m_bComponent == TYPE_BOW) || (m_bComponent == TYPE_SHIELD) || (m_bComponent == TYPE_PHEAD) || (m_bComponent == TYPE_MISC))) {
		CString sTmp ;
		sTmp.Format("m_bComponent = %X", m_bComponent) ;
		PrintDebug( sTmp) ;
	}
}


void CDiabloItems::ParseFlags()
{
// etheral unrepairable?

	// flags
	BOOL isMeWearing =	m_ItemBits.GetField(1, "isMeWearing") ;		// 64
	BOOL isJustBought =	m_ItemBits.GetField(1, "isJustBought") ;	// 65
	if (m_ItemBits.GetField(1)) PrintDebug("U1 != 0") ;						// 66
	m_isInSocket =		m_ItemBits.GetField(1, "isInSocket") ;		// 67
	m_isIdentified =	m_ItemBits.GetField(1, "isIdentified") ;	// 68
	if (m_ItemBits.GetField(1)) PrintDebug("WAS ISETHERAL") ;				// 69
	BOOL isSwitchIn =	m_ItemBits.GetField(1, "isSwitchIn");		// 70
	BOOL isSwitchOut =	m_ItemBits.GetField(1, "isSwitchOut");		// 71
	BOOL isBroken =		m_ItemBits.GetField(1, "isBroken") ;		// 72
	if (m_ItemBits.GetField(1)) PrintDebug("U2 != 0") ;						// 73
//cn
	BOOL PotionX =		m_ItemBits.GetField(1, "PotionX") ;			// 74
	m_isSocketed =		m_ItemBits.GetField(1, "isSocketed") ;		// 75
	if (m_ItemBits.GetField(1)) PrintDebug("U3 != 0") ;						// 76
	BOOL isJustGen =	m_ItemBits.GetField(1, "isJustGen") ;		// 77
// was 1 on Thudergod's Vigor; could have something to do with 1.08 vs 1.09?
//cn - set back to true after the release
	if (m_ItemBits.GetField(2)) PrintDebug("U4 != 0", FALSE) ;				// 78,79
	m_isEar =			m_ItemBits.GetField(1, "isEar") ;			// 80
	BOOL isStartItem =	m_ItemBits.GetField(1, "isStartItem") ;		// 81
	if (m_ItemBits.GetField(3)) PrintDebug("U5 != 0") ;						// 82-84
	m_isMiscItem =		m_ItemBits.GetField(1, "isMiscItem") ;		// 85
	BOOL isEtheral =	m_ItemBits.GetField(1, "isEtheral") ;		// 86
	m_hasMagicStats =	m_ItemBits.GetField(1, "hasMagic") ;		// 87
	m_isPersonalized =	m_ItemBits.GetField(1, "isPersonal") ;		// 88
	BOOL isGamble =		m_ItemBits.GetField(1, "isGamble") ;		// 89
// this could be isRuneWord or something (the first bit)
	m_isRuneWord =		m_ItemBits.GetField(1, "isRuneWord") ;		// 90
	if (m_ItemBits.GetField(5)) PrintDebug("U8 != 0") ;						// 90-95

//cn
//this is now only happening with potions, but not all!?!?!  Has to do with moving them?
	if (PotionX)
		PrintDebug( "PotionX = 1", FALSE) ;

//cn
	// always 0, 1, or 100... no clue why; I used to think this was a "stackable" flag
	//    this is NOT the "version" field found in the MP
	if (m_ItemBits.GetField(10)) PrintDebug("the 0,1,100 field", FALSE) ;
}


void CDiabloItems::ParsePos()
{
	DWORD locationType = m_ItemBits.GetField(3, "locationType");					// 106-108	
//cn-debug
	if ((locationType > POS_INSOCKET) || (locationType == 0x05)) {
		CString sTmp ;
		sTmp.Format("locationType = %X", locationType) ;
		PrintDebug( sTmp) ;
	}


	// on ground or something, not a player's or in a shop
	if ((locationType == POS_GROUND) || (locationType == 5)) {
		DWORD areaX = m_ItemBits.GetField(16, "areaX");								// 109-124
		DWORD areaY = m_ItemBits.GetField(16, "areaY");								// 125-140


	// mine, someone else's, in a socket, or a shop item
	} else {

		m_bBodyCode = m_ItemBits.GetField(4, "m_bBodyCode");				// 109-112
//cn-debug
		if (m_bBodyCode > BODY_SHEILD2) {
			CString sTmp ;
			sTmp.Format("m_bBodyCode = %X", m_bBodyCode) ;
			PrintDebug( sTmp) ;
		}
		m_bPosX = m_ItemBits.GetField(4, "m_bPosX");						// 113-116
		m_bPosY = m_ItemBits.GetField(4, "m_bPosY");						// 117-120
		m_bWhere = m_ItemBits.GetField(3, "m_bWhere");					// 121-123	



//cn-debug
		if ((m_bActionID == MSG_INSTORE) || (m_bActionID == MSG_BOUGHT)) {
			if (m_bWhere > 4) {
				CString sTmp ;
				sTmp.Format("m_bWhere = %X", m_bWhere) ;
				PrintDebug( sTmp) ;
			}
		} else if (!((m_bWhere == ITEM_WEARING) || (m_bWhere == ITEM_INV) || (m_bWhere == ITEM_CUBE) || (m_bWhere == ITEM_STASH))) {
			CString sTmp ;
			sTmp.Format("m_bWhere = %X", m_bWhere) ;
			PrintDebug( sTmp) ;
		}
	}
}


void CDiabloItems::GetBaseItem()
{
	// item code
	DWORD itemcode = m_ItemBits.GetField(32, "itemcode");					// 124-155	// 141-172
	char stmp[5] ;
	sprintf( stmp, "%.4s", &itemcode) ;

	char tmp[80] ;
	sprintf( tmp, "%.4s", &itemcode) ;
	m_sCode = stmp ;
	m_sCode.Remove(' ') ;



	// got the code, now find the item name and other info from the MPQ tables
	BOOL	bGotOne = FALSE ;


	// head, body, shield, necro's preserved heads
	if (( m_bComponent == TYPE_HELM) || ( m_bComponent == TYPE_ARMOR) ||
		( m_bComponent == TYPE_SHIELD) || ( m_bComponent == TYPE_PHEAD)) {
		m_pArmor = GetArmorRec( m_sCode) ;
		bGotOne = m_pArmor != NULL ;

	// any kind of weapon, including thrown potions
	} else if (( m_bComponent == TYPE_WEAPON) || ( m_bComponent == TYPE_BOW)) {
		m_pWeapon = GetWeaponRec( m_sCode) ;
		bGotOne = m_pWeapon != NULL ;

	// belts, boots, gloves (the rest of armors.txt and most of misc.txt)
	} else if (( m_bComponent == TYPE_MISC) && (!m_isMiscItem)) {
		m_pArmor = GetArmorRec( m_sCode) ;
		bGotOne = m_pArmor != NULL ;

	// all the things in misc.txt
	} else {
		m_pMisc = GetMiscRec( m_sCode) ;
		bGotOne = m_pMisc != NULL ;
	}


	// hmmmm... didn't hit above, so do it the hard way; you would think this is not needed,
	//	but sometimes the components are wrong... I've seen shields with TYPE_BOW :(
	if ( !bGotOne) {

		m_pMisc = GetMiscRec( m_sCode) ;
		bGotOne = m_pMisc != NULL ;

		if (!bGotOne) {
			m_pArmor = GetArmorRec( m_sCode) ;
			bGotOne = m_pArmor != NULL ;
		}

		if (!bGotOne) {
			m_pWeapon = GetWeaponRec( m_sCode) ;
			bGotOne = m_pWeapon != NULL ;
		}
	}
}


void CDiabloItems::GetBaseAttributes()
{
	// set some params now that we know what we have

	// armors.txt
	if ( m_pArmor != NULL) {
		m_sBaseName = m_pArmor->m_Name ;
		m_hasDurability = TRUE ;
		m_sFileName.Format("%s.jpg", m_pArmor->m_InvFile) ;
		m_iBottom = m_pArmor->m_InvHeight * PICPOSLEN ;
		m_iRight = m_pArmor->m_InvWidth * PICPOSLEN ;
		if (m_bQuality == QUAL_UNIQUE) {
			if ( m_pArmor->m_UniqueInvFile != "")
				m_sFileName.Format("%s.jpg", m_pArmor->m_UniqueInvFile) ;
		} else if ( m_bQuality == QUAL_SET) {
			if ( m_pArmor->m_SetInvFile != "")
				m_sFileName.Format("%s.jpg", m_pArmor->m_SetInvFile) ;
		}

	// weapons.txt
	} else if (m_pWeapon != NULL) {
		m_sBaseName = m_pWeapon->m_Name ;
		m_isStackable = m_pWeapon->m_Stackable ;
		m_hasDurability = !m_pWeapon->m_NoDurability ;
		m_sFileName.Format("%s.jpg", m_pWeapon->m_InvFile) ;
		m_iBottom = m_pWeapon->m_InvHeight * PICPOSLEN ;
		m_iRight = m_pWeapon->m_InvWidth * PICPOSLEN ;
		if (m_bQuality == QUAL_UNIQUE) {
			if ( m_pWeapon->m_UniqueInvFile != "")
				m_sFileName.Format("%s.jpg", m_pWeapon->m_UniqueInvFile) ;
		} else if ( m_bQuality == QUAL_SET) {
			if ( m_pWeapon->m_SetInvFile != "")
				m_sFileName.Format("%s.jpg", m_pWeapon->m_SetInvFile) ;
		}

	// misc.txt
	} else {
		m_sBaseName = m_pMisc->m_Name ;
		m_isStackable = m_pMisc->m_Stackable ;
		m_sFileName.Format("%s.jpg", m_pMisc->m_InvFile) ;
		m_iBottom = m_pMisc->m_InvHeight * PICPOSLEN ;
		m_iRight = m_pMisc->m_InvWidth * PICPOSLEN ;
	}
}


void CDiabloItems::GetMiscAttributes()
{
	// if it had the misc item flag, it is really a junky misc item or gold
	m_bQuality = 1 ;
	if ( m_sBaseName == "gold") {
		DWORD goldsize = m_ItemBits.GetField(1);
		DWORD goldAmount = m_ItemBits.GetField(goldsize?32:12);
		CString stemp ;
		stemp.Format("%d %s", goldAmount, m_sBaseName) ;
		m_sBaseName = stemp ;
	}

	m_sFileName.Format("%s.jpg", m_pMisc->m_InvFile) ;
}


void CDiabloItems::GetImage()
{
	//always seems to equal 2 for jewlry
	m_ItemBits.GetField(2);
	DWORD image = m_ItemBits.GetField(4, "image");

	// jewlry
	if ((m_sCode == "rin") || (m_sCode == "amu"))
		m_sFileName.Format("%s%d.jpg", m_pMisc->m_InvFile, image+1) ;

	// jewels
	else if (m_sCode == "jew")
		m_sFileName.Format("invjw%d.jpg", image+1) ;

	// for charms, need to do a little math to get the right pic
	else if (m_sCode.Left(2) == "cm") {
		int i = atoi( m_sCode.Right(1)) ;
		i += (3*image) ;
		m_sFileName.Format("invch%d.jpg", i) ;

	// everything else (shouldn't happen)
	} else
		m_sFileName.Format("%s.jpg", m_pMisc->m_InvFile) ;
}


void CDiabloItems::GetInferiorAttributes()
{
	// find out just how crappy it is!
	DWORD	iQualityType = m_ItemBits.GetField(3, "iQualityType") ;			// 170-172	// 187-189
	switch (iQualityType) {
	case 0: m_sBaseName = "Crude " + m_sBaseName ; break ;
	case 1: m_sBaseName = "Cracked " + m_sBaseName ; break ;
	case 2: m_sBaseName = "Damaged " + m_sBaseName ; break ;
	case 3: m_sBaseName = "Low Quality " + m_sBaseName ; break ;
	}
}


void CDiabloItems::GetSuperiorAttributes()
{
	// what special stuff will this superior do? - doesn't really matter - we'll find out
	//	from the magical itemstatid's later in the record
	DWORD	iQualityType = m_ItemBits.GetField(3, "iQualityType") ;			// 170-172	// 187-189
	m_sBaseName = "Superior " + m_sBaseName ;
}


void CDiabloItems::GetMagicAttributes()
{
	// get the prefix
	DWORD	iPrefix = m_ItemBits.GetField(11, "iPrefix") ;			// 170-172	// 187-189

	// if there is a prefix, do it up!
	if (iPrefix > 0) {
		// not sure why this is, but I've seen it on several items
		if (iPrefix == 601) {
			iPrefix = 75 ;		// the prefix Crimson
		}


		// prevent further errors if the affix is fuxored
		CString	stmp ;
		if (iPrefix > 600) {
			PrintDebug("PREFIX LIMIT") ;
			stmp.Format("???????? %s", m_sBaseName) ;

		} else {
			stmp.Format("%s %s", gMagicPrefix[ iPrefix-1].m_Name, m_sBaseName) ;
		}

		m_sBaseName = stmp ;
	}


	// get the suffix
	DWORD	iSuffix = m_ItemBits.GetField(11, "iSuffix") ;			// 170-172	// 187-189


	// if there is a suffix, do it up!
	if (iSuffix > 0) {
		// not sure why this is, but I've seen it on one item
		if (iSuffix == 688) {
			iSuffix = 51 ;		// of Pestilence
		} else if ( iSuffix == 722) {
			iSuffix = 32 ;		// of Shock
		} else if ( iSuffix == 734) {
			iSuffix = 161 ;		// of Thorns
		} else if ( iSuffix == 732) {
			iSuffix = 105 ;
		}
		CString	stmp ;

		// prevent further errors if the affix is fuxored
		if (iSuffix > 675) {
			PrintDebug("SUFFIX LIMIT") ;
			stmp.Format("%s of ????????", m_sBaseName) ;

		} else {
			stmp.Format("%s %s", m_sBaseName, gMagicSuffix[ iSuffix-1].m_Name) ;
		}
		m_sBaseName = stmp ;
	}
}




void CDiabloItems::GetSetAttributes()
{
	CSetItems*	pSetItem = GetSetItemRec( m_sCode) ;
	m_sSpecialName = pSetItem->m_Name ;

	DWORD	iSetID = m_ItemBits.GetField(12, "SetID") ;
}


void CDiabloItems::GetRareAttributes()
{

/*
Here's how this works.  A rare can have up to 6 modifiers (some mods have multiple params).
  Actually it has slots for 3 prefixes and 3 suffixes wired into the rec.  We alternate
  looking for a prefix and then a suffix.  Preceeding the affix is a single bit and if =1
  then that means the next 11 bits will be the affix.  If =0 then skip this affix.  I
  think that even if we hit the last affix we need to keep alternating until all 6 slots
  have been looked at.
*/

	int iPrefixName = m_ItemBits.GetField(8, "Rare Prefix") -155 ;
	int iSuffixName = m_ItemBits.GetField(8, "Rare Suffix") ;

	CString sTmp ;
	sTmp.Format("%s %s", gRarePrefix[ iPrefixName], gRareSuffix[ iSuffixName]) ;
	m_sSpecialName = sTmp ;



	BOOL bGetPrefix = TRUE ;
	for (int i=0; i<6; i++) {
		// let's see if we are out of the affix who's turn it is
		BOOL bGetNext = m_ItemBits.GetField(1, "bDoGetNext") ;
		if (bGetNext) {
			// out of prefixes
			if (bGetPrefix) {
				int iPrefix = m_ItemBits.GetField(11, "Prefix") ;
				// not sure why this is, but I've seen it on several items
				if (iPrefix == 601) {
					iPrefix = 75 ;		// the prefix Crimson

				// saftey precaution
				} else if (iPrefix > 600) {
//cn - consider putting this back to true!
					PrintDebug("PREFIX LIMIT in GetRareAttributes", FALSE) ;
				}

			// out of suffixes
			} else {
				int iSuffix = m_ItemBits.GetField(11, "Suffix") ;
				// not sure why this is, but I've seen it on one item
				if (iSuffix == 688) {
					iSuffix = 51 ;		// the suffix of Pestilence

				// saftey precaution
				} else if (iSuffix > 675) {
//cn - consider putting this back to true!
					PrintDebug("SUFFIX LIMIT in GetRareAttributes", FALSE) ;
				}
			}
		}

		// change the toggle to the other affix
		bGetPrefix = !bGetPrefix ;
	}
}


void CDiabloItems::GetUniqueAttributes()
{
	CUnique*	pUnique = GetUniqueRec( m_sCode) ;
	m_sSpecialName = pUnique->m_Name ;

	DWORD	iUniqueID = m_ItemBits.GetField(12, "UniqueID") ;
}




void CDiabloItems::GetMagicValues()
{
	DWORD iStatID = 0 ;

	// loop through all the stats until we hit the end
	while (iStatID != 0x1FF) {
		// make sure we don't get more bits then the length of the message
		if ((m_ItemBits.m_Pos/8)+9 > m_bMessageLen) {
			PrintDebug("pre-empt m_bMessageLen exceeded") ;
			break ;
		}

		// get the next stat
		iStatID = m_ItemBits.GetField( STATID_BITLENGTH, "StatID") ;
		// this is the normal exit point
		if (iStatID == 0x1FF) {
			break ;

		// make sure this isn't some garbage number
		} else if (iStatID > NUM_STATIDS) {
			PrintDebug("STATID VAL LIMIT") ;
			break ;
		}


//cn-WTF???
//
// poison damage looks wrong
//


		BOOL	bDone = FALSE ;
		while (!bDone) {

			// get the number of bits we need for the param value
			int iNumBits = gMagicStats[ iStatID].m_SaveBits ;


			// adjust the number of bits for special cases
			if ( gMagicStats[ iStatID].m_SaveAdd == 20) {
//cn-debug
CString sTmp ;
sTmp.Format("SaveAdd = 20; iNumBits=%d", iNumBits) ;
if (iNumBits >= 8) PrintDebug( sTmp, FALSE) ;


				// #110 (p len) it does NOT need an extra bit; also for #75 (max dur%),
				//   #119 (ac%), #121 (demon dam%), #122 (undead dam%), #1 (+energy),
				//   #154 (stam dr)
				if ((iStatID != 110) && (iStatID != 75) && (iStatID != 119) && 
					(iStatID != 121) && (iStatID != 122) && (iStatID != 1)  && 
					(iStatID != 154))
					iNumBits++ ;

			// i've only tested this on one item, so not sure
			} else if ( gMagicStats[ iStatID].m_SaveAdd == 10) {
//cn-debug
CString sTmp ;
sTmp.Format("SaveAdd = 10; iNumBits=%d", iNumBits) ;
if (iNumBits >= 8) PrintDebug( sTmp, FALSE) ;

				// statid #31 (AC%) does NOT need an extra bit; #77 (mana%);
				if ((iStatID != 31) && (iStatID != 77))
					iNumBits++ ;
			}

			// if its the secondary min/max then recalculate the number of bits to get
			if (( iStatID == STATS_SECONDARY_MINDAMAGE) || ( iStatID == STATS_SECONDARY_MAXDAMAGE))
				iNumBits = 1+ gMagicStats[ iStatID].m_SaveBits ;

			// get the value of the param
			int iMod = m_ItemBits.GetField( iNumBits, "Mod Value") ;

			// adjust the value by the SaveAdd vield
			if (( gMagicStats[ iStatID].m_SaveAdd == 20) && (iMod > 100))
				iMod -= 100 ;
//			else if (( gMagicStats[ iStatID].m_SaveAdd == 10) && (iMod > 30))
//				iMod -= 30 ;
			else {
				iMod -= gMagicStats[ iStatID].m_SaveAdd ;
if (( gMagicStats[ iStatID].m_SaveAdd == 10) && (iMod > 30) && (iMod > 54))
PrintDebug("saveadd = 10 and iMod > 30", FALSE) ;
			}


			// get extra mod value for damage if needed
			if (( iStatID ==17) || ( iStatID ==18))
				iMod= m_ItemBits.GetField( DMGPERCENT_BITLENGTH, "Damage Val") ;

			// set the value for repair durability
			else if (iStatID == 252)
				iMod *= 11 ;
				

			char tempDesc[100] ;
			sprintf( tempDesc, gMagicStats[ iStatID].m_Desc, iMod) ;
			m_ModDesc[m_iNumModDesc] = tempDesc ;
			m_iNumModDesc++ ;

			// mods with multiple params (like cold and pois damage)
			if ((iStatID==48) || (iStatID==50) || (iStatID==52) || (iStatID==54) || 
				(iStatID==55) || (iStatID==57) || (iStatID==58))
				iStatID++ ;
			else
				bDone = TRUE ;
		}
	}
}




BOOL CDiabloItems::GetDurability()
{
	// durability and sockets
	m_iDurabilityMax = m_ItemBits.GetField(8, "m_iDurMax") ;
	// if the Max is 0, then the item is indestructable
	if ( m_iDurabilityMax == 0) {
		m_iDurabilityCur = 0 ;
		return TRUE ;
	}
	m_iDurabilityCur = m_ItemBits.GetField(8, "m_iDurCur") ;
	return FALSE ;
}


void CDiabloItems::PrintEarInfo()
{
	// get the class
	DWORD placlass = m_ItemBits.GetField(3, "Pclass");
	CString sClass ;
	switch (placlass) {
	case 0: sClass = "Amazon" ; break ;
	case 1: sClass = "Sorceress" ; break ;
	case 2: sClass = "Necromancer" ; break ;
	case 3: sClass = "Paladin" ; break ;
	case 4: sClass = "Barbarian" ; break ;
	case 5: sClass = "Druid" ; break ;
	case 6: sClass = "Assassin" ; break ;
	default:
		sClass.Format("CLASS = %d", placlass) ;
		PrintDebug( sClass) ;
		break ;
	}

	// get the level
	DWORD plalevel = m_ItemBits.GetField(7, "Plevel");
	CString sLevel ;
	sLevel.Format("Level %d", plalevel) ;

	// get the player name
	DWORD ch;
	while (ch = m_ItemBits.GetField(7,"char")) m_sItemName += (char)ch ;
	m_sItemName = m_sItemName + "'s Ear" ;
	m_sFileName = "invear.jpg" ;


	// print all the good stuff
	//

	AddInfoLine( m_sItemName, 1) ;
	AddInfoLine( sClass, 1) ;
	AddInfoLine( sLevel, 1) ;
}


void CDiabloItems::LoadItemAttributes( const unsigned char *msg)
{
//	m_sPacketMsg = msg ;
	int	iMessageLen = msg[ 2] ;
	for (int count=0; count<iMessageLen; count++)
		m_sPacketMsg[count] = msg[count] ;


	// these are the bytes common to 9D and 9C and are byte level accessable
	CommonByteParsing() ;


	// prepare to parse the bitfields which comprise the remaining bits;  need to exclude
	//	  5 extra bytes if it is a 9D message, still no idea why they did that
	m_ItemBits.m_Data = ((unsigned char*)msg+(( m_bMessageID == 0x9C)?8:13));


	// parse the on/off flags which are the first 32 bits
	ParseFlags() ;


	// parse the XY coordinates of where ever this item exists
	ParsePos() ;

	// get the specifics of the base item
	if (m_isEar) {
		m_bQuality = 1 ;
		m_sCode = "ear" ;
	} else
		GetBaseItem() ;



	if (m_isEar) {
		// do nothing

	} else if (m_isMiscItem) {
		GetMiscAttributes() ;
		GetBaseAttributes() ;

	} else {
		m_iUsedSockets = m_ItemBits.GetField(3, "usedSockets") ;		// 156-158	// 173-175
		DWORD level = m_ItemBits.GetField(7, "level");					// 159-165	// 176-182
		m_bQuality = m_ItemBits.GetField(3, "m_bQuality");				// 166-169	// 183-186

		GetBaseAttributes() ;

		// get the magic for rings, amulets, jewels, and charms
		if (((m_sCode == "rin") || (m_sCode == "amu") || (m_sCode == "jew") ||
			(m_sCode.Left(2) == "cm"))) {
			GetImage() ;

		} else {

//CN CLASS SPECIFIC STILL NEEDS HELP - WHAT THE HELL IS IT???


			int isClassSpecific = m_ItemBits.GetField(3, "isClassSpec") ;
			if (isClassSpecific == 4) {
				m_ItemBits.GetField(11, "CLASS SPEC??") ;
PrintDebug("Class Specific", FALSE) ;

			} else if (isClassSpecific) {
PrintDebug("CLASS SPECIFIC <> 0", FALSE) ;
			}
		}

		// if the item is identified, get the magic info
		if (m_isIdentified) {
			switch (m_bQuality) {
			case QUAL_CRAFTED:	GetRareAttributes(); break ;
			case QUAL_INFERIOR:	GetInferiorAttributes(); break ;
			case QUAL_NORMAL:	break ;
			case QUAL_SUPERIOR:	GetSuperiorAttributes(); break ;
			case QUAL_MAGIC:	GetMagicAttributes(); break ;
			case QUAL_SET:		GetSetAttributes(); break ;
			case QUAL_RARE:		GetRareAttributes(); break ;
			case QUAL_UNIQUE:	GetUniqueAttributes(); break ;
			default:
				break ;
			}
		}

//cn-note sure how to make sense of this though :(
		// get the rune word
		if ( m_isRuneWord) {
			int	iRunePrefix = m_ItemBits.GetField(8, "iRunePrefix") ;
			int	iRuneSuffix = m_ItemBits.GetField(8, "iRuneSuffix") ;
		}


		// if the item is personalized, then get the name
		if ( m_isPersonalized) {
			char	charTmp = 1 ;
			CString	sPersonalized ;
			while (charTmp != 0) {
				charTmp = (char)m_ItemBits.GetField( 7, "p name") ;
				if ( charTmp > 0)
					sPersonalized += charTmp ;
			}
			sPersonalized += "'s " ;
			if ( m_sSpecialName != "")
				m_sSpecialName = sPersonalized + m_sSpecialName ;
			else
				m_sItemName = sPersonalized + m_sItemName ;
		}


		// for armor, get the defense
		if ( m_pArmor != NULL)
			m_iDefense = m_ItemBits.GetField(10, "Armor") - 10 ;


		// if the item is stackable, get the quantity
		if ( m_isStackable) {
			// for some reason, tombs have additional bits??
			if ((m_sBaseName == "Town Portal Book") || (m_sBaseName == "Identify Book")) {
				// i have seen this be 1 on a ident book
				if (m_ItemBits.GetField(5)) PrintDebug("U9-2 ! 0", FALSE) ;					// 173-175	// 190-192

//cn		// weapons have an extra 16 bits here, throwing damage????
			} else if ( m_pWeapon != NULL) {
				DWORD	iThrowMin = m_ItemBits.GetField(8, "Throw 1??") ;
				DWORD	iThrowMax = m_ItemBits.GetField(8, "Throw 2??") ;
			}

			m_iQuantity = m_ItemBits.GetField(9, "quantity") ;


		// grab the durability
		} else if (m_hasDurability)
			m_isIndestructable = GetDurability() ;


		// if the hasMagicStats field is set, then go get 'em!
		if (m_hasMagicStats) {

			// something to do with bows, but I have no idea what
			if ((m_pMisc==NULL) && (!m_hasDurability)) {
				m_ItemBits.GetField(8, "BOW 1??");
				m_ItemBits.GetField(8, "BOW 2??");
			}

			if ( m_bQuality == QUAL_SET)
				int	iNumInSet = m_ItemBits.GetField(5, "NumInSet") ;


// cn I DON'T SEE ANYTHING AFTER DOING SOCKET QUEST THAT PREVENTS DOING IT AGAIN
			if ( m_isSocketed)
				m_iNumSockets = m_ItemBits.GetField(4, "iSockets") ;

//cn no clue what the hell this is either!!
			if ( m_sBaseName == "Superior Bone Shield") {
				m_ItemBits.GetField(8, "GRIM 1");
				m_ItemBits.GetField(8, "GRIM 2");
			}

//cn note sure what the hell this is, should be 0x1FF
			if ( m_isRuneWord)
				m_ItemBits.GetField(9, "RuneDivider") ;

			// get the magical attributes
			if ( m_isIdentified)
				GetMagicValues() ;

//cn NEED FURTHER PARSING TO SEE IF WE ARE INTO THE LAST BYTE (BONUS MODS ON SETS?)
		}
	}



//cn - debug
if (m_bQuality > QUAL_UNIQUE) PrintDebug("m_bQuality > QUAL_UNIQUE") ;

	// get the coordinates for the graphic to display on screen
	CPoint point = getCoordinates() ;
	m_iTop = point.y ;
	m_iLeft = point.x ;
	m_iBottom += point.y  ;
	m_iRight += point.x ;


	if ( m_sSpecialName != "") {
		m_sItemName = m_sSpecialName ;
		AddInfoLine( m_sSpecialName, m_bQuality) ;
	} else {
		m_sItemName = m_sBaseName ;
	}


	if (m_isEar)
		PrintEarInfo() ;

	// item name
	else
		AddInfoLine( m_sBaseName, m_bQuality) ;



//cn need to figure this out ;-)
	if ( m_isRuneWord)
		AddInfoLine( "Rune Word", 7) ;


	CString stmp ;

	// defense
	if ( m_iDefense > 0) {
		stmp.Format("Defense: %d", m_iDefense) ;
		AddInfoLine( stmp, 1) ;
	}


	// print the damage stats
	if ( m_pWeapon != NULL) {
		// throw damage
		if ( m_pWeapon->m_Stackable) {
			stmp.Format("Throw Damage: %d to %d", m_pWeapon->m_MinMisDam, m_pWeapon->m_MaxMisDam) ;
			AddInfoLine( stmp, 1) ;
		}

		// one-handed
		if (( m_pWeapon->m_1or2Handed) || (!m_pWeapon->m_2Handed)) {
			stmp.Format("One-Handed Damage: %d to %d", m_pWeapon->m_MinDam, m_pWeapon->m_MaxDam) ;
			AddInfoLine( stmp, 1) ;
		}

		// two-handed
		if ( m_pWeapon->m_2Handed) {
			stmp.Format("Two-Handed Damage: %d to %d", m_pWeapon->m_2HandMinDam, m_pWeapon->m_2HandMaxDam) ;
			AddInfoLine( stmp, 1) ;
		}
	}


	// print the blocking
	if ( m_pArmor != NULL) {
		if ( m_pArmor->m_Block) {
			stmp.Format("Chance to Block: %d%%", m_pArmor->m_Block) ;
			AddInfoLine( stmp, 1) ;
		}
	}

		
	// durability
	if (m_iDurabilityMax > 0) {
		stmp.Format("Durability: %d of %d", m_iDurabilityCur, m_iDurabilityMax) ;
		AddInfoLine( stmp, 1) ;

	// indestructable
	} else if (m_isIndestructable)
		AddInfoLine( "Durability: Indestructable", 1) ;


	// quantity
	if (m_isStackable) {
		stmp.Format("Quantity: %d", m_iQuantity) ;
		AddInfoLine( stmp, 1) ;
	}


	// print the requirements for a weapon
	if ( m_pWeapon != NULL) {
		// dex
		if ( m_pWeapon->m_ReqDex) {
			stmp.Format("Required Dexterity: %d", m_pWeapon->m_ReqDex) ;
			AddInfoLine( stmp, 1) ;
		}

		// strength
		if ( m_pWeapon->m_ReqStr) {
			stmp.Format("Required Strength: %d", m_pWeapon->m_ReqStr) ;
			AddInfoLine( stmp, 1) ;
		}

/*
		// level
		if ( m_pWeapon->m_Level) {
			stmp.Format("Required Level: %d", m_pWeapon->m_Level) ;
			AddInfoLine( stmp, 1) ;
		}

		stmp.Format("%s Class - %d Attack Speed", m_pWeapon->m_WClass, m_pWeapon->m_Speed) ;
		AddInfoLine( stmp, 1) ;
*/

	// print the requirements for an armor
	} else if ( m_pArmor != NULL) {
		// strength
		if ( m_pArmor->m_ReqStr) {
			stmp.Format("Required Strength: %d", m_pArmor->m_ReqStr) ;
			AddInfoLine( stmp, 1) ;
		}

/*
		// level
		if ( m_pArmor->m_Level) {
			stmp.Format("Required Level: %d", m_pArmor->m_Level) ;
			AddInfoLine( stmp, 1) ;
		}
*/
	}

	// magical attributes
	for (int i=0; i<m_iNumModDesc; i++)
		AddInfoLine( m_ModDesc[i], 4) ;

//cn i need to see an example of how this is displayed
	if (m_isIndestructable)
		AddInfoLine( "Indestructable", 4) ;

	// num socketed
	if ( m_iNumSockets > 0) {
		stmp.Format("Socketed (%d)", m_iNumSockets) ;
		AddInfoLine( stmp, 4) ;
	}


	// say we are identifed
	if ( !m_isIdentified)
		AddInfoLine( "Unidentified", 9) ;
//cn-remove2
//if ( m_sItemName == "Nagelring")
//DumpDebugInfo() ;
	if (m_bDebug)
		AddInfoLine("PARSE ALERT: report cannot be trusted", 0) ;
}


void CDiabloItems::AddInfoLine( CString sText, int iColor)
{
	COutputLine* newLine = new COutputLine ;
	newLine->m_iColor = iColor ;
	newLine->m_sLine = sText ;
	m_InfoLines.AddTail( newLine) ;
}


void CDiabloItems::DumpDebugInfo()
{
// everyone has got one, and I don't have it right!!!
if (m_sItemName == "Buriza-Do Kyanon")
return ;

	// print the item name
	FILE* fout = fopen("dump.txt", "a") ;
	fprintf( fout, "\n\n%s\n", m_sItemName) ;


//cn - should really dump the info lines too


	// print the hex of the item
	fprintf( fout, "%s\n", PrintItemHex()) ;

	// print the byte range header
	for (int x=0; x<60; x++)
		fprintf( fout, " ") ;
	for (x=51; x>=8; x--)
		fprintf( fout, "[--%2d--]", x) ;
	fprintf( fout, "\n") ;

	// print binary of the entire msg (from the juicy part forward) where 9D and 9C 
	//     are identical
	for (x=0; x<60; x++)
		fprintf( fout, " ") ;
	fprintf( fout, "%s\n", BytesToString( m_sPacketMsg, (m_bMessageID==0x9C)?8:13, m_bMessageLen-1, (m_bMessageID==0x9C)?TRUE:FALSE)) ;

	// print the bitfield debug lines
	for( POSITION pos = m_ItemBits.m_sDebugLines.GetHeadPosition(); pos != NULL; )
		fprintf( fout, "%s\n", m_ItemBits.m_sDebugLines.GetNext(pos)) ;

	// print the reason this debug was triggered
	fprintf( fout, "DEBUG TRIGGERS:\n") ;
	for( pos = m_sDebugTriggers.GetHeadPosition(); pos != NULL; )
		fprintf( fout, "      %s\n", m_sDebugTriggers.GetNext(pos)) ;

	fclose(fout) ;
}



// we know we have an item, let's get the attributes
CDiabloItems* parseItem( const unsigned char *pkt_data)
{
	// its an item, so make a new one and load the attributes
	CDiabloItems* newItem = new CDiabloItems ;
	newItem->LoadItemAttributes( pkt_data) ;

//cn
	newItem->m_iOwnerType = ITEMOWNER_PLAYER ;

	return newItem ;
}
