// DlgTree.cpp : implementation file
//

#include "stdafx.h"
#include "PKTK.h"

#include "DiabloItems.h"
#include "DiabloCharacters.h"

#include "DlgTree.h"
#include "MyGUI.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgTree dialog


CDlgTree::CDlgTree(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgTree::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgTree)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_bStopped = FALSE ;
	m_iLoadData = -1 ;
	m_iTmpLoadData = -1 ;
}

CDlgTree::~CDlgTree()
{
	// free all the memory that we didn't add to the Document Character list
	m_Players.RemoveAllCharacters( FALSE) ;
}

void CDlgTree::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgTree)
	DDX_Control(pDX, IDC_TREELIST, m_TreeList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgTree, CDialog)
	//{{AFX_MSG_MAP(CDlgTree)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_LOAD, OnLoad)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREELIST, OnSelChangedTreeList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgTree message handlers


void CDlgTree::SortByQuality( CDiabloCharacters* pChar, HTREEITEM hSub, int iQuality, int recordID)
{
	BOOL		bFirst = TRUE ;
	HTREEITEM	hHeader ;
	char		sQuality[20] ;
	BOOL		bNormal = FALSE ;

	// get the quality name
	switch (iQuality) {
	case QUAL_CRAFTED:	strcpy( sQuality, "Crafted") ; break ;
	case QUAL_UNIQUE:	strcpy( sQuality, "Unique") ; break ;
	case QUAL_RARE:		strcpy( sQuality, "Rare") ; break ;
	case QUAL_SET:		strcpy( sQuality, "Set") ; break ;
	case QUAL_MAGIC:	strcpy( sQuality, "Magic") ; break ;
	default: strcpy( sQuality, "Sup/Norm/Inf") ;
			bNormal = TRUE ;
			break ;
	}

	// if we have images going on top of the background, draw them
	for( POSITION posItem = pChar->m_ItemList.GetHeadPosition(); posItem != NULL;) {
		// get the item and the next pos
		CDiabloItems* pItem = ( CDiabloItems*)pChar->m_ItemList.GetNext(posItem);
		// if we're looking for normal or have a quality match
		if (((bNormal) && ( pItem->m_bQuality < QUAL_MAGIC)) ||
			( (int)pItem->m_bQuality == iQuality)) {

			// add the quality header
			if ( bFirst) {
				// add an entry for the item into our tree
				tvinsert.item.pszText = sQuality ;
				tvinsert.item.lParam = recordID ;
				tvinsert.item.iImage = 0 ;
				tvinsert.item.iSelectedImage = 0 ;
				tvinsert.hParent = hSub ;
				hHeader = m_TreeList.InsertItem( &tvinsert) ;
				bFirst = FALSE ;
			}


			// add an entry for the item into our tree
			char	caption[100] ;
			strcpy( caption, pItem->m_sItemName) ;
			tvinsert.item.pszText = caption ;
			tvinsert.item.lParam = recordID ;
			tvinsert.item.iImage = 0 ;
			tvinsert.item.iSelectedImage = 0 ;
			tvinsert.hParent = hHeader ;
			m_TreeList.InsertItem( &tvinsert) ;
		}
	}
}


// open the file and get the player and item data
void CDlgTree::ItemsInsert(int recordID, HTREEITEM hSub, CString sFileName)
{
	char			sData[300] ;
	unsigned char	iData[100] ;
	CDiabloCharacters* newCharacter = NULL ;

	// loop through the lines of the specified file and get the item data
	CString sFileNameFull ;
	sFileNameFull.Format("%s.inv", sFileName) ;
	FILE* fPlayer = fopen( sFileNameFull, "r") ;
	while (!feof( fPlayer)) {
		// get the line, end looping if eof
		fgets( sData, 300, fPlayer) ;
		if ( feof( fPlayer)) break ;


		// get the number of bytes for the data line
		int iLen ;
		if ( (sData[0] == '5') && (sData[1] == '9'))
			iLen = 26 ;
		else
			iLen = (charToHex( sData[6]) * 16) + charToHex( sData[7]) ;

		// convert the ascii to hex so we can use the data
		for ( int i=0; i<iLen; i++)
			iData[i] = (charToHex( sData[i*3]) * 16) + charToHex( sData[i*3 +1]) ;



		// if a player record, add a new player
		if ( (sData[0] == '5') && (sData[1] == '9')) {
			newCharacter = new CDiabloCharacters( iData) ;

			// add the new character data
			m_Players.AddCharacter( newCharacter) ;
			m_Players.m_iCharCount++ ;

		// if it is an item record, add it to the current player rec
		} else if ( newCharacter != NULL) {
			CDiabloItems*	newItem = parseItem( iData) ;

			// can't use FindOwnerMatch b/c we'll have entries with duplicate playerid's 
			newCharacter->m_ItemList.AddTail( newItem) ;

			// print debug info
			if ( newItem->m_bDebug) {
				newCharacter->PrintCharacter() ;
				newItem->DumpDebugInfo() ;
			}
		}
	}
	fclose( fPlayer) ;

	SortByQuality( newCharacter, hSub, QUAL_CRAFTED, recordID) ;
	SortByQuality( newCharacter, hSub, QUAL_UNIQUE, recordID) ;
	SortByQuality( newCharacter, hSub, QUAL_RARE, recordID) ;
	SortByQuality( newCharacter, hSub, QUAL_SET, recordID) ;
	SortByQuality( newCharacter, hSub, QUAL_MAGIC, recordID) ;
	SortByQuality( newCharacter, hSub, QUAL_NORMAL, recordID) ;
}


BOOL CDlgTree::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here


	// Inserts the items into the tree
/*	
	// insert the icons for the tree
	CImageList* pImageList = new CImageList();
	pImageList->Create( 16, 16, TRUE, 0, 6) ;

	CBitmap bitmap;
	bitmap.LoadBitmap(IDB_BMP1);
m_pImageList->Add(pApp->LoadIcon(IDI_ICONLIST1));
	pImageList->Add( &bitmap, (COLORREF)0xFFFFFF);
	bitmap.DeleteObject();

	bitmap.LoadBitmap(IDB_BMP2);
	pImageList->Add( &bitmap, (COLORREF)0xFFFFFF);
	bitmap.DeleteObject();

	bitmap.LoadBitmap(IDB_BMP3);
	pImageList->Add( &bitmap, (COLORREF)0xFFFFFF);
	bitmap.DeleteObject();

	bitmap.LoadBitmap(IDB_BMP4);
	pImageList->Add( &bitmap, (COLORREF)0xFFFFFF);
	bitmap.DeleteObject();

	bitmap.LoadBitmap(IDB_BMP5);
	pImageList->Add( &bitmap, (COLORREF)0xFFFFFF);
	bitmap.DeleteObject();

	bitmap.LoadBitmap(IDB_BMP6);
	pImageList->Add( &bitmap, (COLORREF)0xFFFFFF);
	bitmap.DeleteObject();

	m_Debug.SetImageList( pImageList, TVSIL_NORMAL) ;
*/

	// construct the tree
	// tree structure common values
	tvinsert.hParent = NULL ;
	tvinsert.hInsertAfter = TVI_LAST ;
	tvinsert.item.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_TEXT | TVIF_PARAM;
	tvinsert.item.hItem = NULL ;
	tvinsert.item.state = 0 ;
	tvinsert.item.stateMask = 0 ;
	tvinsert.item.cchTextMax = 6 ;
	tvinsert.item.iSelectedImage = 3 ;
	tvinsert.item.cChildren = 0 ;
	tvinsert.item.lParam = 0 ;


	HTREEITEM	hSub = NULL ;
	int			loop = 0 ;
	FILE*		findex = fopen("index.inv", "r") ;


	// failed to open, so we don't have any character to display
	if ( findex == NULL) {
		tvinsert.item.pszText = "No characters saved" ;
		// set to -1 so the ViewInvMan won't try to load a character
		tvinsert.item.lParam =  -1 ;
		tvinsert.item.iImage = 0 ;
		tvinsert.item.iSelectedImage = 0 ;
		tvinsert.hParent = NULL ;
		m_TreeList.InsertItem( &tvinsert) ;
		return TRUE ;
	}


	// loop through the index, getting the file names, and then get the item info
	char sFileName[80] ;
	int iNumPlayers = 0 ;
	while ( !feof( findex)) {
		fgets( sFileName, 80, findex) ;
		if ( feof(findex)) break ;
		CString stmp = sFileName ;
		sprintf(sFileName, "%s", stmp.Left( stmp.GetLength() -1)) ;

		// add the index line to our list
		tvinsert.item.pszText = sFileName ;
		tvinsert.item.lParam =  iNumPlayers ;
		tvinsert.item.iImage = 0 ;
		tvinsert.item.iSelectedImage = 0 ;
		tvinsert.hParent = NULL ;
		hSub = m_TreeList.InsertItem( &tvinsert) ;

		// insert the items
		ItemsInsert( iNumPlayers, hSub, stmp.Left( stmp.GetLength() -1)) ;
		iNumPlayers++ ;
	}
	fclose( findex) ;


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgTree::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	m_bStopped = TRUE ;

	CDialog::OnClose();
}

void CDlgTree::OnOK() 
{
	// TODO: Add extra validation here
	
	m_bStopped = TRUE ;

	CDialog::OnOK();
}

void CDlgTree::OnLoad() 
{
	// TODO: Add your control notification handler code here
	
	m_iLoadData = m_iTmpLoadData ;
	m_iTmpLoadData = -1 ;

	OnOK() ;
}

void CDlgTree::OnSelChangedTreeList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	

	m_iTmpLoadData = pNMTreeView->itemNew.lParam ;

	*pResult = 0;
}
