// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "PKTK.h"
#include "PKTKDoc.h"
#include "PKTKView.h"
#include "ViewD2Spy.h"
#include "ViewInvMan.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_COPYDATA()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
	m_diablo2_ph = 0 ;
	m_iTimerCount = 0 ;
	m_DLL_Loaded = FALSE ;
}


CMainFrame::~CMainFrame()
{
	// if the game is still running, then unload the hack
	m_diablo2_ph = GetProcessHandle("Diablo II", "Diablo II") ;
	if (m_diablo2_ph)
		MessagesHackStop( m_diablo2_ph) ;
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	SetTimer( 5301, 50, NULL) ;
//	SetTitle("Looking for Game") ;
//	ShowWindow( SW_SHOWMAXIMIZED) ;
//	MoveWindow( 0, 0, 757, 710) ;

	return 0;
}


BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT /*lpcs*/,
	CCreateContext* pContext)
{
	// create the splitter
	VERIFY( m_wndSplitter.CreateStatic( this, 1, 2)) ;

	// create the views that go into the splitter
	VERIFY( m_wndSplitter.CreateView( 0, 0, RUNTIME_CLASS(CPKTKView3),  CSize(100,0), pContext)) ;
	VERIFY( m_wndSplitter.CreateView( 0, 1, RUNTIME_CLASS(CViewD2Spy), CSize(0,0), pContext)) ;
//	VERIFY( m_wndSplitter.CreateView( 0, 1, RUNTIME_CLASS(CViewInvMan), CSize(0,0), pContext)) ;
	m_wndSplitter.SetActivePane( 0, 1 ) ;

	return TRUE ;
}


BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


// w00t!  This was my own idea and it seems to work just fine.  Display a new view in the
//	second pane of the window
void CMainFrame::SwitchToView( int nView)
{
	// out with the old...
	m_wndSplitter.DeleteView(0,1) ;

	// ...and in with the new
	if (nView == 1)
		VERIFY( m_wndSplitter.CreateView( 0, 1, RUNTIME_CLASS(CViewD2Spy),  CSize(0,0), NULL)) ;
	else if (nView == 2)
		VERIFY( m_wndSplitter.CreateView( 0, 1, RUNTIME_CLASS(CViewInvMan),  CSize(0,0), NULL)) ;

	// reset
	m_wndSplitter.RecalcLayout() ;
	m_wndSplitter.SetActivePane( 0, 1 ) ;
}


// I need the View class to be able to call SwitchToView; the View can access the document
//	and the MainFrame can access the document also.  Therefore, if I tell the document about
//	the frame, then the view can access the frame as well... got all that? ;-)
CDocument* CMainFrame::GetActiveDocument() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	// if we have an active document, then let it know about the mainframe
	CPKTKDoc*	pDoc = (CPKTKDoc*)CFrameWnd::GetActiveDocument();
	if ( pDoc)
		pDoc->m_pMainFrame = this ;

	return pDoc ;
}


// this override snags the Messages from Mousepad's interceptor code; he intercepts the
//	messages from within D2 and then tells our program about it via WM_COPYDATA messages
BOOL CMainFrame::OnCopyData(CWnd* pWnd, COPYDATASTRUCT* pCopyDataStruct) 
{
	// TODO: Add your message handler code here and/or call default
	
	BYTE msg[500];
	memcpy( &msg, (const unsigned char*)pCopyDataStruct->lpData, pCopyDataStruct->cbData);
	CPKTKDoc*	pDoc = (CPKTKDoc*)CFrameWnd::GetActiveDocument();

	if (msg[0] == CHAR_FLAG) {
		pDoc->ParsePlayer( msg) ;
	} else if ((msg[0]==0x9C) || (msg[0]==0x9D)) {
//		if ((msg[1]==0x06) || (msg[1]==0x13)) {
			pDoc->ParseItem( msg) ;
//		}
	}

	
	return CFrameWnd::OnCopyData(pWnd, pCopyDataStruct);
}


void CMainFrame::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	// if the dll hasn't be loaded, check again; the intention here is so that users
	//	can hit the "start" button in the D2 chat room and not have to enter a game first to
	//	load the DLL - this way we can view their items as they enter the game too
	if ( !m_DLL_Loaded) {

		// if it's been loaded, then start the reader thread and toggle so we don't come back here

		// need to have the game running!
		if (m_diablo2_ph == 0) {
			m_diablo2_ph = GetProcessHandle("Diablo II", "Diablo II") ;
			if (m_diablo2_ph == 0) {
				return ;
			}
		}
		if (ReadProcessDWORD(m_diablo2_ph, 0x6FAB43EA) != 0) {

			// modify the dll in memory and insert our intercept code
			MessagesHackStart( this->m_hWnd, m_diablo2_ph) ;


			m_DLL_Loaded = TRUE ;

			CPKTKDoc*	pDoc = (CPKTKDoc*)CFrameWnd::GetActiveDocument();
			pDoc->m_bNotStartedYet = FALSE ;
			Invalidate( TRUE) ;
		} else
			return ;
	}

	
	CFrameWnd::OnTimer(nIDEvent);
}
