// MyGUI.cpp: implementation of the CInfoBox class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PKTK.h"
#include "MyGUI.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// CInfoBox class.

CInfoBox::CInfoBox()
{
	//init the values
	m_bInfoOnly = FALSE ;
	m_iInfoLinesPID = -1 ;
	m_iInfoLinesItemID = -1 ;
}

CInfoBox::~CInfoBox()
{
	// clean up our memory!!!
	RemoveLines() ;
}


// delete all the info lines and free up memory
void CInfoBox::RemoveLines()
{
	// delete all the memory taken up by the messages
	while(!m_Lines.IsEmpty()) {
		COutputLine* pInfo = (COutputLine*)m_Lines.RemoveHead();
		delete pInfo ;
	}
}


void CInfoBox::Display( CPaintDC* pDC, int iLeft, int iTop, BOOL haveChar)
{
	// create our text areas
	pDC->FillSolidRect( CRect(iLeft,iTop,iLeft+300,iTop+330), RGB(0,0,0)) ;

	// set the font and print the message; different font for char name
	CFont	font ;
	font.CreatePointFont( 100, "Times New Roman") ;
	pDC->SelectObject( &font) ;
	pDC->SetBkColor(RGB(0,0,0)) ;

	// if there are info lines, then print them
	if (!m_Lines.IsEmpty()) {
		// loop through and print all of our lines
		int	iLine = 0 ;
		for(POSITION pos = m_Lines.GetHeadPosition(); pos != NULL;) {
			COutputLine* pText = (COutputLine*)m_Lines.GetNext(pos);

			SetLineColor( pDC, pText->m_iColor) ;
			pDC->TextOut( iLeft+4, iTop+2+(iLine *16), pText->m_sLine) ;
			iLine++ ;
		}

	// if there are no line to print, print what this box is used for
	} else if (!haveChar) {
		pDC->SetTextColor( RGB( 255,255,255)) ;
		pDC->TextOut( iLeft+14, iTop+2, "Move the cursor over an item") ;
		pDC->TextOut( iLeft+14, iTop+18, "graphic to display attributes.") ;

	// if there is no lines to print b/c there is no data, then tell them we are waiting
	} else {
		pDC->SetTextColor( RGB( 255,255,255)) ;
		pDC->TextOut( iLeft+14, iTop+2, "Listening for data...") ;
	}
}

//////////////////////////////////////////////////////////////////////





void SetLineColor( CPaintDC* dc, int iColorCode)
{
	switch ( iColorCode) {
		case -1: dc->SetTextColor( RGB( 0,0,0)) ;		// char name
				break ;
		case 0:	dc->SetTextColor( RGB( 248,191,36)) ;	// crafted
				break ;
		case 1:
		case 2:
		case 3:	dc->SetTextColor( RGB( 255,255,255)) ;	// non-magical
				break ;
		case 4:	dc->SetTextColor( RGB( 0,0,255)) ;		// magical
				break ;
		case 5:	dc->SetTextColor( RGB( 0,255,0)) ;		// set item
				break ;
		case 6:	dc->SetTextColor( RGB( 255,255,0)) ;	// rare
				break ;
		case 7:	dc->SetTextColor( RGB( 128,128,0)) ;	// unique
				break ;
		case 8:	dc->SetTextColor( RGB( 128,128,128)) ;	// socketed
				break ;
		case 9:	dc->SetTextColor( RGB( 255,0,0)) ;		// unidentified
				break ;
	}
}




//////////////////////////////////////////////////////////////////////
// Stuff for loading pics

LPPICTURE gpPicture;


//obtained this code from http://support.microsoft.com/support/kb/articles/Q218/9/72.ASP?LN=EN-US&SD=gn&FR=0&qry=loadpic&rnk=1&src=DHCS_MSPSS_gn_SRCH&SPR=VCC
// This function loads a file into an IStream.
BOOL LoadPictureFile(LPCTSTR szFile)
{
	// open file
	CString fileName = JPG_PATH ;
	fileName += szFile ;
	HANDLE hFile = CreateFile(fileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
	if ( hFile == INVALID_HANDLE_VALUE) {

		// if we couldn't find the file, then check current dir (for idiot users!!!)
		//   this will also work if they previously did a find and change the current dir
//cn
//		CString fileName = szFile ;
//		fileName = fileName.Right( fileName.GetLength() - 4) ;
//		CString fileName = JPG_PATH ;
		fileName = JPG_PATH ;
		fileName += "invhrt.jpg" ;
		hFile = CreateFile( fileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
		if ( hFile == INVALID_HANDLE_VALUE) {


			CString prompt = "Missing a necessary JPG file: " + fileName + "\n  Would you like to search for it?" ;
			if ( AfxMessageBox( prompt, MB_YESNO) == IDYES) {

				OPENFILENAME ofn;
				::memset(&ofn, 0, sizeof(OPENFILENAME));
				ofn.lStructSize = sizeof(OPENFILENAME);
				TCHAR ptchFileName[MAX_PATH] ;
				strcpy( ptchFileName, fileName) ;
				ofn.lpstrFile = ptchFileName;
				ofn.nMaxFile = MAX_PATH;
				::GetOpenFileName(&ofn);

				hFile = CreateFile( ofn.lpstrFile, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
				if ( hFile == INVALID_HANDLE_VALUE)
					return FALSE ;

			// didn't want to search, so bail
			} else
				return FALSE ;
		}
	}
	_ASSERTE(INVALID_HANDLE_VALUE != hFile);

	// get file size
	DWORD dwFileSize = GetFileSize(hFile, NULL);
	_ASSERTE(-1 != dwFileSize);

	LPVOID pvData = NULL;
	// alloc memory based on file size
	HGLOBAL hGlobal = GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
	_ASSERTE(NULL != hGlobal);

	pvData = GlobalLock(hGlobal);
	_ASSERTE(NULL != pvData);

	DWORD dwBytesRead = 0;
	// read file and store in global memory
	BOOL bRead = ReadFile(hFile, pvData, dwFileSize, &dwBytesRead, NULL);
	_ASSERTE(FALSE != bRead);
	GlobalUnlock(hGlobal);
	CloseHandle(hFile);

	LPSTREAM pstm = NULL;
	// create IStream* from global memory
	HRESULT hr = CreateStreamOnHGlobal(hGlobal, TRUE, &pstm);
	_ASSERTE(SUCCEEDED(hr) && pstm);

	// Create IPicture from image file
	if (gpPicture)
		gpPicture->Release();
	hr = ::OleLoadPicture(pstm, dwFileSize, FALSE, IID_IPicture, (LPVOID *)&gpPicture);
	_ASSERTE(SUCCEEDED(hr) && gpPicture);	
	pstm->Release();

	return TRUE ;
}


void RenderPic(CPaintDC* pdc, RECT* pRect, int iLeft, int iTop, int iXOffSet, int iYOffSet)
{
	// get width and height of picture
	long hmWidth;
	long hmHeight;
	gpPicture->get_Width(&hmWidth);
	gpPicture->get_Height(&hmHeight);

	// convert himetric to pixels
	int nWidth	= MulDiv(hmWidth, GetDeviceCaps(pdc->m_hDC, LOGPIXELSX), HIMETRIC_INCH);
	int nHeight	= MulDiv(hmHeight, GetDeviceCaps(pdc->m_hDC, LOGPIXELSY), HIMETRIC_INCH);

	// display picture using IPicture::Render
	gpPicture->Render( pdc->m_hDC, iLeft-iXOffSet, iTop-iYOffSet, nWidth, nHeight, 0, hmHeight, hmWidth, -hmHeight, pRect);
}



//////////////////////////////////////////////////////
// general utils

int charToHex( char theChar)
{
	// if its a letter, return the hex value
	switch ( theChar) {
	case 'A': return 10 ;
	case 'B': return 11 ;
	case 'C': return 12 ;
	case 'D': return 13 ;
	case 'E': return 14 ;
	case 'F': return 15 ;
	}

	// otherwise return the numeric value
	int i = theChar - '0' ;
	if ((i>9) || (i<0))
		return 0 ;
	return i ;
}
