// PKTKDoc.cpp : implementation of the CPKTKDoc class
//

#include "stdafx.h"
#include "PKTK.h"

#include "DiabloItems.h"
#include "PKTKDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPKTKDoc

IMPLEMENT_DYNCREATE(CPKTKDoc, CDocument)

BEGIN_MESSAGE_MAP(CPKTKDoc, CDocument)
	//{{AFX_MSG_MAP(CPKTKDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPKTKDoc construction/destruction

CPKTKDoc::CPKTKDoc()
{
	// TODO: add one-time construction code here

	m_bNewData = FALSE ;
	m_bNewCharacter = FALSE ;
	m_bNotStartedYet = TRUE ;
}

CPKTKDoc::~CPKTKDoc()
{
	m_Players.RemoveAllCharacters() ;
}

BOOL CPKTKDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

//	SetTitle("PK Tool Kit") ;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CPKTKDoc serialization

void CPKTKDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CPKTKDoc diagnostics

#ifdef _DEBUG
void CPKTKDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CPKTKDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPKTKDoc commands



// get the character data
void CPKTKDoc::ParsePlayer( const unsigned char *decoded_data)
{
	CDiabloCharacters* newCharacter = new CDiabloCharacters( decoded_data) ;

	// if we have already seen this character, then free the memory
	if ( !m_Players.FindMatch( newCharacter)) {
		delete newCharacter ;

	// add the new char to our list and update player name tabs in the dlg
	} else {
		m_Players.m_iCharCount++ ;
		m_bNewData = TRUE ;
		m_bNewCharacter = TRUE ;
	}
}


void CPKTKDoc::ParseItem( const unsigned char *msg)
{
//CN - parseItem should definitely be part of the class; perhaps even a constructor
	CDiabloItems*	newItem = parseItem( msg) ;

	// no item was created so we know its not an item
	if ( newItem == NULL) {
		//do nothing

	// we know it belongs to a player, so add it to that player's list
	} else if ( newItem->m_iOwnerType == ITEMOWNER_PLAYER) {

		// match this item with an owner in our list, add it if not already there
		if ( m_Players.FindOwnerMatch( newItem)) {
			m_bNewData = TRUE ;

		// we already have this item, or couldn't match the owner
		} else {
			delete newItem ;
		}

	} else
		delete newItem ;
}
