// ViewD2Spy.cpp : implementation file
//

#include "stdafx.h"
#include "PKTK.h"

#include "PKTKDoc.h"
#include "MyGUI.h"
#include "ViewD2Spy.h"
#include "MainFrm.h"

#include "ClipBoard.h"
#include "Mouse.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CViewD2Spy

IMPLEMENT_DYNCREATE(CViewD2Spy, CFormView)

CViewD2Spy::CViewD2Spy()
	: CFormView(CViewD2Spy::IDD)
{
	//{{AFX_DATA_INIT(CViewD2Spy)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CViewD2Spy::~CViewD2Spy()
{
}

void CViewD2Spy::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CViewD2Spy)
	DDX_Control(pDX, IDC_CHARTAB, m_CharTab);
	DDX_Control(pDX, IDC_IMAGE, m_Image);
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CViewD2Spy, CFormView)
	//{{AFX_MSG_MAP(CViewD2Spy)
	ON_WM_MOUSEMOVE()
	ON_NOTIFY(TCN_SELCHANGE, IDC_CHARTAB, OnSelchangeChartab)
	ON_BN_CLICKED(IDC_CLIPBOARD, OnClipboard)
	ON_WM_TIMER()
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CViewD2Spy diagnostics

#ifdef _DEBUG
void CViewD2Spy::AssertValid() const
{
	CFormView::AssertValid();
}

void CViewD2Spy::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CPKTKDoc* CViewD2Spy::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPKTKDoc)));
	return (CPKTKDoc*)m_pDocument;
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CViewD2Spy message handlers

void CViewD2Spy::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
	
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();


	m_Image.m_pParent = this ;

	// setup the Debug tab control
	TC_ITEM TabCtrlItem;
	TabCtrlItem.mask = TCIF_TEXT;
	TabCtrlItem.pszText = "D2Spy";
	m_CharTab.InsertItem( 0, &TabCtrlItem );


	if ( !GetDocument()->m_Players.m_CharList.IsEmpty()) {

		// remake the tabs
		m_CharTab.DeleteAllItems() ;
		POSITION	posChar = GetDocument()->m_Players.m_CharList.GetHeadPosition() ;
		int count = 1 ;
		while ( posChar != NULL) {
			CDiabloCharacters* pChar = (CDiabloCharacters*)GetDocument()->m_Players.m_CharList.GetNext(posChar);

			char	sTmp[80] = "" ;
			sprintf( sTmp, "%s", pChar->m_Name) ;
			TC_ITEM TabCtrlItem;
			TabCtrlItem.mask = TCIF_TEXT;
			TabCtrlItem.pszText = sTmp ;
			m_CharTab.InsertItem( count++, &TabCtrlItem );
		}

		m_CharTab.SetCurSel( count-1) ;

		// make the clipboard available for cutting and pasting
		GetDlgItem( IDC_CLIPBOARD)->EnableWindow( TRUE) ;
		GetDocument()->m_bNewCharacter = FALSE ;
	}


	SetTimer( 5302, 1000, NULL) ;
}


int GetPktkXY( int iLeft, int iTop, int iRight, int iBottom, BOOL getX)
{
	int	iCenterX = (PICPOS_MAXWEAPONX - ( iRight - iLeft))/2 ;
	if (iCenterX < 10) iCenterX = 0 ;
	int	iCenterY = (PICPOS_MAXWEAPONY - ( iBottom - iTop))/2 ;
	if (iCenterY < 10) iCenterY = 0 ;

	if (( iLeft == PICPOS_HEADX) && ( iTop == PICPOS_HEADY))
		return getX ? PICPOS_PKTK_HEADX : PICPOS_PKTK_HEADY ;

	else if (( iLeft == PICPOS_BODYX) && ( iTop == PICPOS_BODYY))
		return getX ? PICPOS_PKTK_BODYX : PICPOS_PKTK_BODYY ;

	else if (( iLeft == PICPOS_BELTX) && ( iTop == PICPOS_BELTY))
		return getX ? PICPOS_PKTK_BELTX : PICPOS_PKTK_BELTY ;

	else if (( iLeft == PICPOS_WEAPONX) && ( iTop == PICPOS_WEAPONY))
		return getX ? PICPOS_PKTK_WEAPONX : PICPOS_PKTK_WEAPONY ;

	else if (( iLeft == PICPOS_WEAPONX + iCenterX) && ( iTop == PICPOS_WEAPONY + iCenterY))
		return getX ? PICPOS_PKTK_WEAPONX + iCenterX : PICPOS_PKTK_WEAPONY + iCenterY ;

	else if (( iLeft == PICPOS_HANDX) && ( iTop == PICPOS_HANDY))
		return getX ? PICPOS_PKTK_HANDX : PICPOS_PKTK_HANDY ;

	else if (( iLeft == PICPOS_SHIELDX) && ( iTop == PICPOS_SHIELDY))
		return getX ? PICPOS_PKTK_SHIELDX : PICPOS_PKTK_SHIELDY ;

	else if (( iLeft == PICPOS_SHIELDX + iCenterX) && ( iTop == PICPOS_SHIELDY + iCenterY))
		return getX ? PICPOS_PKTK_SHIELDX + iCenterX : PICPOS_PKTK_SHIELDY + iCenterY ;

	else if (( iLeft == PICPOS_FOOTX) && ( iTop == PICPOS_FOOTY))
		return getX ? PICPOS_PKTK_FOOTX : PICPOS_PKTK_FOOTY ;

	else if (( iLeft == PICPOS_RINGLEFTX) && ( iTop == PICPOS_RINGLEFTY))
		return getX ? PICPOS_PKTK_RINGLEFTX : PICPOS_PKTK_RINGLEFTY ;

	else if (( iLeft == PICPOS_AMULETX) && ( iTop == PICPOS_AMULETY))
		return getX ? PICPOS_PKTK_AMULETX : PICPOS_PKTK_AMULETY ;

	else if (( iLeft == PICPOS_RINGRIGHTX) && ( iTop == PICPOS_RINGRIGHTY))
		return getX ? PICPOS_PKTK_RINGRIGHTX : PICPOS_PKTK_RINGRIGHTY ;

	else
		return 0 ;
}


int GetPktkSocketXY( int iLeft, int iTop, BOOL getX)
{
	// see if this is a wielded weapon
	if (( iLeft >= PICPOS_PKTK_WEAPONX) && ( iLeft <= PICPOS_PKTK_WEAPONX+PICPOS_MAXWEAPONX) &&
		( iTop  >= PICPOS_PKTK_WEAPONY) && ( iTop  <= PICPOS_PKTK_WEAPONY+PICPOS_MAXWEAPONY))
		return getX ? PICPOS_PKTK_WEAPONX : PICPOS_PKTK_WEAPONY ;

	// see if this is a wielded weapon
	else if (( iLeft >= PICPOS_PKTK_SHIELDX) && ( iLeft <= PICPOS_PKTK_SHIELDX+PICPOS_MAXWEAPONX) &&
		( iTop  >= PICPOS_PKTK_SHIELDY) && ( iTop  <= PICPOS_PKTK_SHIELDY+PICPOS_MAXWEAPONY))
		return getX ? PICPOS_PKTK_SHIELDX : PICPOS_PKTK_SHIELDY ;

	else
		return getX ? iLeft : iTop ;
}


// correction from the m_Image to screen coordinates
#define CORRECTX	13
#define CORRECTY	26

int CViewD2Spy::DoHitTest( CPoint point)
{
	CCharList*	pPlayers = &GetDocument()->m_Players ;

	POSITION	posChar = pPlayers->m_CharList.GetHeadPosition() ;
	while ( posChar != NULL) {
		CDiabloCharacters* pChar = (CDiabloCharacters*)pPlayers->m_CharList.GetNext(posChar);


		// see if we match a character to the tab selected
		if ( pChar->m_iPlayerCounter == m_CharTab.GetCurSel() ) {

			// see if our cursor is above this item
			for(POSITION pos = pChar->m_ItemList.GetHeadPosition(); pos != NULL;)
			{
				// get the item and the next pos
				CDiabloItems* pItem = (CDiabloItems*)pChar->m_ItemList.GetNext(pos);

				// disqualify this item if it is not in the proper range
				if (( pItem->m_iLeft < PICPOS_WEAPONX) || ( pItem->m_iLeft > PICPOS_SHIELDX +PICPOS_MAXWEAPONX) ||
					( pItem->m_iTop  < PICPOS_HEADY)   || ( pItem->m_iTop  > PICPOS_BELTY +PICPOS_MAXBELTY))
					continue ;

				// adjust the coordinates to D2Spy AND the tab control
				int	pktkX = CORRECTX + GetPktkXY( pItem->m_iLeft, pItem->m_iTop, pItem->m_iRight, pItem->m_iBottom, TRUE) ;
				int	pktkY = CORRECTY + GetPktkXY( pItem->m_iLeft, pItem->m_iTop, pItem->m_iRight, pItem->m_iBottom, FALSE) ;

				// test X
				if (( point.x < pktkX) || ( point.x > pktkX +( pItem->m_iRight - pItem->m_iLeft) ))
					continue ;

				// test Y
				else if (( point.y < pktkY) || ( point.y > pktkY +( pItem->m_iBottom - pItem->m_iTop) ))
					continue ;

				// if its the same id, then no reason to do an update
				else if (((int)m_InfoBox.m_iInfoLinesPID == pChar->m_iPlayerCounter) && (m_InfoBox.m_iInfoLinesItemID == (int)pItem->m_bItemID))
					return HITSAME ;

				// made it past all the checks, so update
				else {
					// out with the old
					m_InfoBox.RemoveLines() ;

					// in with the new - loop through the lines and add them to our new list
					for(POSITION pos = pItem->m_InfoLines.GetHeadPosition(); pos != NULL;) {
						COutputLine* pText = (COutputLine*)pItem->m_InfoLines.GetNext(pos);

						COutputLine* newLine = new COutputLine ;
						newLine->m_sLine = pText->m_sLine ;
						newLine->m_iColor = pText->m_iColor ;
						m_InfoBox.m_Lines.AddTail( newLine) ;
					}

					m_InfoBox.m_iInfoLinesPID = pChar->m_iPlayerCounter ;
					m_InfoBox.m_iInfoLinesItemID = pItem->m_bItemID ;

					return HITNEW ;
				}

/*
				// failed to hit, see if this item is socketed with something
				if ( !pItem->m_pSocketItems.IsEmpty()) {
					// this only makes sense if we are on a weapon or shield
//					if (( pItem->m_iLeft < PICPOS_WEAPONX) || ( pItem->m_iLeft > PICPOS_SHIELDX
					if (( point.x < PICPOS_WEAPONX) && ( point.x > PICPOS_WEAPONX+PICPOS_MAXWEAPONX) &&
						( point.y < PICPOS_WEAPONY) && ( point.y > PICPOS_WEAPONY+PICPOS_MAXWEAPONY))
						continue ;

					else if (( point.x < PICPOS_SHIELDX) && ( point.x > PICPOS_SHIELDX+PICPOS_MAXWEAPONX) &&
						( point.y < PICPOS_SHIELDY) && ( point.y > PICPOS_SHIELDY+PICPOS_MAXWEAPONY))
						continue ;

					// adjust the invman coordinates to fit D2Spy
//					int	pktkSockX = GetPktkSocketXY( pktkX, pktkY, TRUE) ;
//					int	pktkSockY = GetPktkSocketXY( pktkX, pktkY, FALSE) ;
				}
*/
			}
		}
	}

	return HITNONE ;
}


void CViewD2Spy::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	BOOL wasEmpty = m_InfoBox.m_Lines.IsEmpty() ;


	// if we don't hit anything, make sure nothing is displayed in the infobox
	//   but only if its not the same item we are already displaying (check in hittest)
	int iHit = DoHitTest( point) ;
	if ( iHit == HITNONE) {
		// if it was already empty, then no need to redraw everything
		if ( !wasEmpty) {
			m_InfoBox.RemoveLines() ;
			m_InfoBox.m_bInfoOnly = TRUE ;
			Invalidate( FALSE) ;
		}
		// if we didn't match with anything, then reset
		m_InfoBox.m_iInfoLinesPID = -1 ;
		m_InfoBox.m_iInfoLinesItemID = -1 ;

	// got a hit, so redraw
	} else if ( iHit == HITNEW) {
		m_InfoBox.m_bInfoOnly = TRUE ;
		Invalidate( FALSE) ;
	}
	// don't do anything if its the same item

	
	CFormView::OnMouseMove(nFlags, point);
}


void CViewD2Spy::OnSelchangeChartab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	Invalidate() ;

	*pResult = 0;
}


void CViewD2Spy::OnClipboard() 
{
	// TODO: Add your control notification handler code here
	
	CClipBoard	dlg ;

	// build the display string
	CCharList*	pPlayers = &GetDocument()->m_Players ;
	POSITION	posChar = pPlayers->m_CharList.GetHeadPosition() ;
	while ( posChar != NULL) {
		CDiabloCharacters* pChar = (CDiabloCharacters*)pPlayers->m_CharList.GetNext(posChar);

		// see if we match a character to the tab selected
		if ( pChar->m_iPlayerCounter == m_CharTab.GetCurSel() ) {
			dlg.m_sItems = ">>> " + pChar->m_Name ;
			dlg.m_sItemsDetails = ">>> " + pChar->m_Name ;

			// if we have images going on top of the background, draw them
			for( POSITION posItem = pChar->m_ItemList.GetHeadPosition(); posItem != NULL;)
			{
				// get the item and the next pos
				CDiabloItems* pItem = (CDiabloItems*)pChar->m_ItemList.GetNext(posItem);

				// not displaying potions and other things or things from stash, cube, or inv
				if (( pItem->m_iLeft >= PICPOS_WEAPONX) && ( pItem->m_iLeft <= PICPOS_SHIELDX) &&
					( pItem->m_iTop  >= PICPOS_HEADY)   && ( pItem->m_iTop  <= PICPOS_BELTY)) {
					dlg.m_sItems += "\r\n" ;
					dlg.m_sItems += pItem->m_sItemName ;
					dlg.m_sItemsDetails += "\r\n\r\n>>" ;
					dlg.m_sItemsDetails += pItem->m_sItemName ;

					BOOL bFirst = TRUE ;
					// loop through the lines and add them to our list
					for(POSITION pos = pItem->m_InfoLines.GetHeadPosition(); pos != NULL;) {
						COutputLine* pText = (COutputLine*)pItem->m_InfoLines.GetNext(pos);

						// want to skip the first line
						if ( !bFirst) {
							dlg.m_sItemsDetails += "\r\n" ;
							dlg.m_sItemsDetails += pText->m_sLine ;
						}
						bFirst = FALSE ;
					}
				}
			}
			break ;
		}
	}


	dlg.m_sDisplayInfo = dlg.m_sItems ;
	dlg.DoModal() ;
}


void CViewD2Spy::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	

	if ( GetDocument()->m_bNewCharacter) {

		// remake the tabs
		m_CharTab.DeleteAllItems() ;
		POSITION	posChar = GetDocument()->m_Players.m_CharList.GetHeadPosition() ;
		int count = 1 ;
		while ( posChar != NULL) {
			CDiabloCharacters* pChar = (CDiabloCharacters*)GetDocument()->m_Players.m_CharList.GetNext(posChar);

			char	sTmp[80] = "" ;
			sprintf( sTmp, "%s", pChar->m_Name) ;
			TC_ITEM TabCtrlItem;
			TabCtrlItem.mask = TCIF_TEXT;
			TabCtrlItem.pszText = sTmp ;
			m_CharTab.InsertItem( count++, &TabCtrlItem );
		}

		m_CharTab.SetCurSel( count-2) ;

		// make the clipboard available for cutting and pasting
		GetDlgItem( IDC_CLIPBOARD)->EnableWindow( TRUE) ;
		GetDocument()->m_bNewCharacter = FALSE ;
	}


	// we are checking once per second to see if there is new data requiring a redraw
	if ( GetDocument()->m_bNewData)
		Invalidate( TRUE) ;

	// when the proggy first opens, it will say "program name - Sleeping"
//	GetDocument()->SetTitle("2GK") ;
//	GetParent()->SetWindowText("2 Girls Kissing - Active") ;
//	SetWindowText("2 Girls Kissing - Active") ;

	CFormView::OnTimer(nIDEvent);
}






////////////////////////////////////////////////////////////
// CImage

BEGIN_MESSAGE_MAP(CImage, CStatic)
	//{{AFX_MSG_MAP(CImage)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// The OnPaint windows message gets called when ever a modification is done to the
//   display such as a move window or minimize.  Redraw our image when this occurs
void CImage::OnPaint()
{
	// device context for painting
	CPaintDC dc(this);

	RECT rc;
	GetClientRect(&rc);

	CCharList*	pPlayers = &m_pParent->GetDocument()->m_Players ;

	// set the title; what a mess of pointers!!!!
	m_pParent->GetDocument()->m_pMainFrame->SetWindowText("PK Tool Kit - D2 Spy") ;


	////
	//// fill in the item description box
	////

	m_pParent->m_InfoBox.Display( &dc, 240, 0, pPlayers->m_CharList.IsEmpty()) ;

	// if we only wanted to updae the info box, then we are done, otherwise drive on
	//   but if we have new item data and the cursor is on top of an item, then still
	//   do the redraw
	if ((m_pParent->m_InfoBox.m_bInfoOnly) && (!m_pParent->GetDocument()->m_bNewData)) {
		m_pParent->m_InfoBox.m_bInfoOnly = FALSE ;
		return ;
	}
	m_pParent->m_InfoBox.m_bInfoOnly = FALSE ;
	m_pParent->GetDocument()->m_bNewData = FALSE ;




	////
	//// draw the background pic
	////

	// clear out the items list rect
	dc.FillSolidRect( CRect( 0,260,233,405), RGB(0,0,0)) ;
	
	// load the background
	if (!LoadPictureFile("invmanager-4.jpg")) {
		MessageBox("Missing a necessary JPG file \"invmanager-4.jpg\".  Make sure\nthe JPG folder is in the same directory as the program.", "Fatal Error") ;
//		return ;
	}
	RenderPic( &dc, &rc, 0, 0) ;



	////
	//// draw the items and character name
	////

	// find the character that corresponds to the tab we just selected
	POSITION	posChar = pPlayers->m_CharList.GetHeadPosition() ;
	while ( posChar != NULL) {
		CDiabloCharacters* pChar = (CDiabloCharacters*)pPlayers->m_CharList.GetNext(posChar);

		// see if we match a character to the tab selected
		if ( pChar->m_iPlayerCounter == m_pParent->m_CharTab.GetCurSel() ) {

			int	iItemCount = 0 ;
			// if we have images going on top of the background, draw them
			for( POSITION posItem = pChar->m_ItemList.GetHeadPosition(); posItem != NULL;){
				// get the item and the next pos
				CDiabloItems* pItem = (CDiabloItems*)pChar->m_ItemList.GetNext(posItem);

				// not rendering potions and other things or things from stash, cube, or inv
				if (( pItem->m_iLeft >= PICPOS_WEAPONX) && ( pItem->m_iLeft <= PICPOS_SHIELDX +PICPOS_MAXWEAPONX) &&
					( pItem->m_iTop  >= PICPOS_HEADY)   && ( pItem->m_iTop  <= PICPOS_BELTY)) {
					if (!LoadPictureFile( pItem->m_sFileName)) {
//						MessageBox("Missing a necessary JPG file \""+pItem->m_sFileName+"\".  Make sure\nthe JPG folder is\nin the same directory as the program.", "Fatal Error") ;
						continue ;
					}

					// adjust the invman coordinates to fit D2Spy
					int	pktkX = GetPktkXY( pItem->m_iLeft, pItem->m_iTop, pItem->m_iRight, pItem->m_iBottom, TRUE) ;
					int	pktkY = GetPktkXY( pItem->m_iLeft, pItem->m_iTop, pItem->m_iRight, pItem->m_iBottom, FALSE) ;

					// display picture using IPicture::Render
					RenderPic( &dc, &rc, pktkX, pktkY) ;



					// see if its socketed
					int iColor = pItem->m_bQuality ;
//					if ( pItem->m_bSocketed == ITEM_HASSOCKET)
//						iColor = 8 ;

					SetLineColor( &dc, iColor) ;
					if ( iItemCount <= 7)
						dc.TextOut(  5, 265+(iItemCount *16), pItem->m_sItemName) ;
					else
						dc.TextOut(115, 265+((iItemCount-8) *16), pItem->m_sItemName) ;
					iItemCount++ ;


					// display any gems/runes socketed in this item
					int iNumSocketed = 0 ;
					for( POSITION posSock = pItem->m_pSocketItems.GetHeadPosition(); posSock != NULL;){
						// get the item and the next pos
						CDiabloItems* pSockItem = (CDiabloItems*)pItem->m_pSocketItems.GetNext(posSock);

						if (!LoadPictureFile( pSockItem->m_sFileName))
							continue ;
						
						// adjust the invman coordinates to fit D2Spy
						int	pktkSockX = GetPktkSocketXY( pktkX, pktkY, TRUE) ;
						int	pktkSockY = GetPktkSocketXY( pktkX, pktkY, FALSE) ;

						// display picture using IPicture::Render
						RenderPic( &dc, &rc, pktkSockX, pktkSockY +(iNumSocketed*PICPOSLEN)) ;
						iNumSocketed++ ;
					}
				}
			}


			// display the player name
			CFont newFont ;
			newFont.CreatePointFont( 130, "Arial Black", &dc) ;
			dc.SetBkColor(RGB(192,192,192)) ;

			dc.SelectObject( &newFont) ;
			dc.SetTextColor( RGB( 255,0,0)) ;
			dc.TextOut( 240, 340, pChar->m_Name) ;


			break ;
		}
	}




	////
	//// draw the welcome message
	////
/*
	// write weclome info to the screen if we have not started capturing yet
	if ( m_pParent->GetDocument()->m_bNotStartedYet) {
		CRect rect(75,50,350,300) ;
		dc.FillSolidRect( rect, RGB(200,200,200)) ;
		dc.SetBkColor(RGB(200,200,200)) ;

		CFont	font ;
		font.CreatePointFont( 110, "Times New Roman", &dc) ;
		dc.SelectObject( &font) ;


		dc.SetTextColor( RGB( 0,0,0)) ;
//		dc.TextOut( 80,  75, "Welcome!  Press the            button to begin.") ;
		dc.TextOut( 80,  75, "Welcome!  Just join a game to begin.") ;
//		dc.SetTextColor( RGB( 0,128,0)) ;
//		dc.TextOut( 201,  75, "START") ;

		dc.SetTextColor( RGB( 255,0,0)) ;
		dc.TextOut( 80, 125, "NOTE: This is only a demo and I am aware") ;
		dc.TextOut( 80, 142, "     that many problems exist.  Please do") ;
		dc.TextOut( 80, 159, "     not submit bug reports until I make") ;
		dc.TextOut( 80, 176, "     an official release.") ;

		dc.SetTextColor( RGB( 0,0,0)) ;
		dc.TextOut( 80,  240, "Copyright (c) 2001 by \"Nuttzy\"") ;
//		dc.TextOut( 80,  256, "         see \"About\" for credits and notices") ;
	}
*/
}

void CViewD2Spy::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	pCmdUI->Enable( FALSE) ;	
}

void CViewD2Spy::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
	pCmdUI->Enable( FALSE) ;	
}
