// ViewInvMan.cpp : implementation file
//

#include "stdafx.h"
#include "PKTK.h"

#include "PKTKDoc.h"
#include "MyGUI.h"
#include "ViewInvMan.h"
#include "DlgList.h"
#include "DlgTree.h"
#include "DlgGameData.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CViewInvMan

IMPLEMENT_DYNCREATE(CViewInvMan, CFormView)

CViewInvMan::CViewInvMan()
	: CFormView(CViewInvMan::IDD)
{
	//{{AFX_DATA_INIT(CViewInvMan)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pItemDesc = NULL ;
	m_pCharList = NULL ;
}

CViewInvMan::~CViewInvMan()
{
	delete m_pItemDesc ;
	delete m_pCharList ;
}

void CViewInvMan::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CViewInvMan)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CViewInvMan, CFormView)
	//{{AFX_MSG_MAP(CViewInvMan)
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_BN_CLICKED(IDC_SUBMIT, OnSubmit)
	ON_BN_CLICKED(IDC_ITEMDESC, OnItemDesc)
	ON_BN_CLICKED(IDC_CharacterList, OnCharacterList)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CViewInvMan diagnostics

#ifdef _DEBUG
void CViewInvMan::AssertValid() const
{
	CFormView::AssertValid();
}

void CViewInvMan::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CPKTKDoc* CViewInvMan::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPKTKDoc)));
	return (CPKTKDoc*)m_pDocument;
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CViewInvMan message handlers

void CViewInvMan::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
	
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	SetTimer( 5303, 1000, NULL) ;

//cn-note: decided to let the user open it
//	OnItemDesc() ;
}


int GetSocketXY( int iLeft, int iTop, BOOL getX)
{
	// see if this is a wielded weapon
	if (( iLeft >= PICPOS_WEAPONX) && ( iLeft <= PICPOS_WEAPONX+PICPOS_MAXWEAPONX) &&
		( iTop  >= PICPOS_WEAPONY) && ( iTop  <= PICPOS_WEAPONY+PICPOS_MAXWEAPONY))
		return getX ? PICPOS_WEAPONX : PICPOS_WEAPONY ;

	// see if this is a wielded weapon
	else if (( iLeft >= PICPOS_SHIELDX) && ( iLeft <= PICPOS_SHIELDX+PICPOS_MAXWEAPONX) &&
		( iTop  >= PICPOS_SHIELDY) && ( iTop  <= PICPOS_SHIELDY+PICPOS_MAXWEAPONY))
		return getX ? PICPOS_SHIELDX : PICPOS_SHIELDY ;

	else
		return getX ? iLeft : iTop ;
}


// The OnPaint windows message gets called when ever a modification is done to the
//   display such as a move window or minimize.  Redraw our image when this occurs
void CViewInvMan::OnPaint() 
{
	// device context for painting
	CPaintDC dc(this);
	
	// TODO: Add your message handler code here


	RECT rc;
	GetClientRect(&rc);

	int iXOffSet = GetScrollPos(SB_HORZ) ;
	int iYOffSet = GetScrollPos(SB_VERT) ;

	CCharList*	pPlayers = &GetDocument()->m_Players ;
	GetDocument()->m_bNewData = FALSE ;

	
	// set the entire title (both halves)
	GetDocument()->m_pMainFrame->SetWindowText("PK Tool Kit - Inv Man") ;


	////
	//// draw the background pic
	////

	// load the background
	if (!LoadPictureFile("invmanager-5.jpg")) {
		MessageBox("Missing a necessary JPG file \"invmanager-5.jpg\".  Make sure\nthe JPG folder is in the same directory as the program.", "Fatal Error") ;
//		return ;
	}
	RenderPic( &dc, &rc, 0, 0, iXOffSet, iYOffSet) ;



	////
	//// draw the items and character name
	////

	// make suer we have a char, and then display the items
	POSITION	posChar = pPlayers->m_CharList.GetHeadPosition() ;
	while ( posChar != NULL) {
		CDiabloCharacters* pChar = (CDiabloCharacters*)pPlayers->m_CharList.GetNext(posChar);
		// don't print if it's not me
		if ( !pChar->m_itsMe) continue ;

		int	iItemCount = 0 ;
		// if we have images going on top of the background, draw them
		for( POSITION posItem = pChar->m_ItemList.GetHeadPosition(); posItem != NULL;) {
			// get the item and the next pos
			CDiabloItems* pItem = (CDiabloItems*)pChar->m_ItemList.GetNext(posItem);

			// not rendering potions and other things or things from stash, cube, or inv
			if (( pItem->m_iLeft > 0) && ( pItem->m_iTop > 0)) {
				if (!LoadPictureFile( pItem->m_sFileName)) {
//					MessageBox("Missing a necessary JPG file \""+pItem->m_sFileName+"\".  Make sure\nthe JPG folder is\nin the same directory as the program.", "Fatal Error") ;
					return ;
				}
				// display picture using IPicture::Render
				RenderPic( &dc, &rc, pItem->m_iLeft, pItem->m_iTop, iXOffSet, iYOffSet) ;


				// display any gems/runes socketed in this item
				int iNumSocketed = 0 ;
				for( POSITION posSock = pItem->m_pSocketItems.GetHeadPosition(); posSock != NULL;){
					// get the item and the next pos
					CDiabloItems* pSockItem = (CDiabloItems*)pItem->m_pSocketItems.GetNext(posSock);

					if (!LoadPictureFile( pSockItem->m_sFileName))
						continue ;
					
					// adjust the invman coordinates to fit D2Spy
					int	SockX = GetSocketXY( pItem->m_iLeft, pItem->m_iTop, TRUE) ;
					int	SockY = GetSocketXY( pItem->m_iLeft, pItem->m_iTop, FALSE) ;

					// display picture using IPicture::Render
					RenderPic( &dc, &rc, SockX, SockY +(iNumSocketed*PICPOSLEN, iXOffSet, iYOffSet)) ;
					iNumSocketed++ ;
				}
			}
		}


		CFont	newFont ;
		newFont.CreatePointFont( 130, "Arial Black", &dc) ;
		dc.SetBkColor(RGB(192,192,192)) ;

		dc.SelectObject( &newFont) ;
		dc.SetBkColor(RGB(0,0,0)) ;
		dc.SetTextColor( RGB( 255,255,255)) ;
		dc.TextOut( 355-iXOffSet,  263-iYOffSet, pChar->m_Name) ;
	}




	////
	//// draw the welcome message
	////
/*
	// write weclome info to the screen if we have not started capturing yet
	if ( GetDocument()->m_bNotStartedYet) {
		CRect rect(75,50,350,300) ;
		dc.FillSolidRect( rect, RGB(192,192,192)) ;
		dc.SetBkColor(RGB(192,192,192)) ;

		CFont	font ;
		font.CreatePointFont( 110, "Times New Roman", &dc) ;
		dc.SelectObject( &font) ;


		dc.SetTextColor( RGB( 0,0,0)) ;
		dc.TextOut( 80,  75, "Welcome!  Press the            button to begin.") ;
		dc.SetTextColor( RGB( 0,128,0)) ;
		dc.TextOut( 201,  75, "START") ;

		dc.SetTextColor( RGB( 255,0,0)) ;
		dc.TextOut( 80, 125, "WARNING: For security reasons, connect to ") ;
		dc.TextOut( 80, 142, "     Battle.Net BEFORE running this or any  ") ;
		dc.TextOut( 80, 159, "     other program.  Your Battle.Net password ") ;
		dc.TextOut( 80, 176, "     can be stolen very easily with a program ") ;
		dc.TextOut( 80, 193, "     such as this.") ;

		dc.SetTextColor( RGB( 0,0,0)) ;
		dc.TextOut( 80,  240, "        Copyright (C) 2001 by Nuttzy") ;
		dc.TextOut( 80,  256, "         see \"About\" for credits and notices") ;	
	}
*/
	// Do not call CFormView::OnPaint() for painting messages
}


void CViewInvMan::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	

	GetDocument()->m_bNewCharacter = FALSE ;

	// we are checking once per second to see if there is new data requiring a redraw
	if ( GetDocument()->m_bNewData)
		Invalidate( TRUE) ;

	// when the proggy first opens, it will say "program name - Sleeping"
//	GetDocument()->SetTitle("2GK") ;
//	GetParent()->SetWindowText("2 Girls Kissing - Active") ;
//	SetWindowText("2 Girls Kissing - Active") ;

	if ( m_pItemDesc != NULL) {
		if ( m_pItemDesc->m_bStopped) {
			delete m_pItemDesc ;
			m_pItemDesc = NULL ;
		}
	}

	if ( m_pCharList != NULL) {
		if ( m_pCharList->m_iLoadData >= 0) {

//			POSITION	posChar = m_pCharList->m_Players.m_CharList.GetHeadPosition() ;
//			CDiabloCharacters* pChar = (CDiabloCharacters*)m_pCharList->m_Players.m_CharList.GetNext(posChar);

			// make sure we have a char, and then display the items
			POSITION	posChar = m_pCharList->m_Players.m_CharList.GetHeadPosition() ;
			int iCount = 0 ;
			CDiabloCharacters* pChar ;
			while ( posChar != NULL) {
				pChar = (CDiabloCharacters*)m_pCharList->m_Players.m_CharList.GetNext(posChar);
				// don't print if it's not me
				if ( iCount == m_pCharList->m_iLoadData) break ;
				iCount++ ;
			}
			m_pCharList->m_iLoadData = -1 ;


			// if we have already seen this character, then free the memory
			if ( !GetDocument()->m_Players.FindMatch( pChar)) {
				delete pChar ;

			// add the new char to our list and update player name tabs in the dlg
			} else {
				// make sure we don't delete the memory when the DlgTree is deleted
				pChar->m_bDualUse = TRUE ;

				GetDocument()->m_Players.m_iCharCount++ ;
				GetDocument()->m_bNewData = TRUE ;
				GetDocument()->m_bNewCharacter = TRUE ;
				GetDocument()->m_bNotStartedYet = FALSE ;
				Invalidate() ;
			}	
		}

		
		if ( m_pCharList->m_bStopped) {
			delete m_pCharList ;
			m_pCharList = NULL ;
		}
	}

	
	CFormView::OnTimer(nIDEvent);
}


int CViewInvMan::DoHitTest( CPoint point)
{
	int iXOffSet = GetScrollPos(SB_HORZ) ;
	int iYOffSet = GetScrollPos(SB_VERT) ;

	CCharList*	pPlayers = &GetDocument()->m_Players ;
	POSITION	posChar = pPlayers->m_CharList.GetHeadPosition() ;
	// make sure we have a char
	while ( posChar != NULL) {
		CDiabloCharacters* pChar = (CDiabloCharacters*)pPlayers->m_CharList.GetNext(posChar);

		// make sure it's me!
		if ( !pChar->m_itsMe) continue ;


		// see if our cursor is above this item
		for(POSITION pos = pChar->m_ItemList.GetHeadPosition(); pos != NULL;)
		{
			// get the item and the next pos
			CDiabloItems* pItem = (CDiabloItems*)pChar->m_ItemList.GetNext(pos);

			// test X
			if (!(( pItem->m_iLeft-iXOffSet <= point.x) && ( pItem->m_iRight-iXOffSet >= point.x)))
				continue ;

			// test Y
			else if (!((pItem->m_iTop-iYOffSet <= point.y) && (pItem->m_iBottom-iYOffSet >= point.y)))
				continue ;

			// if its the same id, then no reason to do an update
			else if (((int)m_InfoBox.m_iInfoLinesPID == pChar->m_iPlayerCounter) && (m_InfoBox.m_iInfoLinesItemID == (int)pItem->m_bItemID))
				return HITSAME ;

			// made it past all the checks, so update
			else {
				// out with the old
				m_InfoBox.RemoveLines() ;

				// in with the new - loop through the lines and add them to our new list
				for(POSITION pos = pItem->m_InfoLines.GetHeadPosition(); pos != NULL;) {
					COutputLine* pText = (COutputLine*)pItem->m_InfoLines.GetNext(pos);

					COutputLine* newLine = new COutputLine ;
					newLine->m_sLine = pText->m_sLine ;
					newLine->m_iColor = pText->m_iColor ;
					m_InfoBox.m_Lines.AddTail( newLine) ;
				}

				m_InfoBox.m_iInfoLinesPID = pChar->m_iPlayerCounter ;
				m_InfoBox.m_iInfoLinesItemID = pItem->m_bItemID ;

				return HITNEW ;
			}
		}
	}

	return HITNONE ;
}


void CViewInvMan::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	
	BOOL wasEmpty = m_InfoBox.m_Lines.IsEmpty() ;


	// if we don't hit anything, make sure nothing is displayed in the infobox
	//   but only if its not the same item we are already displaying (check in hittest)
	int iHit = DoHitTest( point) ;
	if ( iHit == HITNONE) {
		// if it was already empty, then no need to redraw everything
		if ( !wasEmpty) {
			m_InfoBox.RemoveLines() ;
			if ( m_pItemDesc != NULL)
				m_pItemDesc->Invalidate( FALSE) ;
		}
		// if we didn't match with anything, then reset
		m_InfoBox.m_iInfoLinesPID = -1 ;
		m_InfoBox.m_iInfoLinesItemID = -1 ;

	// got a hit, so redraw
	} else if ( iHit == HITNEW) {
		if ( m_pItemDesc != NULL)
			m_pItemDesc->Invalidate( FALSE) ;
	}


	// don't do anything if its the same item
	CFormView::OnMouseMove(nFlags, point);
}


void CViewInvMan::OnFileOpen() 
{
	// TODO: Add your command handler code here
	

	// get file name to open
	TCHAR szFile[MAX_PATH];
	ZeroMemory(szFile, MAX_PATH);
	OPENFILENAME ofn;
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.Flags  = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;
	ofn.hwndOwner = m_hWnd;
	ofn.lpstrFilter = _T("Supported Files Types(*.inv;*.itm)\0*.inv;*.itm\0Inventories (*.inv)\0*.inv\0Single Item (*.itm)\0*.itm\0\0");
	ofn.lpstrTitle = _T("Open Inventory File");
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = MAX_PATH;
	if ( GetOpenFileName(&ofn) != IDOK)
		return ;

	// make sure they aren't trying to open the index
	CString sFileName = ofn.lpstrFile ;
	sFileName = sFileName.Right( sFileName.GetLength() - ofn.nFileOffset) ;
	if ( sFileName == "index.inv") {
		MessageBox("You cannot open the index file here.  Use notepad to modify it.","Abort") ;
		return ;
	}


	char			sData[300] ;
	unsigned char	iData[100] ;
	CDiabloCharacters* newCharacter = NULL ;

	// loop through the lines of the specified file and get the item data
	FILE* fPlayer = fopen( ofn.lpstrFile, "r") ;
	while (!feof( fPlayer)) {
		// get the line, end looping if eof
		fgets( sData, 300, fPlayer) ;
		if ( feof( fPlayer)) break ;


		// get the number of bytes for the data line
		int iLen ;
		if ( (sData[0] == '5') && (sData[1] == '9'))
			iLen = 26 ;
		else
			iLen = (charToHex( sData[6]) * 16) + charToHex( sData[7]) ;
/*
{
//			iLen = (charToHex( sData[6]) * 16) + charToHex( sData[7]) ;
			int first = charToHex( sData[6]) ;
			int second = charToHex( sData[7]) ;
			iLen = first*16 + second ;
fprintf( fdebug, "%d [%d][%d] {%c}{%c}\n", iLen, first, second, sData[6], sData[7]) ;
}
*/
		// convert the ascii to hex so we can use the data
//fprintf( fdebug, "\n\n") ;
//fprintf( fdebug, "[\n%s]\n", sData) ;
		for ( int i=0; i<iLen; i++)
//{
			iData[i] = (charToHex( sData[i*3]) * 16) + charToHex( sData[i*3 +1]) ;
//fprintf( fdebug, "%2d [%c][%c] {%2X}\n", i, sData[i*3], sData[i*3 +1], iData[i]) ;
//}
//fclose( fdebug) ;

		// if a player record, add a new player
		if ((sData[0] == '5') && (sData[1] == '9')) {
			newCharacter = new CDiabloCharacters( iData) ;

			// the itsMe will be set and end up deleting all other character in our list
			if ( !GetDocument()->m_Players.FindMatch( newCharacter)) {
				delete newCharacter ;

			// add the new char to our list and update player name tabs in the dlg
			} else {
				GetDocument()->m_Players.m_iCharCount++ ;
				GetDocument()->m_bNewData = TRUE ;
				GetDocument()->m_bNewCharacter = TRUE ;
				GetDocument()->m_bNotStartedYet = FALSE ;
				Invalidate() ;
			}


		// if it is an item record, add it to the current player rec
		} else if ( newCharacter != NULL) {
			CDiabloItems*	newItem = parseItem( iData) ;

			// can't use FindOwnerMatch b/c we'll have entries with duplicate playerid's 
			newCharacter->m_ItemList.AddTail( newItem) ;

			// print debug info
			if ( newItem->m_bDebug) {
				newCharacter->PrintCharacter() ;
				newItem->DumpDebugInfo() ;
			}

		// no current player rec for this item, make a fake player and add item
		} else {
			// if we haven't defined an owner, make one
			newCharacter = new CDiabloCharacters ;
			newCharacter->m_itsMe = TRUE ;
			newCharacter->m_Name = sFileName ;
			newCharacter->m_bItemPlayerID = 0 ;
			newCharacter->m_iPlayerCounter = 0 ;

			// the itsMe will be set and end up deleting all other character in our list
			if ( !GetDocument()->m_Players.FindMatch( newCharacter)) {
				delete newCharacter ;

			// add the new char to our list and update player name tabs in the dlg
			} else {
				GetDocument()->m_Players.m_iCharCount++ ;
				GetDocument()->m_bNewData = TRUE ;
				GetDocument()->m_bNewCharacter = TRUE ;
				GetDocument()->m_bNotStartedYet = FALSE ;
			}


			// add the item
			CDiabloItems*	newItem = parseItem( iData) ;
			// can't use FindOwnerMatch b/c we'll have entries with duplicate playerid's 
			newCharacter->m_ItemList.AddTail( newItem) ;

			// print debug info
			if ( newItem->m_bDebug) {
				newCharacter->PrintCharacter() ;
				newItem->DumpDebugInfo() ;
			}
			Invalidate() ;
		}
	}
	fclose( fPlayer) ;
}


void CViewInvMan::OnSubmit() 
{
	// TODO: Add your control notification handler code here
	
	ShellExecute(NULL,"open","http://www.cnn.com",NULL,NULL,SW_SHOWMAXIMIZED);
}


void CViewInvMan::OnItemDesc() 
{
	// TODO: Add your control notification handler code here
	
	if ( m_pItemDesc == NULL) {
		m_pItemDesc = new CDlgList ;
		m_pItemDesc->m_pInfoBox = &m_InfoBox ;
		m_pItemDesc->Create( IDD_DLGLIST) ;
		m_pItemDesc->ShowWindow( SW_SHOW) ;

		// move the window to where we want it
		LPRECT	lpRect = new RECT ;
		GetDocument()->m_pMainFrame->GetWindowRect( lpRect) ;
		LPRECT	lpRectDlg = new RECT ;
		m_pItemDesc->GetWindowRect( lpRectDlg) ;
		RECT newPos ;
		newPos.left = lpRect->left+550 ;
		newPos.right = newPos.left + ( lpRectDlg->right - lpRectDlg->left) ;
		newPos.top = lpRect->top+50 ;
		newPos.bottom = newPos.top + ( lpRectDlg->bottom - lpRectDlg->top) ;
		m_pItemDesc->MoveWindow( &newPos) ;
		delete lpRect ;
		delete lpRectDlg ;
	}
}

void CViewInvMan::OnCharacterList() 
{
	// TODO: Add your control notification handler code here
	
	if ( m_pCharList == NULL) {
		m_pCharList = new CDlgTree ;
		m_pCharList->Create( IDD_DLGTREE) ;
		m_pCharList->ShowWindow( SW_SHOW) ;

		// move the window to where we want it
		LPRECT	lpRect = new RECT ;
		GetDocument()->m_pMainFrame->GetWindowRect( lpRect) ;
		LPRECT	lpRectDlg = new RECT ;
		m_pCharList->GetWindowRect( lpRectDlg) ;
		RECT newPos ;
		newPos.left = lpRect->left+250 ;
		newPos.right = newPos.left + ( lpRectDlg->right - lpRectDlg->left) ;
		newPos.top = lpRect->top+100 ;
		newPos.bottom = newPos.top + ( lpRectDlg->bottom - lpRectDlg->top) ;
		m_pCharList->MoveWindow( &newPos) ;
		delete lpRect ;
		delete lpRectDlg ;
	}
}

void CViewInvMan::OnFileSave() 
{
	// TODO: Add your command handler code here

	// make suer we have a char, and then display the items
	CCharList*	pPlayers = &GetDocument()->m_Players ;
	POSITION	posChar = pPlayers->m_CharList.GetHeadPosition() ;
	while ( posChar != NULL) {
		CDiabloCharacters* pChar = (CDiabloCharacters*)pPlayers->m_CharList.GetNext(posChar);
		// don't print if it's not me
		if ( !pChar->m_itsMe) continue ;


		///
		/// get game data
		///

		// get the game data for this character; abort if they hit cancel
		CDlgGameData	dlg ;
		if (dlg.DoModal() != IDOK)
			return ;

		CString	sFileName = pChar->m_Name ;
		sFileName += "-" ;

		// realm
		switch ( dlg.m_iRealm) {
		case 1: sFileName += "USEast" ;
				break ;
		case 2: sFileName += "USWest" ;
				break ;
		case 3: sFileName += "Europe" ;
				break ;
		case 4: sFileName += "Asia 1" ;
				break ;
		case 5: sFileName += "Asia 2" ;
				break ;
		case 6: sFileName += "Asia 3" ;
				break ;
		default: sFileName += "Single" ;
				break ;
		}
		sFileName += "-" ;

		// play style
		(dlg.m_iPlayStye == 1) ? sFileName += "sc" : sFileName += "hc" ;
		sFileName += "-" ;

		// versiom
		(dlg.m_iVersion == 1) ? sFileName += "d2x" : sFileName += "d2c" ;
		CString sFileNoExt = sFileName ;
		sFileName += ".inv" ;


		///
		/// update index
		///

		FILE* fout ;
		// is this filename already in the index?  add if not
		if (( fout = fopen( "index.inv", "r")) != NULL) {
			BOOL	bGotMatch = FALSE ;
			char	line[100] ;

			// loop through the index to see if there is already an entry for this character
			while ( fgets( line, 100, fout ) != NULL) {
				CString sTmp = line ;
				if ( sTmp.Left( sTmp.GetLength() -1) == sFileNoExt)
					bGotMatch = TRUE ;
			}
			fclose( fout) ;

			// make a new entry in the index if there was no match
			if ( !bGotMatch) {
				FILE* fout = fopen( "index.inv", "a") ;
				fprintf( fout, "%s\n", sFileNoExt) ;
				fclose( fout) ;
			}
		}


		///
		/// write saved data
		///

		// is this filename already here?
		if (( fout = fopen( sFileName, "r")) != NULL) {
			fclose( fout) ;
			if ( MessageBox( "Ok to overwrite previous data for this character?", "Overwrite", MB_YESNO | MB_ICONEXCLAMATION ) == IDNO) {
				MessageBox( "Data not saved.", "User Aborted") ;
				return ;
			}
		}
		fout = fopen( sFileName, "w") ;

		// write the char info
		fprintf( fout, "%s\n", pChar->PrintHex()) ;

		// write out all the items
		for(POSITION pos = pChar->m_ItemList.GetHeadPosition(); pos != NULL;) {
			// get the item and the next pos
			CDiabloItems* pItem = (CDiabloItems*)pChar->m_ItemList.GetNext(pos);

			// write the item info
			fprintf( fout, "%s\n", pItem->PrintItemHex()) ;

			// write the info for items socketed in this item
			for( POSITION posSock = pItem->m_pSocketItems.GetHeadPosition(); posSock != NULL;){
				// get the item and the next pos
				CDiabloItems* pSockItem = (CDiabloItems*)pItem->m_pSocketItems.GetNext(posSock);

				// write the item info
				fprintf( fout, "%s\n", pSockItem->PrintItemHex()) ;
			}
		}
		fclose( fout) ;

		return ;
	}

	MessageBox( "No character loaded.", "Save failed") ;
}
