//////////////////////////////////////////////////////////////////////
// Chicken.cpp - Chicken for chicken players! *LOL* by Maulei
// -------------------------------------------------------------------
// A D2HackIt module that auto tp / auto quit game when low HP or
// hostiled.
//////////////////////////////////////////////////////////////////////
#include "External/D2Hackit.h"
#include "External/D2Client.h"
#include <time.h>

//////////////////////////////////////////////////////////////////////
// Version History
//
// Ver.  Date       Details
// -------------------------------------------------------------------
// 0.10  07-Feb-02  Initial code
//                  Chicken go to town when low in HP
//                  Chicken quit game when really low in HP
//                  How chicken react to hostile player?
//                    - tp and unhostile
//                    - quit game
//                  Go to town thingie copy from PvPBuddy
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Go to town thingie, copy from PvPBuddy
//////////////////////////////////////////////////////////////////////
#define STATE_GOTO_TOWN_IDLE 0
#define STATE_GOTO_TOWN_SWITCHING_SKILL 1
#define STATE_GOTO_TOWN_USING_SKILL 2

//	Goto town
DWORD stateGotoTown;
BYTE portalPos[4];
BYTE saPacket[9];

DWORD WINAPI SleepThread(LPVOID lpParameter);
DWORD WINAPI ResetThread(LPVOID lpParameter);
void GoToTown(void);
void LoadConfig(void);
void OverheadMsg(char *);
void ChatMsg(char *);

//////////////////////////////////////////////////////////////////////
// CLIENTINFO
//////////////////////////////////////////////////////////////////////
DWORD   ModuleVersion=MAKELONG(0, 11);
char    ModuleAuthor[]="Maulei";
char    ModuleWebsite[]="jonathan.makes.it";
char    ModuleDescription[]="Chicken - Auto TP and Auto Quit when in danger";
char    ModuleEmail[]="jonathanwu@hongkong.com";

//////////////////////////////////////////////////////////////////////
// Function Definition
//////////////////////////////////////////////////////////////////////
DWORD WINAPI ThreadProc(LPVOID lpParameter);
BOOL PRIVATE OnGameCommandHelp(char** argv, int argc);
BOOL PRIVATE OnGameCommandHPquit(char** argv, int argc);
BOOL PRIVATE OnGameCommandHPtown(char** argv, int argc);
BOOL PRIVATE OnGameCommandTP(char** argv, int argc);
BOOL PRIVATE OnGameCommandHostile(char** argv, int argc);
BOOL PRIVATE OnGameCommandStart(char** argv, int argc);
BOOL PRIVATE OnGameCommandStop(char** argv, int argc);
DWORD EXPORT OnGameTimerTick(void);

void ShowHPquit(void);
void ShowHPtown(void);
void ShowHostile(void);
void Quit(void);

//////////////////////////////////////////////////////////////////////
// ClientCore.cpp stuff
//////////////////////////////////////////////////////////////////////
char ConfigPath[1024];
FUNCTIONENTRYPOINTS	*server;
THISGAMESTRUCT *thisgame;

int CurrentHP, CurrentMP, CurrentLvl;
int MaxHP, MaxMP;
int HPquit, HPtown, Hostile;
char HostileMsg[256];
BOOL ChickenQuit=FALSE, ChickenTown=FALSE, HostileQuit=FALSE, HostileTown=FALSE;
BYTE PlayerID;

// For writing INI file
char _Character[64], _Key[64], _Value[64];
char Msg1[256];

typedef struct thread_data_t
{
	// Thread ID
	HANDLE   Thread;

	// TRUE if in a game
	BOOL  Active;

    // For getting info :)
    THISGAMESTRUCT*   thisgame;

} THREAD_DATA;

THREAD_DATA td;

//////////////////////////////////////////////////////////////////////
// Module Commands
//////////////////////////////////////////////////////////////////////
MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{
		"help",  OnGameCommandHelp,
		"help c0 List commands available in this module.\n"
		"<command> help c0 Shows detailed help for <command> in this module."
	},
	{
		"hp.quit", OnGameCommandHPquit,
		"hp.quit c0 Quit game when HP reaches <amount>"
	},
	{
		"hp.town", OnGameCommandHPtown,
		"hp.quit c0 Use TP and go to town when HP reaches <amount>"
	},
	{
		"tp", OnGameCommandTP,
		"tp c0 Use TP to escape"
	},
	{
		"hostile", OnGameCommandHostile,
		"hostile c0 Specify your action when hostiled. 0:Off 1:Quit 2:TP to town"
	},
	{
		"start", OnGameCommandStart,
		"start c0 Start or reset Chicken\n"
	},
	{
		"stop",  OnGameCommandStop,
		"stop c0 Temporarily stops Chicken\n"
	},
	{NULL}
};

BOOL EXPORT OnClientStart()
{
	FILE *file;

	// Make sure ini file exists
	sprintf(Msg1, "%s\\%s", ConfigPath, "chicken.ini");
	file = fopen(Msg1, "a+");
	fclose(file);

	stateGotoTown = STATE_GOTO_TOWN_IDLE;

	return TRUE;
}

void EXPORT OnGameJoin(THISGAMESTRUCT* thisgame)
{
	td.thisgame=thisgame;
	ChickenQuit = FALSE;
	ChickenTown = FALSE;
	HostileQuit = FALSE;
	HostileTown = FALSE;
	LoadConfig();

	ShowHPquit();
	ShowHPtown();
	ShowHostile();

	// Start thread
	td.Active=TRUE;
	DWORD dummy=0;
    td.Thread = CreateThread(NULL,0,ThreadProc,&td,0,&dummy);
}

void EXPORT OnGameLeave(THISGAMESTRUCT* thisgame)
{
    td.Active=FALSE;

    // Wait for thread to die
    if (td.Thread)
    {
		server->GamePrintVerbose("Chicken: Waiting max 2 seconds for worker thread to exit.");
        WaitForSingleObject(td.Thread, 2000);
        server->GamePrintVerbose("Chicken: OK!");
    }
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandStart
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandStart(char** argv, int argc)
{
    if (argc!=2)
		return FALSE;

    OnGameLeave(0);
    OnGameJoin(td.thisgame);
    return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandStop
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandStop(char** argv, int argc)
{
    OnGameLeave(0);
    return TRUE;
}

BOOL PRIVATE OnGameCommandHPquit(char** argv, int argc)
{
    if (argc==2)
	    ShowHPquit();
    else if (argc==3)
    {
        HPquit = abs(atoi(argv[2]));
 	    ShowHPquit();
		sprintf(_Character, "%s", td.thisgame->player->PlayerName);
		sprintf(_Key, "%s", "HP Quit");
		sprintf(_Value, "%d", HPquit);
		server->SetHackProfileString("chicken", _Character, _Key, _Value);
    }
    else
    {
		sprintf(Msg1, "c1Syntax:c0 .chicken hp.quit <HP>");
		server->GamePrintInfo(Msg1);
    }
    return TRUE ;
}

BOOL PRIVATE OnGameCommandHPtown(char** argv, int argc)
{
    if (argc==2)
	    ShowHPtown();
    else if (argc==3)
    {
        HPtown = abs(atoi(argv[2]));
 	    ShowHPtown();
		sprintf(_Character, "%s", td.thisgame->player->PlayerName);
		sprintf(_Key, "%s", "HP Town");
		sprintf(_Value, "%d", HPtown);
		server->SetHackProfileString("chicken", _Character, _Key, _Value);
    }
    else
    {
		sprintf(Msg1, "c1Syntax:c0 .chicken hp.town <HP>");
		server->GamePrintInfo(Msg1);
    }
    return TRUE ;
}

BOOL PRIVATE OnGameCommandTP(char** argv, int argc)
{
	if ((argc != 2) || (stateGotoTown != STATE_GOTO_TOWN_IDLE)) return FALSE;
	GoToTown();
	return TRUE;
}

BOOL PRIVATE OnGameCommandHostile(char** argv, int argc)
{
    if (argc==2)
	    ShowHostile();
    else if (argc==3)
    {
        Hostile = abs(atoi(argv[2]));
		if (Hostile == 0 || Hostile == 1 || Hostile == 2)
		{
 			ShowHostile();
			sprintf(_Character, "%s", td.thisgame->player->PlayerName);
			sprintf(_Key, "%s", "Hostile");
			sprintf(_Value, "%d", Hostile);
			server->SetHackProfileString("chicken", _Character, _Key, _Value);
			return TRUE;
		}
		sprintf(Msg1, "c1Syntax:c0 .chicken hostile <0:Off 1:TP to town 2:Quit>");
		server->GamePrintInfo(Msg1);
    }
    else
    {
		sprintf(Msg1, "c1Syntax:c0 .chicken hostile <0:Off 1:TP to town 2:Quit>");
		server->GamePrintInfo(Msg1);
    }
    return TRUE ;
}

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen)
{
	// Capture Hostile Packet
	if (aPacket[0] == 0x8c && aPacket[5] == td.thisgame->player->PlayerID && aPacket[9] & 0x08)
	{
		if (Hostile==2)
		{
			HostileQuit = TRUE;
			return aLen; 
		}
		if (Hostile==1)
		{
			HostileTown = TRUE;
			return aLen;
		}
	}

	// Update HP, MP
	if (aPacket[0] == 0x95)
	{
		CurrentHP = *((WORD *)(aPacket + 1)) & 0x0FFF;
		CurrentMP = (*((WORD *)(aPacket + 3)) & 0x0FFF) << 1;
		if ((HPquit && CurrentHP) && (CurrentHP < HPquit) && stateGotoTown == STATE_GOTO_TOWN_IDLE)
		{
			ChickenQuit = TRUE;
		}
		if ((HPtown && CurrentHP) && (CurrentHP < HPtown) && stateGotoTown == STATE_GOTO_TOWN_IDLE)
		{
			ChickenTown = TRUE;
		}
	}

	// Goto town thingie
	if (stateGotoTown != STATE_GOTO_TOWN_IDLE)
	{
		//	Confirmation on switching skill
		if ((stateGotoTown == STATE_GOTO_TOWN_SWITCHING_SKILL) &&
			(aPacket[0] == 0x23) && (aPacket[7] == 0xdc) &&	(aPacket[8] == 0x00) && (aPacket[9] == 0xff) &&
			(aPacket[10] == 0xff) && (aPacket[11] == 0xff) && (aPacket[12] == 0xff))
		{
			stateGotoTown = STATE_GOTO_TOWN_USING_SKILL;
			// Do this incase we need to check position later on
			portalPos[0] = (BYTE) (td.thisgame->player->PlayerPositionX & 0xff);
			portalPos[1] = (BYTE) ((td.thisgame->player->PlayerPositionX >> 8) & 0xff);
			portalPos[2] = (BYTE) (td.thisgame->player->PlayerPositionY & 0xff);
			portalPos[3] = (BYTE) ((td.thisgame->player->PlayerPositionY >> 8) & 0xff);
			BYTE sPacket[5] = { (BYTE) 0x0c, portalPos[0], portalPos[1], portalPos[2], portalPos[3] };
			server->GameSendPacketToServer(sPacket, 5);
			DWORD dummy;
			CreateThread(NULL, 0, ResetThread, NULL,0, &dummy);
			return aLen;
		}

		//	Portal appears, walk into it
		if ((stateGotoTown == STATE_GOTO_TOWN_USING_SKILL) &&
			(aPacket[0] == 0x51) && (aPacket[1] == 0x02) && (aPacket[6] == 0x3b) && (aPacket[7] == 0x00))
		{
			stateGotoTown = STATE_GOTO_TOWN_IDLE;
			saPacket[0] = (BYTE) 0x13;
			saPacket[1] = (BYTE) 0x02;
			saPacket[2] = (BYTE) 0x00;
			saPacket[3] = (BYTE) 0x00;
			saPacket[4] = (BYTE) 0x00;
			saPacket[5] = aPacket[2];
			saPacket[6] = aPacket[3];
			saPacket[7] = aPacket[4];
			saPacket[8] = aPacket[5];
			DWORD dummy;
			CreateThread(NULL, 0, SleepThread, &saPacket,0, &dummy);
		}
	}
    return aLen;
}

DWORD WINAPI SleepThread(LPVOID lpParameter)
{
	BYTE *sPacket = (BYTE *) lpParameter;
	Sleep(150);
	server->GameSendPacketToServer(sPacket, 9);
	return 0;
}

DWORD WINAPI ResetThread(LPVOID lpParameter)
{
	Sleep(1000);
	if (stateGotoTown == STATE_GOTO_TOWN_USING_SKILL)
	{
		server->GamePrintInfo("Cannot goto town, out of portals or in town already?");
		stateGotoTown = STATE_GOTO_TOWN_IDLE;
	}
	return 0;
}

DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen)
{
	return aLen;
}

void ShowHPquit()
{
    if (HPquit)
		sprintf(Msg1, "(Quit game) HP is c2%d", HPquit);
	else
		sprintf(Msg1, "Quit game when low HP is c2OFF");
	server->GamePrintInfo(Msg1);

}

void ShowHPtown()
{
    if (HPtown)
		sprintf(Msg1, "(Town Portal) HP is c2%d", HPtown);
	else
		sprintf(Msg1, "TP to town when low HP is c1OFF");
    server->GamePrintInfo(Msg1);
}

void ShowHostile()
{
	switch (Hostile)
	{
		case 0:
		    sprintf(Msg1, "When hostiled, c1do nothing");
			break;
		case 1:
		    sprintf(Msg1, "When hostiled, c1TP to town");
			break;
		case 2:
		    sprintf(Msg1, "When hostiled, c1quit game");
			break;
		default:
		    sprintf(Msg1, "");
			break;
	}
    server->GamePrintInfo(Msg1);
}

void GoToTown()
{
	BYTE sPacket[9] = { 0x3c, 0xdc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff };

	if (stateGotoTown != STATE_GOTO_TOWN_IDLE)
		return;

	stateGotoTown = STATE_GOTO_TOWN_SWITCHING_SKILL;
	server->GameSendPacketToServer(sPacket, 9);
}

void LoadConfig()
{
	char *retval;

	// Character specific Config
	sprintf(_Character, "%s", td.thisgame->player->PlayerName);

	// Go to town HP
	sprintf(_Key, "%s", "HP Town");
	retval = server->GetHackProfileString("chicken", _Character, _Key);

	if (strlen(retval))
	{
		HPtown = atoi(retval);
		//delete retval;
	}
	else
	{
		HPtown = 0;
		sprintf(_Value, "%d", 0);
		server->SetHackProfileString("chicken", _Character, _Key, _Value);
	}

	// Quit game HP
	sprintf(_Key, "%s", "HP Quit");
	retval = server->GetHackProfileString("chicken", _Character, _Key);

	if (strlen(retval))
	{
		HPquit = atoi(retval);
		//delete retval;
	}
	else
	{
		HPquit = 0;
		sprintf(_Value, "%d", 0);
		server->SetHackProfileString("chicken", _Character, _Key, _Value);
	}

	// Hostile
	sprintf(_Key, "%s", "Hostile");
	retval = server->GetHackProfileString("chicken", _Character, _Key);

	if (strlen(retval))
	{
		Hostile = atoi(retval);
		//delete retval;
	}
	else
	{
		Hostile = 0;
		sprintf(_Value, "%d", 0);
		server->SetHackProfileString("chicken", _Character, _Key, _Value);
	}
}

void OverheadMsg(char *Msg)
{
	BYTE aPacket[512];

	sprintf((char*)aPacket, "%c%c%c%s%c%c%c", 0x14, 0x00, 0x00, Msg, 0,0,0);
	server->GameSendPacketToServer(aPacket, strlen(Msg)+6);
}

void ChatMsg(char *Msg)
{
	BYTE aPacket[512];

	sprintf((char*)aPacket, "%c%c%c%s%c%c%c", 0x15, 0x01, 0x00, Msg, 0,0,0);
	server->GameSendPacketToServer(aPacket, strlen(Msg)+6);
}

DWORD WINAPI ThreadProc(LPVOID lpParameter)
{
	THREAD_DATA *td=(THREAD_DATA*)lpParameter;
	
	BYTE *b;
	BYTE sPacket[9] = { 0x3c, 0xdc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff };

	while (td->Active)
    {
		// Chicken quit
		if (ChickenQuit)
		{
			// Say something before chicken quit (packet 0x15)
			sprintf(Msg1, "Oh it hurts!  I'm now using c1CHICKENc0 module to quit game!  Bye!");
			ChatMsg(Msg1);
			b=new BYTE[1];
			sprintf((char*)b, "%c", 0x66);
			server->GameSendPacketToServer(b, 1);
			delete b;
		}
	
		// Chicken go to town
		if (ChickenTown && stateGotoTown == STATE_GOTO_TOWN_IDLE)
		{
			sprintf(Msg1, "c1CHICKENc0: Going to TOWN!  Get heal! Otherwise this message will not stop!");
			OverheadMsg(Msg1);
			stateGotoTown = STATE_GOTO_TOWN_SWITCHING_SKILL;
			server->GameSendPacketToServer(sPacket, 9);
			ChickenTown = FALSE;
		}

		// Chicken quit
		if (HostileQuit)
		{
			// Say something before chicken quit (packet 0x15)
			sprintf(Msg1, "I hate PK! I'm now using c1CHICKENc0 module to quit game!");
			ChatMsg(Msg1);
			b=new BYTE[1];
			sprintf((char*)b, "%c", 0x66);
			server->GameSendPacketToServer(b, 1);
			delete b;
		}

		// Hostile go to town
		if (HostileTown && stateGotoTown == STATE_GOTO_TOWN_IDLE)
		{
			sprintf(Msg1, "Why hostile me? I'm now using c1CHICKENc0 module to go to TOWN!");
			ChatMsg(Msg1);
			stateGotoTown = STATE_GOTO_TOWN_SWITCHING_SKILL;
			server->GameSendPacketToServer(sPacket, 9);
			HostileTown = FALSE;
		}

		Sleep(250);

		if (!td->Active)
		{
			td->Thread=0;
			return 0;
		}
	}

	td->Thread=0;
	return 0;	
}


//////////////////////////////////////////////////////////////////////
// stuff below here is from ClientCore.cpp
//////////////////////////////////////////////////////////////////////
// Dll entry/exit
//////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	BOOL hResult = TRUE;
	char *t;
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:

			// Create server struct
			server = new FUNCTIONENTRYPOINTS;

			// Bind exported functions from server
			HMODULE hModule;
			hModule = (HMODULE)GetModuleHandle("D2HackIt");

			// Macros make this look a lot nicer :)
			BIND_TO_SERVER(GamePrintInfo);
			BIND_TO_SERVER(GamePrintError);
			BIND_TO_SERVER(GamePrintVerbose);
			BIND_TO_SERVER(GamePrintString);
			BIND_TO_SERVER(GameCommandLine);
			BIND_TO_SERVER(GameSendPacketToServer);
			BIND_TO_SERVER(GameSendPacketToGame);
			BIND_TO_SERVER(GetFingerprint);
			BIND_TO_SERVER(Intercept);
			BIND_TO_SERVER(GetHackProfileString);
			BIND_TO_SERVER(SetHackProfileString);
			BIND_TO_SERVER(GetThisgameStruct);

			// Get plugin path
			t = ConfigPath;
			if (GetModuleFileName((HINSTANCE)hModule, t, _MAX_PATH)) {
				int p=strlen(ConfigPath);
				while (p) {
						if (ConfigPath[p] == '\\')
							{ ConfigPath[p] = 0; p=0;}
						else
					p--;
				}
			}
			// initiate client
			// hResult = OnClientStart();
			break;

		case DLL_PROCESS_DETACH:
			// kill client

			// hResult = OnClientStop();

			delete server;
			break;
    }
    return hResult;
}

//////////////////////////////////////////////////////////////////////
// Stubfunctions for 'property get' functions.
//////////////////////////////////////////////////////////////////////
LPCSTR	EXPORT GetModuleAuthor()		{return ModuleAuthor;}
LPCSTR	EXPORT GetModuleWebsite()		{return ModuleWebsite;}
DWORD	EXPORT GetModuleVersion()		{return ModuleVersion;}
LPCSTR	EXPORT GetModuleEmail()			{return ModuleEmail;}
LPCSTR	EXPORT GetModuleDescription()	{return ModuleDescription;}

//////////////////////////////////////////////////////////////////////
// OnClientCommandLine
// -------------------------------------------------------------------
// The modules own extension of the command line interface. Any custom
// commands you add are parsed here.
//
// Return value should be TRUE, but it is not used at this
// time.
//
// Arguments when we get here:
// argv[0]			Name of module
// argv[1]			Name of command (If supplied)
// argv[2 ... n]	The rest
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnGameCommandLine(char* argv[], int argc)
{
	// Check if user supplied anything at all, if not assume help...
	if (argc==1)
		argv[argc++]="help";


	MODULECOMMANDSTRUCT* mcs=ModuleCommands;

	while (mcs->szName) {
		if (!stricmp(mcs->szName, argv[1]))
			break;
		mcs++;
	}

	char *p,*t,*msg,*fMsg;
	fMsg=new char[256];
	//
	// Is this a built-in function ?
	if (mcs->szName) {
		//
		// If functions returns false, show usage help
		if (!mcs->pFunc(argv, argc)) {
			t=new char[strlen(mcs->szUsage)+1];
			server->GamePrintInfo("Usage:");
			sprintf((char*)t, "%s", mcs->szUsage);
			if (strlen((char*)t))
			{
				msg=p=t;
				while (*p != 0) {
					if (*p == '\n')
					{
						*(p++) = 0;
						sprintf(fMsg, "c4.%s %s", argv[0], msg);
						server->GamePrintInfo((char*)fMsg);
					if (*p != 0)
						msg = p;
					} else
						p++;
					}
				sprintf(fMsg, "c4.%s %s", argv[0], msg);
				server->GamePrintInfo((char*)fMsg);
			}
			delete t;
		}
	}
	else {
	// Unknown command, show catch-all help phraze.
	t=new char[128];
	sprintf(t, "Unknown command c4'%s %s'c0 - try c4'.%s help'c0 to get help.",
		argv[0], argv[1], argv[0]);
	server->GamePrintError(t);
	delete t;
	}
	delete fMsg;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandHelp
// -------------------------------------------------------------------
// Our default help function.
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandHelp(char** argv, int argc)
{
	// If command line is longer than 2, show usage for 'help'
	if (argc>2) return FALSE;

	char t[1024];
	sprintf(t, "Available commands for %s:", argv[0]);
	server->GamePrintInfo(t);

	// Loop through ModuleCommands[] and print their names
	for (int i=0; ModuleCommands[i].szName != NULL; i++)
	{
		sprintf(t, "c4.%s %s", argv[0], ModuleCommands[i].szName);
		server->GamePrintInfo(t);
	}

	sprintf(t, "For help on a specific command, type c4.%s <command> help", argv[0]);
	server->GamePrintInfo(t);
	return TRUE;
}
