/*
 *	Clipboard Module for D2Hackit
 *
 *	Copyright (c) 2002 Sherpya <sherpya@hotmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../ClientCore.cpp"

///////////
BOOL PRIVATE OnGameCommandCopy(char** argv, int argc);
BOOL PRIVATE OnGameCommandPaste(char** argv, int argc);
BOOL PRIVATE OnGameCommandDump(char** argv, int argc);
HANDLE data;
char outstr[1024];


//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(0,1);
char	ModuleAuthor[]="sherpya";
char	ModuleWebsite[]="";
char	ModuleDescription[]="ClipBoard Module";
char	ModuleEmail[]="sherpya@hotmail.com";

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
// To add your own commands, just add them to this list like:
//
//	{
//		"name"			// Name of the command
//		pFunction		// The function that handles command
//		"usage"			// Help text for the command
//	}
// 
// Functions should use following convention...
// BOOL PRIVATE OnGameCommandName(char** argv, int argc)
// ...and return TRUE on success or FALSE to show usage of the command.
//
// To use your commands in the game, just type 
// .modulename <command> [arguments]
//////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{
		"copy",
		OnGameCommandCopy,
		"copy c0 Copy not yet implemented."
	},
	{
		"paste",
		OnGameCommandPaste,
		"enablec0 Paste From Clipboard."
	},
	{
		"dump",
		OnGameCommandDump,
		"debugc0 Show Clipboard."
	},
	{NULL}	// No more commands
};


//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
// Runs *once* before client is loaded. Return FALSE to prevent from
// loading.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStart()
{
	return true;
}


//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
// Runs *once* before client is unloaded. Return value should be TRUE,
// but it is not used at this time.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStop()
{
	return true;
}



//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandCopy(char** argv, int argc)
{
	return false;
}

//////////////////////////////////////////////////////////////////////
// 
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandPaste(char** argv, int argc)
{
	OpenClipboard(NULL);
	data = GetClipboardData(CF_TEXT);
	CloseClipboard();
	if (data)
	{
		sprintf(outstr, "c0Cliboard: c1%s",(char *) data);
		server->GamePrintInfo(outstr);
		server->GameCommandLine((char *) data);
	}
	else
		server->GamePrintInfo("c0Clipboard: no suitable data");

	return true;
}


BOOL PRIVATE OnGameCommandDump(char** argv, int argc)
{
	OpenClipboard(NULL);
	data = GetClipboardData(CF_TEXT);
	CloseClipboard();
	if (data)
	{
		sprintf(outstr, "c0Cliboard: c1%s",(char *) data);
		server->GamePrintInfo(outstr);
	}
	else
		server->GamePrintInfo("c0Clipboard: no suitable data");
	return true;
}