#include <windows.h>
#include "external/D2Hackit.h"
#include "external/D2Client.h"

#define dprint(a)	if(debug) server->GamePrintInfo(a)

// globals
FUNCTIONENTRYPOINTS	*server;
THISGAMESTRUCT *thisgame;
BOOL inGame = 0;
BOOL ModuleActive = 1;
BOOL debug = 1;
DWORD InventoryGold = 0;

BOOL PRIVATE OnCommandToggle(char **argv, int argc);
BOOL PRIVATE OnCommandHelp(char **argv, int argc);

#define VERSION_MAJOR	0
#define VERSION_MINOR	2

// module info
DWORD	ModuleVersion=MAKELONG(VERSION_MAJOR,VERSION_MINOR);
char	ModuleAuthor[]="syadasti";
char	ModuleWebsite[]="";
char	ModuleDescription[]="deposit";
char	ModuleEmail[]="mike@gogulski.com";

VOID PRIVATE DepositGold(DWORD amount) {
	BYTE packet[7];
	WORD g1 = 0, g2 = 0;
	memset(&packet, 0, 7);
	// build deposit packet
	packet[0] = 0x4f;
	packet[1] = 0x14;
	g2 = amount / 65536;
	g1 = amount % 65536;
	memcpy(&packet[3], &g2, 2);
	memcpy(&packet[5], &g1, 2);
	server->GameSendPacketToServer(packet, 7); }

// module commands
MODULECOMMANDSTRUCT ModuleCommands[]= {
	{ "toggle", OnCommandToggle,
		"togglec0 toggles module on/off.\n" },
	{ "help", OnGameCommandHelp,
		"helpc0 displays this helpful text.\n" },
	{NULL} };

BOOL PRIVATE OnCommandToggle(char **argv, int argc) {
	
	ModuleActive = 1 - ModuleActive;
	server->GamePrintInfo(ModuleActive ? "deposit: Module active" : "deposit: Module inactive");
	return true; }

// functions called by d2hackit
BOOL EXPORT OnClientStart() {
	return true; }

BOOL EXPORT OnClientStop() {
	return true; }

VOID EXPORT OnGameJoin(THISGAMESTRUCT* aThisgame) {
	thisgame = aThisgame;
	InventoryGold = 0;
	inGame = 1; }

VOID EXPORT OnGameLeave(THISGAMESTRUCT* aThisgame) {
	inGame = 0; }

// is run ~every 1/10th a second
DWORD EXPORT OnGameTimerTick(void) {
	return true; }

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen) {

	if (aPacket[0] == 0x1d && aPacket[1] == 0x0e) {		// inventory gold BYTE update
		BYTE gTmp;
		memcpy(&gTmp, &aPacket[2], sizeof(BYTE));
		InventoryGold = (DWORD)gTmp;
		return aLen; }

	if (aPacket[0] == 0x1e && aPacket[1] == 0x0e) {		// inventory gold WORD update
		WORD gTmp;
		memcpy(&gTmp, &aPacket[2], sizeof(WORD));
		InventoryGold = (DWORD)gTmp;
		return aLen; }

	if (aPacket[0] == 0x1f && aPacket[1] == 0x0e) {		// inventory gold DWORD update
		DWORD gTmp;
		memcpy(&gTmp, &aPacket[2], sizeof(DWORD));
		InventoryGold = (DWORD)gTmp;
		return aLen; }

	if (ModuleActive && inGame && InventoryGold > 0 &&
		aPacket[0]==0x77 && aPacket[1]==0x10) {	// opening stash
		DepositGold(InventoryGold);
		dprint("deposit: gold deposited to stash");
		return aLen; }

	return aLen; }

// 
// stuff below here is from ClientCore.cpp
//////////////////////////////////////////////////////////////////////
// Dll entry/exit
//////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	BOOL hResult = TRUE;
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			
			// Create server struct			
			server = new FUNCTIONENTRYPOINTS; 

			// Bind exported functions from server
			HMODULE hModule;
			hModule = (HMODULE)GetModuleHandle("D2HackIt");
			
			// Macros make this look a lot nicer :)
			BIND_TO_SERVER(GamePrintInfo);
			BIND_TO_SERVER(GamePrintError);
			BIND_TO_SERVER(GamePrintVerbose);
			BIND_TO_SERVER(GamePrintString);
			BIND_TO_SERVER(GameCommandLine);
			BIND_TO_SERVER(GameSendPacketToServer);
			BIND_TO_SERVER(GameSendPacketToGame);
			BIND_TO_SERVER(GetFingerprint);
			BIND_TO_SERVER(Intercept);
			BIND_TO_SERVER(GetHackProfileString);
			BIND_TO_SERVER(SetHackProfileString);
			BIND_TO_SERVER(GetThisgameStruct);

			// initiate client
			// hResult = OnClientStart();
			break;

		case DLL_PROCESS_DETACH:
			// kill client

			// hResult = OnClientStop();

			delete server;
			break;
    } 
    return hResult;
}

//////////////////////////////////////////////////////////////////////
// Stubfunctions for 'property get' functions.
//////////////////////////////////////////////////////////////////////
LPCSTR	EXPORT GetModuleAuthor()		{return ModuleAuthor;}
LPCSTR	EXPORT GetModuleWebsite()		{return ModuleWebsite;}
DWORD	EXPORT GetModuleVersion()		{return ModuleVersion;}
LPCSTR	EXPORT GetModuleEmail()			{return ModuleEmail;}
LPCSTR	EXPORT GetModuleDescription()	{return ModuleDescription;}

//////////////////////////////////////////////////////////////////////
// OnClientCommandLine
// -------------------------------------------------------------------
// The modules own extension of the command line interface. Any custom
// commands you add are parsed here.
//
// Return value should be TRUE, but it is not used at this 
// time.
//
// Arguments when we get here:
// argv[0]			Name of module
// argv[1]			Name of command (If supplied)
// argv[2 ... n]	The rest
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnGameCommandLine(char* argv[], int argc)
{
	// Check if user supplied anything at all, if not assume help...
	if (argc==1)
		argv[argc++]="help";


	MODULECOMMANDSTRUCT* mcs=ModuleCommands;

	while (mcs->szName) {
		if (!stricmp(mcs->szName, argv[1]))
			break;
		mcs++;
	}

	char *p,*t,*msg,*fMsg;
	fMsg=new char[256];
	//
	// Is this a built-in function ?
	if (mcs->szName) {
		//
		// If functions returns false, show usage help
		if (!mcs->pFunc(argv, argc)) {
			t=new char[strlen(mcs->szUsage)+1];
			server->GamePrintInfo("Usage:");
			sprintf((char*)t, "%s", mcs->szUsage);
			if (strlen((char*)t))
			{
				msg=p=t;
				while (*p != 0) {
					if (*p == '\n') 
					{
						*(p++) = 0;
						sprintf(fMsg, "c4.%s %s", argv[0], msg);
						server->GamePrintInfo((char*)fMsg);
					if (*p != 0)
						msg = p;
					} else
						p++;
					}
				sprintf(fMsg, "c4.%s %s", argv[0], msg);
				server->GamePrintInfo((char*)fMsg);
			}
			delete t;
		}
	} else {
	// Unknown command, show catch-all help phraze.
	t=new char[128];
	sprintf(t, "Unknown command c4'%s %s'c0 - try c4'.%s help'c0 to get help.",
		argv[0], argv[1], argv[0]);
	server->GamePrintError(t);
	delete t;
	}
	delete fMsg;
	return TRUE;
}


//////////////////////////////////////////////////////////////////////
// OnClientCommandHelp
// -------------------------------------------------------------------
// Our default help function.
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandHelp(char** argv, int argc)
{
	// If command line is longer than 2, show usage for 'help'
	if (argc>2) return FALSE;

	char t[1024];
	sprintf(t, "Available commands for %s:", argv[0]);
	server->GamePrintInfo(t);

	// Loop through ModuleCommands[] and print their names
	for (int i=0; ModuleCommands[i].szName != NULL; i++)
	{
		sprintf(t, "c4.%s %s", argv[0], ModuleCommands[i].szName);
		server->GamePrintInfo(t);
	}

	sprintf(t, "For help on a specific command, type c4.%s <command> help", argv[0]);
	server->GamePrintInfo(t);
	return TRUE;
}
