//////////////////////////////////////////////////////////////////////
// fake.cpp - Fake Client Info by Maulei (jonathanwu@hongkong.com)
// -------------------------------------------------------------------
// This module sends fake info to your D2 client.  You can use it to
// take a real screen shot in closed realm with fake info
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Version History
//
// Ver.  Date       Details
// -------------------------------------------------------------------
// 1.00  19-Jan-02  Fake stats, resistances, skills, level
//////////////////////////////////////////////////////////////////////

#include "..\ClientCore.cpp"	  // Include the backend of the module

//////////////////////////////////////////////////////////////////////
// CLIENTINFO
//////////////////////////////////////////////////////////////////////
DWORD   ModuleVersion=MAKELONG(1, 0);
char    ModuleAuthor[]="Maulei";
char    ModuleWebsite[]="jonathan.makes.it";
char    ModuleDescription[]="Fake Info - fakes client statistics";
char    ModuleEmail[]="jonathanwu@hongkong.com";

//////////////////////////////////////////////////////////////////////
// Function Definition
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandStr(char** argv, int argc);
BOOL PRIVATE OnGameCommandDex(char** argv, int argc);
BOOL PRIVATE OnGameCommandVit(char** argv, int argc);
BOOL PRIVATE OnGameCommandNrg(char** argv, int argc);
BOOL PRIVATE OnGameCommandHPMP(char** argv, int argc);
BOOL PRIVATE OnGameCommandRES(char** argv, int argc);
BOOL PRIVATE OnGameCommandRESmax(char** argv, int argc);
BOOL PRIVATE OnGameCommandStatPt(char** argv, int argc);
BOOL PRIVATE OnGameCommandSkillPt(char** argv, int argc);
BOOL PRIVATE OnGameCommandBaseSkills(char** argv, int argc);
BOOL PRIVATE OnGameCommandAddSkills(char** argv, int argc);
BOOL PRIVATE OnGameCommandMinusSkills(char** argv, int argc);
BOOL PRIVATE OnGameCommandLvl(char** argv, int argc);

void CommandError();
void CommandDone();

//////////////////////////////////////////////////////////////////////
// Global Variables
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BYTE aBYTE;
WORD aWORD;
DWORD aDWORD;
char Msg[256];
BYTE HPMPpacket[13];
THISGAMESTRUCT *thisgame;
WORD SkillOffset[7] = { 6, 36, 66, 96, 126, 221, 251 };
BOOL fake;

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{
		"str",
		OnGameCommandStr,
		"str <strength>c0 Set strength. Range: 0~65535"
	},
	{
		"dex",
		OnGameCommandDex,
		"dex <dexterity>c0 Set dexterity.  Range: 0~65535"
	},
	{
		"vit",
		OnGameCommandVit,
		"vit <vitality>c0 Set vitality.  Range: 0~65535"
	},
	{
		"nrg",
		OnGameCommandNrg,
		"nrg <energy>c0 Set energy.  Range: 0~65535"
	},
	{
		"hpmp",
		OnGameCommandHPMP,
		"hpmp <life> <mana> c0 Set HP and MP.  Range: 0~32767"
	},
	{
		"res",
		OnGameCommandRES,
		"res <resistance>c0 Set resistances.  Range: 0~255"
	},
	{
		"res.max",
		OnGameCommandRESmax,
		"res.max <max resistance>c0 Set max resistances.  Range: 0~255"
	},
	{
		"stat.pt",
		OnGameCommandStatPt,
		"stat.pt <stat point>c0 Set available stats.  Range: 0~65535"
	},
	{
		"skill.pt",
		OnGameCommandSkillPt,
		"skill.pt <skill point>c0 Set available skill points.  Range: 0~65535"
	},
	{
		"lvl",
		OnGameCommandLvl,
		"lvl <level> c0 set level.  Range: 0~65535"
	},
	{
		"skills",
		OnGameCommandBaseSkills,
		"skills c0 Set all base skill levels.  Range: 0~20"
	},
	{
		"+skills",
		OnGameCommandAddSkills,
		"skills c0 Set +x all skill levels.  Range: 1~999"
	},
	{
		"-skills",
		OnGameCommandMinusSkills,
		"skills c0 Set -x all skill levels.  Range: 1~999"
	},
	{NULL}	// No more commands
};

//////////////////////////////////////////////////////////////////////
// OnClientStart
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStart()
{
	memset(HPMPpacket, 0, 13);
	fake = FALSE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameJoin
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameJoin(THISGAMESTRUCT* athisgame)
{
	thisgame = athisgame;
	memset(HPMPpacket, 0, 13);
	fake = FALSE;

	return;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeSent
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen)
{
	return aLen;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeReceived
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen)
{
	if (fake)
	{
		if (aPacket[0] == 0x95)
		{
			if (HPMPpacket[0] == 0x95)
				memcpy(aPacket, HPMPpacket, aLen);
			else
				server->GamePrintInfo("fake: HP & MP not setup");
		}
	}

	return aLen;
}

BOOL PRIVATE OnGameCommandStr(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x00, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandDex(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x02, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandVit(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x03, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandNrg(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x01, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandHPMP(char** argv, int argc)
{
	BYTE p[13];
	if (argc==4)
	{
		// Max HP
		aWORD = abs(atoi(argv[2]));
		if (aWORD > 32767)
		{
			CommandError();
			return FALSE;
		}
		p[0] = 0x1F;
		p[1] = 0x07;
		p[2] = 0x00;
		p[3] = aWORD & 0xFF;
		p[4] = aWORD >> 8;
		p[5] = 0x00;
		server->GameSendPacketToGame(p, 6);
		// Max MP
		aWORD = abs(atoi(argv[3]));
		if (aWORD > 32767)
		{
			CommandError();
			return FALSE;
		}
		p[0] = 0x1F;
		p[1] = 0x09;
		p[2] = 0x00;
		p[3] = aWORD & 0xFF;
		p[4] = aWORD >> 8;
		p[5] = 0x00;
		server->GameSendPacketToGame(p, 6);
		// HP & MP
		memset(p, 0, 13);
		p[0] = 0x95;
		aWORD = abs(atoi(argv[2]));
		p[1] = aWORD & 0xFF;
		p[2] = aWORD >> 8;
		aWORD = abs(atoi(argv[3])/2);
		p[3] = aWORD & 0xFF;
		p[4] = aWORD >> 8;
		p[5] = aWORD & 0xFF;
		p[6] = aWORD >> 8;
		fake = FALSE;		
		server->GameSendPacketToGame(p, 13);
		fake = TRUE;
		memcpy(HPMPpacket, p, 13);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandRES(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x00, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		p[1] = 39;
		server->GameSendPacketToGame(p, 4);
		p[1] = 41;
		server->GameSendPacketToGame(p, 4);
		p[1] = 43;
		server->GameSendPacketToGame(p, 4);
		p[1] = 45;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandRESmax(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x00, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		p[1] = 40;
		server->GameSendPacketToGame(p, 4);
		p[1] = 42;
		server->GameSendPacketToGame(p, 4);
		p[1] = 44;
		server->GameSendPacketToGame(p, 4);
		p[1] = 46;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandStatPt(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x04, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandSkillPt(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x05, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandLvl(char** argv, int argc)
{
	BYTE p[4] = { 0x1E, 0x00, 0x00, 0x00 };
	if (argc==3)
	{
		aWORD = abs(atoi(argv[2]));
		p[1] = 12;
		p[2] = aWORD & 0xFF;
		p[3] = aWORD >> 8;
		server->GameSendPacketToGame(p, 4);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandBaseSkills(char** argv, int argc)
{
	BYTE p[12] = { 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6F };
	WORD skill;

	aWORD = abs(atoi(argv[2]));
	p[3] = thisgame->player->PlayerID;
	if (argc==3 && aWORD <= 20)
	{
		for (int i=0; i<30; i++)
		{
			skill = SkillOffset[thisgame->player->CharacterClass] + i;
			p[7]  = skill & 0xFF;
			p[8]  = skill >> 8;
			p[9]  = aWORD & 0xFF;
			p[10] = aWORD >> 8;
			server->GameSendPacketToGame(p, 12);
		}
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandAddSkills(char** argv, int argc)
{
	BYTE p[8] = { 0x93, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04 };

	aWORD = abs(atoi(argv[2]));
	p[1] = thisgame->player->PlayerID;
	if (argc==3 && aWORD <= 999 && aWORD > 0)
	{
		for (int i=0; i<aWORD; i++)
			server->GameSendPacketToGame(p, 8);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

BOOL PRIVATE OnGameCommandMinusSkills(char** argv, int argc)
{
	BYTE p[8] = { 0x93, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x04 };

	aWORD = abs(atoi(argv[2]));
	p[1] = thisgame->player->PlayerID;
	if (argc==3 && aWORD <= 999 && aWORD > 0)
	{
		for (int i=0; i<aWORD; i++)
			server->GameSendPacketToGame(p, 8);
		CommandDone();
		return TRUE;
	}
	CommandError();
	return FALSE ;
}

void CommandError()
{
	server->GamePrintError("fake: c1Command errorc0");
}

void CommandDone()
{
	server->GamePrintInfo("fake: Done");
}
