//////////////////////////////////////////////////////////////////////
// FASTWP MODULE
// by Gayak.
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
#include "..\Clientcore.cpp"

//////////////////////////////////////////////////////////////////////
// Global stuff.
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
THISGAMESTRUCT* thisgame;

BOOL PRIVATE OnGameCommand1(char** argv, int argc);
BOOL PRIVATE OnGameCommand2(char** argv, int argc);
BOOL PRIVATE OnGameCommand3(char** argv, int argc);
BOOL PRIVATE OnGameCommand4(char** argv, int argc);
BOOL PRIVATE OnGameCommand5(char** argv, int argc);
BOOL PRIVATE OnGameCommandTown(char** argv, int argc);
BOOL PRIVATE OnGameCommandClear(char** argv, int argc);
DWORD GetDistanceSquared(DWORD x1, DWORD y1, DWORD x2, DWORD y2);
BOOL PRIVATE checkiftaken(WORD f, WORD g);
VOID PRIVATE whole(int wh, int wj);
VOID PRIVATE clear();

int currentact=0;

LinkedList *Objects = new LinkedList;

typedef struct ItemStruct_t {
	WORD x;
	WORD y;
	BYTE id[4];	
} OBJ;

BYTE act[5][9]={
	{0x01,0x03,0x04,0x05,0x06,0x1b,0x1d,0x20,0x23},
	{0x28,0x30,0x2a,0x39,0x2b,0x2c,0x34,0x4a,0x2e},
	{0x4b,0x4c,0x4d,0x4e,0x4f,0x50,0x51,0x53,0x65},
	{0x67,0x6a,0x6b,0x00,0x00,0x00,0x00,0x00,0x6c}, //6c is a dummy used for town command.
	{0x6d,0x6f,0x70,0x71,0x73,0x7b,0x75,0x76,0x81}};


//////////////////////////////////////////////////////////////////////
// CLIENTINFO
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(2,1);
char	ModuleAuthor[]="Gayak";
char	ModuleWebsite[]="Gayak.50megs.com";
char	ModuleDescription[]="It warps to a waypoint using objects on the map.";
char	ModuleEmail[]="170@guyau.qc.ca";

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
MODULECOMMANDSTRUCT ModuleCommands[]= {
	{"help",OnGameCommandHelp,"helpc0 List commands available in this module.\n""<command> helpc0 Shows detailed help for <command> in this module."},

	{"1",OnGameCommand1,"1 [wp number]c0 It goes to a wp in act 1. If no number is typed, it goes to town."},
	{"2",OnGameCommand2,"2 [wp number]c0 It goes to a wp in act 2. If no number is typed, it goes to town."},
	{"3",OnGameCommand3,"3 [wp number]c0 It goes to a wp in act 3. If no number is typed, it goes to town."},
	{"4",OnGameCommand4,"4 [wp number]c0 It goes to a wp in act 4. If no number is typed, it goes to town."},
	{"5",OnGameCommand5,"5 [wp number]c0 It goes to a wp in act 5. If no number is typed, it goes to town."},
	{"town",OnGameCommandTown,"townc0 It goes to the first wp of the current act."},
	{"clear",OnGameCommandClear,"clearc0 It clears fastwp database."},
	{NULL}	// No more commands
};


BOOL PRIVATE OnGameCommand1(char** argv, int argc) {
	if (argc>2 && atoi(argv[2])<=9){whole(1,atoi(argv[2]));}
	else {whole(1,1);}
	return true;
}

BOOL PRIVATE OnGameCommand2(char** argv, int argc) {
	if (argc>2 && atoi(argv[2])<=9){whole(2,atoi(argv[2]));}
	else {whole(2,1);}
	return true;
}

BOOL PRIVATE OnGameCommand3(char** argv, int argc) {
	if (argc>2 && atoi(argv[2])<=9){whole(3,atoi(argv[2]));}
	else {whole(3,1);}
	return true;
}

BOOL PRIVATE OnGameCommand4(char** argv, int argc) {
	if (argc>2 && atoi(argv[2])<=3){whole(4,atoi(argv[2]));}
	else {whole(4,1);}
	return true;
}

BOOL PRIVATE OnGameCommand5(char** argv, int argc) {
	if (argc>2 && atoi(argv[2])<=9){whole(5,atoi(argv[2]));}
	else {whole(5,1);}
	return true;
}

BOOL PRIVATE OnGameCommandTown(char** argv, int argc) {
	if (thisgame->player->PlayerLocation==5) {server->GamePrintInfo("You already are in town.");}
	else {whole(currentact,1);}
	return true;
}

BOOL PRIVATE OnGameCommandClear(char** argv, int argc) {
	clear();
	server->GamePrintInfo("c3Cleared fastwp database.");
	return true;
}

//////////////////////////////////////////////////////////////////////
// OnGameJoin
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameJoin(THISGAMESTRUCT* aThisgame) {
	thisgame = aThisgame;
	return;
}
VOID EXPORT OnGameLeave(THISGAMESTRUCT* aThisgame) {
	clear();
	return;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeReceived
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen) {
    OBJ *object = new OBJ;
	WORD temp[2];

	// 51 PACKET : 51 02 ID ID ID ID -- -- XX XX YY YY -- --
	if (aPacket[0] == 0x51 && aPacket[1] == 0x02) {
		memcpy(&temp[0],&aPacket[8],2);
		memcpy(&temp[1],&aPacket[10],2);

		if (checkiftaken(temp[0],temp[1])) {
			object->x=temp[0];
			object->y=temp[1];
			memcpy(&object->id,&aPacket[2],2);
			Objects->AddItem(object);
		}
	}

	if (aPacket[0]==0x07) {
		for (int x=0; x<5; x++) {
			if( aPacket[5]>=act[x][0] && aPacket[5]<=act[x][8]) {
				currentact=x+1;
			}
		}
	}
return aLen;
}

///////////////////////////////////////////////////////////////////
// Heres the job.
///////////////////////////////////////////////////////////////////
BOOL PRIVATE checkiftaken(WORD f, WORD g) {
	BOOL b=1;
    LinkedItem *linkedobj;
    OBJ *object = new OBJ;

    for(linkedobj = Objects->GetFirstItem();linkedobj != NULL;linkedobj = Objects->GetNextItem(linkedobj)) {
		if(object->x==f && object->y==g){b=0;}
	}
	return b;
}

DWORD GetDistanceSquared(DWORD x1, DWORD y1, DWORD x2, DWORD y2) {
        return ( ((x1 - x2) * (x1 - x2)) + ((y1 - y2) * (y1 - y2)));
}

VOID PRIVATE whole(int wh, int wj) {
	LinkedItem *linkedobj;
	BOOL found=FALSE;

    for(linkedobj = Objects->GetFirstItem();linkedobj != NULL;linkedobj = Objects->GetNextItem(linkedobj)) {
		if (GetDistanceSquared(thisgame->player->PlayerPositionX,thisgame->player->PlayerPositionY,((OBJ*)linkedobj->lpData)->x,((OBJ*)linkedobj->lpData)->y) <= 10*10 && !found && (OBJ*)linkedobj->lpData!=NULL ) {
			BYTE wp[9]={0x49,0,0,0,0,act[wh-1][wj-1],0,0,0};
			memcpy(wp+1, ((OBJ*)linkedobj->lpData)->id,4);
			server->GameSendPacketToServer(wp,9);
			found=TRUE;
		}
	}
	if(!found){server->GamePrintInfo("There is no objects close enough.");}
}

VOID PRIVATE clear() {
	LinkedItem *linkedobj;
    for(linkedobj = Objects->GetFirstItem();linkedobj != NULL;linkedobj = Objects->GetNextItem(linkedobj)) {
		if ((OBJ*)linkedobj->lpData!=NULL){delete (OBJ*)linkedobj->lpData;}
	}
}

// That's it... Wasn't that tough!!!
// Have fun. Gayak.