// gbot.cpp g0llum2002@yahoo.com
#include "gbot.h"
#include "item.h"
#include "packethelper.h"

WORD Debug;
WORD DevelDebug;
WORD state;
NPCSTRUCT npc;
FUNCTIONENTRYPOINTS     *server;
char ConfigPath[_MAX_PATH];
char DebugBuffer[1024];

char target_item[16];
DWORD item_cost = 1;  //this value doesn't seem to matter
DWORD gold = 0;
WORD num_to_buy;
WORD num_rares;
WORD iter;
WORD shop_ticks = 5;

BOOL SetNPC = false;
BOOL HaveSync = false;
DWORD tick = 0;

// module info
DWORD	ModuleVersion=MAKELONG(VERSION_MAJOR,VERSION_MINOR);
char	ModuleAuthor[]="g0llum";
char	ModuleWebsite[]="www.geocities.com/g0llum2002";
char	ModuleDescription[]="gbot for Diablo2 LOD";
char	ModuleEmail[]="g0llum2002@yahoo.com";

// module commands
MODULECOMMANDSTRUCT ModuleCommands[]= {
    {  "debug", OnCommandDebug,
	"debug c0 toggle debug mode." },

    {	"develdebug", OnCommandDevelDebug,
	"debug c0 Developer's mode debug toggle." },

    {   "setnpc", OnCommandSetNPC,
	"setnpcc0 used to set which npc to tade with.\n"
	"run this command then click on the npc." },

    {   "setcost", OnCommandSetCost,
	"setcost [cost]c0 used to set the item cost of\n"
	"the item type for which you are gambling." },

    {   "setshopticks", OnCommandSetShopTicks,
	"setshopticks [num ticks]c0 Sets the amount of time to keep the shop open\n"
	"Default is approximately 1 second." },

    {   "help", OnCommandHelp,
	"setnpcc0 help!?" },

    {   "buy", OnCommandBuy,
	"buy [itemcode] [max] c0 start the bot" },

    {   "stop", OnCommandStop,
	"stopc0 stop the bot" },
    {NULL}
};

// module command functions
BOOL PRIVATE OnCommandDebug(char **argv, int argc) {
    if(Debug) {
	server->GamePrintString("Debugging disabled");
	Debug = false; }
    else {
	server->GamePrintString("Debugging enabled");
	Debug = true; }
    return true; }

BOOL PRIVATE OnCommandDevelDebug(char **argv, int argc) {
    if(DevelDebug) {
	server->GamePrintString("Developer Debugging disabled");
	Debug = false;
	DevelDebug = false; }
    else {
	server->GamePrintString("Developer Debugging enabled");
	Debug = true; 
	DevelDebug = true; }
    return true; }

BOOL PRIVATE OnCommandSetNPC(char **argv, int argc) {
    SetNPC = true;
    server->GamePrintString("SetNPC Enabled.  Go click on NPC to shop with");
    return true; }

BOOL PRIVATE OnCommandSetShopTicks(char **argv, int argc) {
    if (argc != 3) { 
	server->GamePrintString("setshopticks requires exactly one argument"); }
    else {
	shop_ticks = atoi(argv[2]); }
    return true; }

BOOL PRIVATE OnCommandSetCost(char **argv, int argc) {
    if (argc != 3) { 
	server->GamePrintString("setcost requires exactly one argument"); }
    else {
	item_cost = atol(argv[2]);
	sprintf(DebugBuffer,"item_cost set to %ld",item_cost);
	server->GamePrintString(DebugBuffer);	 }
    return true; }

BOOL PRIVATE OnCommandBuy(char **argv, int argc) {
    if (argc != 5) {
	server->GamePrintString("Need exactly three arguments to start gbot");
	return true; }
    else {
	server->GamePrintString("Starting gbot");
        strcpy(target_item, argv[2]);
	num_rares = atoi(argv[3]);
	num_to_buy = atoi(argv[4]);
        iter = 1; 	
	gold = -1; //do this so we will get a gold update when we open the shop
	state = STATE_OPENSHOP;
	tick = 0;
	return true; } }

BOOL PRIVATE OnCommandStop(char **argv, int argc) {
    state = STATE_NONE;
    server->GamePrintString("Stopping gamblebot");
    return true; }

BOOL EXPORT OnClientJoinGame() {
    tick = 0;
    state = STATE_NONE;
    return true; }

// functions called by d2hackit
BOOL EXPORT OnClientStart() { return true; }

// outgoing packet
DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen) {
    // dump packet if packet debugging is on
    if(DevelDebug) {
	sprintf(DebugBuffer,"%s","SENT: ");
	for(int i = 0;i < aLen;i++) {
	    sprintf(DebugBuffer,"%s %.2x",DebugBuffer,aPacket[i]); }
	server->GamePrintInfo(DebugBuffer); }

    // setting npc
    if(SetNPC) {
	if(aPacket[0] == 0x13 && aPacket[1] == 0x01) {
	    memcpy(&npc.npcID,&aPacket[5],4);
	    npc.pos.x = 0;
	    npc.pos.y = 0;
	    SetNPC = false;
	    if(Debug) {
		sprintf(DebugBuffer,"NPC set to id: %d",npc.npcID);
		server->GamePrintString(DebugBuffer); }
	    else { server->GamePrintString("NPC is now set"); } } }

    return aLen; }

// incoming packet
DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen) {

    // dump packet if packet debugging is on
    if(DevelDebug) {
	sprintf(DebugBuffer,"%s","RECV: ");
	for(int i = 0;i < aLen;i++) {
	    sprintf(DebugBuffer,"%s %.2x",DebugBuffer,aPacket[i]); }
	server->GamePrintInfo(DebugBuffer); }

    else if(aPacket[0] == 0x6d) {  // npc update
	if(npc.npcID != 0) {
	    WORD npcID;
	    memcpy(&npcID,&aPacket[1],4);
	    // see if this is our npc
	    if(npc.npcID == npcID) {
		memcpy(&npc.pos.x,&aPacket[5],2);
		memcpy(&npc.pos.y,&aPacket[7],2);
		if(DevelDebug) {
		    sprintf(DebugBuffer,"Got NPC loc update (%d,%d)",npc.pos.x,npc.pos.y);
		    server->GamePrintString(DebugBuffer); } } } }

    else if (state == STATE_NONE) { return aLen; }

    else if(aPacket[0] == 0x9c && state == STATE_WAITSHOP) { //item drop packets
	ITEMSTRUCT *item;
	item = ParseItemDrop(aPacket,aLen);
	if(Debug && item != NULL) {
	    DumpItemStruct(item);
	    server->GamePrintInfo(DebugBuffer); } 
	        
	if (item != NULL && strcmp(item->ItemCode,target_item) == 0) {
	    //We found an item in the shop that we
	    //wanted, so we should change the state
	    //and buy it
	    sprintf(DebugBuffer,"Buying item id %d (%s)...",item->ItemID,item->ItemCode);
	    server->GamePrintInfo(DebugBuffer);
	    state = STATE_CLOSESHOP;
	    BuyItem(item->ItemID,npc.npcID,item_cost);
	    num_to_buy--;
	    tick = 0; } } 

    else if(aPacket[0] == 0x9d && aPacket[1] == 0x15) {
	ITEMSTRUCT *item;
	item = Parse9D(aPacket,aLen);
	if (item != NULL) {
	    if (item->ItemLevel == 4) {
		// we just have a magic item, so we sell it back
	        sprintf(DebugBuffer,"Item quality is magical. Selling item back...");
	        server->GamePrintInfo(DebugBuffer);
		PickupItem(item->ItemID);
		SellItem(item->ItemID,npc.npcID,1); }
	    else {
	        sprintf(DebugBuffer,"Item quality is RARE. Keeping item...");
	        server->GamePrintInfo(DebugBuffer);
		num_rares--; } } }


    //else if(aPacket[0] == 0x2a) {  // gold update 
	//DWORD oldgold = gold;
	//memcpy(&gold,&aPacket[11],4);
	//if (gold != oldgold) {
	    //sprintf(DebugBuffer,"Gold update: %ld", gold);
	    //server->GamePrintString(DebugBuffer); } }

    return aLen; }

// is run ~every 1/10th a second
DWORD EXPORT OnGameTimerTick(void) {
    tick++;
    if (state == STATE_NONE) {
	tick = 0;
	return true; }
    else if(tick > 100) {
	// if we have been in a state for more then 10 seconds something is wrong
	server->GamePrintString("I am lost.  Disabling gamblebot");
	state = STATE_NONE;
	return true; }
    else { switch(state) {

	    case STATE_OPENSHOP:
		if(tick > 3) {
                    sprintf(DebugBuffer, "Opening Store (iter: %d, rares_left: %d, num_to_buy: %d)",
			    iter, num_rares, num_to_buy);
		    server->GamePrintString(DebugBuffer);
		    state = STATE_WAITSHOP;
		    OpenStore(npc.npcID,npc.pos.x,npc.pos.y);
		    iter++;
		    tick = 0; }
		break;

	    case STATE_WAITSHOP:
		if(tick > shop_ticks) {
		    state = STATE_CLOSESHOP;
		    tick = 0; }
		break;

	    case STATE_CLOSESHOP:
		if (tick > 4) {
		    if(DevelDebug) {
			server->GamePrintString("Closing Store with NPC"); }
		    CloseStore(npc.npcID);

		    if (num_to_buy <= 0) {
	                sprintf(DebugBuffer,"Terminating since we have bought the maximum number of items.");
			server->GamePrintString(DebugBuffer);
			state = STATE_NONE; } 
		    else if (num_rares <= 0) {
	                sprintf(DebugBuffer,"Terminating since we have the number of rares we wanted.");
			server->GamePrintString(DebugBuffer);
			state = STATE_NONE; }
		    else { 
			state = STATE_OPENSHOP; tick = 0;} }
		break; 
			
	    default:
		break; } }
    return true; }

// stuff below here is from ClientCore.cpp
//////////////////////////////////////////////////////////////////////
// Dll entry/exit
//////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	BOOL hResult = TRUE;
	char *t;
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			
			// Create server struct			
			server = new FUNCTIONENTRYPOINTS; 

			// Bind exported functions from server
			HMODULE hModule;
			hModule = (HMODULE)GetModuleHandle("D2HackIt");
			
			// Macros make this look a lot nicer :)
			BIND_TO_SERVER(GamePrintInfo);
			BIND_TO_SERVER(GamePrintError);
			BIND_TO_SERVER(GamePrintVerbose);
			BIND_TO_SERVER(GamePrintString);
			BIND_TO_SERVER(GameCommandLine);
			BIND_TO_SERVER(GameSendPacketToServer);
			BIND_TO_SERVER(GameSendPacketToGame);
			BIND_TO_SERVER(GetFingerprint);
			BIND_TO_SERVER(Intercept);
			BIND_TO_SERVER(GetHackProfileString);
			BIND_TO_SERVER(SetHackProfileString);
			BIND_TO_SERVER(GetThisgameStruct);

			// Get plugin path
			t = ConfigPath;
			if (GetModuleFileName((HINSTANCE)hModule, t, _MAX_PATH)) {
				int p=strlen(ConfigPath);
				while (p) {
						if (ConfigPath[p] == '\\')
							{ ConfigPath[p] = 0; p=0;}
						else
					p--;
				}
			}	 
			// initiate client
			// hResult = OnClientStart();
			break;

		case DLL_PROCESS_DETACH:
			// kill client

			// hResult = OnClientStop();

			delete server;
			break;
    } 
    return hResult;
}

//////////////////////////////////////////////////////////////////////
// Stubfunctions for 'property get' functions.
//////////////////////////////////////////////////////////////////////
LPCSTR	EXPORT GetModuleAuthor()		{return ModuleAuthor;}
LPCSTR	EXPORT GetModuleWebsite()		{return ModuleWebsite;}
DWORD	EXPORT GetModuleVersion()		{return ModuleVersion;}
LPCSTR	EXPORT GetModuleEmail()			{return ModuleEmail;}
LPCSTR	EXPORT GetModuleDescription()	{return ModuleDescription;}

//////////////////////////////////////////////////////////////////////
// OnClientCommandLine
// -------------------------------------------------------------------
// The modules own extension of the command line interface. Any custom
// commands you add are parsed here.
//
// Return value should be TRUE, but it is not used at this 
// time.
//
// Arguments when we get here:
// argv[0]			Name of module
// argv[1]			Name of command (If supplied)
// argv[2 ... n]	The rest
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnGameCommandLine(char* argv[], int argc)
{
	// Check if user supplied anything at all, if not assume help...
	if (argc==1)
		argv[argc++]="help";


	MODULECOMMANDSTRUCT* mcs=ModuleCommands;

	while (mcs->szName) {
		if (!stricmp(mcs->szName, argv[1]))
			break;
		mcs++;
	}

	char *p,*t,*msg,*fMsg;
	fMsg=new char[256];
	//
	// Is this a built-in function ?
	if (mcs->szName) {
		//
		// If functions returns false, show usage help
		if (!mcs->pFunc(argv, argc)) {
			t=new char[strlen(mcs->szUsage)+1];
			server->GamePrintInfo("Usage:");
			sprintf((char*)t, "%s", mcs->szUsage);
			if (strlen((char*)t))
			{
				msg=p=t;
				while (*p != 0) {
					if (*p == '\n') 
					{
						*(p++) = 0;
						sprintf(fMsg, "c4.%s %s", argv[0], msg);
						server->GamePrintInfo((char*)fMsg);
					if (*p != 0)
						msg = p;
					} else
						p++;
					}
				sprintf(fMsg, "c4.%s %s", argv[0], msg);
				server->GamePrintInfo((char*)fMsg);
			}
			delete t;
		}
	} else {
	// Unknown command, show catch-all help phraze.
	t=new char[128];
	sprintf(t, "Unknown command c4'%s %s'c0 - try c4'.%s help'c0 to get help.",
		argv[0], argv[1], argv[0]);
	server->GamePrintError(t);
	delete t;
	}
	delete fMsg;
	return TRUE;
}


//////////////////////////////////////////////////////////////////////
// OnCommandHelp
// -------------------------------------------------------------------
// Our default help function.
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnCommandHelp(char** argv, int argc)
{
	// If command line is longer than 2, show usage for 'help'
	if (argc>2) return FALSE;

	char t[1024];
	sprintf(t, "Available commands for %s:", argv[0]);
	server->GamePrintInfo(t);

	// Loop through ModuleCommands[] and print their names
	for (int i=0; ModuleCommands[i].szName != NULL; i++)
	{
		sprintf(t, "c4.%s %s", argv[0], ModuleCommands[i].szName);
		server->GamePrintInfo(t);
	}

	sprintf(t, "For help on a specific command, type c4.%s <command> help", argv[0]);
	server->GamePrintInfo(t);
	return TRUE;
}
