// shopbot.h ackmed@gotwalls.com
#pragma once
#include "item.h"
#include "external/D2Hackit.h"
#include "external/D2Client.h"

// defines
#define VERSION_MAJOR		0x00
#define VERSION_MINOR		0x0a

#define DEBUG_OFF			0x00
#define DEBUG_USER			0x01
#define	DEBUG_DEVEL			0x02
#define DEBUG_PACKET		0x03

// different states the bot can be in
#define STATE_NONE			0x00	// bot not going
#define STATE_ANTIIDLE		0x01	// anti idle mode.

#define STATE_OPENSHOP		0x02
#define STATE_WAITSHOP		0x03
#define STATE_CLOSESHOP		0x04
#define STATE_BUYITEM		0x05

// structs
typedef struct location_t {
	WORD			x;
	WORD			y;
} LOCATIONSTRUCT;

typedef struct waypoint_t {
	DWORD			entityID;
	LOCATIONSTRUCT	pos;
} WPSTRUCT;

typedef struct npc_t {
	DWORD			npcID;
	LOCATIONSTRUCT	pos;
} NPCSTRUCT;


// global vars
extern WORD Debug;
extern WORD DevelDebug;
extern char DebugBuffer[1024];
extern WORD state;

// functions
BOOL PRIVATE OnCommandDebug(char **argv, int argc);
BOOL PRIVATE OnCommandDevelDebug(char **argv, int argc);
BOOL PRIVATE OnCommandRecord(char **argv, int argc);
BOOL PRIVATE OnCommandClear(char **argv, int argc);
BOOL PRIVATE OnCommandSetNPC(char **argv, int argc);
BOOL PRIVATE OnCommandSetCost(char **argv, int argc);
BOOL PRIVATE OnCommandSetShopTicks(char **argv, int argc);
BOOL PRIVATE OnCommandHelp(char** argv, int argc);
BOOL PRIVATE OnCommandReload(char **argv, int argc);
BOOL PRIVATE OnCommandBuy(char **argv, int argc);
BOOL PRIVATE OnCommandStop(char **argv, int argc);
