// item.cpp
// ackmed@gotwalls.com
#include "item.h"
#include "gbot.h"

ITEMSTRUCT *Parse9D(BYTE *Packet, DWORD Length) {
    ITEMSTRUCT *item = new ITEMSTRUCT;

    BitFields iPacket(Packet,Length);	

    item->MessageID = iPacket.GetField(8);
    item->Action = iPacket.GetField(8);
    item->MessageSize = iPacket.GetField(8);
    item->ItemType = iPacket.GetField(8);
    item->ItemID = iPacket.GetField(32);

    //5 extra bytes here in the 9D packets
    DebugItemBits(iPacket.GetField(40),40,iPacket.pos);

    // flags
    item->isSocketsFull = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
    item->isIdentified = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->isSwitchin = iPacket.GetField(1);
    item->isSwitchout = iPacket.GetField(1);
    item->isBroken = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->fromBelt = iPacket.GetField(1);
    item->hasSockets = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->isJustGenerated = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
    item->isEar = iPacket.GetField(1);
    item->isStartitem = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
    item->isMiscItem = iPacket.GetField(1);
    item->isEthereal = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->isPersonalized = iPacket.GetField(1);
    item->isGamble = iPacket.GetField(1);
    item->isRuneWord = iPacket.GetField(1);
	
    DebugItemBits(iPacket.GetField(5),5,iPacket.pos);
    item->MPQVersionField = iPacket.GetField(10);
	
    item->Location = iPacket.GetField(3);
    iPacket.GetField(4);
    item->PositionX = iPacket.GetField(4);
    item->PositionY = iPacket.GetField(4);
    iPacket.GetField(3);

    // is ear?  not exactly possible  
    if(item->isEar) {
	delete item;
	return NULL; }

    // read in itemcode, its a string;
    item->ItemCode[0] = iPacket.GetField(8);
    item->ItemCode[1] = iPacket.GetField(8);
    item->ItemCode[2] = iPacket.GetField(8);
    item->ItemCode[3] = iPacket.GetField(8);

    // chomp off the space if it exists
    if(item->ItemCode[3] == ' ') {
	item->ItemCode[3] = '\0'; }
    else {
	item->ItemCode[4] = '\0'; }

    DebugItemBits(iPacket.GetField(8),8,iPacket.pos);
    DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
    item->ItemLevel = iPacket.GetField(4);

    return item; }


ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length) {
    ITEMSTRUCT *item = new ITEMSTRUCT;

    BitFields iPacket(Packet,Length);	

    item->MessageID = iPacket.GetField(8);
    item->Action = iPacket.GetField(8);
    item->MessageSize = iPacket.GetField(8);
    item->ItemType = iPacket.GetField(8);
    item->ItemID = iPacket.GetField(32);

    // flags
    item->isSocketsFull = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
    item->isIdentified = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->isSwitchin = iPacket.GetField(1);
    item->isSwitchout = iPacket.GetField(1);
    item->isBroken = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->fromBelt = iPacket.GetField(1);
    item->hasSockets = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->isJustGenerated = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
    item->isEar = iPacket.GetField(1);
    item->isStartitem = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
    item->isMiscItem = iPacket.GetField(1);
    item->isEthereal = iPacket.GetField(1);
    DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
    item->isPersonalized = iPacket.GetField(1);
    item->isGamble = iPacket.GetField(1);
    item->isRuneWord = iPacket.GetField(1);
	
    DebugItemBits(iPacket.GetField(5),5,iPacket.pos);
    item->MPQVersionField = iPacket.GetField(10);
	
    item->Location = iPacket.GetField(3);
    iPacket.GetField(4);
    item->PositionX = iPacket.GetField(4);
    item->PositionY = iPacket.GetField(4);
    iPacket.GetField(3);

    // is ear?  not exactly possible  
    if(item->isEar) {
	delete item;
	return NULL; }

    // read in itemcode, its a string;
    item->ItemCode[0] = iPacket.GetField(8);
    item->ItemCode[1] = iPacket.GetField(8);
    item->ItemCode[2] = iPacket.GetField(8);
    item->ItemCode[3] = iPacket.GetField(8);

    // chomp off the space if it exists
    if(item->ItemCode[3] == ' ') {
	item->ItemCode[3] = '\0'; }
    else {
	item->ItemCode[4] = '\0'; }

    DebugItemBits(iPacket.GetField(8),8,iPacket.pos);
    DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
    item->ItemLevel = iPacket.GetField(4);

    return item; }

void DumpItemStruct(ITEMSTRUCT *item) {

	char DumpString[1024];
	
	BOOL found = false;
	
	sprintf(DumpString,"%s","DumpItemStruct ");
	
	sprintf(DumpString,"%s %s",DumpString,item->ItemCode);
	sprintf(DumpString,"%s Loc: (%d,%d)",DumpString,item->PositionX,item->PositionY);

	if      (item->ItemLevel == ITEM_UNSET) {
	    sprintf(DumpString,"%s ItemLevel: Unset",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_INFERIOR) {
	    sprintf(DumpString,"%s ItemLevel: Inferior",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_NORMAL) {
	    sprintf(DumpString,"%s ItemLevel: Normal",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_SUPERIOR) {
	    sprintf(DumpString,"%s ItemLevel: Superior",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_MAGIC) {
	    sprintf(DumpString,"%s ItemLevel: Magic",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_SET) {
	    sprintf(DumpString,"%s ItemLevel: Set",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_RARE) {
	    sprintf(DumpString,"%s ItemLevel: Rare",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_UNIQUE) {
	    sprintf(DumpString,"%s ItemLevel: Unique",DumpString); }
        else if (item->ItemLevel == ITEM_LEVEL_CRAFT) {
	    sprintf(DumpString,"%s ItemLevel: Craft",DumpString); }
        else {
	    sprintf(DumpString,"%s ItemLevel: Unknown",DumpString); }

	server->GamePrintString(DumpString);
	return; }

void DebugItemBits(BYTE data, BYTE size, DWORD pos) {
// fill me in!
	BYTE n;

	if(Debug == DEBUG_PACKET) {
		sprintf(DebugBuffer,"%d: ",pos);
		if(size > 8)
			size = 8;

		if(size != 8) {
			data = data<<(8 - size);
			
		}
		for(n = 0;n < size;n++) {
			if((data & 0x80) !=0)
			{
				sprintf(DebugBuffer,"%s1",DebugBuffer);
			}
			else
			{
				sprintf(DebugBuffer,"%s0",DebugBuffer);
			}
			data = data<<1;
		}
		server->GamePrintInfo(DebugBuffer);
	}
}
// from mousepad with some small mods
DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max) {
	// trying to read beyond the end of the packet

	if(pos + len > max) {

		// if we are already at or beyond the end of packet, return 0;
		if(pos >= max) {
			return 0;
		}
		// otherwise adjust len to all remaining bits
		if(Debug == DEBUG_PACKET) {
			sprintf(DebugBuffer,"Trying to read beyond eop. len:%d pos:%d max:%d",len,pos,max);
			server->GamePrintString(DebugBuffer);
		}
		len = max - pos;
	}

	return (DWORD)(*(unsigned __int64 *)(data+pos/8)<<(64-len-(pos&7))>>(64-len));
}
