// packethelper.cpp ackmed@gotwalls.com
#include <windows.h>
#include "packethelper.h"
#include "gbot.h"

BOOL TakeWayPoint(DWORD wpEntityID, DWORD Dest) {
	// first interact with entity
	InteractWithEntity(2,wpEntityID);

	BYTE packet[9];
	packet[0] = 0x49;

	memcpy(&packet[1],&wpEntityID,4);
	memcpy(&packet[5],&Dest,4);
	server->GameSendPacketToServer(packet,9);
	return true; }

BOOL InteractWithEntity(DWORD type,DWORD EntityID) {
	BYTE packet[9];
	packet[0] = 0x13;
	memcpy(&packet[1],&type,4);
	memcpy(&packet[5],&EntityID,4);
	server->GameSendPacketToServer(packet,9);
	return true; }

BOOL StopInteractWithEntity(DWORD type,DWORD EntityID) {
	BYTE packet[9];
	packet[0] = 0x30;
	memcpy(&packet[1],&type,4);
	memcpy(&packet[5],&EntityID,4);
	server->GameSendPacketToServer(packet,9);
	return true; }

BOOL PickupItem(DWORD id) {
	BYTE packet[5];
	packet[0] = 0x19;
	memcpy(&packet[1],&id,4);
	server->GameSendPacketToServer(packet,5);
	return true; }

BOOL BuyItem(DWORD id, DWORD npcid, DWORD cost) {
	BYTE packet[17];
	DWORD gambleid = 2;
	packet[0] = 0x32;
	memcpy(&packet[1],&npcid,4);
	memcpy(&packet[5],&id,4);
	memcpy(&packet[9],&gambleid,4);
	memcpy(&packet[13],&cost,4);
	server->GameSendPacketToServer(packet,17);
	return true; }

BOOL SellItem(DWORD id, DWORD npcid, DWORD cost) {
	BYTE packet[17];
	DWORD gambleid = 4; // don't know why this is 4, but it seems to work
	packet[0] = 0x33;
	memcpy(&packet[1],&npcid,4);
	memcpy(&packet[5],&id,4);
	memcpy(&packet[9],&gambleid,4);
	memcpy(&packet[13],&cost,4);
	server->GameSendPacketToServer(packet,17);
	return true; }

BOOL IdItem(DWORD id) {
	BYTE packet[5];
	packet[0] = 0x37;
	memcpy(&packet[1],&id,4);
	server->GameSendPacketToServer(packet,5);
	return true; }

BOOL TakeStep(WORD x, WORD y) {
	BYTE packet[5];
	packet[0] = 0x03;
	memcpy(&packet[1],&x,2);
	memcpy(&packet[3],&y,2);
	server->GameSendPacketToServer(packet,5);
	return true; }

BOOL OpenStore(DWORD npcID,WORD x, WORD y) {
	BYTE packet[17];
	
	packet[0] = 0x59;
	packet[1] = 0x01;
	packet[2] = packet[3] = packet[4] = 0;
	memcpy(&packet[5],&npcID,4);
	memcpy(&packet[9],&x,2);
	packet[11] = packet[12] = 0x00;
	memcpy(&packet[13],&y,2);
	packet[15] = packet[16] = 0x00;
	server->GameSendPacketToServer(packet,17);

	InteractWithEntity(1,npcID);
	
	packet[0] = 0x2f;
	packet[1] = 0x01;
	packet[2] = packet[3] = packet[4] = 0;
	memcpy(&packet[5],&npcID,4);
	server->GameSendPacketToServer(packet,9);

	packet[0] = 0x38;
	packet[1] = 0x02;  //0x2 for gambling
	packet[2] = packet[3] = packet[4] = 0;
	memcpy(&packet[5],&npcID,4);
	packet[9] = packet[10] = packet[11] = packet[12] = 0;
	server->GameSendPacketToServer(packet,13);

	return true;
}

BOOL CloseStore(DWORD npcID) {
	StopInteractWithEntity(1,npcID);
	return(StopInteractWithEntity(1,npcID)); // YES do it twice.
}
