// D2Item.cpp: implementation of the CWeapon class.
//
//////////////////////////////////////////////////////////////////////
#include "MString.h"


// NOTE: I would love to use C++ style classes, but explicit data initialization is not
//		allowed.  Therefore I can only use struct :(


/*
TO MAKE THESE LISTS:
	1) extract weapons.txt, armor.txt and misc.txt from the game MPQ's
	2) open with Excel and save as an xls
	3) delete unwanted columns and as XXX-fields.xls
	4) use 2 macros to add colums for exporting and save as XXX-fields-format.xls
	5) save as .cvs
	6) make copy and rename to .txt
	7) open .txt with wordpad and replace the formatting with proper text
	8) paste into this .cpp
*/



#include "D2Items.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//{"name",minac,maxac,reqstr,block,durability,level,cost,"code",component,invwidth,invheight,gemapplytype,"invfile","uniqueinvfile","setinvfile","type",bitfield1},
struct CArmor gArmorItems[] = {
	{"Cap/hat",3,5,0,0,12,1,64,"cap",0,2,2,1,"invcap","invcapu","invcapu","helm",1},
	{"Skull Cap",8,11,15,0,18,5,441,"skp",0,2,2,1,"invskp","","","helm",3},
	{"Helm",15,18,26,0,24,11,1558,"hlm",0,2,2,1,"invhlm","invhlmu","invhlmu","helm",3},
	{"Full Helm",23,26,41,0,30,15,3095,"fhl",0,2,2,1,"invfhl","invfhlu","invfhlu","helm",3},
	{"Great Helm",30,35,63,0,40,23,6177,"ghm",0,2,2,1,"invghm","","","helm",3},
	{"Crown",25,45,55,0,50,29,8345,"crn",0,2,2,1,"invcrn","","","helm",3},
	{"Mask",9,27,23,0,20,19,2857,"msk",0,2,2,1,"invmsk","","","helm",3},
	{"Quilted Armor",8,11,12,0,20,1,140,"qui",1,2,3,1,"invqlt","","","tors",1},
	{"Leather Armor",14,17,15,0,24,3,481,"lea",1,2,3,1,"invlea","","","tors",1},
	{"Hard Leather Armor",21,24,20,0,28,5,1060,"hla",1,2,3,1,"invhla","","","tors",1},
	{"Studded Leather ",32,35,27,0,32,8,2385,"stu",1,2,3,1,"invstu","","","tors",1},
	{"Ring Mail",45,48,36,0,26,11,4428,"rng",1,2,3,1,"invrng","","","tors",3},
	{"Scale Mail",57,60,44,0,36,13,6508,"scl",1,2,3,1,"invscl","","","tors",3},
	{"Chain Mail",72,75,48,0,45,15,9360,"chn",1,2,3,1,"invchn","","","tors",3},
	{"Breast Plate",65,68,30,0,50,18,10078,"brs",1,2,3,1,"invbrs","","","tors",3},
	{"Splint Mail",90,95,51,0,30,20,15489,"spl",1,2,3,1,"invspl","","","tors",3},
	{"Plate Mail",108,116,65,0,60,24,22335,"plt",1,2,3,1,"invplt","","","tors",3},
	{"Field Plate",101,105,55,0,48,28,23841,"fld",1,2,3,1,"invfld","","","tors",3},
	{"Gothic Plate",128,135,70,0,55,32,34646,"gth",1,2,3,1,"invgth","","","tors",3},
	{"Full Plate Mail",150,161,80,0,70,37,47192,"ful",1,2,3,1,"invful","invfulu","invfulu","tors",3},
	{"Ancient Armor",218,233,100,0,60,40,73864,"aar",1,2,3,1,"invaar","invaaru","invaaru","tors",3},
	{"Light Plate",90,107,41,0,60,35,28327,"ltp",1,2,3,1,"invltp","","","tors",3},
	{"Buckler",4,6,12,0,12,1,68,"buc",7,2,2,2,"invbuc","invbucu","invbucu","shie",3},
	{"Small Shield",8,10,22,5,16,5,410,"sml",7,2,2,2,"invsml","invsmlu","invsmlu","shie",3},
	{"Large Shield",12,14,34,12,24,11,1214,"lrg",7,2,3,2,"invlrg","invlrgu","invlrgu","shie",3},
	{"Kite Shield",16,18,47,8,30,15,2129,"kit",7,2,3,2,"invkit","invkitu","invkitu","shie",3},
	{"Tower Shield",22,25,75,24,60,22,4249,"tow",7,2,3,2,"invtow","invtowu","invtowu","shie",3},
	{"Gothic Shield",30,35,60,16,40,30,8000,"gts",7,2,4,2,"invgts","invgtsu","invgtsu","shie",3},
	{"Gloves(L)",2,3,0,0,12,3,80,"lgl",16,2,2,0,"invlgl","","","glov",1},
	{"Heavy Gloves",5,6,0,0,14,7,352,"vgl",16,2,2,0,"invvgl","","","glov",1},
	{"Bracers(M)",8,9,25,0,16,12,859,"mgl",16,2,2,0,"invmgl","","","glov",1},
	{"Light Gauntlets",9,11,45,0,18,20,1635,"tgl",16,2,2,0,"invtgl","","","glov",1},
	{"Gaunlets(H)",12,15,60,0,24,27,2964,"hgl",16,2,2,0,"invhgl","","","glov",1},
	{"Leather Boots",2,3,0,0,12,3,80,"lbt",16,2,2,0,"invlbt","","","boot",1},
	{"Heavy Boots",5,6,18,0,14,7,334,"vbt",16,2,2,0,"invvbt","","","boot",1},
	{"Chain Boots",8,9,30,0,16,12,854,"mbt",16,2,2,0,"invmbt","","","boot",3},
	{"Light Plate Boots",9,11,50,0,18,20,1630,"tbt",16,2,2,0,"invtbt","","","boot",3},
	{"Plate Boots",12,15,70,0,24,27,2954,"hbt",16,2,2,0,"invhbt","","","boot",3},
	{"Sash(L)",2,2,0,0,12,3,64,"lbl",16,2,1,0,"invlbl","","","belt",1},
	{"Light Belt",3,3,0,0,14,7,192,"vbl",16,2,1,0,"invvbl","","","belt",1},
	{"Belt(M)",5,5,25,0,16,12,495,"mbl",16,2,1,0,"invmbl","","","belt",1},
	{"Heavy Belt",6,6,45,0,18,20,963,"tbl",16,2,1,0,"invtbl","","","belt",1},
	{"Girdle(H)",8,11,60,0,24,27,2068,"hbl",16,2,1,0,"invhbl","","","belt",3},
	{"Bone Helm",33,36,25,0,40,22,6323,"bhm",0,2,2,1,"invbhm","invbhmu","invbhmu","helm",1},
	{"Bone Shield",10,30,25,20,40,19,3175,"bsh",7,2,3,2,"invbsh","invbshu","invbshu","shie",1},
	{"Spiked Shield",15,25,30,10,40,11,1890,"spk",7,2,3,2,"invspk","invspku","invspku","shie",1},
	{"War Hat",45,53,20,0,12,34,13560,"xap",0,2,2,1,"invcap","","","helm",1},
	{"Sallet",52,62,43,0,18,37,17210,"xkp",0,2,2,1,"invskp","invxkpu","invxkpu","helm",3},
	{"Casque",63,72,59,0,24,42,23075,"xlm",0,2,2,1,"invhlm","invhlmu","invhlmu","helm",3},
	{"Basinet",75,84,82,0,30,45,29083,"xhl",0,2,2,1,"invfhl","invfhlu","invfhlu","helm",3},
	{"Winged Helm",85,98,115,0,40,51,37846,"xhm",0,2,2,1,"invghm","","","helm",3},
	{"Grand Crown",78,113,103,0,50,55,42458,"xrn",0,2,2,1,"invcrn","invxrnu","invxrnu","helm",3},
	{"Death Mask",54,86,55,0,20,48,27190,"xsk",0,2,2,1,"invmsk","","","helm",3},
	{"Ghost Armor",102,117,38,0,20,34,30552,"xui",1,2,3,1,"invqlt","","","tors",1},
	{"Serpentskin Armor",111,126,43,0,24,36,34960,"xea",1,2,3,1,"invlea","","","tors",1},
	{"Demonhide Armor",122,136,50,0,28,37,39090,"xla",1,2,3,1,"invhla","","","tors",1},
	{"Trellised Armor",138,153,61,0,32,40,47582,"xtu",1,2,3,1,"invstu","invxtuu","invxtuu","tors",1},
	{"Linked Mail",158,172,74,0,26,42,56600,"xng",1,2,3,1,"invrng","","","tors",3},
	{"Tigulated Mail",176,190,86,0,36,43,64242,"xcl",1,2,3,1,"invscl","","","tors",3},
	{"Mesh Armor",198,213,92,0,45,45,75440,"xhn",1,2,3,1,"invchn","","","tors",3},
	{"Cuirass",188,202,65,0,50,47,74719,"xrs",1,2,3,1,"invbrs","","invxrss","tors",3},
	{"Russet Armor",225,243,97,0,30,49,93404,"xpl",1,2,3,1,"invspl","","","tors",3},
	{"Templar Coat",252,274,118,0,60,52,111395,"xlt",1,2,3,1,"invplt","","","tors",3},
	{"Sharktooth Armor",242,258,103,0,48,55,111674,"xld",1,2,3,1,"invfld","","","tors",3},
	{"Embossed Plate",282,303,125,0,55,58,137817,"xth",1,2,3,1,"invgth","","","tors",3},
	{"Chaos Armor",315,342,140,0,70,61,162672,"xul",1,2,3,1,"invful","","","tors",3},
	{"Ornate Armor",417,450,170,0,60,64,225120,"xar",1,2,3,1,"invaar","invxaru","invxaru","tors",3},
	{"Mage Plate",225,261,55,0,60,60,118407,"xtp",1,2,3,1,"invltp","","","tors",3},
	{"Defender",41,49,38,10,68,34,12562,"xuc",7,2,2,2,"invbuc","invbucu","invbucu","shie",3},
	{"Round Shield",47,55,53,12,64,37,15451,"xml",7,2,2,2,"invsml","invxmlu","invxmlu","shie",3},
	{"Scutum",53,61,71,14,62,42,19537,"xrg",7,2,3,2,"invlrg","invxrgu","invxrgu","shie",3},
	{"Dragon Shield",59,67,91,18,76,45,23094,"xit",7,2,3,2,"invkit","invkitu","invkitu","shie",3},
	{"Pavise",68,78,133,24,72,50,29550,"xow",7,2,3,2,"invtow","invtowu","invtowu","shie",3},
	{"Ancient Shield",80,93,110,16,80,56,39220,"xts",7,2,4,2,"invgts","invgtsu","invgtsu","shie",3},
	{"Demonhide Gloves",28,35,20,0,12,36,9230,"xlg",16,2,2,0,"invlgl","","","glov",1},
	{"Sharkskin Gloves",33,39,20,0,14,39,11420,"xvg",16,2,2,0,"invvgl","","","glov",1},
	{"Heavy Bracers",37,44,58,0,16,43,14111,"xmg",16,2,2,0,"invmgl","","","glov",1},
	{"Battle Gauntlets",39,47,88,0,18,49,16913,"xtg",16,2,2,0,"invtgl","","","glov",1},
	{"War Gauntlets",43,53,110,0,24,54,20900,"xhg",16,2,2,0,"invhgl","","","glov",1},
	{"Demonhide Boots",28,35,20,0,12,36,9230,"xlb",16,2,2,0,"invlbt","","","boot",1},
	{"Sharkskin Boots",33,39,47,0,14,39,11393,"xvb",16,2,2,0,"invvbt","","","boot",1},
	{"Mesh Boots",37,44,65,0,16,43,14103,"xmb",16,2,2,0,"invmbt","","","boot",3},
	{"Battle Boots",39,47,95,0,18,49,16905,"xtb",16,2,2,0,"invtbt","","","boot",3},
	{"War Boots",43,53,125,0,24,54,20885,"xhb",16,2,2,0,"invhbt","","","boot",3},
	{"Demonhide Sash",29,34,20,0,12,36,9304,"zlb",16,2,1,0,"invlbl","","","belt",1},
	{"Sharkskin Belt",31,36,20,0,14,39,10700,"zvb",16,2,1,0,"invvbl","","","belt",1},
	{"Mesh Belt",35,40,58,0,16,43,13143,"zmb",16,2,1,0,"invmbl","","","belt",1},
	{"Battle Belt",37,42,88,0,18,49,15713,"ztb",16,2,1,0,"invtbl","","","belt",1},
	{"War Belt",41,52,110,0,24,54,20350,"zhb",16,2,1,0,"invhbl","","","belt",1},
	{"Grim Helm",60,125,58,0,40,50,37683,"xh9",0,2,2,1,"invbhm","invbhmu","invbhmu","helm",1},
	{"Grim Shield",50,150,58,14,70,48,39143,"xsh",7,2,3,2,"invbsh","invxshu","invxshu","shie",1},
	{"Barbed Shield",58,78,65,17,55,42,23155,"xpk",7,2,3,2,"invspk","invxpku","invxpku","shie",1},
	{"Wolf Head",8,11,16,0,20,4,364,"dr1",0,2,2,1,"invdr1","","","pelt",1},
	{"Hawk Helm",4,15,20,0,20,8,664,"dr2",0,2,2,1,"invdr2","","","pelt",1},
	{"Antlers",18,24,24,0,20,16,2832,"dr3",0,2,2,1,"invdr3","","","pelt",1},
	{"Falcon Mask",12,28,28,0,20,20,3332,"dr4",0,2,2,1,"invdr4","","","pelt",1},
	{"Spirit Mask",22,35,30,0,20,24,5670,"dr5",0,2,2,1,"invdr5","","","pelt",1},
	{"Jawbone Cap",10,15,25,0,25,4,320,"ba1",0,2,2,1,"invba1","","","phlm",1},
	{"Fanged Helm",15,20,35,0,35,8,750,"ba2",0,2,2,1,"invba2","","","phlm",1},
	{"Horned Helm",25,30,45,0,45,16,2750,"ba3",0,2,2,1,"invba3","","","phlm",3},
	{"Assault Helmet",30,35,55,0,50,20,3420,"ba4",0,2,2,1,"invba4","","","phlm",3},
	{"Avenger Guard",35,50,65,0,55,24,5785,"ba5",0,2,2,1,"invba5","","","phlm",3},
	{"Targe",8,12,16,10,20,4,384,"pa1",7,2,2,2,"invpa1","","","ashd",3},
	{"Rondache",10,18,26,15,30,8,982,"pa2",7,2,2,2,"invpa2","","","ashd",3},
	{"Heraldic Shield",16,26,40,20,40,16,2816,"pa3",7,2,4,2,"invpa3","","","ashd",3},
	{"Aerin Shield",26,36,50,22,50,20,5158,"pa4",7,2,4,2,"invpa4","","","ashd",3},
	{"Crown Shield",30,40,65,25,60,24,6935,"pa5",7,2,2,2,"invpa5","","","ashd",3},
	{"Preserved Head",2,5,12,3,20,4,128,"ne1",10,2,2,2,"invne1","","","head",1},
	{"Zombie Head",4,8,14,5,20,8,418,"ne2",10,2,2,2,"invne2","","","head",1},
	{"Unraveller Head",6,10,18,8,20,16,1070,"ne3",10,2,2,2,"invne3","","","head",1},
	{"Gargoyle Head",10,16,20,10,20,20,2164,"ne4",10,2,2,2,"invne4","","","head",1},
	{"Demon Head",15,20,25,12,20,24,3475,"ne5",10,2,2,2,"invne5","","","head",1},
	{"Circlet",20,30,0,0,35,24,5000,"ci0",0,2,2,1,"invci0","","","circ",3},
	{"Coronet",30,40,0,0,30,35,7500,"ci1",0,2,2,1,"invci1","","","circ",3},
	{"Tiara",40,50,0,0,25,45,60000,"ci2",0,2,2,1,"invci2","","","circ",3},
	{"Diadem",50,60,0,0,20,60,90000,"ci3",0,2,2,1,"invci3","","","circ",3},
	{"Shako",98,141,50,0,12,65,62993,"uap",0,2,2,1,"invcap","","","helm",1},
	{"Hydraskull",101,145,84,0,18,68,67647,"ukp",0,2,2,1,"invskp","","","helm",3},
	{"Armet",105,149,109,0,24,73,75016,"ulm",0,2,2,1,"invhlm","invhlmu","invhlmu","helm",3},
	{"Giant Conch",110,154,142,0,30,54,57806,"uhl",0,2,2,1,"invfhl","invfhlu","invfhlu","helm",3},
	{"Spired Helm",114,159,192,0,40,78,86076,"uhm",0,2,2,1,"invghm","","invuhms","helm",3},
	{"Corona",111,165,174,0,50,81,90354,"urn",0,2,2,1,"invcrn","","","helm",3},
	{"Demonhead",101,154,102,0,20,76,78623,"usk",0,2,2,1,"invmsk","","","helm",3},
	{"Dusk Shroud",361,467,77,0,20,66,221666,"uui",1,2,3,1,"invqlt","","","tors",1},
	{"Wyrmhide",364,470,84,0,24,67,226927,"uea",1,2,3,1,"invlea","","","tors",1},
	{"Scarab Husk",369,474,95,0,28,68,232573,"ula",1,2,3,1,"invhla","","","tors",1},
	{"Wire Fleece",375,481,111,0,32,70,243050,"utu",1,2,3,1,"invstu","","","tors",1},
	{"Diamond Mail",383,489,131,0,26,72,254435,"ung",1,2,3,1,"invrng","","","tors",3},
	{"Loricated Mail",390,496,149,0,36,72,258621,"ucl",1,2,3,1,"invscl","","","tors",3},
	{"Boneweave",399,505,158,0,45,64,234934,"uhn",1,2,3,1,"invchn","","","tors",3},
	{"Great Hauberk",395,501,118,0,50,75,272206,"urs",1,2,3,1,"invbrs","","","tors",3},
	{"Balrog Skin",410,517,165,0,30,77,289059,"upl",1,2,3,1,"invspl","","","tors",3},
	{"Hellforged Plate",421,530,196,0,60,79,303932,"ult",1,2,3,1,"invplt","","","tors",3},
	{"Kraken Shell",417,523,174,0,48,81,308015,"uld",1,2,3,1,"invfld","","","tors",3},
	{"Lacquered Plate",433,541,208,0,55,84,330885,"uth",1,2,3,1,"invgth","","","tors",3},
	{"Shadow Plate",446,557,230,0,70,86,348675,"uul",1,2,3,1,"invful","","","tors",3},
	{"Sacred Armor",487,600,232,0,60,88,386598,"uar",1,2,3,1,"invaar","invaaru","invaaru","tors",3},
	{"Archon Plate",410,524,103,0,60,85,321262,"utp",1,2,3,1,"invltp","","","tors",3},
	{"Heater",81,100,77,22,88,66,48163,"uuc",7,2,2,2,"invbuc","invbucu","invbucu","shie",3},
	{"Luna",84,103,100,20,84,68,51237,"uml",7,2,2,2,"invsml","invsmlu","invsmlu","shie",3},
	{"Hyperion",87,106,127,24,82,72,55938,"urg",7,2,3,2,"invlrg","invlrgu","invlrgu","shie",3},
	{"Monarch",90,109,156,22,86,74,59244,"uit",7,2,3,2,"invkit","invkitu","invkitu","shie",3},
	{"Aegis",94,114,219,24,92,78,65430,"uow",7,2,3,2,"invtow","invtowu","invtowu","shie",3},
	{"Ward",100,121,185,24,100,82,73270,"uts",7,2,4,2,"invgts","invgtsu","invutss","shie",3},
	{"Bramble Mitts",54,62,50,0,12,67,31570,"ulg",16,2,2,0,"invlgl","","","glov",1},
	{"Vampirebone Gloves",56,65,50,0,14,69,33760,"uvg",16,2,2,0,"invvgl","","","glov",1},
	{"Vambraces",59,67,106,0,16,72,36467,"umg",16,2,2,0,"invmgl","","","glov",1},
	{"Crusader Gauntlets",59,68,151,0,18,77,39629,"utg",16,2,2,0,"invtgl","","","glov",1},
	{"Ogre Gauntlets",62,71,185,0,24,81,43357,"uhg",16,2,2,0,"invhgl","","","glov",1},
	{"Wyrmhide Boots",54,62,50,0,12,67,31570,"ulb",16,2,2,0,"invlbt","","","boot",1},
	{"Scarabshell Boots",56,65,91,0,14,69,33720,"uvb",16,2,2,0,"invvbt","","","boot",1},
	{"Boneweave Boots",59,67,118,0,16,72,36456,"umb",16,2,2,0,"invmbt","","","boot",3},
	{"Mirrored Boots",59,68,163,0,18,77,39618,"utb",16,2,2,0,"invtbt","","","boot",3},
	{"Myrmidon Greaves",62,71,208,0,24,81,43335,"uhb",16,2,2,0,"invhbt","","","boot",3},
	{"Spiderweb Sash",55,62,50,0,12,67,31638,"ulc",16,2,1,0,"invlbl","","","belt",1},
	{"Vampirefang Belt",56,63,50,0,14,69,33130,"uvc",16,2,1,0,"invvbl","","","belt",1},
	{"Mithril Coil",58,65,106,0,16,72,35664,"umc",16,2,1,0,"invmbl","","","belt",1},
	{"Troll Belt",59,66,151,0,18,77,38693,"utc",16,2,1,0,"invtbl","","","belt",1},
	{"Colossus Girdle",61,71,185,0,24,81,42947,"uhc",16,2,1,0,"invhbl","","","belt",1},
	{"Bone Visage",70,108,106,0,40,78,55984,"uh9",0,2,2,1,"invbhm","invbhmu","invbhmu","helm",1},
	{"Troll Nest",65,120,106,20,74,76,56874,"ush",7,2,3,2,"invbsh","invbshu","invbshu","shie",1},
	{"Blade Barrier",69,84,118,20,83,72,44413,"upk",7,2,3,2,"invspk","invspku","invspku","shie",1},
	{"Alpha Helm",52,62,44,0,20,28,13122,"dr6",0,2,2,1,"invdr1","","","pelt",1},
	{"Griffon Headress",46,68,50,0,20,31,14478,"dr7",0,2,2,1,"invdr2","","","pelt",1},
	{"Hunter's Guise",67,81,56,0,20,37,22440,"dr8",0,2,2,1,"invdr3","","","pelt",1},
	{"Sacred Feathers",58,87,62,0,20,40,23718,"dr9",0,2,2,1,"invdr4","","","pelt",1},
	{"Totemic Mask",73,98,65,0,20,43,29943,"dra",0,2,2,1,"invdr5","","","pelt",1},
	{"Jawbone Visor",55,68,58,0,25,28,14153,"ba6",0,2,2,1,"invba1","","","phlm",1},
	{"Lion Helm",63,75,73,0,35,31,17528,"ba7",0,2,2,1,"invba2","","","phlm",1},
	{"Rage Mask",78,90,88,0,45,37,25373,"ba8",0,2,2,1,"invba3","","","phlm",3},
	{"Savage Helmet",85,98,103,0,50,40,29828,"ba9",0,2,2,1,"invba4","","","phlm",3},
	{"Slayer Guard",93,120,118,0,55,43,37283,"baa",0,2,2,1,"invba5","","","phlm",3},
	{"Akaran Targe",47,58,44,10,20,28,12136,"pa6",7,2,2,2,"invpa1","","","ashd",3},
	{"Akaran Rondache",50,67,59,15,30,31,14917,"pa7",7,2,2,2,"invpa2","","","ashd",3},
	{"Protector Shield",59,79,69,20,40,37,20907,"pa8",7,2,4,2,"invpa3","","","ashd",3},
	{"Guilded Shield",74,94,89,22,50,40,27463,"pa9",7,2,4,2,"invpa4","","","ashd",3},
	{"Royal Shield",80,100,114,25,60,43,31566,"paa",7,2,2,2,"invpa5","","","ashd",3},
	{"Mummified Trophy",38,48,38,3,20,28,9880,"ne6",10,2,2,2,"invne1","","","head",1},
	{"Fetish Trophy",41,52,41,5,20,31,11863,"ne7",10,2,2,2,"invne2","","","head",1},
	{"Sexton Trophy",44,55,47,8,20,37,15001,"ne8",10,2,2,2,"invne3","","","head",1},
	{"Cantor Trophy",50,64,50,10,20,40,18646,"ne9",10,2,2,2,"invne4","","","head",1},
	{"Heirophant Trophy",58,70,58,12,20,43,22383,"nea",10,2,2,2,"invne5","","","head",1},
	{"Blood Spirt",101,145,86,0,20,56,55865,"drb",0,2,2,1,"invdr1","","","pelt",1},
	{"Sun Spirit",98,147,95,0,20,58,58065,"drc",0,2,2,1,"invdr2","","","pelt",1},
	{"Earth Spirit",107,152,104,0,20,63,65992,"drd",0,2,2,1,"invdr3","","","pelt",1},
	{"Sky Spirit",103,155,113,0,20,65,67999,"dre",0,2,2,1,"invdr4","","","pelt",1},
	{"Dream Spirit",109,159,118,0,20,67,73101,"drf",0,2,2,1,"invdr5","","","pelt",1},
	{"Carnage Helm",102,147,106,0,25,56,56666,"bab",0,2,2,1,"invba1","","","phlm",1},
	{"Fury Visor",105,150,129,0,35,58,60306,"bac",0,2,2,1,"invba2","","","phlm",1},
	{"Destroyer Helm",111,156,151,0,45,63,67934,"bad",0,2,2,1,"invba3","","","phlm",3},
	{"Conquerer Crown",114,159,174,0,50,65,71898,"bae",0,2,2,1,"invba4","","","phlm",3},
	{"Guardian Crown",117,168,196,0,55,67,77609,"baf",0,2,2,1,"invba5","","","phlm",3},
	{"Sacred Targe",84,104,86,10,20,56,42778,"pab",7,2,2,2,"invpa1","","","ashd",3},
	{"Sacred Rondache",85,109,109,15,30,58,45675,"pac",7,2,2,2,"invpa2","","","ashd",3},
	{"Ancient Shield",90,115,124,20,40,62,51536,"pad",7,2,4,2,"invpa3","","","ashd",3},
	{"Zakarum Shield",97,122,142,22,50,65,57674,"pae",7,2,4,2,"invpa4","","","ashd",3},
	{"Vortex Shield",100,125,148,25,60,67,61052,"paf",7,2,2,2,"invpa5","","","ashd",3},
	{"Minion Skull",95,139,77,3,20,56,53321,"neb",10,2,2,2,"invne1","","","head",1},
	{"Hellspawn Skull",96,141,82,5,20,58,55898,"nec",10,2,2,2,"invne2","","","head",1},
	{"Overseer Skull",98,142,91,8,20,62,60289,"ned",10,2,2,2,"invne3","","","head",1},
	{"Succubae Skull",100,146,95,10,20,65,64743,"nee",10,2,2,2,"invne4","","","head",1},
	{"Bloodlord Skull",103,148,106,12,20,67,68166,"nef",10,2,2,2,"invne5","","","head",1}
} ;


int GetNumberOfArmors()
{
	return (sizeof gArmorItems / sizeof gArmorItems[0]) ;
}

CArmor* GetArmorRec( CString sCode) 
{
	for (int count=0; count<GetNumberOfArmors(); count++) {
		if (sCode == gArmorItems[ count].m_Code)
			return &gArmorItems[ count] ;
	}
	return NULL ;
}





//{"name","type","code",mindam,maxdam,1or2handed,2handed,2handmindam,2handmaxdam,minmisdam,maxmisdam,speed,StrBonus,DexBonus,reqstr,reqdex,nodurability,level,cost,"wclass","2handedwclass",component,"hit class",invwidth,invheight,stackable,"invfile","uniqueinvfile","setinvfile","special",bitfield1},
struct CWeapon gWeaponItems[] = {
	{"Hand Axe","axe","hax",3,6,0,0,0,0,0,0,0,100,0,0,0,0,3,170,"1hs","1hs",5,"1hsl",1,3,0,"invhax","invhaxu","invhaxu","",3},
	{"Axe","axe","axe",4,11,0,0,0,0,0,0,10,100,0,32,0,0,7,403,"1hs","1hs",5,"1hsl",2,3,0,"invaxe","invaxeu","invaxeu","",3},
	{"Double Axe","axe","2ax",5,13,0,0,0,0,0,0,10,100,0,43,0,0,13,873,"1hs","1hs",5,"1hsl",2,3,0,"inv2ax","","","",3},
	{"Military Pick","axe","mpi",7,11,0,0,0,0,0,0,-10,100,0,49,33,0,19,1421,"1hs","1hs",5,"1hsl",2,3,0,"invmpi","invmpiu","invmpiu","",3},
	{"War Axe","axe","wax",10,18,0,0,0,0,0,0,0,100,0,67,0,0,25,2123,"1hs","1hs",5,"1hsl",2,3,0,"invwax","","","",3},
	{"Large Axe","axe","lax",0,0,0,1,6,13,0,0,-10,100,0,35,0,0,6,354,"stf","stf",5,"2hsl",2,3,0,"invlax","","","",3},
	{"Broad Axe ","axe","bax",0,0,0,1,10,18,0,0,0,100,0,48,0,0,12,806,"stf","stf",5,"2hsl",2,3,0,"invbrx","","","",3},
	{"Battle Axe","axe","btx",0,0,0,1,12,32,0,0,10,100,0,54,0,0,17,1262,"stf","stf",5,"2hsl",2,3,0,"invbtx","invbtxu","invbtxu","",3},
	{"Great Axe","axe","gax",0,0,0,1,9,30,0,0,-10,100,0,63,39,0,23,1916,"stf","stf",5,"2hsl",2,4,0,"invgax","invgaxu","invgaxu","",3},
	{"Giant Axe","axe","gix",0,0,0,1,22,45,0,0,10,100,0,70,0,0,27,2410,"stf","stf",5,"2hsl",2,3,0,"invgix","","","",3},
	{"Wand","wand","wnd",2,4,0,0,0,0,0,0,0,100,0,0,0,0,2,205,"1hs","1hs",5,"1hss",1,2,0,"invwnd","invwndu","invwndu","magically charged",5},
	{"Yew Wand","wand","ywn",2,8,0,0,0,0,0,0,10,100,0,0,0,0,12,745,"1hs","1hs",5,"1hss",1,2,0,"invywn","","","magically charged",5},
	{"Bone Wand","wand","bwn",3,7,0,0,0,0,0,0,-20,100,0,0,0,0,18,1296,"1hs","1hs",5,"1hss",1,2,0,"invbwn","invbwnu","invbwnu","magically charged",5},
	{"Grim Wand","wand","gwn",5,11,0,0,0,0,0,0,0,100,0,0,0,0,26,2098,"1hs","1hs",5,"1hss",1,2,0,"invgwn","","","magically charged",5},
	{"Club","club","clb",1,6,0,0,0,0,0,0,-10,100,0,0,0,0,1,32,"1hs","1hs",5,"club",1,3,0,"invclb","invclbu","invclbu","",1},
	{"Scepter","scep","scp",6,11,0,0,0,0,0,0,0,100,0,25,0,0,3,350,"1hs","1hs",5,"club",1,3,0,"invscp","","","magically charged",3},
	{"Grand Scepter","scep","gsc",8,18,0,0,0,0,0,0,10,100,0,37,0,0,15,1109,"1hs","1hs",5,"club",1,3,0,"invgsc","","","magically charged",3},
	{"War Scepter","scep","wsp",10,17,0,0,0,0,0,0,-10,100,0,55,0,0,21,2323,"1hs","1hs",5,"club",2,3,0,"invwsp","","","magically charged",3},
	{"Spiked Club","club","spc",5,8,0,0,0,0,0,0,0,100,0,0,0,0,4,225,"1hs","1hs",5,"1hsl",1,3,0,"invspc","invspcu","invspcu","",1},
	{"Mace","mace","mac",3,10,0,0,0,0,0,0,0,100,0,27,0,0,8,463,"1hs","1hs",5,"1hsl",1,3,0,"invmac","","","",3},
	{"Morning Star","mace","mst",7,16,0,0,0,0,0,0,10,100,0,36,0,0,13,844,"1hs","1hs",5,"1hsl",1,3,0,"invmst","invmstu","invmstu","",3},
	{"Flail","mace","fla",1,24,0,0,0,0,0,0,-10,100,0,41,35,0,19,1412,"1hs","1hs",5,"1hsl",2,3,0,"invfla","","","",3},
	{"War Hammer","hamm","whm",19,29,0,0,0,0,0,0,20,110,0,53,0,0,25,2081,"1hs","1hs",5,"1hsl",2,3,0,"invwhm","","","",3},
	{"Maul","hamm","mau",0,0,0,1,30,43,0,0,10,110,0,69,0,0,21,1670,"stf","stf",5,"2hsl",2,4,0,"invmau","invmauu","invmauu","",3},
	{"Great Maul","hamm","gma",0,0,0,1,38,58,0,0,20,110,0,99,0,0,32,3215,"stf","stf",5,"2hsl",2,3,0,"invgma","invgma","invgma","",3},
	{"Short Sword","swor","ssd",2,7,0,0,0,0,0,0,0,100,0,0,0,0,1,72,"1hs","1hs",5,"1hsl",1,3,0,"invssd","","","",3},
	{"Scimitar","swor","scm",2,6,0,0,0,0,0,0,-20,100,0,0,21,0,5,274,"1hs","1hs",5,"1hsl",1,3,0,"invscm","invscmu","invscmu","",3},
	{"Saber","swor","sbr",3,8,0,0,0,0,0,0,-10,100,0,25,25,0,8,466,"1hs","1hs",5,"1hsl",1,3,0,"invsbr","inv9sbu","inv9sbu","",3},
	{"Falchion","swor","flc",9,17,0,0,0,0,0,0,20,100,0,33,0,0,11,683,"1hs","1hs",5,"1hsl",1,3,0,"invflc","invflcu","invflcu","",3},
	{"Crystal Sword","swor","crs",5,15,0,0,0,0,0,0,0,100,0,43,0,0,11,2127,"1hs","1hs",5,"1hsl",2,3,0,"invcrs","invcrsu","invcrsu","",1},
	{"Broad Sword","swor","bsd",7,14,0,0,0,0,0,0,0,100,0,48,0,0,15,1029,"1hs","1hs",5,"1hsl",2,3,0,"invbsd","invbsdu","invbsdu","",3},
	{"Long Sword ","swor","lsd",3,19,0,0,0,0,0,0,-10,100,0,55,39,0,20,1520,"1hs","1hs",5,"1hsl",2,3,0,"invlsd","invlsdu","invlsdu","",3},
	{"War Sword","swor","wsd",8,20,0,0,0,0,0,0,0,100,0,71,45,0,27,1997,"1hs","1hs",5,"1hsl",1,3,0,"invwsd","","","",3},
	{"Two-Handed Sword","swor","2hs",2,9,1,1,8,17,0,0,0,100,0,35,27,0,10,644,"1hs","2hs",5,"2hss",1,4,0,"inv2hs","inv2hsu","inv2hsu","",3},
	{"Claymore","swor","clm",5,12,1,1,13,30,0,0,10,100,0,47,0,0,17,1262,"1hs","2hs",5,"2hss",1,4,0,"invclm","","","",3},
	{"Giant Sword","swor","gis",3,16,1,1,9,28,0,0,0,100,0,56,34,0,21,1459,"1hs","2hs",5,"2hss",1,4,0,"invgis","invgisu","invgisu","",3},
	{"Bastard Sword","swor","bsw",7,19,1,1,20,28,0,0,10,100,0,62,0,0,24,1971,"1hs","2hs",5,"2hss",1,4,0,"invbsw","invbswu","invbswu","",3},
	{"Flamberge","swor","flb",9,15,1,1,13,26,0,0,-10,100,0,70,49,0,27,2400,"1hs","2hs",5,"2hss",2,4,0,"invflb","","","",3},
	{"Great Sword","swor","gsd",12,20,1,1,25,42,0,0,10,100,0,100,60,0,33,3451,"1hs","2hs",5,"2hss",2,4,0,"invgsd","invgsdu","invgsdu","",3},
	{"Dagger","knif","dgr",1,4,0,0,0,0,0,0,-20,50,50,0,0,0,3,60,"1ht","1ht",5,"1ht",1,2,0,"invdgr","","","",3},
	{"Dirk","knif","dir",3,9,0,0,0,0,0,0,0,50,50,0,25,0,9,532,"1ht","1ht",5,"1ht",1,2,0,"invdir","","","",3},
	{"Kriss","knif","kri",2,11,0,0,0,0,0,0,-20,50,50,0,45,0,17,1227,"1ht","1ht",5,"1ht",1,3,0,"invkrs","invkrsu","invkrsu","",3},
	{"Blade","knif","bld",4,15,0,0,0,0,0,0,-10,50,50,35,51,0,23,1764,"1ht","1ht",5,"1ht",1,3,0,"invbld","","","",3},
	{"Throwing Knife","tkni","tkf",2,3,0,0,0,0,4,9,0,50,50,0,21,0,2,6,"1ht","1ht",5,"1ht",1,2,1,"invtkn","","","primarily thrown",3},
	{"Throwing Axe","taxe","tax",4,7,0,0,0,0,8,12,10,50,50,0,40,0,7,11,"1hs","1hs",5,"1hsl",1,2,1,"invtax","","","primarily thrown",3},
	{"Balanced Knife","tkni","bkf",1,8,0,0,0,0,6,11,-20,50,50,0,51,0,13,15,"1ht","1ht",5,"1ht",1,2,1,"invbkf","","","primarily thrown",3},
	{"Balanced Axe","taxe","bal",5,10,0,0,0,0,12,15,-10,50,50,0,57,0,16,35,"1hs","1hs",5,"1hsl",2,3,1,"invbal","","","primarily thrown",3},
	{"Javelin","jave","jav",1,5,0,0,0,0,6,14,-10,50,50,0,0,0,1,12,"1ht","1ht",5,"1ht",1,3,1,"invjav","","","primarily thrown",3},
	{"Pilum","jave","pil",4,9,0,0,0,0,7,20,0,50,50,0,45,0,10,18,"1ht","1ht",5,"1ht",1,3,1,"invpil","","","primarily thrown",3},
	{"Short Spear","jave","ssp",2,13,0,0,0,0,10,22,10,50,50,40,40,0,15,24,"1ht","1ht",5,"1ht",1,3,1,"invssp","","","primarily thrown",3},
	{"Glaive","jave","glv",5,17,0,0,0,0,16,22,20,50,50,52,35,0,23,36,"1ht","1ht",5,"1ht",1,4,1,"invglv","","","primarily thrown",3},
	{"Throwing Spear","jave","tsp",5,15,0,0,0,0,12,30,-10,50,50,0,65,0,29,48,"1ht","1ht",5,"1ht",1,4,1,"invtsp","","","primarily thrown",3},
	{"Spear","spea","spr",0,0,0,1,3,15,0,0,-10,100,0,0,20,0,5,300,"2ht","2ht",5,"2ht",2,4,0,"invspr","","","2 square reach",3},
	{"Trident","spea","tri",0,0,0,1,9,15,0,0,0,100,0,38,24,0,9,683,"2ht","2ht",5,"2ht",2,4,0,"invtri","invtriu","invtriu","2 square reach",3},
	{"Brandistock","spea","brn",0,0,0,1,7,17,0,0,-20,100,0,40,50,0,16,1162,"2ht","2ht",5,"2ht",2,4,0,"invbrn","","","2 square reach",3},
	{"Spetum","spea","spt",0,0,0,1,15,23,0,0,0,100,0,54,35,0,20,1672,"2ht","2ht",5,"2ht",2,4,0,"invspt","","","2 square reach",3},
	{"Pike","spea","pik",0,0,0,1,14,63,0,0,20,100,0,60,45,0,24,2023,"2ht","2ht",5,"2ht",2,4,0,"invpik","","","3 square reach",3},
	{"Bardiche","pole","bar",0,0,0,1,1,27,0,0,10,100,0,40,0,0,5,302,"stf","stf",5,"2hsl",2,4,0,"invbar","","","2 square reach",3},
	{"Voulge","pole","vou",0,0,0,1,6,21,0,0,0,100,0,50,0,0,11,611,"stf","stf",5,"2hsl",2,4,0,"invvou","","","2 square reach",3},
	{"Scythe","pole","scy",0,0,0,1,8,20,0,0,-10,100,0,41,41,0,15,848,"stf","stf",5,"2hsl",2,4,0,"invscy","invscyu","invscyu","2 square reach",3},
	{"Poleaxe","pole","pax",0,0,0,1,18,39,0,0,10,100,0,62,0,0,21,1701,"stf","stf",5,"2hsl",2,4,0,"invpax","","","2 square reach",3},
	{"Halberd","pole","hal",0,0,0,1,12,45,0,0,0,100,0,75,47,0,29,2706,"stf","stf",5,"2hsl",2,4,0,"invhal","","","2 square reach",3},
	{"War Scythe","pole","wsc",0,0,0,1,15,36,0,0,-10,100,0,80,80,0,34,3388,"stf","stf",5,"2hsl",2,4,0,"invwsc","","","2 square reach",3},
	{"Short Staff","staf","sst",0,0,0,1,1,5,0,0,-10,100,0,0,0,0,1,168,"stf","stf",5,"club",1,3,0,"invsst","","","magically charged",5},
	{"Long Staff","staf","lst",0,0,0,1,2,8,0,0,0,100,0,0,0,0,8,463,"stf","stf",5,"staf",1,4,0,"invlst","","","magically charged",5},
	{"Gnarled Staff","staf","cst",0,0,0,1,4,12,0,0,10,100,0,0,0,0,12,766,"stf","stf",5,"staf",1,4,0,"invcst","invcstu","invcstu","magically charged",5},
	{"Battle Staff","staf","bst",0,0,0,1,6,13,0,0,0,100,0,0,0,0,17,1223,"stf","stf",5,"staf",1,4,0,"invbst","","","magically charged",5},
	{"War Staff","staf","wst",0,0,0,1,12,28,0,0,20,100,0,0,0,0,24,1985,"stf","stf",5,"staf",2,4,0,"invwst","","","magically charged",5},
	{"Short Bow","bow","sbw",0,0,0,1,1,4,0,0,5,0,100,0,15,1,1,100,"bow","bow",6,"bow",2,3,0,"invsbw","","","",1},
	{"Hunter's Bow","bow","hbw",0,0,0,1,2,6,0,0,-10,0,100,0,28,1,5,350,"bow","bow",6,"bow",2,3,0,"invhbw","","","",1},
	{"Long Bow","bow","lbw",0,0,0,1,3,10,0,0,0,0,100,22,19,1,8,490,"bow","bow",6,"bow",2,4,0,"invlbw","","","",1},
	{"Composite Bow","bow","cbw",0,0,0,1,4,8,0,0,-10,0,100,25,35,1,12,727,"bow","bow",6,"bow",2,3,0,"invcbw","invcbwu","invcbwu","",1},
	{"Short Battle Bow","bow","sbb",0,0,0,1,5,11,0,0,0,0,100,30,40,1,18,1045,"bow","bow",6,"bow",2,3,0,"invsbb","invsbbu","invsbbu","",1},
	{"Long Battle Bow","bow","lbb",0,0,0,1,3,18,0,0,10,0,100,40,50,1,23,1545,"bow","bow",6,"bow",2,4,0,"invlbb","","","",1},
	{"Short War Bow","bow","swb",0,0,0,1,6,14,0,0,0,0,100,35,55,1,27,2500,"bow","bow",6,"bow",2,3,0,"invswb","invswbu","invswbu","",1},
	{"Long War Bow","bow","lwb",0,0,0,1,3,23,0,0,10,0,100,50,65,1,31,3575,"bow","bow",6,"bow",2,4,0,"invlwb","","","",1},
	{"Light Crossbow","xbow","lxb",0,0,0,1,6,9,0,0,-10,0,100,21,27,1,6,803,"xbw","xbw",5,"xbow",2,3,0,"invlxb","invlxbu","invlxbu","reload lag between shots",1},
	{"Crossbow","xbow","mxb",0,0,0,1,9,16,0,0,0,0,100,40,33,1,15,2345,"xbw","xbw",5,"xbow",2,3,0,"invmxb","invmxbu","invmxbu","reload lag between shots",1},
	{"Heavy Crossbow","xbow","hxb",0,0,0,1,14,26,0,0,10,0,100,60,40,1,24,4096,"xbw","xbw",5,"xbow",2,4,0,"invhxb","invhxbu","invhxbu","reload lag between shots",1},
	{"Repeating Crossbow","xbow","rxb",0,0,0,1,6,12,0,0,-40,0,100,40,50,1,33,2739,"xbw","xbw",5,"xbow",2,3,0,"invrxb","invrxbu","invrxbu","fires 5 shots before reload",1},
	{"Rancid Gas Potion","tpot","gps",0,1,0,0,0,0,0,0,0,0,0,0,0,1,32,200,"1ht","1ht",5,"hth",1,1,1,"invgpl","","","",0},
	{"Oil Potion","tpot","ops",0,1,0,0,0,0,0,0,0,0,0,0,0,1,28,150,"1ht","1ht",5,"hth",1,1,1,"invopl","","","",0},
	{"Choking Gas Potion","tpot","gpm",0,1,0,0,0,0,0,0,0,0,0,0,0,1,20,120,"1ht","1ht",5,"hth",1,1,1,"invgpm","","","",0},
	{"Exploding Potion","tpot","opm",0,1,0,0,0,0,0,0,0,0,0,0,0,1,16,80,"1ht","1ht",5,"hth",1,1,1,"invopm","","","",0},
	{"Strangling Gas Potion","tpot","gpl",0,1,0,0,0,0,0,0,0,0,0,0,0,1,8,40,"1ht","1ht",5,"hth",1,1,1,"invgps","","","",0},
	{"Fulminating Potion","tpot","opl",0,1,0,0,0,0,0,0,0,0,0,0,0,1,4,24,"1ht","1ht",5,"hth",1,1,1,"invops","","","",0},
	{"decoy dagger","knif","d33",1,2,0,0,0,0,0,0,-20,100,0,15,20,0,0,666,"1ht","1ht",5,"1ht",1,2,0,"invd33","","","",3},
	{"Gidbinn","knif","g33",3,7,0,0,0,0,0,0,-20,100,0,15,25,0,0,666,"1ht","1ht",5,"1ht",1,2,0,"invg33","","","",3},
	{"Wirt's Leg","club","leg",2,8,0,0,0,0,0,0,-10,100,0,0,0,0,0,20,"1hs","1hs",5,"1hsl",1,3,0,"invleg","","","",1},
	{"Horadric Malus","hamm","hdm",6,15,0,0,0,0,0,0,20,100,0,15,15,0,0,600,"1hs","1hs",5,"1hsl",1,2,0,"invhmr","","","",0},
	{"Hellforge Hammer","hamm","hfh",6,15,0,0,0,0,0,0,0,100,0,0,0,0,0,600,"1hs","1hs",5,"1hsl",2,3,0,"invhfh","","","",1},
	{"Horadric Staff","staf","hst",0,0,0,1,12,20,0,0,0,100,0,30,0,0,0,1223,"stf","stf",5,"staf",1,4,0,"invhst","","","magically charged",5},
	{"Staff of the Kings","staf","msf",0,0,0,1,10,15,0,0,0,100,0,25,0,0,0,1223,"stf","stf",5,"staf",1,3,0,"invmsf","","","magically charged",5},
	{"Hatchet","axe","9ha",10,21,0,0,0,0,0,0,0,100,0,25,25,0,31,810,"1hs","1hs",5,"1hsl",1,3,0,"invhax","invhaxu","invhaxu","",3},
	{"Cleaver","axe","9ax",10,33,0,0,0,0,0,0,10,100,0,68,0,0,34,1509,"1hs","1hs",5,"1hsl",2,3,0,"invaxe","invaxeu","invaxeu","",3},
	{"Twin Axe","axe","92a",13,38,0,0,0,0,0,0,10,100,0,85,0,0,39,2919,"1hs","1hs",5,"1hsl",2,3,0,"inv2ax","","","",3},
	{"Crowbill","axe","9mp",14,34,0,0,0,0,0,0,-10,100,0,94,70,0,43,4563,"1hs","1hs",5,"1hsl",2,3,0,"invmpi","invmpiu","invmpiu","",3},
	{"Naga","axe","9wa",16,45,0,0,0,0,0,0,0,100,0,121,0,0,48,6669,"1hs","1hs",5,"1hsl",2,3,0,"invwax","","","",3},
	{"Military Axe","axe","9la",0,0,0,1,14,34,0,0,-10,100,0,73,0,0,34,1362,"stf","stf",5,"2hsl",2,3,0,"invlax","","","",3},
	{"Bearded Axe ","axe","9ba",0,0,0,1,21,49,0,0,0,100,0,92,0,0,38,2718,"stf","stf",5,"2hsl",2,3,0,"invbrx","","","",3},
	{"Tabar","axe","9bt",0,0,0,1,24,77,0,0,10,100,0,101,0,0,42,4086,"stf","stf",5,"2hsl",2,3,0,"invbtx","inv9btu","inv9btu","",3},
	{"Gothic Axe","axe","9ga",0,0,0,1,18,70,0,0,-10,100,0,115,79,0,46,6048,"stf","stf",5,"2hsl",2,4,0,"invgax","invgaxu","invgaxu","",3},
	{"Ancient Axe","axe","9gi",0,0,0,1,43,85,0,0,10,100,0,125,0,0,51,7530,"stf","stf",5,"2hsl",2,3,0,"invgix","inv9giu","inv9giu","",3},
	{"Burnt Wand","wand","9wn",8,18,0,0,0,0,0,0,0,100,0,25,0,0,31,915,"1hs","1hs",5,"1hss",1,2,0,"invwnd","","","magically charged",5},
	{"Petrified Wand","wand","9yw",8,24,0,0,0,0,0,0,10,100,0,25,0,0,38,2535,"1hs","1hs",5,"1hss",1,2,0,"invywn","","","magically charged",5},
	{"Tomb Wand","wand","9bw",10,22,0,0,0,0,0,0,-20,100,0,25,0,0,43,4188,"1hs","1hs",5,"1hss",1,2,0,"invbwn","invbwnu","invbwnu","magically charged",5},
	{"Grave Wand","wand","9gw",13,29,0,0,0,0,0,0,0,100,0,25,0,0,49,6594,"1hs","1hs",5,"1hss",1,2,0,"invgwn","inv9gwu","inv9gwu","magically charged",5},
	{"Cudgel","club","9cl",6,21,0,0,0,0,0,0,-10,100,0,25,0,0,30,396,"1hs","1hs",5,"club",1,3,0,"invclb","invclbu","invclbu","",1},
	{"Rune Scepter","scep","9sc",13,24,0,0,0,0,0,0,0,100,0,58,0,0,31,1350,"1hs","1hs",5,"club",1,3,0,"invscp","","","magically charged",3},
	{"Holy Water Sprinkler","scep","9qs",14,36,0,0,0,0,0,0,10,100,0,76,0,0,40,3627,"1hs","1hs",5,"club",1,3,0,"invgsc","","","magically charged",3},
	{"Divine Scepter","scep","9ws",16,38,0,0,0,0,0,0,-10,100,0,103,0,0,45,7269,"1hs","1hs",5,"club",2,3,0,"invwsp","","","magically charged",3},
	{"Barbed Club","club","9sp",13,25,0,0,0,0,0,0,0,100,0,30,0,0,32,975,"1hs","1hs",5,"1hsl",1,3,0,"invspc","invspcu","invspcu","",1},
	{"Flanged Mace","mace","9ma",15,23,0,0,0,0,0,0,0,100,0,61,0,0,35,1689,"1hs","1hs",5,"1hsl",1,3,0,"invmac","","","",3},
	{"Jagged Star","mace","9mt",20,31,0,0,0,0,0,0,10,100,0,74,0,0,39,2832,"1hs","1hs",5,"1hsl",1,3,0,"invmst","invmstu","invmstu","",3},
	{"Knout","mace","9fl",13,35,0,0,0,0,0,0,-10,100,0,82,73,0,43,4536,"1hs","1hs",5,"1hsl",2,3,0,"invfla","","","",3},
	{"Battle Hammer","hamm","9wh",35,58,0,0,0,0,0,0,20,110,0,100,0,0,48,6543,"1hs","1hs",5,"1hsl",2,3,0,"invwhm","","","",3},
	{"War Club","hamm","9m9",0,0,0,1,53,78,0,0,10,110,0,124,0,0,45,5310,"stf","stf",5,"2hsl",2,4,0,"invmau","","","",3},
	{"Martel de Fer","hamm","9gm",0,0,0,1,61,99,0,0,20,110,0,169,0,0,53,9945,"stf","stf",5,"2hsl",2,3,0,"invgma","inv9gmu","inv9gmu","",3},
	{"Gladius","swor","9ss",8,22,0,0,0,0,0,0,0,100,0,25,0,0,30,516,"1hs","1hs",5,"1hsl",1,3,0,"invssd","","","",3},
	{"Cutlass","swor","9sm",8,21,0,0,0,0,0,0,-30,100,0,25,52,0,43,1122,"1hs","1hs",5,"1hsl",1,3,0,"invscm","invscmu","invscmu","",3},
	{"Shamshir","swor","9sb",10,24,0,0,0,0,0,0,-10,100,0,58,58,0,35,1698,"1hs","1hs",5,"1hsl",1,3,0,"invsbr","invsbru","invsbru","",3},
	{"Tulwar","swor","9fc",16,35,0,0,0,0,0,0,20,100,0,70,42,0,37,2349,"1hs","1hs",5,"1hsl",1,3,0,"invflc","","","",3},
	{"Dimensional Blade","swor","9cr",13,35,0,0,0,0,0,0,0,100,0,85,60,0,37,6681,"1hs","1hs",5,"1hsl",2,3,0,"invcrs","inv9cru","inv9cru","",1},
	{"Battle Sword","swor","9bs",16,34,0,0,0,0,0,0,0,100,0,92,43,0,40,3387,"1hs","1hs",5,"1hsl",2,3,0,"invbsd","","","",3},
	{"Rune Sword","swor","9ls",10,42,0,0,0,0,0,0,-10,100,0,103,79,0,44,4860,"1hs","1hs",5,"1hsl",2,3,0,"invlsd","inv9lsu","inv9lsu","",3},
	{"Ancient Sword","swor","9wd",18,43,0,0,0,0,0,0,0,100,0,127,88,0,49,6291,"1hs","1hs",5,"1hsl",1,3,0,"invwsd","","","",3},
	{"Espadon","swor","92h",8,26,1,1,18,40,0,0,0,100,0,73,61,0,37,2232,"1hs","2hs",5,"2hss",1,4,0,"inv2hs","inv2hsu","inv2hsu","",3},
	{"Dacian Falx","swor","9cm",13,30,1,1,26,61,0,0,10,100,0,91,20,0,42,4086,"1hs","2hs",5,"2hss",1,4,0,"invclm","","","",3},
	{"Tusk Sword","swor","9gs",10,37,1,1,19,58,0,0,0,100,0,104,71,0,45,4677,"1hs","2hs",5,"2hss",1,4,0,"invgis","invgisu","invgisu","",3},
	{"Gothic Sword","swor","9b9",14,40,1,1,39,60,0,0,10,100,0,113,20,0,48,6213,"1hs","2hs",5,"2hss",1,4,0,"invbsw","invbswu","invbswu","",3},
	{"Zweihander","swor","9fb",19,35,1,1,29,54,0,0,-10,100,0,125,94,0,49,7500,"1hs","2hs",5,"2hss",2,4,0,"invflb","inv9fbu","inv9fbu","",3},
	{"Executioner Sword","swor","9gd",24,40,1,1,47,80,0,0,10,100,0,170,110,0,54,10653,"1hs","2hs",5,"2hss",2,4,0,"invgsd","invgsdu","invgsdu","",3},
	{"Poignard","knif","9dg",6,18,0,0,0,0,0,0,-20,50,50,25,0,0,31,480,"1ht","1ht",5,"1ht",1,2,0,"invdgr","","","",3},
	{"Rondel","knif","9di",10,26,0,0,0,0,0,0,0,50,50,25,58,0,36,1896,"1ht","1ht",5,"1ht",1,2,0,"invdir","","","",3},
	{"Cinquedeas","knif","9kr",15,31,0,0,0,0,0,0,-20,50,50,25,88,0,42,3981,"1ht","1ht",5,"1ht",1,3,0,"invkrs","invkrsu","invkrsu","",3},
	{"Stilleto","knif","9bl",19,36,0,0,0,0,0,0,-10,50,50,47,97,0,46,5592,"1ht","1ht",5,"1ht",1,3,0,"invbld","inv9blu","inv9blu","",3},
	{"Battle Dart","tkni","9tk",8,16,0,0,0,0,11,24,0,50,50,25,52,0,31,80,"1ht","1ht",5,"1ht",1,2,1,"invtkn","","","primarily thrown",3},
	{"Francisca","taxe","9ta",11,22,0,0,0,0,18,33,10,50,50,25,80,0,34,90,"1hs","1hs",5,"1hsl",1,2,1,"invtax","","","primarily thrown",3},
	{"War Dart","tkni","9bk",6,24,0,0,0,0,14,27,-20,50,50,25,97,0,39,100,"1ht","1ht",5,"1ht",1,2,1,"invbkf","","","primarily thrown",3},
	{"Hurlbat","taxe","9b8",13,27,0,0,0,0,24,34,-10,50,50,25,106,0,41,110,"1hs","1hs",5,"1hsl",2,3,1,"invbal","","","primarily thrown",3},
	{"War Javelin","jave","9ja",6,19,0,0,0,0,14,32,-10,50,50,25,25,0,30,120,"1ht","1ht",5,"1ht",1,3,1,"invjav","","","primarily thrown",3},
	{"Great Pilum","jave","9pi",11,26,0,0,0,0,16,42,0,50,50,25,88,0,37,125,"1ht","1ht",5,"1ht",1,3,1,"invpil","","","primarily thrown",3},
	{"Simbilan","jave","9s9",8,32,0,0,0,0,27,50,10,50,50,80,80,0,40,135,"1ht","1ht",5,"1ht",1,3,1,"invssp","","","primarily thrown",3},
	{"Spiculum","jave","9gl",13,38,0,0,0,0,32,60,20,50,50,98,73,0,46,145,"1ht","1ht",5,"1ht",1,4,1,"invglv","","","primarily thrown",3},
	{"Harpoon","jave","9ts",13,35,0,0,0,0,18,54,-10,50,50,25,118,0,51,150,"1ht","1ht",5,"1ht",1,4,1,"invtsp","","","primarily thrown",3},
	{"War Spear","spea","9sr",0,0,0,1,10,37,0,0,-10,100,0,25,25,0,33,1200,"2ht","2ht",5,"2ht",2,4,0,"invspr","","","2 square reach",3},
	{"Fuscina","spea","9tr",0,0,0,1,19,37,0,0,0,100,0,77,25,0,36,2349,"2ht","2ht",5,"2ht",2,4,0,"invtri","invtriu","invtriu","2 square reach",3},
	{"War Fork","spea","9br",0,0,0,1,16,40,0,0,-20,100,0,80,95,0,41,3786,"2ht","2ht",5,"2ht",2,4,0,"invbrn","inv9bru","inv9bru","2 square reach",3},
	{"Yari","spea","9st",0,0,0,1,29,59,0,0,0,100,0,101,0,0,44,5316,"2ht","2ht",5,"2ht",2,4,0,"invspt","","","2 square reach",3},
	{"Lance","spea","9p9",0,0,0,1,27,114,0,0,20,100,0,110,88,0,47,6369,"2ht","2ht",5,"2ht",2,4,0,"invpik","","","3 square reach",3},
	{"Lochaber Axe","pole","9b7",0,0,0,1,6,58,0,0,10,100,0,80,0,0,33,1206,"stf","stf",5,"2hsl",2,4,0,"invbar","","","2 square reach",3},
	{"Bill","pole","9vo",0,0,0,1,14,53,0,0,0,100,0,95,0,0,37,2133,"stf","stf",5,"2hsl",2,4,0,"invvou","","","2 square reach",3},
	{"Battle Scythe","pole","9s8",0,0,0,1,18,45,0,0,-10,100,0,82,82,0,40,2844,"stf","stf",5,"2hsl",2,4,0,"invscy","inv9s8u","inv9s8u","2 square reach",3},
	{"Partizan","pole","9pa",0,0,0,1,34,75,0,0,10,100,0,113,67,0,35,5403,"stf","stf",5,"2hsl",2,4,0,"invpax","","","2 square reach",3},
	{"Bec-de-Corbin","pole","9h9",0,0,0,1,13,85,0,0,0,100,0,133,91,0,51,8418,"stf","stf",5,"2hsl",2,4,0,"invhal","","","2 square reach",3},
	{"Grim Scythe","pole","9wc",0,0,0,1,30,70,0,0,-10,100,0,140,140,0,55,10464,"stf","stf",5,"2hsl",2,4,0,"invwsc","","","2 square reach",3},
	{"Jo Staff","staf","8ss",0,0,0,1,6,21,0,0,-10,100,0,25,0,0,30,804,"stf","stf",5,"club",1,3,0,"invsst","","","magically charged",5},
	{"Quarterstaff","staf","8ls",0,0,0,1,8,26,0,0,0,100,0,25,0,0,35,1689,"stf","stf",5,"staf",1,4,0,"invlst","","","magically charged",5},
	{"Cedar Staff","staf","8cs",0,0,0,1,11,32,0,0,10,100,0,25,0,0,38,2598,"stf","stf",5,"staf",1,4,0,"invcst","invcstu","invcstu","magically charged",5},
	{"Gothic Staff","staf","8bs",0,0,0,1,14,34,0,0,0,100,0,25,0,0,42,3969,"stf","stf",5,"staf",1,4,0,"invbst","","","magically charged",5},
	{"Rune Staff","staf","8ws",0,0,0,1,24,58,0,0,20,100,0,25,0,0,47,6255,"stf","stf",5,"staf",2,4,0,"invwst","inv8wsu","inv8wsu","magically charged",5},
	{"Edge Bow","bow","8sb",0,0,0,1,6,19,0,0,5,0,100,25,43,1,30,600,"bow","bow",6,"bow",2,3,0,"invsbw","","","",1},
	{"Razor Bow","bow","8hb",0,0,0,1,8,22,0,0,-10,0,100,25,62,1,33,1350,"bow","bow",6,"bow",2,3,0,"invhbw","","","",1},
	{"Cedar Bow","bow","8lb",0,0,0,1,10,29,0,0,0,0,100,53,49,1,35,1770,"bow","bow",6,"bow",2,4,0,"invlbw","inv8lbu","inv8lbu","",1},
	{"Double Bow","bow","8cb",0,0,0,1,11,26,0,0,-10,0,100,58,73,1,39,2481,"bow","bow",6,"bow",2,3,0,"invcbw","invcbwu","invcbwu","",1},
	{"Short Siege Bow","bow","8s8",0,0,0,1,13,30,0,0,0,0,100,65,80,1,43,3435,"bow","bow",6,"bow",2,3,0,"invsbb","inv8s8u","inv8s8u","",1},
	{"Long Siege Bow","bow","8l8",0,0,0,1,10,42,0,0,10,0,100,80,95,1,46,4935,"bow","bow",6,"bow",2,4,0,"invlbb","","","",1},
	{"Rune Bow","bow","8sw",0,0,0,1,14,35,0,0,0,0,100,73,103,1,49,7800,"bow","bow",6,"bow",2,3,0,"invswb","invswbu","invswbu","",1},
	{"Gothic Bow","bow","8lw",0,0,0,1,10,50,0,0,10,0,100,95,118,1,52,11025,"bow","bow",6,"bow",2,4,0,"invlwb","","","",1},
	{"Arbalest","xbow","8lx",0,0,0,1,14,27,0,0,-10,0,100,52,61,1,34,2709,"xbw","xbw",5,"xbow",2,3,0,"invlxb","inv8lxu","inv8lxu","reload lag between shots",1},
	{"Siege Crossbow","xbow","8mx",0,0,0,1,20,42,0,0,0,0,100,80,70,1,40,7335,"xbw","xbw",5,"xbow",2,3,0,"invmxb","inv8mxu","inv8mxu","reload lag between shots",1},
	{"Balista","xbow","8hx",0,0,0,1,33,55,0,0,10,0,100,110,80,1,47,12588,"xbw","xbw",5,"xbow",2,4,0,"invhxb","invhxbu","invhxbu","reload lag between shots",1},
	{"Chu-Ko-Nu","xbow","8rx",0,0,0,1,14,32,0,0,-60,0,100,80,95,1,54,8517,"xbw","xbw",5,"xbow",2,3,0,"invrxb","invrxbu","invrxbu","fires 5 shots before reload",1},
	{"KhalimFlail","mace","qf1",1,15,0,0,0,0,0,0,-10,100,0,41,35,0,0,1412,"1hs","1hs",5,"1hsl",2,3,0,"invqf1","","","",1},
	{"SuperKhalimFlail","mace","qf2",1,15,0,0,0,0,0,0,-10,100,0,0,0,0,0,1412,"1hs","1hs",5,"1hsl",2,3,0,"invqf2","","","",1},
	{"Katar","h2h","ktr",4,7,0,0,0,0,0,0,-10,50,50,20,20,0,1,72,"ht1","ht1",5,"1hsl",1,3,0,"invktr","","","",3},
	{"Wrist Blade","h2h","wrb",5,9,0,0,0,0,0,0,0,50,50,35,35,0,9,220,"ht1","ht1",5,"1hsl",1,3,0,"invktr","","","",3},
	{"Hatchet Hands","h2h","axf",2,15,0,0,0,0,0,0,10,50,50,40,40,0,12,466,"ht1","ht1",5,"1hsl",1,3,0,"invaxf","invaxfu","invaxfu","",3},
	{"Cestus","h2h","ces",7,15,0,0,0,0,0,0,0,50,50,45,45,0,15,514,"ht1","ht1",5,"1hsl",1,3,0,"invaxf","invaxfu","invaxfu","",3},
	{"Claws","h2h","clw",8,15,0,0,0,0,0,0,-10,50,50,50,50,0,18,683,"ht1","ht1",5,"1hsl",1,3,0,"invclw","","","",3},
	{"Blade Talons","h2h","btl",10,14,0,0,0,0,0,0,-20,50,50,55,55,0,21,847,"ht1","ht1",5,"1hsl",1,3,0,"invclw","","","",3},
	{"Scissors Katar","h2h","skr",9,17,0,0,0,0,0,0,-10,50,50,60,60,0,24,1029,"ht1","ht1",5,"1hsl",1,3,0,"invskr","invskru","invskru","",3},
	{"Quhab","h2h","9ar",11,24,0,0,0,0,0,0,0,50,50,65,65,0,26,2334,"ht1","ht1",5,"1hsl",1,3,0,"invktr","","","",3},
	{"Wrist Spike","h2h","9wb",13,27,0,0,0,0,0,0,-10,50,50,73,73,0,32,4203,"ht1","ht1",5,"1hsl",1,3,0,"invktr","","","",3},
	{"Fascia","h2h","9xf",8,37,0,0,0,0,0,0,10,50,50,80,80,0,34,4203,"ht1","ht1",5,"1hsl",1,3,0,"invaxf","invaxfu","invaxfu","",3},
	{"Hand Scythe","h2h2","9cs",16,37,0,0,0,0,0,0,-10,50,50,88,88,0,36,2964,"ht1","ht1",5,"1hsl",1,3,0,"invaxf","invaxfu","invaxfu","",3},
	{"Greater Claws","h2h2","9lw",18,37,0,0,0,0,0,0,-20,50,50,95,95,0,39,5061,"ht1","ht1",5,"1hsl",1,3,0,"invclw","","","",3},
	{"Greater Talons","h2h2","9tw",21,35,0,0,0,0,0,0,-30,50,50,103,103,0,41,9291,"ht1","ht1",5,"1hsl",1,3,0,"invclw","","","",3},
	{"Scissors Quhab","h2h2","9qr",19,40,0,0,0,0,0,0,0,50,50,110,110,0,43,14223,"ht1","ht1",5,"1hsl",1,3,0,"invskr","invskru","invskru","",3},
	{"Suwayyah","h2h2","7ar",17,40,0,0,0,0,0,0,0,50,50,120,120,0,54,16205,"ht1","ht1",5,"1hsl",1,3,0,"invktr","","","",3},
	{"Wrist Sword","h2h2","7wb",19,44,0,0,0,0,0,0,-10,50,50,123,117,0,59,16996,"ht1","ht1",5,"1hsl",1,3,0,"invktr","","","",3},
	{"War Fist","h2h2","7xf",13,56,0,0,0,0,0,0,10,50,50,126,122,0,61,15784,"ht1","ht1",5,"1hsl",1,3,0,"invaxf","invaxfu","invaxfu","",3},
	{"Battle Cestus","h2h2","7cs",23,56,0,0,0,0,0,0,-10,50,50,113,129,0,62,15537,"ht1","ht1",5,"1hsl",1,3,0,"invaxf","invaxfu","invaxfu","",3},
	{"Feral Claws","h2h2","7lw",25,56,0,0,0,0,0,0,-20,50,50,115,134,0,64,16035,"ht1","ht1",5,"1hsl",1,3,0,"invclw","","","",3},
	{"Runic Talons","h2h2","7tw",29,54,0,0,0,0,0,0,-30,50,50,105,140,0,66,17396,"ht1","ht1",5,"1hsl",1,3,0,"invclw","","","",3},
	{"Scissors Suwayyah","h2h2","7qr",27,59,0,0,0,0,0,0,0,50,50,130,123,0,67,18002,"ht1","ht1",5,"1hsl",1,3,0,"invskr","invskru","invskru","",3},
	{"Tomahawk","axe","7ha",18,47,0,0,0,0,0,0,0,100,0,87,95,0,58,14033,"1hs","1hs",5,"1hsl",1,3,0,"invhax","invhaxu","invhaxu","",3},
	{"Small Crescent","axe","7ax",22,57,0,0,0,0,0,0,10,100,0,95,83,0,61,15781,"1hs","1hs",5,"1hsl",2,3,0,"invaxe","invaxeu","invaxeu","",3},
	{"Ettin Axe","axe","72a",19,60,0,0,0,0,0,0,10,100,0,121,69,0,64,13496,"1hs","1hs",5,"1hsl",2,3,0,"inv2ax","","","",3},
	{"War Spike","axe","7mp",13,46,0,0,0,0,0,0,-10,100,0,144,55,0,67,16108,"1hs","1hs",5,"1hsl",2,3,0,"invmpi","invmpiu","invmpiu","",3},
	{"Berserker Axe","axe","7wa",3,64,0,0,0,0,0,0,0,100,0,149,0,0,71,15957,"1hs","1hs",5,"1hsl",2,3,0,"invwax","","","",3},
	{"Feral Axe","axe","7la",0,0,0,1,10,88,0,0,-15,100,0,165,45,0,61,17430,"stf","stf",5,"2hsl",2,3,0,"invlax","","","",3},
	{"Silver Edged Axe","axe","7ba",0,0,0,1,39,87,0,0,0,100,0,130,87,0,64,18956,"stf","stf",5,"2hsl",2,3,0,"invbrx","","","",3},
	{"Decapitator","axe","7bt",0,0,0,1,40,107,0,0,10,100,0,175,0,0,67,16377,"stf","stf",5,"2hsl",2,3,0,"invbtx","invbtxu","invbtxu","",3},
	{"Champion Axe","axe","7ga",0,0,0,1,26,82,0,0,-10,100,0,143,65,0,70,19245,"stf","stf",5,"2hsl",2,4,0,"invgax","invgaxu","invgaxu","",3},
	{"Glorious Axe","axe","7gi",0,0,0,1,16,132,0,0,10,100,0,155,73,0,73,18431,"stf","stf",5,"2hsl",2,3,0,"invgix","","","",3},
	{"Polished Wand","wand","7wn",18,33,0,0,0,0,0,0,0,100,0,35,61,0,58,9412,"1hs","1hs",5,"1hss",1,2,0,"invwnd","","","magically charged",5},
	{"Ghost Wand","wand","7yw",20,42,0,0,0,0,0,0,10,100,0,25,75,0,64,8786,"1hs","1hs",5,"1hss",1,2,0,"invywn","","","magically charged",5},
	{"Lich Wand","wand","7bw",9,31,0,0,0,0,0,0,-20,100,0,33,67,0,67,9208,"1hs","1hs",5,"1hss",1,2,0,"invbwn","invbwnu","invbwnu","magically charged",5},
	{"Unearthed Wand","wand","7gw",22,28,0,0,0,0,0,0,0,100,0,42,56,0,72,7687,"1hs","1hs",5,"1hss",1,2,0,"invgwn","","","magically charged",5},
	{"Truncheon","club","7cl",14,45,0,0,0,0,0,0,-10,100,0,57,65,0,58,1488,"1hs","1hs",5,"club",1,3,0,"invclb","invclbu","invclbu","",1},
	{"Mighty Scepter","scep","7sc",24,47,0,0,0,0,0,0,0,100,0,158,76,0,58,20199,"1hs","1hs",5,"club",1,3,0,"invscp","","","magically charged",3},
	{"Seraph Rod","scep","7qs",27,51,0,0,0,0,0,0,10,100,0,123,105,0,65,23501,"1hs","1hs",5,"club",1,3,0,"invgsc","","","magically charged",3},
	{"Caduceus","scep","7ws",19,40,0,0,0,0,0,0,-10,100,0,117,117,0,69,22870,"1hs","1hs",5,"club",2,3,0,"invwsp","","","magically charged",3},
	{"Tyrant Club","club","7sp",13,52,0,0,0,0,0,0,0,100,0,103,52,0,59,6793,"1hs","1hs",5,"1hsl",1,3,0,"invspc","invspcu","invspcu","",1},
	{"Reinforced Mace","mace","7ma",22,43,0,0,0,0,0,0,0,100,0,112,62,0,61,14765,"1hs","1hs",5,"1hsl",1,3,0,"invmac","","inv7mas","",3},
	{"Devil Star","mace","7mt",28,52,0,0,0,0,0,0,10,100,0,97,85,0,64,15674,"1hs","1hs",5,"1hsl",1,3,0,"invmst","invmstu","invmstu","",3},
	{"Scourge","mace","7fl",3,57,0,0,0,0,0,0,-10,100,0,88,122,0,67,19532,"1hs","1hs",5,"1hsl",2,3,0,"invfla","","","",3},
	{"Legendary Mallet","hamm","7wh",46,53,0,0,0,0,0,0,20,110,0,145,0,0,71,14388,"1hs","1hs",5,"1hsl",2,3,0,"invwhm","","","",3},
	{"Ogre Maul","hamm","7m7",0,0,0,1,66,91,0,0,10,110,0,176,0,0,69,12156,"stf","stf",5,"2hsl",2,4,0,"invmau","","","",3},
	{"Thunder Maul","hamm","7gm",0,0,0,1,9,172,0,0,20,110,0,218,0,0,75,17821,"stf","stf",5,"2hsl",2,3,0,"invgma","","","",3},
	{"Falcata","swor","7ss",22,42,0,0,0,0,0,0,0,100,0,95,143,0,58,15680,"1hs","1hs",5,"1hsl",1,3,0,"invssd","","","",3},
	{"Ataghan","swor","7sm",8,38,0,0,0,0,0,0,-20,100,0,102,137,0,67,16103,"1hs","1hs",5,"1hsl",1,3,0,"invscm","invscmu","invscmu","",3},
	{"Elegant Blade","swor","7sb",12,40,0,0,0,0,0,0,-10,100,0,105,134,0,61,22785,"1hs","1hs",5,"1hsl",1,3,0,"invsbr","invsbru","invsbru","",3},
	{"Hydra Edge","swor","7fc",24,63,0,0,0,0,0,0,20,100,0,112,119,0,63,18479,"1hs","1hs",5,"1hsl",1,3,0,"invflc","","","",3},
	{"Phase Blade","swor","7cr",24,27,0,0,0,0,0,0,-30,100,0,106,145,0,63,25680,"1hs","1hs",5,"1hsl",2,3,0,"invcrs","invcrsu","invcrsu","",1},
	{"Conquest Sword","swor","7bs",18,47,0,0,0,0,0,0,0,100,0,130,88,0,65,19044,"1hs","1hs",5,"1hsl",2,3,0,"invbsd","","","",3},
	{"Cryptic Sword","swor","7ls",5,54,0,0,0,0,0,0,-10,100,0,125,110,0,68,14306,"1hs","1hs",5,"1hsl",2,3,0,"invlsd","invlsdu","invlsdu","",3},
	{"Mythical Sword","swor","7wd",13,52,0,0,0,0,0,0,0,100,0,157,40,0,72,20187,"1hs","1hs",5,"1hsl",1,3,0,"invwsd","","","",3},
	{"Legend Sword","swor","72h",20,38,1,1,40,66,0,0,-15,100,0,127,130,0,63,23789,"1hs","2hs",5,"2hss",1,4,0,"inv2hs","inv2hsu","inv2hsu","",3},
	{"Highland Blade","swor","7cm",23,47,1,1,47,78,0,0,-5,100,0,134,125,0,67,14391,"1hs","2hs",5,"2hss",1,4,0,"invclm","","","",3},
	{"Balrog Blade","swor","7gs",12,58,1,1,31,94,0,0,0,100,0,142,119,0,69,16331,"1hs","2hs",5,"2hss",1,4,0,"invgis","invgisu","invgisu","",3},
	{"Champion Sword","swor","7b7",7,51,1,1,21,84,0,0,-10,100,0,156,107,0,71,19939,"1hs","2hs",5,"2hss",1,4,0,"invbsw","invbswu","invbswu","",3},
	{"Colossal Sword","swor","7fb",18,64,1,1,46,98,0,0,10,100,0,170,91,0,72,24800,"1hs","2hs",5,"2hss",2,4,0,"invflb","","","",3},
	{"Colossus Blade","swor","7gd",16,54,1,1,17,107,0,0,5,100,0,188,65,0,76,22259,"1hs","2hs",5,"2hss",2,4,0,"invgsd","invgsdu","invgsdu","",3},
	{"Bone Knife","knif","7dg",11,36,0,0,0,0,0,0,-20,50,50,65,75,0,58,12429,"1ht","1ht",5,"1ht",1,2,0,"invdgr","","","",3},
	{"Mithral Point","knif","7di",23,43,0,0,0,0,0,0,0,50,50,50,98,0,62,17988,"1ht","1ht",5,"1ht",1,2,0,"invdir","","","",3},
	{"Fanged Knife","knif","7kr",4,49,0,0,0,0,0,0,-20,50,50,54,86,0,67,13729,"1ht","1ht",5,"1ht",1,3,0,"invkrs","invkrsu","invkrsu","",3},
	{"Legend Spike","knif","7bl",11,48,0,0,0,0,0,0,-10,50,50,76,67,0,70,16076,"1ht","1ht",5,"1ht",1,3,0,"invbld","","","",3},
	{"Flying Knife","tkni","7tk",22,32,0,0,0,0,16,76,0,50,50,50,104,0,58,215,"1ht","1ht",5,"1ht",1,2,1,"invtkn","","","primarily thrown",3},
	{"Flying Axe","taxe","7ta",17,49,0,0,0,0,25,85,10,50,50,50,129,0,61,230,"1hs","1hs",5,"1hsl",1,2,1,"invtax","","","primarily thrown",3},
	{"Winged Knife","tkni","7bk",5,33,0,0,0,0,3,67,-20,50,50,50,136,0,64,248,"1ht","1ht",5,"1ht",1,2,1,"invbkf","","","primarily thrown",3},
	{"Winged Axe","taxe","7b8",3,40,0,0,0,0,7,68,-10,50,50,50,142,0,66,251,"1hs","1hs",5,"1hsl",2,3,1,"invbal","","","primarily thrown",3},
	{"Hyperion Javelin","jave","7ja",19,26,0,0,0,0,27,50,-10,50,50,100,124,0,58,211,"1ht","1ht",5,"1ht",1,3,1,"invjav","","","primarily thrown",3},
	{"Stygian Pilum","jave","7pi",14,42,0,0,0,0,21,72,0,50,50,128,125,0,63,220,"1ht","1ht",5,"1ht",1,3,1,"invpil","","","primarily thrown",3},
	{"Balrog Spear","jave","7s7",12,50,0,0,0,0,20,82,10,50,50,133,116,0,65,232,"1ht","1ht",5,"1ht",1,3,1,"invssp","","","primarily thrown",3},
	{"Ghost Glaive","jave","7gl",19,64,0,0,0,0,50,75,20,50,50,55,156,0,70,241,"1ht","1ht",5,"1ht",1,4,1,"invglv","","","primarily thrown",3},
	{"Winged Harpoon","jave","7ts",21,29,0,0,0,0,18,67,-10,50,50,75,145,0,73,199,"1ht","1ht",5,"1ht",1,4,1,"invtsp","","","primarily thrown",3},
	{"Hyperion Spear","spea","7sr",0,0,0,1,54,62,0,0,-10,100,0,155,120,0,60,15900,"2ht","2ht",5,"2ht",2,4,0,"invspr","","","2 square reach",3},
	{"Stygian Pike","spea","7tr",0,0,0,1,37,89,0,0,0,100,0,168,97,0,62,17347,"2ht","2ht",5,"2ht",2,4,0,"invtri","invtriu","invtriu","2 square reach",3},
	{"Mancatcher","spea","7br",0,0,0,1,26,80,0,0,-20,100,0,143,134,0,66,14658,"2ht","2ht",5,"2ht",2,4,0,"invbrn","","","2 square reach",3},
	{"Ghost Spear","spea","7st",0,0,0,1,40,85,0,0,0,100,0,122,163,0,68,17248,"2ht","2ht",5,"2ht",2,4,0,"invspt","","","2 square reach",3},
	{"War Pike","spea","7p7",0,0,0,1,54,106,0,0,20,100,0,165,105,0,70,16070,"2ht","2ht",5,"2ht",2,4,0,"invpik","","","3 square reach",3},
	{"Ogre Axe","pole","7o7",0,0,0,1,33,113,0,0,10,100,0,195,75,0,60,9871,"stf","stf",5,"2hsl",2,4,0,"invbar","","","2 square reach",3},
	{"Colossus Voulge","pole","7vo",0,0,0,1,7,119,0,0,0,100,0,210,55,0,63,12822,"stf","stf",5,"2hsl",2,4,0,"invvou","","","2 square reach",3},
	{"Thresher","pole","7s8",0,0,0,1,16,91,0,0,-10,100,0,152,118,0,65,11086,"stf","stf",5,"2hsl",2,4,0,"invscy","invscyu","invscyu","2 square reach",3},
	{"Cryptic Axe","pole","7pa",0,0,0,1,59,98,0,0,10,100,0,165,103,0,61,16509,"stf","stf",5,"2hsl",2,4,0,"invpax","","","2 square reach",3},
	{"Great Poleaxe","pole","7h7",0,0,0,1,19,107,0,0,0,100,0,179,99,0,73,21554,"stf","stf",5,"2hsl",2,4,0,"invhal","","","2 square reach",3},
	{"Giant Thresher","pole","7wc",0,0,0,1,20,97,0,0,-10,100,0,188,88,0,76,17692,"stf","stf",5,"2hsl",2,4,0,"invwsc","","","2 square reach",3},
	{"Walking Stick","staf","6ss",0,0,0,1,45,52,0,0,-10,100,0,50,35,0,58,8154,"stf","stf",5,"club",1,3,0,"invsst","","","magically charged",5},
	{"Stalagmite","staf","6ls",0,0,0,1,44,61,0,0,0,100,0,50,42,0,61,5367,"stf","stf",5,"staf",1,4,0,"invlst","","","magically charged",5},
	{"Elder Staff","staf","6cs",0,0,0,1,56,68,0,0,10,100,0,50,37,0,64,9048,"stf","stf",5,"staf",1,4,0,"invcst","invcstu","invcstu","magically charged",5},
	{"Shillelah","staf","6bs",0,0,0,1,23,83,0,0,0,100,0,50,48,0,67,7986,"stf","stf",5,"staf",1,4,0,"invbst","","","magically charged",5},
	{"Archon Staff","staf","6ws",0,0,0,1,66,77,0,0,20,100,0,50,32,0,70,10001,"stf","stf",5,"staf",2,4,0,"invwst","","","magically charged",5},
	{"Spider Bow","bow","6sb",0,0,0,1,21,49,0,0,5,0,100,67,188,1,58,21091,"bow","bow",6,"bow",2,3,0,"invsbw","","","",1},
	{"Blade Bow","bow","6hb",0,0,0,1,14,43,0,0,-10,0,100,76,181,1,60,21350,"bow","bow",6,"bow",2,3,0,"invhbw","","","",1},
	{"Shadow Bow","bow","6lb",0,0,0,1,13,58,0,0,0,0,100,82,195,1,61,25610,"bow","bow",6,"bow",2,4,0,"invlbw","","","",1},
	{"Great Bow","bow","6cb",0,0,0,1,3,54,0,0,-10,0,100,89,165,1,64,17743,"bow","bow",6,"bow",2,3,0,"invcbw","invcbwu","invcbwu","",1},
	{"Diamond Bow","bow","6s7",0,0,0,1,33,38,0,0,0,0,100,77,172,1,67,24605,"bow","bow",6,"bow",2,3,0,"invsbb","invsbbu","invsbbu","",1},
	{"Crusader Bow","bow","6l7",0,0,0,1,15,63,0,0,10,0,100,116,134,1,70,18105,"bow","bow",6,"bow",2,4,0,"invlbb","","","",1},
	{"Ward Bow","bow","6sw",0,0,0,1,18,53,0,0,0,0,100,107,143,1,72,15042,"bow","bow",6,"bow",2,3,0,"invswb","invswbu","invswbu","",1},
	{"Hydra Bow","bow","6lw",0,0,0,1,10,68,0,0,10,0,100,134,161,1,74,19375,"bow","bow",6,"bow",2,4,0,"invlwb","","","",1},
	{"Pellet Bow","xbow","6lx",0,0,0,1,14,73,0,0,-10,0,100,82,155,1,61,19512,"xbw","xbw",5,"xbow",2,3,0,"invlxb","invlxbu","invlxbu","reload lag between shots",1},
	{"Gorgon Crossbow","xbow","6mx",0,0,0,1,15,87,0,0,0,0,100,116,103,1,65,22305,"xbw","xbw",5,"xbow",2,3,0,"invmxb","invmxbu","invmxbu","reload lag between shots",1},
	{"Colossus Crossbow","xbow","6hx",0,0,0,1,28,91,0,0,10,0,100,152,77,1,70,26065,"xbw","xbw",5,"xbow",2,4,0,"invhxb","invhxbu","invhxbu","reload lag between shots",1},
	{"Demon Crossbow","xbow","6rx",0,0,0,1,23,30,0,0,-60,0,100,121,98,1,76,25851,"xbw","xbw",5,"xbow",2,3,0,"invrxb","invrxbu","invrxbu","fires 5 shots before reload",1},
	{"Eagle Orb","orb","ob1",2,5,0,0,0,0,0,0,-10,100,0,0,0,0,1,168,"1hs","1hs",5,"1hss",1,2,0,"invob1","","","",5},
	{"Sacred Globe","orb","ob2",3,8,0,0,0,0,0,0,-10,100,0,0,0,0,8,463,"1hs","1hs",5,"1hss",1,2,0,"invob2","","","",5},
	{"Smoked Sphere","orb","ob3",4,10,0,0,0,0,0,0,0,100,0,0,0,0,12,766,"1hs","1hs",5,"1hss",1,2,0,"invob3","","","",5},
	{"Clasped Orb","orb","ob4",5,12,0,0,0,0,0,0,0,100,0,0,0,0,17,1223,"1hs","1hs",5,"1hss",1,2,0,"invob4","","","",5},
	{"Dragon Stone","orb","ob5",8,18,0,0,0,0,0,0,10,100,0,0,0,0,24,1985,"1hs","1hs",5,"1hss",1,3,0,"invob5","","","",5},
	{"Stag Bow","abow","am1",0,0,0,1,7,13,0,0,0,0,100,35,55,1,18,2500,"bow","bow",6,"bow",2,4,0,"invam1","invswbu","invswbu","",1},
	{"Reflex Bow","abow","am2",0,0,0,1,5,22,0,0,10,0,100,50,65,1,24,3575,"bow","bow",6,"bow",2,4,0,"invam2","","","",1},
	{"Maiden Spear","aspe","am3",0,0,0,1,18,20,0,0,0,100,0,54,35,0,18,1672,"2ht","2ht",5,"2ht",2,4,0,"invam3","","","2 square reach",3},
	{"Maiden Pike","aspe","am4",0,0,0,1,23,55,0,0,10,100,0,60,45,0,24,2023,"2ht","2ht",5,"2ht",2,4,0,"invam4","","","3 square reach",3},
	{"Maiden Javelin","ajav","am5",6,14,0,0,0,0,5,24,-10,100,0,0,65,0,24,48,"1ht","1ht",5,"1ht",1,3,1,"invam5","","","primarily thrown",3},
	{"Glowing Orb","orb","ob6",8,21,0,0,0,0,0,0,-10,100,0,20,20,0,26,804,"1hs","1hs",5,"1hss",1,2,0,"invob1","","","",5},
	{"Crystalline Globe","orb","ob7",10,26,0,0,0,0,0,0,-10,100,0,20,20,0,31,1689,"1hs","1hs",5,"1hss",1,2,0,"invob2","","","",5},
	{"Cloudy Sphere","orb","ob8",11,29,0,0,0,0,0,0,0,100,0,20,20,0,34,2598,"1hs","1hs",5,"1hss",1,2,0,"invob3","","","",5},
	{"Sparkling Ball","orb","ob9",13,32,0,0,0,0,0,0,0,100,0,20,20,0,38,3969,"1hs","1hs",5,"1hss",1,2,0,"invob4","","","",5},
	{"Swirling Crystal","orb","oba",18,42,0,0,0,0,0,0,10,100,0,20,20,0,43,6255,"1hs","1hs",5,"1hss",1,3,0,"invob5","","","",5},
	{"Ashwood Bow","abow","am6",0,0,0,1,16,40,0,0,0,0,100,73,103,1,39,7800,"bow","bow",6,"bow",2,4,0,"invam1","invswbu","invswbu","",1},
	{"Ceremonial Bow","abow","am7",0,0,0,1,13,50,0,0,10,0,100,95,118,1,43,11025,"bow","bow",6,"bow",2,4,0,"invam2","","","",1},
	{"Ceremonial Spear","aspe","am8",0,0,0,1,34,45,0,0,0,100,0,101,73,0,39,5316,"2ht","2ht",5,"2ht",2,4,0,"invam3","","","2 square reach",3},
	{"Ceremonial Pike","aspe","am9",0,0,0,1,42,101,0,0,20,100,0,110,88,0,43,6369,"2ht","2ht",5,"2ht",2,4,0,"invam4","","","3 square reach",3},
	{"Ceremonial Javelin","ajav","ama",14,35,0,0,0,0,12,43,-10,100,0,0,118,0,43,444,"1ht","1ht",5,"1ht",1,3,1,"invam5","","","primarily thrown",3},
	{"Heavenly Stone","orb","obb",18,46,0,0,0,0,0,0,-10,100,0,44,44,0,54,21051,"1hs","1hs",5,"1hss",1,2,0,"invob1","","","",5},
	{"Eldritch Orb","orb","obc",20,54,0,0,0,0,0,0,-10,100,0,44,44,0,58,19367,"1hs","1hs",5,"1hss",1,2,0,"invob2","","","",5},
	{"Demon Heart","orb","obd",23,59,0,0,0,0,0,0,0,100,0,44,44,0,61,22094,"1hs","1hs",5,"1hss",1,2,0,"invob3","","","",5},
	{"Vortex Orb","orb","obe",25,64,0,0,0,0,0,0,0,100,0,44,44,0,63,25207,"1hs","1hs",5,"1hss",1,2,0,"invob4","","","",5},
	{"Dimensional Shard","orb","obf",33,79,0,0,0,0,0,0,10,100,0,44,44,0,67,20065,"1hs","1hs",5,"1hss",1,3,0,"invob5","","","",5},
	{"Matriarchal Bow","abow","amb",0,0,0,1,18,58,0,0,0,0,100,107,187,1,64,23700,"bow","bow",6,"bow",2,4,0,"invam1","invswbu","invswbu","",1},
	{"Grand Matron Bow","abow","amc",0,0,0,1,14,70,0,0,10,0,100,134,161,1,67,33375,"bow","bow",6,"bow",2,4,0,"invam2","","","",1},
	{"Matriarchal Spear","aspe","amd",0,0,0,1,45,87,0,0,0,100,0,141,145,0,64,16248,"2ht","2ht",5,"2ht",2,4,0,"invam3","","","2 square reach",3},
	{"Matriarchal Pike","aspe","ame",0,0,0,1,61,116,0,0,20,100,0,152,125,0,67,19407,"2ht","2ht",5,"2ht",2,4,0,"invam4","","","3 square reach",3},
	{"MatriarchalJavelin","ajav","amf",13,44,0,0,0,0,24,63,-10,100,0,107,161,0,67,302,"1ht","1ht",5,"1ht",1,3,1,"invam5","","","primarily thrown",3}
} ;


int GetNumberOfWeapons()
{
	return (sizeof gWeaponItems / sizeof gWeaponItems[0]) ;
}

CWeapon* GetWeaponRec( CString sCode) 
{
	for (int count=0; count<GetNumberOfWeapons(); count++) {
		if (sCode == gWeaponItems[ count].m_Code)
			return &gWeaponItems[ count] ;
	}
	return NULL ;
}




//{"name",levelreq,cost,"code",component,invwidth,invheight,"invfile","type",stackable,bitfield1},
struct CMisc gMiscItems[] = {
	{"elixir",0,20,"elx",16,1,1,"invpot","elix",0,0},
	{"Healing Potion",0,30,"hpo",16,1,1,"invrps","hpot",0,0},
	{"Mana Potion",0,30,"mpo",16,1,1,"invbps","mpot",0,0},
	{"Full Healing Potion",0,150,"hpf",16,1,1,"invrpl","hpot",0,0},
	{"Full Mana Potion",0,150,"mpf",16,1,1,"invbpl","mpot",0,0},
	{"Stamina Potion",0,25,"vps",16,1,1,"invwps","spot",0,0},
	{"Antidote Potion",0,40,"yps",16,1,1,"invnps","apot",0,0},
	{"Rejuv Potion",0,50,"rvs",16,1,1,"invvps","rpot",0,0},
	{"Full Rejuv Potion",0,200,"rvl",16,1,1,"invvpl","rpot",0,0},
	{"Thawing Potion",0,25,"wms",16,1,1,"invyps","wpot",0,0},
	{"Town Portal Book",0,250,"tbk",16,1,2,"invbbk","book",1,0},
	{"Identify Book",0,200,"ibk",16,1,2,"invrbk","book",1,0},
	{"amulet",0,2400,"amu",16,1,1,"invamu","amul",0,1},
	{"viper amulet",0,400,"vip",16,1,1,"invvip","amul",0,1},
	{"ring",0,1800,"rin",16,1,1,"invrin","ring",0,1},
	{"gold",0,0,"gld",16,1,1,"invgld","gold",1,0},
	{"Bark Scroll",0,100,"bks",16,2,2,"invscb","ques",0,0},
	{"deciphered Bark Scroll",0,12000,"bkd",16,2,2,"invscb","ques",0,0},
	{"Arrows",0,256,"aqv",16,1,3,"invqvr","bowq",1,0},
	{"Torch",0,50,"tch",7,1,2,"invtrch","torc",0,0},
	{"Bolts",0,256,"cqv",16,1,3,"invcqv","xboq",1,0},
	{"Town Portal Scroll",0,100,"tsc",16,1,1,"invbsc","scro",0,0},
	{"Identify Scroll",0,80,"isc",16,1,1,"invrsc","scro",0,0},
	{"Not used",0,60,"hrt",16,1,1,"invhrt","body",0,0},
	{"Not used",0,60,"brz",16,1,1,"invbrnz","body",0,0},
	{"Not used",0,75,"jaw",16,1,1,"invjaw","body",0,0},
	{"Not used",0,45,"eyz",16,1,1,"inveye","body",0,0},
	{"Not used",0,48,"hrn",16,1,1,"invhorn","body",0,0},
	{"Not used",0,63,"tal",16,1,1,"invtail","body",0,0},
	{"Not used",0,98,"flg",16,1,2,"invflag","body",0,0},
	{"Not used",0,80,"fng",16,1,1,"invfang","body",0,0},
	{"Not used",0,32,"qll",16,1,1,"invquil","body",0,0},
	{"Not used",0,100,"sol",16,1,1,"invsple","body",0,0},
	{"Not used",0,40,"scz",16,1,1,"invscp","body",0,0},
	{"Not used",0,85,"spe",16,1,1,"invsple","body",0,0},
	{"Skeleton Key",0,45,"key",16,1,1,"invkey","key",1,0},
	{"Mephisto Key",0,99999,"luv",16,1,2,"invmph","key",0,0},
	{"scroll of self resurrect",0,10000,"xyz",16,1,1,"invxyz","ques",0,0},
	{"jade figurine",0,100,"j34",16,1,2,"invjbi","ques",0,0},
	{"gold bird",0,100,"g34",16,1,2,"invgbi","ques",0,0},
	{"lam esen's tome",0,100,"bbb",16,2,2,"invbbb","ques",0,0},
	{"Horadric Cube",0,0,"box",16,2,2,"invbox","ques",0,0},
	{"Scroll of Horadric Quest Info",0,0,"tr1",16,2,2,"invhscr","ques",0,0},
	{"Mephisto SoulStone",0,0,"mss",16,1,1,"invmss","ques",0,0},
	{"Book of Skill",0,0,"ass",16,2,2,"invsbk","ques",0,0},
	{"KhalimEye",0,45,"qey",16,1,1,"inveye","ques",0,0},
	{"KhalimHeart",0,60,"qhr",16,1,1,"invhrt","ques",0,0},
	{"KhalimBrain",0,60,"qbr",16,1,1,"invbrnz","ques",0,0},
	{"Player Ear",0,0,"ear",16,1,1,"invear","play",0,0},
	{"Chipped Amethyst",1,500,"gcv",16,1,1,"invgsva","gem",0,0},
	{"Flawed Amethyst",5,1500,"gfv",16,1,1,"invgsvb","gem",0,0},
	{"Amethyst",12,5000,"gsv",16,1,1,"invgsvc","gem",0,0},
	{"Flawless Amethyst",15,15000,"gzv",16,1,1,"invgsvd","gem",0,0},
	{"Perfect Amethyst",18,30000,"gpv",16,1,1,"invgsve","gem",0,0},
	{"Chipped Topaz",1,500,"gcy",16,1,1,"invgsya","gem",0,0},
	{"Flawed Topaz",5,1500,"gfy",16,1,1,"invgsyb","gem",0,0},
	{"Topaz",12,5000,"gsy",16,1,1,"invgsyc","gem",0,0},
	{"Flawless Topaz",15,15000,"gly",16,1,1,"invgsyd","gem",0,0},
	{"Perfect Topaz",18,30000,"gpy",16,1,1,"invgsye","gem",0,0},
	{"Chipped Saphire",1,500,"gcb",16,1,1,"invgsba","gem",0,0},
	{"Flawed Saphire",5,1500,"gfb",16,1,1,"invgsbb","gem",0,0},
	{"Saphire",12,5000,"gsb",16,1,1,"invgsbc","gem",0,0},
	{"Flawless Saphire",15,15000,"glb",16,1,1,"invgsbd","gem",0,0},
	{"Perfect Saphire",18,30000,"gpb",16,1,1,"invgsbe","gem",0,0},
	{"Chipped Emerald",1,500,"gcg",16,1,1,"invgsga","gem",0,0},
	{"Flawed Emerald",5,1500,"gfg",16,1,1,"invgsgb","gem",0,0},
	{"Emerald",12,5000,"gsg",16,1,1,"invgsgc","gem",0,0},
	{"Flawless Emerald",15,15000,"glg",16,1,1,"invgsgd","gem",0,0},
	{"Perfect Emerald",18,30000,"gpg",16,1,1,"invgsge","gem",0,0},
	{"Chipped Ruby",1,500,"gcr",16,1,1,"invgsra","gem",0,0},
	{"Flawed Ruby",5,1500,"gfr",16,1,1,"invgsrb","gem",0,0},
	{"Ruby",12,5000,"gsr",16,1,1,"invgsrc","gem",0,0},
	{"Flawless Ruby",15,15000,"glr",16,1,1,"invgsrd","gem",0,0},
	{"Perfect Ruby",18,30000,"gpr",16,1,1,"invgsre","gem",0,0},
	{"Chipped Diamond",1,500,"gcw",16,1,1,"invgswa","gem",0,0},
	{"Flawed Diamond",5,1500,"gfw",16,1,1,"invgswb","gem",0,0},
	{"Diamond",12,5000,"gsw",16,1,1,"invgswc","gem",0,0},
	{"Flawless Diamond",15,15000,"glw",16,1,1,"invgswd","gem",0,0},
	{"Perfect Diamond",18,30000,"gpw",16,1,1,"invgswe","gem",0,0},
	{"Lesser Healing Potion",0,30,"hp1",16,1,1,"invhp1","hpot",0,0},
	{"Light Healing Potion",0,75,"hp2",16,1,1,"invhp2","hpot",0,0},
	{"Healing Potion",0,125,"hp3",16,1,1,"invhp3","hpot",0,0},
	{"Strong Healing Potion",0,250,"hp4",16,1,1,"invhp4","hpot",0,0},
	{"Greater Healing Potion",0,500,"hp5",16,1,1,"invhp5","hpot",0,0},
	{"Lesser Mana Potion",0,30,"mp1",16,1,1,"invmp1","mpot",0,0},
	{"Light Mana Potion",0,75,"mp2",16,1,1,"invmp2","mpot",0,0},
	{"Mana Potion",0,125,"mp3",16,1,1,"invmp3","mpot",0,0},
	{"Strong Mana Potion",0,250,"mp4",16,1,1,"invmp4","mpot",0,0},
	{"Greater Mana Potion",0,500,"mp5",16,1,1,"invmp5","mpot",0,0},
	{"Chipped Skull",1,1000,"skc",16,1,1,"invskc","gem",0,0},
	{"Flawed Skull",5,3000,"skf",16,1,1,"invskf","gem",0,0},
	{"Skull",12,10000,"sku",16,1,1,"invsku","gem",0,0},
	{"Flawless Skull",15,30000,"skl",16,1,1,"invskl","gem",0,0},
	{"Perfect Skull",18,100000,"skz",16,1,1,"invskz","gem",0,0},
	{"herb",0,75,"hrb",16,1,1,"invhrb","herb",0,0},
	{"Charm Small",0,2000,"cm1",16,1,1,"invchm","scha",0,0},
	{"Charm Medium",0,1000,"cm2",16,1,2,"invwnd","mcha",0,0},
	{"Charm Large",0,600,"cm3",16,1,3,"invsst","lcha",0,0},
	{"Small Red Potion",0,100,"rps",16,1,1,"invrps","hpot",1,0},
	{"Large Red Potion",0,100,"rpl",16,1,1,"invrpl","hpot",1,0},
	{"Small Blue Potion",0,100,"bps",16,1,1,"invbps","mpot",1,0},
	{"Large Blue Potion",0,100,"bpl",16,1,1,"invbpl","mpot",1,0},
	{"El Rune",11,560,"r01",16,1,1,"invrEl","rune",0,0},
	{"Eld Rune",11,560,"r02",16,1,1,"invrEld","rune",0,0},
	{"Tir Rune",13,1260,"r03",16,1,1,"invrTir","rune",0,0},
	{"Nef Rune",13,1260,"r04",16,1,1,"invrNef","rune",0,0},
	{"Eth Rune",15,2240,"r05",16,1,1,"invrEth","rune",0,0},
	{"Ith Rune",15,2240,"r06",16,1,1,"invrIth","rune",0,0},
	{"Tal Rune",17,3500,"r07",16,1,1,"invrTal","rune",0,0},
	{"Ral Rune",19,5040,"r08",16,1,1,"invrRal","rune",0,0},
	{"Ort Rune",21,6860,"r09",16,1,1,"invrOrt","rune",0,0},
	{"Thul Rune",23,8960,"r10",16,1,1,"invrThul","rune",0,0},
	{"Amn Rune",25,11340,"r11",16,1,1,"invrAmn","rune",0,0},
	{"Sol Rune",27,14000,"r12",16,1,1,"invrSol","rune",0,0},
	{"Shael Rune",29,16940,"r13",16,1,1,"invrShae","rune",0,0},
	{"Dol Rune",31,20160,"r14",16,1,1,"invrDol","rune",0,0},
	{"Hel Rune",0,1715,"r15",16,1,1,"invrHel","rune",0,0},
	{"Io Rune",35,27440,"r16",16,1,1,"invrIo","rune",0,0},
	{"Lum Rune",37,31500,"r17",16,1,1,"invrLum","rune",0,0},
	{"Ko Rune",39,35840,"r18",16,1,1,"invrKo","rune",0,0},
	{"Fal Rune",41,40460,"r19",16,1,1,"invrFal","rune",0,0},
	{"Lem Rune",43,45360,"r20",16,1,1,"invrLem","rune",0,0},
	{"Pul Rune",45,50540,"r21",16,1,1,"invrPul","rune",0,0},
	{"Um Rune",47,56000,"r22",16,1,1,"invrUm","rune",0,0},
	{"Mal Rune",49,61740,"r23",16,1,1,"invrMal","rune",0,0},
	{"Ist Rune",51,67760,"r24",16,1,1,"invrIst","rune",0,0},
	{"Gul Rune",53,74060,"r25",16,1,1,"invrGul","rune",0,0},
	{"Vex Rune",55,80640,"r26",16,1,1,"invrVex","rune",0,0},
	{"Ohm Rune",57,87500,"r27",16,1,1,"invrOhm","rune",0,0},
	{"Lo Rune",59,94640,"r28",16,1,1,"invrLo","rune",0,0},
	{"Sur Rune",61,102060,"r29",16,1,1,"invrSur","rune",0,0},
	{"Ber Rune",63,109760,"r30",16,1,1,"invrBer","rune",0,0},
	{"Jo Rune",65,117740,"r31",16,1,1,"invrJo","rune",0,0},
	{"Cham Rune",67,126000,"r32",16,1,1,"invrCham","rune",0,0},
	{"Zod Rune",69,134540,"r33",16,1,1,"invrZod","rune",0,0},
	{"Jewel",0,1000,"jew",16,1,1,"invgswe","jewl",0,0},
	{"Maguffin",0,10000,"ice",16,1,1,"invxyz","ques",0,0},
	{"Scroll",0,100,"0sc",16,1,1,"invrsc","scro",0,0},
	{"Scroll of Malah - Boost Resistances",0,0,"tr2",16,2,2,"invscb","ques",0,0}
} ;

int GetNumberOfMisc()
{
	return (sizeof gMiscItems / sizeof gMiscItems[0]) ;
}

CMisc* GetMiscRec( CString sCode) 
{
	for (int count=0; count<GetNumberOfMisc(); count++) {
		if (sCode == gMiscItems[ count].m_Code)
			return &gMiscItems[ count] ;
	}
	return NULL ;
}
