//////////////////////////////////////////////////////////////////////
// merc.cpp
// -------------------------------------------------------------------
// 
//
// by icky
//
//////////////////////////////////////////////////////////////////////
#include "..\ClientCore.cpp"

// Globals
BYTE p[5];

bool mercset=FALSE;
bool skipstep=FALSE;
bool mercrun=FALSE;
bool mercon=FALSE;
bool mercdance=FALSE;
bool attackright=FALSE;
DWORD mercid=0;
//DWORD lastpos;

THISGAMESTRUCT *tg;

BOOL PRIVATE OnGameCommandSet(char** argv, int argc);
BOOL PRIVATE OnGameCommandStart(char** argv, int argc);
BOOL PRIVATE OnGameCommandStop(char** argv, int argc);
BOOL PRIVATE OnGameCommandRun(char** argv, int argc);
BOOL PRIVATE OnGameCommandWalk(char** argv, int argc);
BOOL PRIVATE OnGameCommandDance(char** argv, int argc);
BOOL PRIVATE OnGameCommandAttack(char** argv, int argc);


//////////////////////////////////////////////////////////////////////
// CLIENTINFO
// -------------------------------------------------------------------
// 0.1 2001-12-11 First version
// 0.5 2001-12-12 Features added Start,Stop,Run,Walk,Dance,Set,Attack
// 0.6 2001-12-13 Fixed above features so they now work :P
//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(0,6);
char	ModuleAuthor[]="icky";
char	ModuleWebsite[]="thohell.d2network.com";
char	ModuleDescription[]="Test module";
char	ModuleEmail[]="icky@no.spam";


//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
// To use your commands in the game, just type 
// .modulename <command> [arguments]
//////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{
		"set",
		OnGameCommandSet,
		"startc0 Sets merc to follow.\n"
	},	{
		"start",
		OnGameCommandStart,
		"startc0 Starts merc follow.\n"
	},
	{
		"stop",
		OnGameCommandStop,
		"stopc0 Stops merc follow.\n"
	},
	{
		"run",
		OnGameCommandRun,
		"runc0 Set your follow speed to Run.\n"
	},
	{
		"walk",
		OnGameCommandWalk,
		"walkc0 Set your follow speed to Walk.\n"
	},
	{
		"dance",
		OnGameCommandDance,
		"dancec0 (toggle on/off) Engages you and your merc in an energetic dance.\n"
	},
	{
		"attack",
		OnGameCommandAttack,
		"attack left|rightc0 Sets attack to left or right click.\n"
	},
	{NULL}	// No more commands
};

//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
// Runs *once* when the module loads. 
// This function cannot be removed.
//
// Put any initialization code here.
//
// Return FALSE to prevent module from loading.
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnClientStart()
{
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
// Runs *once* before client is unloaded. 
// This function cannot be removed.
// 
// Put any cleanup code here.
//
// Return value should be TRUE.
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnClientStop()
{
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// EVENTS
// -------------------------------------------------------------------
// The rest of this file are event functions, and they can safely be
// removed if the module makes no use of them.
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameJoin(THISGAMESTRUCT* thisgame)
{
	tg=thisgame;
	return;
}

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen)
{
	if ((aPacket[0]==0x6d)&&(mercset))
	{
		mercset=FALSE;
		mercid=*(DWORD*)(aPacket+1);
		char t[100];
		sprintf(t, "NPC with ID c4%dc0 detected. Now set to follow.",mercid);
		server->GamePrintInfo(t);
	}

     if ((aPacket[0]==0x6d)&&(mercon)&&(*(DWORD*)(aPacket+1)==mercid))
     {

          BYTE b[] = {0x01,0,0,0,0};

		  b[0] = ((mercrun)?0x03:0x01);
		  *(DWORD*)(b+1) = *(DWORD*)(aPacket+5);

		  server->GameSendPacketToServer(b,5);
     }

	 if ((mercdance)&&(aPacket[0]==0x67)&&(mercon)&&(*(DWORD*)(aPacket+1)==mercid))
     {
          BYTE b[] = {0x01,0,0,0,0};

		  b[0] = ((mercrun)?0x03:0x01);

		  *(DWORD*)(b+1) = *(DWORD*)(aPacket+6);

		  server->GameSendPacketToServer(b,5);
     }

     if ((mercon)&&(aPacket[0]==0x4c)&&(*(DWORD*)(aPacket+2)==mercid))
     {
          BYTE b[] = {0x09,0x01,0,0,0,0,0,0,0};
		  b[0] = ((attackright)?0x10:0x09);
		  *(DWORD*)(b+5) = *(DWORD*)(aPacket+10);
		  
		  server->GameSendPacketToServer(b,9);
	 }

     return aLen;
}

DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen)
{
     // Update client when running
     if ((aPacket[0] == 0x03)||(aPacket[0] == 0x01))
     {
          BYTE p[]={0x0f, 0, 0,0,0,0, 0x17, 0,0,0,0, 0, 0,0,0,0};
          memcpy(p+2,&tg->player->PlayerID,4);               // Paste my ID
          memcpy(p+7,aPacket+1,4);                              // New location
          memcpy(p+12,&tg->player->PlayerPositionX,2);     // Old location X
          memcpy(p+14,&tg->player->PlayerPositionY,2);     // Old location Y
          server->GameSendPacketToGame(p, 16);               // Move clientside
          return aLen;
     }
     return aLen;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandSet
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandSet(char** argv, int argc)
{
	server->GamePrintInfo("Detecting NPC to follow...");
	mercset = TRUE;
	mercon = FALSE;
	mercdance = FALSE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandStart
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandStart(char** argv, int argc)
{
	mercon = TRUE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandStop
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandStop(char** argv, int argc)
{
	mercon = FALSE;
	mercset = FALSE;
	mercdance = FALSE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandRun
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandRun(char** argv, int argc)
{
	mercrun = TRUE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandWalk
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandWalk(char** argv, int argc)
{
	mercrun=FALSE;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandDance
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandDance(char** argv, int argc)
{
	mercdance = !mercdance;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandAttack
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandAttack(char** argv, int argc)
{
	if (argc != 3) return FALSE;

	if (strcmp(argv[2],"left")==0)
		attackright = FALSE;
	else if (strcmp(argv[2],"right")==0)
		attackright = TRUE;
	else return FALSE;

	char t[100];
	sprintf(t, "Attack key set to c4%sc0.", argv[2]);
	server->GamePrintInfo(t);

	return TRUE;
}
