/*
 *	Notify Module for D2Hackit
 *
 *	Copyright (c) 2002 Sherpya <sherpya@hotmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define ICQPAGERURL "http://wwp.icq.com:80/scripts/WWPMsg.dll?from=%s&fromemail=%s&subject=%s&body=%s&to=%s&x=90&y=90&Send=Send%%20Messsage"
#define ICQPAGEREMAIL "@pager.icq.com"
#include <windows.h>

#define EXPORT
#include <mapi.h>
#undef EXPORT

#include "../ClientCore.cpp"
#include <Exdisp.h>
#include <stdlib.h>
#include <stdio.h>
#include <comdef.h>

// STL - Not using iostreams
#define _STLP_NO_OWN_IOSTREAMS 1
#include <queue>


#if !defined (STLPORT) || defined(__STL_USE_NAMESPACES)
using namespace std;
#endif

queue<lpMapiMessage> qEmail;
queue<BSTR> qICQ;

///////////
extern "C" { DWORD EXPORT OnGameTimerTick(); }

BOOL PRIVATE OnGameCommandICQ(char** argv, int argc);
BOOL PRIVATE OnGameCommandICQSmtp(char** argv, int argc);
BOOL PRIVATE OnGameCommandEmail(char** argv, int argc);
BOOL PRIVATE OnGameCommandSMS(char** argv, int argc);
BOOL PRIVATE OnGameCommandReload(char** argv, int argc);


VOID PRIVATE OnGameLoadSettings(void);


// Threads

VOID PRIVATE WebDispatcherThread(void);
VOID PRIVATE EmailDispatcherThread(void);
VOID PRIVATE KillThreads(void);


HANDLE wEvent;
HANDLE eEvent; 

HANDLE wMutex;
HANDLE eMutex;

// Create a mutex with no initial owner.

char outstr[1024];

// For Web Browser Interface
IWebBrowser2* pWebBrowser = NULL;
VARIANT vFlags = {0},
		vTargetFrameName = {0},
		vPostData = {0},
		vHeaders = {0};

// Threads handling queues
BOOL isRunning = false;
HANDLE WebDisp = NULL;
HANDLE EmailDisp = NULL;
DWORD WebDispID = 0;
DWORD EmailDispID = 0;

// For Mapi Interface
HINSTANCE hlibMAPI = NULL;
LPMAPISENDMAIL m_MAPISendMail = NULL;

// Settings
char *Name = NULL;
char *Email = NULL;
char *UIN = NULL; 

//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(0,1);
char	ModuleAuthor[]="sherpya";
char	ModuleWebsite[]="";
char	ModuleDescription[]="ICQ/EMail/SMS Notifier";
char	ModuleEmail[]="sherpya@hotmail.com";

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
// To add your own commands, just add them to this list like:
//
//	{
//		"name"			// Name of the command
//		pFunction		// The function that handles command
//		"usage"			// Help text for the command
//	}
// 
// Functions should use following convention...
// BOOL PRIVATE OnGameCommandName(char** argv, int argc)
// ...and return TRUE on success or FALSE to show usage of the command.
//
// To use your commands in the game, just type 
// .modulename <command> [arguments]
//////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{
		"icq",
		OnGameCommandICQ,
		"icqc0 uin subject message"
	},
	{
		"icqsmtp",
		OnGameCommandICQSmtp,
		"icqsmtpc0 uin subject message"
	},
	{
		"email",
		OnGameCommandEmail,
		"emailc0 recipient subject message"
	},
	{
		"sms",
		OnGameCommandSMS,
		"smsc0 Not yet implemented"
	},
	{
		"reload",
		OnGameCommandReload,
		"reloadc0 Reload settings from ini"
	},
	{NULL}	// No more commands
};


//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
// Runs *once* before client is loaded. Return FALSE to prevent from
// loading.
//////////////////////////////////////////////////////////////////////
// PS: Don't blame me for gotos... it's the cleanest way
BOOL EXPORT OnClientStart()
{

	isRunning = true;
	// Load Settings from ini
	OnGameLoadSettings();

	// FIXME: Check
	wEvent = CreateEvent( 
        NULL,     // no security attributes
        FALSE,    // auto-reset event
        FALSE,    // initial state is not signaled
        NULL      // object name
        ); 
	
	wMutex = CreateMutex(
		NULL,     // no security
		FALSE,    // Not Active
		NULL);


	WebDisp = CreateThread(NULL,
						   0,
						   (LPTHREAD_START_ROUTINE)WebDispatcherThread,
						   NULL,
						   0,
						   &WebDispID);

	// Load mapi
	hlibMAPI = LoadLibrary("mapi32.dll");
	if (!hlibMAPI)
	{
		server->GamePrintError("c1Cannot load mapi32.dll SMTP Services disabled");
		return true;
	}

    m_MAPISendMail = (LPMAPISENDMAIL) GetProcAddress(hlibMAPI, "MAPISendMail");

	if (!m_MAPISendMail)
	{
		server->GamePrintError("c1Cannot find MAPISendMail on mapi32.dll SMTP Services disabled");
		return true;
	}


	// FIXME: Check
	eEvent = CreateEvent( 
        NULL,     // no security attributes
        FALSE,    // auto-reset event
        FALSE,    // initial state is not signaled
        NULL      // object name
        ); 
	
	eMutex = CreateMutex(
		NULL,     // no security
		FALSE,    // Not Active
		NULL);


	EmailDisp = CreateThread(NULL,
						   0,
						   (LPTHREAD_START_ROUTINE)EmailDispatcherThread,
						   NULL,
						   0,
						   &EmailDispID);


	if (!EmailDisp)
		server->GamePrintError("c1Cannot find MAPISendMail on mapi32.dll SMTP Services disabled");

	return true;
}


//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
// Runs *once* before client is unloaded. Return value should be TRUE,
// but it is not used at this time.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStop()
{
	// Let thread terminate
	server->GamePrintVerbose("Stopping threads...");
	isRunning = false;
	if (WebDisp) SetEvent(wEvent);
	if (EmailDisp) SetEvent(eEvent);
	Sleep(200); // Maybe to small for slow pc?

	// Just to be sure - FIXME: Really needed?
	KillThreads();

	// Free Mapi32
	if (hlibMAPI) FreeLibrary(hlibMAPI);
	return true;
}


//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
// argv[0] = notify
// argv[1] = icq
// argv[2] = uin
// argv[3] = subject
// argv[4] = msg

BOOL PRIVATE OnGameCommandICQ(char** argv, int argc)
{
	int len = 0; // %%20 is %20 then len = len -1 + 1 (termination) = len
	char *url;
	BSTR bstrURL = NULL;
	char *uin;

	if (argc != 5)
		return false;

	if ((strlen(argv[2]) > 0) && !strcmp(argv[2], "0"))
		uin = UIN;
	else
		uin = argv[2];

	if (!pWebBrowser || !WebDisp)
	{
		server->GamePrintError("c1No IWebBrowser2 Interface");
		return false;
	}
	len+=strlen(ICQPAGERURL);

	len+=strlen(Name)-2;
	len+=strlen(Email)-2;
	len+=strlen(argv[3])-2; // Subject
	len+=strlen(argv[4])-2; // Message
	len+=strlen(uin)-2; // UIN

	// Allocating new string...
	url = new char[len];
	memset(url, 0, len);
	sprintf(url, ICQPAGERURL, Name, Email, argv[3], argv[4], uin);

	//sprintf(outstr,"Debug len = %d, strlen = %d", len, strlen(url));
	//server->GamePrintVerbose(outstr);

	bstrURL = _bstr_t(url);
	if (url) delete url;

	
	server->GamePrintVerbose("Putting ICQ message in queue");
	WaitForSingleObject(wMutex, INFINITE);
	qICQ.push(bstrURL);
	ReleaseMutex(wMutex);
	SetEvent(wEvent);

	return true;
}

//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
// argv[0] = notify
// argv[1] = icqsmtp
// argv[2] = uin
// argv[3] = subject
// argv[4] = msg
BOOL PRIVATE OnGameCommandICQSmtp(char** argv, int argc)
{
	char *uin, *recipient;
	int len = 0;

	if (argc != 5)
		return false;

	if ((strlen(argv[2]) > 0) && !strcmp(argv[2], "0"))
		uin = UIN;
	else
		uin = argv[2];

	if (!m_MAPISendMail || !EmailDisp)
	{
		server->GamePrintError("c1Mapi function not avaiable");
		return false;
	}

	len = strlen(ICQPAGEREMAIL) + strlen(uin) + 1;
	recipient = (char *) malloc (len);
	sprintf(recipient, "%s%s", uin, ICQPAGEREMAIL);
	
	lpMapiMessage msg = new MapiMessage;
	memset(msg, 0, sizeof(MapiMessage));

	msg->lpRecips = new MapiRecipDesc;
	memset(msg->lpRecips, 0, sizeof(MapiRecipDesc));

	msg->lpRecips->lpszName = NULL;
	msg->lpRecips->ulRecipClass = MAPI_TO;
	msg->lpRecips->lpszAddress = recipient;

	msg->lpszSubject = strdup(argv[3]);
	msg->lpszNoteText = strdup(argv[4]);
	msg->lpOriginator = NULL;
	msg->nRecipCount = 1;

	server->GamePrintVerbose("Putting ICQ message in Email queue");
	WaitForSingleObject(eMutex, INFINITE);
	qEmail.push(msg);
	ReleaseMutex(eMutex);
	SetEvent(eEvent);

	return true;
}

//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
// argv[0] = notify
// argv[1] = email
// argv[2] = recipient
// argv[3] = subject
// argv[4] = msg

BOOL PRIVATE OnGameCommandEmail(char** argv, int argc)
{
	if (argc != 5)
		return false;

	if (!m_MAPISendMail || !EmailDisp)
	{
		server->GamePrintError("c1Mapi function not avaiable");
		return false;
	}

	lpMapiMessage msg = new MapiMessage;
	memset(msg, 0, sizeof(MapiMessage));

	msg->lpRecips = new MapiRecipDesc;
	memset(msg->lpRecips, 0, sizeof(MapiRecipDesc));

	msg->lpRecips->lpszName = NULL;
	msg->lpRecips->ulRecipClass = MAPI_TO;
	msg->lpRecips->lpszAddress = strdup(argv[2]);

	msg->lpszSubject = strdup(argv[3]);
	msg->lpszNoteText = strdup(argv[4]);
	msg->lpOriginator = NULL;
	msg->nRecipCount = 1;

	server->GamePrintVerbose("Putting Email in queue");
	WaitForSingleObject(eMutex, INFINITE);
	qEmail.push(msg);
	ReleaseMutex(eMutex);
	SetEvent(eEvent);

	return true;
}

//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandSMS(char** argv, int argc)
{
	return false;
}

//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandReload(char** argv, int argc)
{

	// Reload Settings from ini
	if (wMutex)	WaitForSingleObject(wMutex, INFINITE);
	if (eMutex) WaitForSingleObject(eMutex, INFINITE);
	OnGameLoadSettings();
	if (eMutex) ReleaseMutex(eMutex);
	if (wMutex) ReleaseMutex(wMutex);

	server->GamePrintInfo("Configuration reloaded");
		
	return true;
}

//////////////////////////////////////////////////////////////////////
// OnGameTimerTick
// -------------------------------------------------------------------
// This gets executed apx. every 1/10th of a second when in a game.
//
// You can use this to create custom timers.
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGameTimerTick(void)
{
	// FIXME: check thread timeout
	//server->GamePrintError("c1Tick is working");
	return 0;
}


//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////

/// Settings

VOID PRIVATE OnGameLoadSettings(void)
{
	Name=server->GetHackProfileString("notify", "Default", "Name");
	Email=server->GetHackProfileString("notify", "Default", "Email");
	UIN=server->GetHackProfileString("notify", "Default", "UIN");
}

//////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
// Thread stuff
VOID PRIVATE WebDispatcherThread(void)
{
	DWORD dwWaitResult;
	BSTR bstrURL; 

	server->GamePrintVerbose("c2Web Dispacher Thread Started");

	// Query Interface for iwebbrowser2
	if (FAILED(OleInitialize(NULL)))
	{
		server->GamePrintError("c1OleInitialize Failed Internal Web Interface disabled");
		return;
	}
	if (FAILED(CoCreateInstance(CLSID_InternetExplorer,
								NULL,
								CLSCTX_SERVER,
								IID_IWebBrowser2,
								(LPVOID*)&pWebBrowser)))
	{
		server->GamePrintError("c1CoCreateInstance Failed Internal Web Interface disabled");
		OleUninitialize();
		return;
	}

	pWebBrowser->put_Visible(VARIANT_FALSE);


	while (isRunning)
	{
		dwWaitResult = WaitForSingleObject(wEvent, INFINITE);
		//server->GamePrintError("c1WebDispatcherThread");

		// No messages
		if (qICQ.empty())
			continue;
		
		bstrURL = qICQ.front();
		qICQ.pop();

		if (!pWebBrowser)
			server->GamePrintError("UFFA");

		if (FAILED(pWebBrowser->Navigate(bstrURL,
			&vFlags,
			&vTargetFrameName,
			&vPostData,
			&vHeaders)))
		{
			LPVOID lpMsgBuf;
			FormatMessage( 
				FORMAT_MESSAGE_ALLOCATE_BUFFER | 
				FORMAT_MESSAGE_FROM_SYSTEM | 
				FORMAT_MESSAGE_IGNORE_INSERTS,
				NULL,
				GetLastError(),
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
				(LPTSTR) &lpMsgBuf,
				0,
				NULL 
				);

			sprintf(outstr, "c1Error Sending ICQ pager: %s", (LPCTSTR)lpMsgBuf);
			// Free the buffer.
			LocalFree( lpMsgBuf );
			server->GamePrintError(outstr);
		}
		else
			server->GamePrintVerbose("ICQ Pager sent");
		if (bstrURL) SysFreeString(bstrURL);

	}

	// Unquery interface
	if (pWebBrowser) pWebBrowser->Release();
	OleUninitialize();
    
	server->GamePrintVerbose("c2Web Dispacher Thread Terminated");
	WebDisp = 0;
	WebDispID = 0;
}

//
VOID PRIVATE EmailDispatcherThread(void)
{

	DWORD dwWaitResult;
	lpMapiMessage msg;
	server->GamePrintVerbose("c2Email Dispacher Thread Started");
	while (isRunning)
	{
		dwWaitResult = WaitForSingleObject(eEvent, INFINITE);
		//server->GamePrintError("c1EmailDispatcherThread");

		// No messages
		if (qEmail.empty())
			continue;

		WaitForSingleObject(eMutex, INFINITE);
		msg = qEmail.front();
		qEmail.pop();
		ReleaseMutex(eMutex);

		if (FAILED(m_MAPISendMail(0, 0, msg, MAPI_NEW_SESSION , 0)))
		{
			LPVOID lpMsgBuf;
			FormatMessage( 
				FORMAT_MESSAGE_ALLOCATE_BUFFER | 
				FORMAT_MESSAGE_FROM_SYSTEM | 
				FORMAT_MESSAGE_IGNORE_INSERTS,
				NULL,
				GetLastError(),
				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
				(LPTSTR) &lpMsgBuf,
				0,
				NULL 
				);

			sprintf(outstr, "c1MAPISendMail Failed: %s", (LPCTSTR)lpMsgBuf);
			// Free the buffer.
			LocalFree( lpMsgBuf );
			server->GamePrintError(outstr);
		}

		// Free
		if (msg->lpRecips->lpszAddress) free(msg->lpRecips->lpszAddress);
		if (msg->lpRecips) delete msg->lpRecips;
		if (msg->lpszSubject) free (msg->lpszSubject);
		if (msg->lpszNoteText) free (msg->lpszNoteText);
		if (msg) delete msg;

		server->GamePrintVerbose("Email sent");

	}
	server->GamePrintVerbose("c2Email Dispacher Thread Terminated");
	EmailDisp = 0;
	EmailDispID = 0;
}

VOID PRIVATE KillThreads(void)
{
	// Stop dispatcher threads
	if (WebDisp) TerminateThread(WebDisp,0);

	if (EmailDisp) TerminateThread(EmailDisp,0);

}
