// pickit.cpp
// by Gayak (170@guyau.qc.ca)
// original program (0.82 and previous) by ackmed@gotwalls.com

#include <time.h>
#include <windows.h>
#include "pickit.h"
#include "config.h"
#include "external/LinkedList/LinkedList.h"

//////////////////////////////////////////
VOID txtwrite(char *write); //Gayak
BOOL pickitprint(char *printi); //Gayak
//////////////////////////////////////////

// globals
DWORD Debug = DEBUG_OFF;
char DebugBuffer[1024];
char ConfigPath[_MAX_PATH];  // dir where to find pickit.ini
FUNCTIONENTRYPOINTS	*server;
THISGAMESTRUCT *thisgame;
BOOL DumpItems = false;
BOOL inGame = false;		// d2hackit bug/feature work around
DWORD PickupRadiusSquared = 10*10;
DWORD TeleportRadiusSquared = 25*25;
BOOL PickupEnabled = true;
BOOL GoldEnabled = true;
BOOL InventoryFull=false;
BOOL Teleport = false;
BOOL Log=true;
LinkedList *Config = new LinkedList;
LinkedList *Items = new LinkedList;

char logpath[512];
char logfile[512];

BYTE lastskill[4];
BOOL donottracklastskill=0;

DWORD chosenitemid=0;
DWORD chosengoldid=0;
BYTE chosenitempos[4];
BYTE chosengoldpos[4];

BOOL DoNotTryWhenFull[20000000];

BOOL taking=0;
BOOL pickwhenarrived=FALSE;
int breakit=0;

int refresh=30;
int counter=0;

// module info
DWORD	ModuleVersion=MAKELONG(VERSION_MAJOR,VERSION_MINOR);
char	ModuleAuthor[]="Gayak";
char	ModuleWebsite[]="http://gayak.50megs.com";
char	ModuleDescription[]="pickit v0.86 for Diablo II: LoD";
char	ModuleEmail[]="170@guyau.qc.ca";

// module commands
MODULECOMMANDSTRUCT ModuleCommands[]= {
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",OnGameCommandHelp,"helpc0 List commands available in this module.\n""<command> helpc0 Shows detailed help for <command> in this module."
	},
	{"debug",OnCommandDebug,"debug [devel]c0 toggle debug mode.\n""[devel] added extra debugging"},
	{"dumpitems",OnCommandDumpItems,"dumpItemsc0 toggle dumping of item drop packets.\n"},
	{"radius",OnCommandRadius,"radius <n>c0 set the pickup radius on items.\n""Default is 10"},
	{"teleportradius",OnCommandTeleportRadius,"teleportradius <n>c0 set the teleport radius on items.\n""Default is 25"},
	{"activate",OnCommandActivate,"activatec0 toggles item pickup on.\n"},
	{"deactivate",OnCommandDeactivate,"deactivatec0 toggles item pickup off.\n"},
	{"toggle",OnCommandToggle,"togglec0 toggles item pickup on/off.\n"},
	{"load",OnCommandLoad,"loadc0 Loads chosen config file.\n"},
	{"gold",OnCommandGold,"togglec0 toggles gold pickup on/off.\n"},
	{"log",OnCommandLog,"log [file]c0 Makes you change the current log file (does not change in ini file).\n"},
	{NULL}
};

// functions related to the above commands
BOOL PRIVATE OnCommandDebug(char **argv, int argc) {

	// no params passed, just do a simple toggle
	if(argc == 2){
		if(Debug) {
			pickitprint("Debugging disabled");
			Debug = DEBUG_OFF;
		} else {
			pickitprint("Debugging enabled");
			Debug = DEBUG_USER;
		}
		return true;
	} else if(argc == 3) {
		if(strcmpi(argv[2],"devel") == 0) {
			pickitprint("Devel Debugging enabled");
			Debug = DEBUG_DEVEL;
			return true;
		} else if(strcmpi(argv[2],"packet") == 0) {
			pickitprint("Packet Debugging enabled");
			Debug = DEBUG_PACKET;
			return true;
		}
	}
	return false;
}

BOOL PRIVATE OnCommandDumpItems(char** argv, int argc) {

	if(DumpItems) {
		pickitprint("DumpItems Disabled");
	} else {
		pickitprint("DumpItems Enabled");
	}
	DumpItems = 1 - DumpItems;

	return true;
}

BOOL PRIVATE OnCommandRadius(char **argv, int argc) {

	DWORD newRadius;
	char radiusString[64];
	if(argc == 3) {
		newRadius = atoi(argv[2]);
		sprintf(radiusString,"Pickup Radius is set to %d.",newRadius);
		pickitprint(radiusString);
		PickupRadiusSquared = newRadius * newRadius;
		return true;
	}

	return false;
}

BOOL PRIVATE OnCommandTeleportRadius(char **argv, int argc) {

	DWORD newRadius;
	char radiusString[64];
	if(argc == 3) {
		newRadius = atoi(argv[2]);
		sprintf(radiusString,"Teleport Pickup Radius is set to %d.",newRadius);
		pickitprint(radiusString);
		TeleportRadiusSquared = newRadius * newRadius;
		return true;
	}

	return false;
}

BOOL PRIVATE OnCommandActivate(char **argv, int argc) {

	pickitprint("Item Pickup enabled.");
	PickupEnabled = 1;
	InventoryFull = 0;
	taking=FALSE;

	for (int x=0; x<20000000; x++){DoNotTryWhenFull[x]=0;}
	return true;
}

BOOL PRIVATE OnCommandDeactivate(char **argv, int argc) {

	pickitprint("Item Pickup disabled.");
	PickupEnabled = 0;
	return true;
}

BOOL PRIVATE OnCommandToggle(char **argv, int argc) {

	if(PickupEnabled) {
		pickitprint("Item Pickup disabled.");
	} else {
		pickitprint("Item Pickup enabled.");
	}

	PickupEnabled = 1 - PickupEnabled;
	taking=FALSE;
	return true;
}

BOOL PRIVATE OnCommandGold(char **argv, int argc) {

	if(GoldEnabled) {
		pickitprint("Gold Pickup disabled.");
	} else {
		pickitprint("Gold Pickup enabled.");
	}

	GoldEnabled = 1 - GoldEnabled;
	return true;
}

BOOL PRIVATE OnCommandLog(char **argv, int argc) {

	if (argc!=3){return false;}
	for (int cl=0; cl<=512; cl++){logfile[cl]='\0';}

	strcpy(logfile,argv[2]);
	pickitprint("Set Log File successfully.");
	return true;
}

BOOL PRIVATE OnCommandLoad(char** argv, int argc) {

	LinkedItem_t *cfg;

	// delete the old config
	for(cfg = Config->GetFirstItem();cfg != NULL;cfg = Config->RemoveItem(cfg)){
		delete (CONFIGSTRUCT*) cfg->lpData;
	}

	char filetemp[128];
	if (argc<3){strcpy(filetemp,"pickit");}
	else if (argc==3){strcpy(filetemp,argv[2]);}
	else {return false;}

	
	// load new config
	if(!LoadConfig(filetemp)) {
		pickitprint("Error loading Config file.");
	} else {
		char say[128];
		strcpy(say,filetemp);
		strcat(say,".ini loaded successfully.");
		pickitprint(say);
	}
	return true;
}


// config load function
BOOL LoadConfig(char *file) {
	char ConfigFile[1024];
	char *Sections;
	char error[1024];
	char *rval;
	int length,counter;
	CONFIGSTRUCT *cfg;

	char cfile[]="Pickit-Config";
	char *chosensection;

	chosensection="\0";
	sprintf(chosensection, "%s", thisgame->player->PlayerName);
	if (strlen(server->GetHackProfileString(cfile,chosensection,"PickupRadius"))==0 )
	{chosensection="default";}


	sprintf(ConfigFile,"%s\\%s.ini",ConfigPath,file);

	if (_access(ConfigFile, 0))
	{ 
		char error[1024];
		sprintf(error, "Unable to open Config: %s", ConfigFile);
		server->GamePrintError(error);
		return false;
	}

	DWORD  alloc=0;
	DWORD  allocStep = 1024;

	char *pathtemp;
	char *filetemp;
	PickupRadiusSquared = atoi(server->GetHackProfileString(cfile,chosensection,"PickupRadius"))*atoi(server->GetHackProfileString(cfile,chosensection,"PickupRadius"));
	TeleportRadiusSquared = atoi(server->GetHackProfileString(cfile,chosensection,"TeleportRadius"))*atoi(server->GetHackProfileString(cfile,chosensection,"TeleportRadius"));
	PickupEnabled = atoi(server->GetHackProfileString(cfile,chosensection,"PickupEnabled"));
	GoldEnabled = atoi(server->GetHackProfileString(cfile,chosensection,"GoldEnabled"));
	Log = atoi(server->GetHackProfileString(cfile,chosensection,"Log"));
	Teleport = atoi(server->GetHackProfileString(cfile,chosensection,"Teleport"));
	refresh = atoi(server->GetHackProfileString(cfile,chosensection,"Refresh"));
	pathtemp = server->GetHackProfileString(cfile, chosensection,"LogPath");
	if (strlen(pathtemp)!=TRUE){strcpy(logpath,ConfigPath);}
	else {strcpy(logpath,pathtemp);}
	filetemp = server->GetHackProfileString(cfile, chosensection,"LogFile");
	if (strlen(filetemp)!=TRUE){strcpy(logfile,"pickit.log");}
	else {strcpy(logfile,filetemp);}

	while (TRUE) {
		alloc+=allocStep;
		Sections = new char[alloc];
		length = GetPrivateProfileSectionNames(Sections,alloc,ConfigFile);
		
		if(length + 1 != alloc - 1 ) {
			break;
		}
		delete Sections;
	}
	counter = 0;
NEXT:
	while(counter < length) {
		cfg = new CONFIGSTRUCT;


		if(strlen(&Sections[counter]) > 128 || Sections[counter] == '\0' /*|| strcmp(&Sections[counter],"config")==0*/) {
			
			counter = counter + strlen(&Sections[counter]) + 1;
			delete cfg;
			goto NEXT;
		}
			
		strcpy(cfg->Section,&Sections[counter]);
		if (strcmp(cfg->Section,"config")==0)
		{
			counter = counter + strlen(&Sections[counter]) + 1;
			delete cfg;
			goto NEXT;
		}

		counter = counter + strlen(&Sections[counter]) + 1;
		// now query the section and fill in data
		
		// ItemCode should be 3 or 4 chars long
		rval = server->GetHackProfileString(file, cfg->Section, "Code");

//edited by FallNAngel
	//if rval has a length >= 1
		if(strlen(rval))
		{
		//if rval is >= 4 and the 4th character is not a space, it's a basename.. get the code
			if(strlen(rval) >= 4 && rval[3] != ' ')
				rval = server->GetHackProfileString("Item-Conversions", "NamesToCodes", rval);
		//it's a code, just has a space as 4th char.. get rid of the space
			else if(strlen(rval) == 4 && rval[3] == ' ') 
				rval[3] = '\0';
		//no itemcode or basename is < 3 chars.. it's bad
			else if(strlen(rval) < 3) 
			{
					sprintf(error,"Bad Code value '%s' in section [%s], Skipping",rval,cfg->Section);
					pickitprint(error);
					delete cfg;
					goto NEXT;
			}
		//if the code isn't formatted bad (which it shouldn't be if we got here), rval will hopefuly be a valid item code.. just add it.
			strcpy(cfg->item.ItemCode,rval);
		}
	//if itemcode isn't length >= 1  (ie.. doesn't exist) just leave it blank and move on.
		else
			cfg->item.ItemCode[0] = '\0';
//finished editing

		// Item Description
		rval = server->GetHackProfileString(file, cfg->Section, "Description");
		if(strlen(rval)) {
			if(strlen(rval) > 127) {
				sprintf(error,"Description too long in section [%s], Skipping",cfg->Section);
				pickitprint(error);
				delete cfg;
				goto NEXT;
			}
			strcpy(cfg->Description,rval);
			// delete rval;
		} else {
			cfg->Description[0] = '\0';
		}

		// identified
		rval = server->GetHackProfileString(file, cfg->Section, "Identified");
		if(strlen(rval)) {
			cfg->item.isIdentified = atoi(rval);
			// delete rval;
		} else {
			cfg->item.isIdentified = ITEM_UNSET;
		}

		// ethereal
		rval = server->GetHackProfileString(file, cfg->Section, "isEthereal");
		if(strlen(rval)) {
			cfg->item.isEthereal = atoi(rval);
			// delete rval;
		} else {
			cfg->item.isEthereal = ITEM_UNSET;
		}

		// item should have sockets, doesnt matter how many unlesss NumSockets is used
		rval = server->GetHackProfileString(file, cfg->Section, "HasSockets");
		if(strlen(rval)) {
			cfg->item.hasSockets = atoi(rval);
			// delete rval;
		} else {
			cfg->item.hasSockets = ITEM_UNSET;
		}

		// dont pickup item.  useful if you only want to be told of the item drop
		rval = server->GetHackProfileString(file, cfg->Section, "Pickup");
		if(strlen(rval)) {
			cfg->Pickup = atoi(rval);
		//	delete rval;
		} else {
			cfg->Pickup = CONFIG_UNSET;
		}
		
		// hide item
		rval = server->GetHackProfileString(file, cfg->Section, "Hide");
		if(strlen(rval)) {
			cfg->Hide = atoi(rval);
		//	delete rval;
		} else {
			cfg->Hide = 0;
		}
		
		// gold amount
		rval = server->GetHackProfileString(file, cfg->Section, "GoldAmount");
		if(strlen(rval)) {
			cfg->item.GoldAmount = atoi(rval);
		//	delete rval;
		} else {
			cfg->item.GoldAmount = 0;
		}

		// item level
		rval = server->GetHackProfileString(file, cfg->Section, "Level");
		if(strlen(rval)) {
			if(strcmpi(rval,"rare") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_RARE;
			} else if(strcmpi(rval,"unique") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_UNIQUE;
			} else if(strcmpi(rval,"set") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_SET;
			} else if(strcmpi(rval,"magic") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_MAGIC;
			} else if(strcmpi(rval,"craft") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_CRAFT;
			} else if(strcmpi(rval,"normal") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_NORMAL;
			} else if(strcmpi(rval,"superior") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_SUPERIOR;
			} else if(strcmpi(rval,"lowquality") == 0) {
				cfg->item.ItemLevel = ITEM_LEVEL_INFERIOR;
			} else {
				sprintf(error,"Bad Level '%s' in section [%s], skipping",rval,cfg->Section);
				pickitprint(error);
				// delete rval;
				delete cfg;
				goto NEXT;
			}
			// delete rval;
		} else {
			cfg->item.ItemLevel = ITEM_UNSET;
		}
	
		// item class
		rval = server->GetHackProfileString(file, cfg->Section, "Type");
		if(strlen(rval)) {
			if(strcmpi(rval,"Helm") == 0) {
				cfg->item.ItemType = ITEM_ITEMTYPE_HELM;
			} else if(strcmpi(rval,"Armor") == 0) {
				cfg->item.ItemType = ITEM_ITEMTYPE_ARMOR;
			} else if(strcmpi(rval,"Weapon") == 0) {
				cfg->item.ItemType = ITEM_ITEMTYPE_WEAPON;
			} else if(strcmpi(rval,"Bow") == 0) {
				cfg->item.ItemType = ITEM_ITEMTYPE_BOW;
			} else if(strcmpi(rval,"Shield") == 0) {
				cfg->item.ItemType = ITEM_ITEMTYPE_SHIELD;
			} else if(strcmpi(rval,"Other") == 0) {
				cfg->item.ItemType = ITEM_ITEMTYPE_OTHER;
			} else {
				sprintf(error,"Bad class '%s' in section [%s], skipping",rval,cfg->Section);
				pickitprint(error);
				// delete rval;
				delete cfg;
				goto NEXT;
			}
			// delete rval;
		} else {
			cfg->item.ItemType = ITEM_UNSET;
		}
		Config->AddItem(cfg);

	}
	delete Sections;
	return true;
}

/////////////////////////////////////////////////////////////////
BOOL pickitprint(char *printi)
{
	char temp[1024];
	strcpy(temp,"c7+ c0");
	strcat(temp,printi);
	return server->GamePrintString(temp);
}

/////////////////////////////////////////////////////////////////
VOID txtwrite(char *str,int itemlvl,BOOL imp)			//Gayak
{
	FILE *stream;
	char fileplace[512];
	strcpy(fileplace,logpath);
	strcat(fileplace,"\\");
	strcat(fileplace,logfile);
	stream = fopen( fileplace, "a+" );

	char timestr[25];

	struct tm *when;
	time_t now;
	time( &now );
	when = localtime( &now );

	char tempstr[256];
	int tempstrnum=0;
	for (int ge=0; ge<=strlen(str); ge++)
	{
		if(str[ge]=='' && str[ge+1]=='c'){ge=ge+2;}
		else{tempstr[tempstrnum]=str[ge]; tempstrnum++;}
	}

	strftime( timestr, 25, "%y/%m/%d %H:%M:%S", when );

	fprintf(stream,"%s : %s\n", timestr, tempstr);
	if (fclose(stream)) {pickitprint("Cannot close file.");}


	delete stream;
	char fileplacehtml[512];
	strcpy(fileplacehtml,logpath);
	strcat(fileplacehtml,"\\");
	strcat(fileplacehtml,"pickitlog.html");
	stream = fopen( fileplacehtml, "a+" );

	char namehtml[64];
	if (imp==1){strcpy(namehtml,"important ");}
	else {strcpy(namehtml," ");}
	if (itemlvl==ITEM_LEVEL_CRAFT){strcat(namehtml,"craft");}
	if (itemlvl==ITEM_LEVEL_UNIQUE){strcat(namehtml,"unique");}
	if (itemlvl==ITEM_LEVEL_SET){strcat(namehtml,"set");}
	if (itemlvl==ITEM_LEVEL_MAGIC){strcat(namehtml,"magic");}
	if (itemlvl==ITEM_LEVEL_NORMAL){strcat(namehtml,"normal");}
	if (itemlvl==ITEM_LEVEL_RARE){strcat(namehtml,"rare");}

	fprintf(stream,"<script>item(\"%s\",\"%s\",\"%s\")</script>\n\0",namehtml,timestr,tempstr);
	if (fclose(stream)) {pickitprint("Cannot close file.");}
}
/////////////////////////////////////////////////////////////////

DWORD GetDistanceSquared(DWORD x1, DWORD y1, DWORD x2, DWORD y2) {
	return ( ((x1 - x2) * (x1 - x2)) + ((y1 - y2) * (y1 - y2)));
}

// functions called by d2hackit
BOOL EXPORT OnClientStart() {
	return true;
}

BOOL EXPORT OnClientStop() {
	return true;
}

VOID EXPORT OnGameJoin(THISGAMESTRUCT* aThisgame) {
	thisgame = aThisgame;
	LinkedItem_t *linkeditem;
	
	// make sure there are now stale items in the llist
	for(linkeditem = Items->GetFirstItem();linkeditem != NULL;linkeditem = Items->RemoveItem(linkeditem)){
		delete (ITEMSTRUCT*) linkeditem->lpData;
	}

	for (int x=0; x<20000000; x++){DoNotTryWhenFull[x]=0;}
	counter=0;

	inGame = true; // d2hackit bug/feature work around

	if (!LoadConfig("pickit"))
	{pickitprint("PICKIT has a problem loading configuration files.");}
}

VOID EXPORT OnGameLeave(THISGAMESTRUCT* aThisgame) {
	inGame = false;  // d2hackit bug/feature work around
}

// is run ~every 1/10th a second
DWORD EXPORT OnGameTimerTick(void)
{
	DWORD DistanceSquared;
	LinkedItem_t *linkeditem;
	ITEMSTRUCT *item;

	int used;
	BOOL dotake=FALSE;
	int teleport;

	int SmallestItemDistanceSquared;
	int SmallestGoldDistanceSquared;

	// d2hackit bug/feature work around
	// OnGameTimerTick() gets called even when not in game.
	if(!inGame) {return true;}

	if (taking==0)
	{
		//if(breakit>0){breakit--; return true;}
		SmallestItemDistanceSquared=-1; 
		SmallestGoldDistanceSquared=-1;
		chosenitemid=0;
		chosengoldid=0;
		used=0;
		counter=0;
		teleport=FALSE;
		for(int x=0; x<=3; x++){chosengoldpos[x]=0; chosenitempos[x]=0;}

		for(linkeditem = Items->GetFirstItem();linkeditem != NULL;linkeditem = Items->GetNextItem(linkeditem)) 
		{
			item = (ITEMSTRUCT*)linkeditem->lpData;
			
			DistanceSquared = GetDistanceSquared(thisgame->player->PlayerPositionX,thisgame->player->PlayerPositionY,item->PositionX,item->PositionY);

			if (InventoryFull==0 || /*item->DoNotTryWhenFull==FALSE*/ DoNotTryWhenFull[item->ItemID]==0 )
			{

				if (strcmp(item->ItemCode,"gld")!=0)
				{
					if ((DistanceSquared<SmallestItemDistanceSquared || SmallestItemDistanceSquared==-1) && item!=NULL)
					{
						chosenitemid=item->ItemID;
						memcpy(&chosenitempos,&item->PositionX,2);
						memcpy(&chosenitempos[2],&item->PositionY,2);

						SmallestItemDistanceSquared=DistanceSquared;
						dotake=TRUE;
					}
				}

				if (strcmp(item->ItemCode,"gld")==0)
				{
					if ((DistanceSquared<SmallestGoldDistanceSquared || SmallestGoldDistanceSquared==-1) && item!=NULL)
					{
						chosengoldid=item->ItemID;
						memcpy(&chosengoldpos,&item->PositionX,2);
						memcpy(&chosengoldpos[2],&item->PositionY,2);

						SmallestGoldDistanceSquared=DistanceSquared;
						dotake=TRUE;
					}
				}
				if (item->ItemID>20000000) {dotake=FALSE; Items->RemoveItem(linkeditem);}

			}
		}

		if (chosenitemid==0 && chosengoldid==0){dotake=FALSE; counter=0;}
		if (chosenitemid!=0 && PickupEnabled==0){chosenitemid=0; for(int x=0; x<=3; x++){chosenitempos[x]=0;}}
		if (chosenitemid==0 && GoldEnabled==1){chosenitemid=chosengoldid; SmallestItemDistanceSquared=SmallestGoldDistanceSquared; memcpy(chosenitempos,chosengoldpos,4);}
		if (chosenitemid==0){dotake=FALSE;}

		
		if (Teleport==TRUE && SmallestItemDistanceSquared<TeleportRadiusSquared && SmallestItemDistanceSquared>PickupRadiusSquared && dotake==TRUE && thisgame->player->PlayerLocation!=0x05)
		{
			donottracklastskill=1;
			BYTE spell[9]={0x3c,0x36,0,0,0,0xFF,0xFF,0xFF,0xFF};
			server->GameSendPacketToServer(spell, 9);

			BYTE tele[5]={0x0c,0,0,0,0};
			memcpy(tele+1,chosenitempos,4);
			server->GameSendPacketToServer(tele, 5);

			BYTE lasts[9]={0x3c,0,0,0,0,0xFF,0xFF,0xFF,0xFF};
			memcpy(lasts+1,lastskill,4);
			if (lastskill[0]!=0){server->GameSendPacketToServer(lasts, 9);}

			donottracklastskill=0;
			pickwhenarrived=TRUE;
			used=counter;
			taking=TRUE;
		}
		if (SmallestItemDistanceSquared<=PickupRadiusSquared && dotake==TRUE) {
			BYTE PickupPacket[13];
			PickupPacket[0] = 0x16;
			PickupPacket[1] = 0x04;
			PickupPacket[2] = PickupPacket[3] = PickupPacket[4] = 0;
			memcpy(&PickupPacket[5],&chosenitemid,4);
			PickupPacket[9] = PickupPacket[10] = PickupPacket[11] = PickupPacket[12] = 0;
			server->GameSendPacketToServer(PickupPacket,13);
			if(Debug == DEBUG_DEVEL) {
				sprintf(DebugBuffer,"Sending Pickup Request (%d)",chosenitemid);
				pickitprint(DebugBuffer);
			}
			used=counter;
			taking=1;
		}
	}

	counter++;
	if(counter >= 100000) {counter=0; used=used-100000; taking=FALSE;}
	if(counter-used>=refresh) {counter=0; used=0; taking=FALSE;}
	return true;
}

DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen) {
	if (aPacket[0]==0x3c && donottracklastskill!=1)
	{memcpy(lastskill,aPacket+1,4);}

	if (aPacket[0]==0x16){taking=FALSE;}
	return aLen;
}

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen) {

	ITEMSTRUCT *item;  
	CONFIGSTRUCT *cfg;
	LinkedItem_t *linkedcfg;
	LinkedItem_t *linkeditem;
	BOOL DoPickup;
	BOOL hide=FALSE;

	// see if the packet is has the right messageID
	if (aPacket[0]==ITEM_MESSAGEID_DROP) {
		item = ParseItemDrop(aPacket,aLen);
		if(item == NULL) {
			// adds alot of un-needed spam
			if(Debug == DEBUG_DEVEL) {
				server->GamePrintInfo("OnGamePacketBeforeReceived:  ParseItemDrop returnned NULL");
			}
			
			return aLen;
		}

		// need to make sure we delete item if not used

		if(DumpItems) {
			DumpItemStruct(item);
		}

		// see if we should pickup/annouce this item
		for(linkedcfg = Config->GetFirstItem();linkedcfg != NULL;linkedcfg = Config->GetNextItem(linkedcfg)){
			DoPickup = true;
			cfg = (CONFIGSTRUCT*)linkedcfg->lpData;

			// hasSockets
			if(cfg->item.hasSockets != ITEM_UNSET && item->hasSockets != cfg->item.hasSockets)
				DoPickup = false;

			// isIdentified
			if(cfg->item.isIdentified != ITEM_UNSET && item->isIdentified != cfg->item.isIdentified)
				DoPickup = false;

			if(cfg->item.isEthereal != ITEM_UNSET && item->isEthereal != cfg->item.isEthereal)
				DoPickup = false;

			// ItemCode 
			if(cfg->item.ItemCode[0] != '\0' && strcmp(cfg->item.ItemCode,item->ItemCode) != 0) 
				DoPickup = false;
			
			// ItemType
			if(cfg->item.ItemType != ITEM_UNSET && item->ItemType != cfg->item.ItemType) 
				DoPickup = false;

			// ItemLevel
			if(cfg->item.ItemLevel != ITEM_UNSET && item->ItemLevel != cfg->item.ItemLevel)
				DoPickup = false;

			// want to pick or be notified of this item
			if(DoPickup) {
				if(Debug) {
					sprintf(DebugBuffer,"Pickup/Noticed cause by [%s]",cfg->Section);
					server->GamePrintInfo(DebugBuffer);
				}

				// Gold amount
				if(item->GoldAmount < cfg->item.GoldAmount && strcmp(item->ItemCode,"gld")==0)
				DoPickup = false;

				// do notification if description exists;
				if(strlen(cfg->Description)) 
				{
					char *des;
				//if the description is 'auto', look up the real item name
					if(strstr(cfg->Description, "<auto-id>") != NULL)
					{
					//name is the real name of the item..  we also create a temp copy of the description to work with
						char name[1024];
						name[0]=0;
						char temp[1024];
						temp[0]=0;
					//here, we attempt to find the real name, basically setting it to unknown if we can't find it

						if(item->ItemLevel == ITEM_LEVEL_SET)
							strcat(name,server->GetHackProfileString("Pickit-Conversions",  "CodesToSetNames", item->ItemCode));
						else if(item->ItemLevel == ITEM_LEVEL_UNIQUE)
							strcat(name,server->GetHackProfileString("Pickit-Conversions", "CodesToUniqueNames", item->ItemCode));

						if(name[0]!=0){strcat(name," - ");}

						if(item->ItemLevel == ITEM_LEVEL_UNIQUE)
							strcat(name,"Unique ");
						else if(item->ItemLevel == ITEM_LEVEL_SET)
							strcat(name,"Set ");
						else if(item->ItemLevel == ITEM_LEVEL_RARE)
							strcat(name,"Rare ");
						else if(item->ItemLevel == ITEM_LEVEL_MAGIC)
							strcat(name,"Magic ");
						else if(item->ItemLevel == ITEM_LEVEL_NORMAL)
							strcat(name,"Normal ");
						else if(item->ItemLevel == ITEM_LEVEL_INFERIOR)
							strcat(name,"Inferior ");
						else if(item->ItemLevel == ITEM_LEVEL_SUPERIOR)
							strcat(name,"Superior ");
						else if(item->ItemLevel == ITEM_LEVEL_CRAFT)
							strcat(name,"Craft ");

						strcat(temp,server->GetHackProfileString("Pickit-Conversions", "CodesToNames", item->ItemCode));

						if(name[0]==0 && temp[0]==0){strcat(name,"Unknown item");}
						else if (temp[0]==0 && name[0]!=0){strcat(name,"item");}
						else {strcat(name,temp);}

					//here we actually replace "auto-id" with the real name
						des = ReplaceString(cfg->Description, "<auto-id>", name);
						ReplaceString(cfg->Description, name, "<auto-id>");
						
					}
					else
					{
						des = new char[strlen(cfg->Description)];
						strcpy(des, cfg->Description);
					}

					// if outside our pickup radius add directional information
					if(GetDistanceSquared(thisgame->player->PlayerPositionX,thisgame->player->PlayerPositionY,item->PositionX,item->PositionY) > PickupRadiusSquared) {
						
						int x = thisgame->player->PlayerPositionX - item->PositionX;
						int y = thisgame->player->PlayerPositionY - item->PositionY;
						char DesBuffer[1024];

						double dir;
						double dirSetting = 0.414;  // tan of 22.5 degrees
						if( abs(x) > abs(y)) {
							dir = (float)y / x;
						} else {
							dir = (float)x / y;
						}
						
						if(x > 0 && y > 0) {
							if(dir < dirSetting) {
								if(x > y) {
									sprintf(DesBuffer,"%s c7(NorthWest)", des);
								} else {
									sprintf(DesBuffer,"%s c7(NorthEast)", des);
								}
							} else {
								sprintf(DesBuffer,"%s c7(North)", des);
							}
						} else if(x > 0 && y < 0) {
							if(dir > -dirSetting) {
								if(x > abs(y)) {
									sprintf(DesBuffer,"%s c7(NorthWest)", des);
								} else {
									sprintf(DesBuffer,"%s c7(SouthWest)", des);
								}
							} else {
								sprintf(DesBuffer,"%s c7(West)", des);
							}
						} if(x < 0 && y > 0) {
							if(dir > -dirSetting) {
								if(abs(x) > y) {
									sprintf(DesBuffer,"%s c7(SouthEast)", des);
								} else {
									sprintf(DesBuffer,"%s c7(NorthEast)", des);
								}
							} else {
								sprintf(DesBuffer,"%s c7(East)", des);
							}
						} else if(x < 0 && y < 0) {
							if( dir < dirSetting) {
								if(abs(x) > abs(y)) {
									sprintf(DesBuffer,"%s c7(SouthEast)", des);
								} else {
									sprintf(DesBuffer,"%s c7(SouthWest)", des);
								}
							} else {
								sprintf(DesBuffer,"%s c7(South)", des);
							}
						}
						pickitprint(DesBuffer);
					} else {
						pickitprint(des);
					}

					if (Log != false && DoPickup==1) 
					{
						if(cfg->item.ItemCode[0]!='\0'){txtwrite(des,item->ItemLevel,1);}
						else{txtwrite(des,item->ItemLevel,0);}
					}
					delete des;
				}

				if(cfg->Pickup != false && DoPickup==1) {
					Items->AddItem(item);
				} else {
					delete item;
				}

				// Hide
				if(cfg->Hide==1){hide=TRUE;}
			 
		if(hide==TRUE){return 0;}
		else{return aLen;}
			}
		}


	} else if(aPacket[0] == 0x0a && aPacket[1] == 0x04) {  // item was picked up or is gone
		BitFields Pickedup(aPacket,aLen);
		Pickedup.GetField(16);
		DWORD ItemID = Pickedup.GetField(32);

		for(linkeditem = Items->GetFirstItem();linkeditem != NULL;linkeditem = Items->GetNextItem(linkeditem)) {
			item = (ITEMSTRUCT*)linkeditem->lpData;
			if(item->ItemID == ItemID) {
				// remove item and its place in the llist
				delete item;
				Items->RemoveItem(linkeditem);
				if(taking==TRUE){taking=FALSE;}
				return aLen;
			}
		}


	} else if(aPacket[0] == 0x2c && aPacket[1] == 0x00 && PickupEnabled) {
		if(aLen == 8 && aPacket[6] == 0x16) {
			if (InventoryFull==FALSE)
			{
				pickitprint("Inventory full! PICKIT will try once to take every items. To reset PICKIT, type \".pickit activate\".");
				InventoryFull=TRUE;
			}

			taking=FALSE;

			DoNotTryWhenFull[chosenitemid]=1;
		}


	} else if (aPacket[0] == 0x15 && aPacket[2] == 0x01 && pickwhenarrived==TRUE 
		&& labs(aPacket[6]-chosenitempos[0])<3 
		&& labs(aPacket[7]-chosenitempos[1])<3 
		&& labs(aPacket[8]-chosenitempos[2])<3 
		&& labs(aPacket[9]-chosenitempos[3])<3 ) 
	{
			pickwhenarrived=FALSE;
			//breakit=4;
			BYTE PickupPacket[13];
			PickupPacket[0] = 0x16;
			PickupPacket[1] = 0x04;
			PickupPacket[2] = PickupPacket[3] = PickupPacket[4] = 0;
			memcpy(&PickupPacket[5],&chosenitemid,4);
			PickupPacket[9] = PickupPacket[10] = PickupPacket[11] = PickupPacket[12] = 0;
			server->GameSendPacketToServer(PickupPacket, 13);
	}

	return aLen;
}

















// 
// stuff below here is from ClientCore.cpp
//////////////////////////////////////////////////////////////////////
// Dll entry/exit
//////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	BOOL hResult = TRUE;
	char *t;
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
			
			// Create server struct			
			server = new FUNCTIONENTRYPOINTS; 

			// Bind exported functions from server
			HMODULE hModule;
			hModule = (HMODULE)GetModuleHandle("D2HackIt");
			
			// Macros make this look a lot nicer :)
			BIND_TO_SERVER(GamePrintInfo);
			BIND_TO_SERVER(GamePrintError);
			BIND_TO_SERVER(GamePrintVerbose);
			BIND_TO_SERVER(GamePrintString);
			BIND_TO_SERVER(GameCommandLine);
			BIND_TO_SERVER(GameSendPacketToServer);
			BIND_TO_SERVER(GameSendPacketToGame);
			BIND_TO_SERVER(GetFingerprint);
			BIND_TO_SERVER(Intercept);
			BIND_TO_SERVER(GetHackProfileString);
			BIND_TO_SERVER(SetHackProfileString);
			BIND_TO_SERVER(GetThisgameStruct);

			// Get plugin path
			t = ConfigPath;
			if (GetModuleFileName((HINSTANCE)hModule, t, _MAX_PATH)) {
				int p=strlen(ConfigPath);
				while (p) {
						if (ConfigPath[p] == '\\')
							{ ConfigPath[p] = 0; p=0;}
						else
					p--;
				}
			}	 
			// initiate client
			// hResult = OnClientStart();
			break;

		case DLL_PROCESS_DETACH:
			// kill client

			// hResult = OnClientStop();

			delete server;
			break;
    } 
    return hResult;
}

//////////////////////////////////////////////////////////////////////
// Stubfunctions for 'property get' functions.
//////////////////////////////////////////////////////////////////////
LPCSTR	EXPORT GetModuleAuthor()		{return ModuleAuthor;}
LPCSTR	EXPORT GetModuleWebsite()		{return ModuleWebsite;}
DWORD	EXPORT GetModuleVersion()		{return ModuleVersion;}
LPCSTR	EXPORT GetModuleEmail()			{return ModuleEmail;}
LPCSTR	EXPORT GetModuleDescription()	{return ModuleDescription;}

//////////////////////////////////////////////////////////////////////
// OnClientCommandLine
// -------------------------------------------------------------------
// The modules own extension of the command line interface. Any custom
// commands you add are parsed here.
//
// Return value should be TRUE, but it is not used at this 
// time.
//
// Arguments when we get here:
// argv[0]			Name of module
// argv[1]			Name of command (If supplied)
// argv[2 ... n]	The rest
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnGameCommandLine(char* argv[], int argc)
{
	// Check if user supplied anything at all, if not assume help...
	if (argc==1)
		argv[argc++]="help";


	MODULECOMMANDSTRUCT* mcs=ModuleCommands;

	while (mcs->szName) {
		if (!stricmp(mcs->szName, argv[1]))
			break;
		mcs++;
	}

	char *p,*t,*msg,*fMsg;
	fMsg=new char[256];
	//
	// Is this a built-in function ?
	if (mcs->szName) {
		//
		// If functions returns false, show usage help
		if (!mcs->pFunc(argv, argc)) {
			t=new char[strlen(mcs->szUsage)+1];
			server->GamePrintInfo("Usage:");
			sprintf((char*)t, "%s", mcs->szUsage);
			if (strlen((char*)t))
			{
				msg=p=t;
				while (*p != 0) {
					if (*p == '\n') 
					{
						*(p++) = 0;
						sprintf(fMsg, "c4.%s %s", argv[0], msg);
						server->GamePrintInfo((char*)fMsg);
					if (*p != 0)
						msg = p;
					} else
						p++;
					}
				sprintf(fMsg, "c4.%s %s", argv[0], msg);
				server->GamePrintInfo((char*)fMsg);
			}
			delete t;
		}
	} else {
	// Unknown command, show catch-all help phraze.
	t=new char[128];
	sprintf(t, "Unknown command c4'%s %s'c0 - try c4'.%s help'c0 to get help.",
		argv[0], argv[1], argv[0]);
	server->GamePrintError(t);
	delete t;
	}
	delete fMsg;
	return TRUE;
}


//////////////////////////////////////////////////////////////////////
// OnClientCommandHelp
// -------------------------------------------------------------------
// Our default help function.
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandHelp(char** argv, int argc)
{
	// If command line is longer than 2, show usage for 'help'
	if (argc>2) return FALSE;

	char t[1024];
	sprintf(t, "Available commands for %s:", argv[0]);
	server->GamePrintInfo(t);

	// Loop through ModuleCommands[] and print their names
	for (int i=0; ModuleCommands[i].szName != NULL; i++)
	{
		sprintf(t, "c4.%s %s", argv[0], ModuleCommands[i].szName);
		server->GamePrintInfo(t);
	}

	sprintf(t, "For help on a specific command, type c4.%s <command> help", argv[0]);
	server->GamePrintInfo(t);
	return TRUE;
}

char *ReplaceString(char *source, char *old, char *newtext)
{
	char *original = new char[strlen(source)];
	strcpy(original, source);
	char *temp = new char[256];
	int old_length = strlen(old);
	int i, j, k, location = -1;
	for(i = 0; source[i] && (location == -1); ++i)
		for(j = i, k = 0; source[j] == old[k]; j++, k++)
			if(!old[k+1])
				location = i;
	if(location != -1)
	{
		for(j = 0; j < location; j++)
			temp[j] = source[j];
		for(i = 0; newtext[i]; i++, j++)
			temp[j] = newtext[i];
		for(k = location + old_length; source[k]; k++, j++)
			temp[j] = source[k];
		temp[j] = NULL;
		for(i = 0; source[i] = temp[i]; i++);
	}	
	delete original;
	return temp;
}
