//////////////////////////////////////////////////////////////////////
// ClientImplementation.cpp
// -------------------------------------------------------------------
// This is the file to change when writing new modules. No other code
// should be needed!
//
// The modules are event based, and the functions they export will be
// called by the D2HackIt! dll at appropriate times. Any events you do
// not need can safely be deleted from this file, as D2HackIt! only
// calls the events it can bind.
//
// 
//
// <thohell@home.se>
//////////////////////////////////////////////////////////////////////
#include "../ClientCore.cpp"	  // Include the backend of the module

//////////////////////////////////////////////////////////////////////
// CLIENTINFO
// -------------------------------------------------------------------
// Tell us a little about this module.
//////////////////////////////////////////////////////////////////////
CLIENTINFO
(		
	0,3,						
	"masterste0",				
	"masterste0.20m.com",		
	"Packet Identifyer",				
	"shirkan_sh@yahoo.com"			
)

/******** THIS PART OF THE CODE IS FROM THOHELL'S SNIFFER MODULE **********/

BOOL PRIVATE OnGameCommandShow(char** argv, int argc);
BOOL PRIVATE OnGameCommandHide(char** argv, int argc);
BOOL PRIVATE OnGameCommandList(char** argv, int argc);
BOOL PRIVATE OnGameCommandLoad(char** argv, int argc);
BOOL PRIVATE OnGameCommandSave(char** argv, int argc);
BOOL PRIVATE OnGameCommandClear(char** argv, int argc);

// Some global stuff

typedef struct filter_t
{
	BOOL	Sent;
	BOOL	Received;
} FILTER;

FILTER f[256];


MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{
		"show",
		OnGameCommandShow,
		"show <R|S> <id> [id] ... [id]c0 Shows <Received|Sent> packets with packet id <id>."
	},
	{
		"hide",
		OnGameCommandHide,
		"hide <R|S> <id> [id] ... [id]c0 Hides <Received|Sent> packets with packet id <id>."
	},
	{
		"list",
		OnGameCommandList,
		"listc0 Lists all packets id's that will show."
	},
	{	"load",
		OnGameCommandLoad,
		"load [section]c0 Loads packet-filter in [filter] from pktident.ini."
	},
	{	"save",
		OnGameCommandSave,
		"save [section]c0 Saves current packet-filer to [filter] in pktident.ini."
	},
	{	"clear",
		OnGameCommandClear,
		"clearc0 Removes all filters (Show all)."
	},
	{NULL}	// No more commands
};

//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
// Runs *once* before client is loaded. Return FALSE to prevent from
// loading.
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnClientStart()
{
	// Initiate list
	char *argv[2];
	char argc=2;
	argv[0]="";
	argv[1]="load";
	OnGameCommandLoad(argv, argc);
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
// Runs *once* before client is unloaded. Return value should be TRUE,
// but it is not used at this time.
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnClientStop()
{
	char *argv[2];
	char argc=2;
	argv[0]="";
	argv[1]="save";
	OnGameCommandSave(argv, argc);
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandShow
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandShow(char** argv, int argc)
{
	// If command line is shorter than 4 tokens, something is wrong
	if (argc<4) return FALSE;

	bool r;

	if (stricmp(argv[2], "r"))
		r=TRUE;
	else if (stricmp(argv[2], "s"))
		r=FALSE;
	else
		return FALSE;

	for (int i=3; i!=argc; i++)
	{
		char* x="";
		DWORD v=(strtoul(argv[i], &x, 0x10)&0xff);
		f[v].Received=(!r?TRUE:f[v].Received);
		f[v].Sent=(r?TRUE:f[v].Sent);
	}	

	server->GamePrintInfo("Ok");
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandHide
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandHide(char** argv, int argc)
{
	// If command line is shorter than 4 tokens, something is wrong
	if (argc<4) return FALSE;

	bool r;

	if (stricmp(argv[2], "r"))
		r=TRUE;
	else if (stricmp(argv[2], "s"))
		r=FALSE;
	else
		return FALSE;

	for (int i=3; i!=argc; i++)
	{
		char* x="";
		DWORD v=(strtoul(argv[i], &x, 0x10)&0xff);
		f[v].Received=(!r?FALSE:f[v].Received);
		f[v].Sent=(r?FALSE:f[v].Sent);
	}	

	server->GamePrintInfo("Ok");
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandList
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandList(char** argv, int argc)
{
	// If command line is not 2 tokens, something is wrong
	if (argc!=2) return FALSE;

	char	s[8][110],r[8][110];
	int		rC=0,sC=0;
	int		i;

	for	(i=0;i!=8;i++)
	{
		sprintf(r[i], "c8RECV: ");
		sprintf(s[i], "c9SENT: ");
	}

	server->GamePrintInfo("Packets that are currently visible:");

	// Format restult
	for (i=0; i!=256; i++)
	{
		if (f[i].Received)
		{
			sprintf(r[rC], "%s %.2x", r[rC], i);
			if (strlen(r[rC])>104)
				rC++;
		}
		if (f[i].Sent)
			sprintf(s[sC], "%s %.2x", s[sC], i);
			if (strlen(s[sC])>104)
				sC++;
	}

	// Print result
	for (i=0; i!=8; i++)
		if (strlen(r[i])>10)
			server->GamePrintInfo(r[i]);
	for (i=0; i!=8; i++)
		if (strlen(s[i])>10)
			server->GamePrintInfo(s[i]);


	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandLoad
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandLoad(char** argv, int argc)
{
	// If command line is not 2 or 3 tokens, something is wrong
	if (argc!=2) return FALSE;

	char t[128];




	sprintf(t, "Loading packet-filter from section: c4[filter]");
	server->GamePrintInfo(t);

	char* r=server->GetHackProfileString("pktident", "filter", "RECV");
	char* s=server->GetHackProfileString("pktident", "filter", "SENT");

	for (int i=0; i!=256; i++)
	{
		f[i].Received=f[i].Sent=FALSE;
		if (strlen(r)>i)
			f[i].Received=((char)*(r+i)=='1');
		if (strlen(s)>i)
			f[i].Sent=((char)*(s+i)=='1');
	}

	delete r,s;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandSave
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandSave(char** argv, int argc)
{
	// If command line is not 2 or 3 tokens, something is wrong
	if (argc!=2)return FALSE;

	char t[1024];


	
	sprintf(t, "Saving packet-filter to section: c4[filter]");
	server->GamePrintInfo(t);

	char s[257],r[257];
	r[256]=s[256]=0;

	for (int i=0; i!=256; i++)
	{
		r[i]=(f[i].Received?'1':'0');
		s[i]=(f[i].Sent?'1':'0');
	}

	server->SetHackProfileString("pktident", "filter", "RECV", r);
	server->SetHackProfileString("pktident", "filter", "SENT", s);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandClear
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandClear(char** argv, int argc)
{
	// If command line is not 2 tokens, something is wrong
	if (argc!=2) return FALSE;
	
	for (int i=0; i!=256; i++)
		f[i].Received=f[i].Sent=TRUE;

	server->GamePrintInfo("All packet-filters has been cleared. All packets are visible.");

	return TRUE;
}
/*************** END OF THOHELL'S CODE ****************/


//////////////////////////////////////////////////////////////////////
//
// module by masterste0
//
// E-Mail: shirkan_sh@yahoo.com
// URL: http://masterste0.20m.com/
//
//////////////////////////////////////////////////////////////////////


DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen)
{
	if (!f[aPacket[0]].Sent) return aLen;

	char text[128];
	
	char c[5];
	sprintf (c,"%.2x%.2x\0",aPacket[0], aPacket[1]);	
	strcpy(text,server->GetHackProfileString("pktident","send",c));
	if (strlen(text) > 1)
		server->GamePrintInfo(text);
	else
	{
		sprintf (c,"%.2x\0",aPacket[0]);	
		strcpy(text,server->GetHackProfileString("pktident","send",c));
		if (strlen(text) > 1)
			server->GamePrintInfo(text);
	}

	return aLen;
}

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen)
{
	if (!f[aPacket[0]].Received) return aLen;



	char text[128];
	char c[5];
	sprintf (c,"%.2x%.2x\0",aPacket[0], aPacket[1]);	
	strcpy(text,server->GetHackProfileString("pktident","recv",c));
	if (strlen(text) > 1)
		server->GamePrintInfo(text);
	else
	{
		sprintf (c,"%.2x\0",aPacket[0]);	
		strcpy(text,server->GetHackProfileString("pktident","recv",c));
		if (strlen(text) > 1)
			server->GamePrintInfo(text);
	}
	

	return aLen;
}