//////////////////////////////////////////////////////////////////////
// ClientImplementation.cpp
// -------------------------------------------------------------------
// This is the file to change when writing new modules. No other code
// should be needed!
//
// The modules are event based, and the functions they export will be
// called by the D2HackIt! dll at appropriate times. Any events you do
// not need can safely be deleted from this file, as D2HackIt! only
// calls the events it can bind.
//
// 
//
// <thohell@home.se>
//////////////////////////////////////////////////////////////////////
#include "..\ClientCore.cpp"	  // Include the backend of the module
#include "..\linkedlist\linkedlist.h"

//////////////////////////////////////////////////////////////////////
// Global stuff.
// -------------------------------------------------------------------
// This is a very convenient place to your function declarations and
// global variables.
//////////////////////////////////////////////////////////////////////

LinkedList	inventory;
BOOL			active = TRUE;

#define RECV_ADD_TO_INV		0x9C04
#define RECV_REM_FR_INV		0x9D05
#define RECV_ADD_TO_BELT	0x9C0E
#define RECV_REM_FR_BELT	0x9C0F

//////////////////////////////////////////////////////////////////////
// CLIENTINFO
// -------------------------------------------------------------------
// Tell us a little about this module.
//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(1,0);
char	ModuleAuthor[]="Uffe";
char	ModuleWebsite[]="thohell.d2network.com";
char	ModuleDescription[]="Automatic belt refill";
char	ModuleEmail[]="d98ulf@dtek.chalmers.se";

//////////////////////////////////////////////////////////////////////
// SPECIFIC STUFF
//--------------------------------------------------------------------
//
//////////////////////////////////////////////////////////////////////

void putInBelt (int id)
{
	BYTE	packet[] = {0x63, 0xFF, 0xFF, 0xFF, 0xFF};
	*(int *)(packet + 1) = id;
	server->GameSendPacketToServer(packet, 5);
}

void fillBelt (void)
{
	for (LinkedItem *item = inventory.GetFirstItem(); item; item = inventory.GetNextItem(item))
		putInBelt((int)item->lpData);
}

unsigned short packetID (BYTE *aPacket)
{
	return (aPacket[0]<<8) + aPacket[1];
}


//////////////////////////////////////////////////////////////////////
// COMMANDS
//--------------------------------------------------------------------
//
//////////////////////////////////////////////////////////////////////

BOOL PRIVATE OnGameCommandInv(char **argv, int argc)
{
	if (argc == 2)
	{
		char t[1024];
		sprintf(t, "In inventory:");
		server->GamePrintInfo(t);
		for (LinkedItem *item = inventory.GetFirstItem(); item; item = inventory.GetNextItem(item))
		{
			sprintf(t, "id=%d", item->lpData);
			server->GamePrintInfo(t);
		}
	} else
	{
		char t[1024];
		sprintf(t, "c4showinv  c0Lists all items in your inventory.");
		server->GamePrintInfo(t);
	}
	return TRUE;
}

BOOL PRIVATE OnGameCommandToggle(char **argv, int argc)
{
	if (argc == 2)
	{
		char t[1024];
		active = !active;
		if (active)
			sprintf(t, "Auto refill is ON.");
		else
			sprintf(t, "Auto refill is OFF.");
		server->GamePrintInfo(t);
	} else
	{
		char t[1024];
		sprintf(t, "c4toggle  c0Toggle auto refill ON and OFF.");
		server->GamePrintInfo(t);
	}
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
// To add your own commands, just add them to this list like:
//
//	{
//		"name"			// Name of the command
//		pFunction		// The function that handles command
//		"usage"			// Help text for the command
//	}
// 
// ...where pFunction is the name of the function that handles the
// command. The function must be declared as...
//
// BOOL PRIVATE OnGameCommandName(char** argv, int argc)
//
// ...and return TRUE on success or FALSE to show usage of the command.
//
// The "usage" line can contain "\n" as linebreaks and should be in 
// the following format for consistency:
//
// "commandname <required parameter> [optional parameter]c0 Description"
//
//
// To use your commands in the game, just type 
// .modulename <command> [arguments]
//////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]=
	{
		{	// The 'help' command is implemented in ClientCore.cpp and 
			// should not need to be changed.
			"help",
			OnGameCommandHelp,
			"helpc0 List commands available in this module.\n"
			"<command> helpc0 Shows detailed help for <command> in this module."
		},
/*		{
			"showinv",
			OnGameCommandInv,
			"showinvc0 Lists all items in your inventory."
		},
*/		{
			"toggle",
			OnGameCommandToggle,
			"togglec0 Toggle auto refill ON and OFF."
		},
		{NULL}	// No more commands
	};

//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
// Runs *once* when the module loads. 
// This function can be removed.
//
// Put any initialization code here.
//
// Return FALSE to prevent module from loading.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStart()
{
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
// Runs *once* before client is unloaded. 
// This function can be removed.
// 
// Put any cleanup code here.
//
// Return value should be TRUE.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStop()
{
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// EVENTS
// -------------------------------------------------------------------
// The rest of this file are event functions, and they can safely be
// removed if the module makes no use of them.
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// OnGameJoin
// -------------------------------------------------------------------
// Executes when joining a game, and if loading the module while 
// inside a game.
//
// Refer to the documentation for the format of THISGAMESTRUCT.
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameJoin(THISGAMESTRUCT* thisgame)
{
	return;
}

//////////////////////////////////////////////////////////////////////
// OnGameLeave
// -------------------------------------------------------------------
// Executes when leaving a game.
//
// Refer to the documentation for the format of THISGAMESTRUCT.
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameLeave(THISGAMESTRUCT* thisgame)
{
	return;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeSent
// -------------------------------------------------------------------
// Executes before packets are sent from the game to the server.
// 
// If you rewrite the packet, you must make sure to return the length
// of the new packet!
//
// NOTE: This event also works in single player games.
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen)
{
	return aLen;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeReceived
// -------------------------------------------------------------------
// Executes before packets are received to the game from the server.
// 
// If you rewrite the packet, you must make sure to return the length
// of the new packet!
//
// NOTE: This event also works in single player games.
//////////////////////////////////////////////////////////////////////

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen)
{
	switch (packetID(aPacket))
	{
		case RECV_ADD_TO_INV :
		{
			LPVOID id = (LPVOID)*(int *)(aPacket + 4);
			inventory.AddItem(id);
			break;
		}
		case RECV_REM_FR_INV :
		{
			LPVOID		id		= (LPVOID)*(int *)(aPacket + 4);
			LinkedItem	*item	= inventory.GetFirstItem();

			while (item)
			{
				if (item->lpData == id)
				{
					inventory.RemoveItem(item);
					break;
				}
				item = inventory.GetNextItem(item);
			}
			break;
		}
		case RECV_REM_FR_BELT :
			if (active)
				fillBelt();
			break;
	}
	return aLen;
}


//////////////////////////////////////////////////////////////////////
// OnGameTimerTick
// -------------------------------------------------------------------
// This gets executed apx. every 1/10th of a second when in a game.
//
// You can use this to create custom timers.
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGameTimerTick(void)
{
	return 0;
}
