//////////////////////////////////////////////////////////////////////
// Sniffer.cpp
// -------------------------------------------------------------------
// Very basic sniffer module.
//
// <thohell@home.se>
//////////////////////////////////////////////////////////////////////
#include "..\ClientCore.cpp"

// Functions as they appear in the source...
BOOL PRIVATE OnGameCommandShow(char** argv, int argc);
BOOL PRIVATE OnGameCommandHide(char** argv, int argc);
BOOL PRIVATE OnGameCommandList(char** argv, int argc);
BOOL PRIVATE OnGameCommandLoad(char** argv, int argc);
BOOL PRIVATE OnGameCommandSave(char** argv, int argc);
BOOL PRIVATE OnGameCommandClear(char** argv, int argc);
BOOL PRIVATE isSetBit(BYTE* mask, int bit);
BOOL PRIVATE setBit(BYTE* mask, int bit, BOOL set);
BOOL PRIVATE OnGameCommandLog(char **argv, int argc);
BOOL PRIVATE OnGameCommandOutput(char **argv, int argc);
// Some global stuff
FINGERPRINTSTRUCT fps;

char	CurrentSection[64];

BYTE RecvMask[32];
BYTE SendMask[32];
//Log and Output Globals
bool log_file_set = false;
bool output = true;
LPSTR log_file;

//////////////////////////////////////////////////////////////////////
// CLIENTINFO
// -------------------------------------------------------------------
// You *need* this, don't ask why :)
//
// 0.01 2001-10-14 First version
// 0.02 2001-11-21 gototown added by druttis (/Blackpower Ugh?)
// 0.03 2002-01-14 log added by Blackpower
// 0.04 2002-01-14 output added by Blackpower
//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(0,4);
char	ModuleAuthor[]="thohell, druttis & Blackpower";
char	ModuleWebsite[]="thohell.d2network.com";
char	ModuleDescription[]="Sniffer module - Very simple D2 sniffer";
char	ModuleEmail[]="thohell@home.se, druttis@darkface.pp.se & blackpower@code-monkey.co.uk";

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
// To add your own commands, just add them to this list like:
//
//	{
//		"name"			// Name of the command
//		pFunction		// The function that handles command
//		"usage"			// Help text for the command
//	}
// 
// Functions should use following convention...
// BOOL PRIVATE OnGameCommandName(char** argv, int argc)
// ...and return TRUE on success or FALSE to show usage of the command.
//
// To use your commands in the game, just type 
// .modulename <command> [arguments]
//////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{
		"show",
		OnGameCommandShow,
		"show <R|S> <id> [id] ... [id]c0 Shows <'R'eceived|'S'ent> packets with packet id <id>."
	},
	{
		"hide",
		OnGameCommandHide,
		"hide <R|S> <id> [id] ... [id]c0 Hides <'R'eceived|'S'ent> packets with packet id <id>."
	},
	{
		"list",
		OnGameCommandList,
		"listc0 Lists all packets id's that will show."
	},
	{	"load",
		OnGameCommandLoad,
		"load [section]c0 Loads packet-filter in [section] from sniffer.ini."
	},
	{	"save",
		OnGameCommandSave,
		"save [section]c0 Saves current packet-filer to <section> in sniffer.ini."
	},
	{	"clear",
		OnGameCommandClear,
		"clearc0 Removes all filters (Show nothing)."
	},
	{
		"log",
		OnGameCommandLog,
		"log <file>c0 Logs packets to <file>.txt in your D2 dir.\n"
		"c4log stopc0 Stops the logging to <file>."
	},
	{
		"output",
		OnGameCommandOutput,
		"output toggles output of packets on/off"
	},

	{NULL}	// No more commands
};

//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
// Runs *once* before client is loaded. Return FALSE to prevent from
// loading.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStart()
{
	// Initiate list
	char *argv[3];
	char argc=3;
	argv[0]="";
	argv[1]="load";
	argv[2]="default";
	OnGameCommandLoad(argv, argc);
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
// Runs *once* before client is unloaded. Return value should be TRUE,
// but it is not used at this time.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStop()
{
	char *argv[2];
	char argc=2;
	argv[0]="";
	argv[1]="save";
	OnGameCommandSave(argv, argc);
//	delete log_file;
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandShow
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandShow(char** argv, int argc)
{
	// If command line is shorter than 4 tokens, something is wrong
	if (argc<4) return FALSE;

	bool r;

	if (!stricmp(argv[2], "r"))
		r = TRUE;
	else if (!stricmp(argv[2], "s"))
		r = FALSE;
	else
		return FALSE;

	for (int i=3; i!=argc; i++) {
		char* x = "";
		DWORD v = (strtoul(argv[i], &x, 0x10) & 0xff);
		if (r)
			setBit(RecvMask, v, TRUE);
		else
			setBit(SendMask, v, TRUE);
	}	

	server->GamePrintInfo("Ok");
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandHide
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandHide(char** argv, int argc)
{
	// If command line is shorter than 4 tokens, something is wrong
	if (argc<4) return FALSE;

	bool r;

	if (!stricmp(argv[2], "r"))
		r = TRUE;
	else if (!stricmp(argv[2], "s"))
		r = FALSE;
	else
		return FALSE;

	for (int i=3; i!=argc; i++) {
		char* x = "";
		DWORD v = (strtoul(argv[i], &x, 0x10) & 0xff);
		if (r)
			setBit(RecvMask, v, FALSE);
		else
			setBit(SendMask, v, FALSE);
	}	

	server->GamePrintInfo("Ok");
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandList
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandList(char** argv, int argc)
{
	// If command line is not 2 tokens, something is wrong
	if (argc != 2) return FALSE;

	char	s[8][110], r[8][110];
	int		rC = 0, sC = 0;
	int		i;

	for	(i = 0; i < 8;i++)
	{
		sprintf(r[i], "c8RECV: ");
		sprintf(s[i], "c9SENT: ");
	}

	server->GamePrintInfo("Packets that are currently visible:");

	// Format restult
	for (i = 0; i < 256; i++)
	{
		if (isSetBit(RecvMask, i)) {
			sprintf(r[rC], "%s %.2x", r[rC], i);
			if (strlen(r[rC]) > 104)
				rC++;
		}

		if (isSetBit(SendMask, i)) {
			sprintf(s[sC], "%s %.2x", s[sC], i);
			if (strlen(s[sC]) > 104)
				sC++;
		}
	}

	// Print result
	for (i=0; i < 8; i++) {
		if (strlen(r[i]) > 10)
			server->GamePrintInfo(r[i]);
	}

	for (i=0; i < 8; i++) {
		if (strlen(s[i]) > 10)
			server->GamePrintInfo(s[i]);
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandLoad
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandLoad(char** argv, int argc)
{
	// If command line is not 2 or 3 tokens, something is wrong
	if ((argc < 2) && (argc > 3))return FALSE;

	char t[128];

	if (argc == 3)
		strcpy(CurrentSection, argv[2]);

	sprintf(t, "Loading packet-filter from section: c4[%s]",CurrentSection);
	server->GamePrintInfo(t);

	char* r=server->GetHackProfileString("sniffer", CurrentSection, "RECV");
	char* s=server->GetHackProfileString("sniffer", CurrentSection, "SENT");

	int c = 0;
	char* x = "";
	for (int i = 0; i < 32; i++) {
		r[c + 2] = 0;
		s[c + 2] = 0;
		RecvMask[i] = (strtoul(&r[c], &x, 0x10) & 0xff);
		SendMask[i] = (strtoul(&s[c], &x, 0x10) & 0xff);
		c += 3;
	}

	delete r, s;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandSave
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandSave(char** argv, int argc)
{
	// If command line is not 2 or 3 tokens, something is wrong
	if ((argc < 2) && (argc > 3))return FALSE;

	char t[1024];

	if (argc == 3)
		strcpy(CurrentSection, argv[2]);

	sprintf(t, "Saving packet-filter to section: c4[%s]",CurrentSection);
	server->GamePrintInfo(t);

	char s[257], r[257];
	r[256] = s[256] = 0;

	sprintf(r, "%.2x", RecvMask[0]);
	sprintf(s, "%.2x", SendMask[0]);
	for (int i = 1; i < 32; i++)
	{
		sprintf(r, "%s %.2x", r, RecvMask[i]);
		sprintf(s, "%s %.2x", s, SendMask[i]);
	}

	server->SetHackProfileString("sniffer", CurrentSection, "RECV", r);
	server->SetHackProfileString("sniffer", CurrentSection, "SENT", s);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandClear
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandClear(char** argv, int argc)
{
	// If command line is not 2 tokens, something is wrong
	if (argc != 2) return FALSE;
	
	for (int i = 0; i < 32; i++) {
		RecvMask[i] = 0;
		SendMask[i] = 0;
	}

	server->GamePrintInfo("All packet-filters has been cleared. No packets are visible.");

	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeSent
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeSent (BYTE * aPacket, DWORD aLen)
{
  // Filter
  if (!isSetBit (SendMask, aPacket[0]))
    return aLen;
  //Changed for log and output
  char swi[1024];
  char t[1024];

  if (log_file_set || output)
    {
      sprintf (t, " ");
      for (int i = 0; i < aLen; i++)
        sprintf (t, "%s%.2x ", t, aPacket[i]);
    }
  if (output)
    {
      sprintf (swi, "c9SENTc0:%s", t);
      server->GamePrintString (swi);
    }
  if (log_file_set)
    {
      FILE *stream;
      if ((stream = fopen (log_file, "a")) == NULL)
        {
          sprintf (t, "Unable to append c8%sc8", log_file);
          server->GamePrintError (t);
          log_file_set = false;
          return aLen;
        }
      sprintf (swi, "SENT:%s", t);
      fprintf (stream, "%s\n", swi);
      fclose (stream);
      delete stream;
    }

  return aLen;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeReceived
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeReceived (BYTE * aPacket, DWORD aLen)
{
  // Filter
  if (!isSetBit (RecvMask, aPacket[0]))
    return aLen;
  //Changed for log and output
  char swi[1024];
  char t[1024];
  if (log_file_set || output)
    {
      sprintf (t, " ");
      for (int i = 0; i < aLen; i++)
        sprintf (t, "%s %.2x", t, aPacket[i]);
    }
  if (output)
    {
      sprintf (swi, "c8RECVc0:%s", t);
      server->GamePrintString (swi);
    }
  if (log_file_set)
    {
      FILE *stream;
      if ((stream = fopen (log_file, "a")) == NULL)
        {
          sprintf (t, "Unable to append c8%sc0", log_file);
          server->GamePrintError (t);
          log_file_set = false;
          return aLen;
        }
      sprintf (swi, "RECV:%s", t);
      fprintf (stream, "%s\n", swi);
      fclose (stream);
      delete stream;
    }

  return aLen;
}

//////////////////////////////////////////////////////////////////////
// isBitSet
// -------------------------------------------------------------------
// Check if bit in mask is set
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE isSetBit(BYTE* mask, int bit)
{
	if ((bit < 0) || (bit > 255))
			return FALSE;
	return ((mask[bit >> 3] & (1 << (bit & 0x7))) != 0 ? 1 : 0);
}

//////////////////////////////////////////////////////////////////////
// setBit
// -------------------------------------------------------------------
// Set or unsets a bit in mask
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE setBit(BYTE* mask, int bit, BOOL set)
{
	if ((bit < 0) || (bit >255))
		return FALSE;
	if (set) {
		mask[bit >> 3] |= (1 << (bit & 0x7));
	} else {
		mask[bit >> 3] &= 0xff - (1 << (bit & 0x7));
	}
	return TRUE;
}
//////////////////////////////////////////////////////////////////////
// OnGameCommandLog
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE
OnGameCommandLog (char **argv, int argc)
{

  if (argc != 3)
    return false;
  if (!(strcmp (argv[2], "stop")))
    {
      log_file_set = false;
      server->GamePrintInfo ("c8Logging has stoppedc0");
      return true;
    }
  FILE *stream;
  char t[1024];
  char D2Dir[256];
  GetCurrentDirectory (255, D2Dir);
  log_file = new char[strlen (D2Dir) + strlen (argv[2]) + 6];
  sprintf (log_file, "%s\\%s.txt", D2Dir, argv[2]);
  if (!(stream = fopen (log_file, "w")))
    {
      sprintf (t, "Unable to create c8%sc0.", log_file);
      server->GamePrintError (t);
      return false;
    }
  sprintf (t, "Logging to c8%sc0", log_file);
  server->GamePrintInfo (t);
  fclose (stream);
  delete stream;
  log_file_set = true;
  return true;
}

//////////////////////////////////////////////////////////////////////
// OnGameCommandOutput
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE
OnGameCommandOutput (char **argv, int argc)
{
  if (argc != 2)
    return false;
  if (output)
    {
      output = false;
        server->GamePrintInfo ("Output off.");
    }
  else
    {
      output = true;
      server->GamePrintInfo ("Output on.");
    }
  return true;
}
