// pickit.cpp
// by Gayak (170@guyau.qc.ca)
// original program (0.82 and previous) by ackmed@gotwalls.com
#include "item.h"
#include "pickit.h"

ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length) {
	ITEMSTRUCT *item = new ITEMSTRUCT;

	BitFields iPacket(Packet,Length);	

	
	item->MessageID = iPacket.GetField(8);
/*
	if(item->MessageID != ITEM_ACTION_PLACE_UNKNOWN) {
		delete item;
		return NULL;
	}
	
	item->Action = iPacket.GetField(8);
	if(item->Action != ITEM_ACTION_NEW_GROUND && item->Action != ITEM_ACTION_DROP
		&& item->Action != ITEM_ACTION_OLD_GROUND) {
		// we dont handle parsing these packets.
		delete item;
		return NULL;
	}
*/
	item->MessageSize = iPacket.GetField(8);
	item->ItemType = iPacket.GetField(8);
	item->ItemID = iPacket.GetField(32);

	// flags
	item->isSocketsFull = iPacket.GetField(1);
	item->isIdentified = iPacket.GetField(1);
	item->isSwitchin = iPacket.GetField(1);
	item->isSwitchout = iPacket.GetField(1);
	item->isBroken = iPacket.GetField(1);
	item->fromBelt = iPacket.GetField(1);
	item->hasSockets = iPacket.GetField(1);
	item->isJustGenerated = iPacket.GetField(1);
	item->isEar = iPacket.GetField(1);
	item->isStartitem = iPacket.GetField(1);
	item->isMiscItem = iPacket.GetField(1);
	item->isEthereal = iPacket.GetField(1);
	item->isPersonalized = iPacket.GetField(1);
	item->isGamble = iPacket.GetField(1);
	item->isRuneWord = iPacket.GetField(1);
	
	item->MPQVersionField = iPacket.GetField(10);
	
	item->Location = iPacket.GetField(3);
	item->PositionX = iPacket.GetField(16);
	item->PositionY = iPacket.GetField(16);

	// isEar need to return now, until ear packets are decoded  
	if(item->isEar) {
		return item;
	}

	// read in itemcode, its a string;
	item->ItemCode[0] = iPacket.GetField(8);
	item->ItemCode[1] = iPacket.GetField(8);
	item->ItemCode[2] = iPacket.GetField(8);
	item->ItemCode[3] = iPacket.GetField(8);

	// chomp off the space if it exists
	if(item->ItemCode[3] == ' ') {
		item->ItemCode[3] = '\0';
	} else {
		item->ItemCode[4] = '\0';
	}

	// gold is a special case
	if(strcmp(item->ItemCode,"gld") == 0) {
		item->GoldSize = iPacket.GetField(1);
		if(item->GoldSize == ITEM_GOLDSIZE_12BIT) {
			item->GoldAmount = iPacket.GetField(12);
		} else {
			item->GoldAmount = iPacket.GetField(32);
		}
		item->ItemLevel = ITEM_UNSET;
		item->Ilvl = ITEM_UNSET;
		return item;
	}

	// more special cases need to look into properly decoding them
	if(strcmp(item->ItemCode,"ibk") == 0 ||
		strcmp(item->ItemCode,"tbk") == 0 ||
		strcmp(item->ItemCode,"key") == 0) {
		item->ItemLevel = ITEM_UNSET;
		item->Ilvl = ITEM_UNSET;
		return item;
	}
	

	// packet not long enough to read ItemLevel
	if(iPacket.pos + 14 >= iPacket.max) {
		// causes way to much spam
	/*	if(Debug == DEBUG_DEVEL) {
			server->GamePrintInfo("ParseItemDrop: Return before ItemLevel");
		}
		*/
		item->Ilvl = ITEM_UNSET;
		item->ItemLevel = ITEM_UNSET;
		return item;
	}

	item->ItemLevel = iPacket.GetField(4);
	item->Ilvl = iPacket.GetField(7);
	return item;
}

// from mousepad with some small mods
DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max) {
	// trying to read beyond the end of the packet

	if(pos + len > max) {

		// if we are already at or beyond the end of packet, return 0;
		if(pos >= max) {
			return 0;
		}
		// otherwise adjust len to all remaining bits
		len = max - pos;
	}

	return (DWORD)(*(unsigned __int64 *)(data+pos/8)<<(64-len-(pos&7))>>(64-len));
}