// pickit.cpp
// by Gayak (170@guyau.qc.ca)
// original program (0.82 and previous) by ackmed@gotwalls.com
#pragma once
#include <windows.h>

// defines
#define		ITEM_MESSAGEID_DROP				0x9C
	
#define		ITEM_ACTION_NEW_GROUND			0x00
#define		ITEM_ACTION_PICK_UP				0x01
#define		ITEM_ACTION_DROP				0x02
#define		ITEM_ACTION_OLD_GROUND			0x03
#define		ITEM_ACTION_PLACE_UNKNOWN		0x04 // cube? or inventory
#define		ITEM_ACTION_TO_STORE			0x0B //?
#define		ITEM_ACTION_FROM_STORE			0x0C
#define		ITEM_ACTION_PLACE_BELT			0x0E
	
#define		ITEM_ITEMTYPE_HELM				0x00
#define		ITEM_ITEMTYPE_ARMOR				0x01
#define		ITEM_ITEMTYPE_WEAPON			0x05
#define		ITEM_ITEMTYPE_BOW				0x06
#define		ITEM_ITEMTYPE_SHIELD			0x07
#define		ITEM_ITEMTYPE_EXPANSION			0x0A // heads
#define		ITEM_ITEMTYPE_OTHER				0x10

#define		ITEM_LOCAIION_STORED			0x00
#define		ITEM_LOCATION_WORN				0x01
#define		ITEM_LOCATION_BELT				0x02
#define		ITEM_LOCATION_GROUND			0x03
#define		ITEM_LOCATION_TOHAND			0x04

#define		ITEM_LEVEL_INFERIOR				0x01
#define		ITEM_LEVEL_NORMAL				0x02
#define		ITEM_LEVEL_SUPERIOR				0x03
#define		ITEM_LEVEL_MAGIC				0x04
#define		ITEM_LEVEL_SET					0x05
#define		ITEM_LEVEL_RARE					0x06
#define		ITEM_LEVEL_UNIQUE				0x07
#define		ITEM_LEVEL_CRAFT				0x08

#define		ITEM_INFERIORTYPE_CRUDE			0x00
#define		ITEM_INFERIORTYPE_CRACKED		0x01
#define		ITEM_INFERIORTYPE_DAMAGED		0x02
#define		ITEM_INFERIORTYPE_LOWQUALITY	0x04

#define		ITEM_SUPERIOR_AR				0x00 // attack rating
#define		ITEM_SUPERIOR_MAXDMG			0x01 // max damage
#define		ITEM_SUPERIOR_AC				0x02
#define		ITEM_SUPERIOR_AR_MAXDMG			0x03
#define		ITEM_SUPERIOR_DUR				0x04
#define		ITEM_SUPERIOR_DUR_AR			0x05
#define		ITEM_SUPERIOR_DUR_MAXDMG		0x06
#define		ITEM_SUPERIOR_DUR_AC			0x07

#define		ITEM_GOLDSIZE_12BIT				0x00
#define		ITEM_GOLDSIZE_32BIT				0x01

#define		ITEM_UNSET						0xFF
/*enum IBOOL {
	ITEM_FALSE = 0,
	ITEM_TRUE,
	ITEM_UNSET
}; */

// item struct
typedef struct ItemStruct_t {

	BYTE	MessageID;
	BYTE	Action;
	BYTE	MessageSize;
	BYTE	ItemType;
	DWORD	ItemID;
	
	// flags
	BOOL	isSocketsFull;
	BOOL	isIdentified;
	BOOL	isEthereal;
	BOOL	isSwitchin;
	BOOL	isSwitchout;
	BOOL	isBroken;
	BOOL	fromBelt;
	BOOL	hasSockets;
	BOOL	isJustGenerated;
	BOOL	isEar;
	BOOL	isStartitem;
	BOOL	isMiscItem;			// unverified
	BOOL	isPersonalized;
	BOOL	isGamble;
	BOOL	isRuneWord;			// unverified
	BOOL	isMagicExtra;		// unverified

	WORD	MPQVersionField;
	BYTE	Location;
	WORD	PositionX;
	WORD	PositionY;
	char	ItemCode[5];
	BYTE	ItemLevel;
	BYTE	Ilvl;

	// gold specific
	BOOL	GoldSize;
	DWORD	GoldAmount;

	//////////////////////////// CHECKS
	BOOL	DoNotTryWhenFull;
	
} ITEMSTRUCT;

// function definations
ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length);
DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max);

// from mousepad with some small mods
struct BitFields {
	BYTE *data;
	DWORD pos;
	DWORD max;
	BitFields(BYTE *d, DWORD mx) {
		data = d; 
		pos = 0; 
		max = (mx * 8);  // convert to max bits
	}
	DWORD GetField(DWORD len) {
		return GetBitField(data, (pos+=len)-len, len, max);
	}
};

