// stashcube.cpp
// by Gayak (170@guyau.qc.ca)
// Sources are ugly... Look at them only if you really want to!

#include "item.h"
#include "external/D2Hackit.h"
#include "external/D2Client.h"

// globals
char ConfigPath[_MAX_PATH];  // dir where to find pickit.ini
FUNCTIONENTRYPOINTS     *server;
THISGAMESTRUCT *thisgame;

BOOL PRIVATE OnCommandOpen(char **argv, int argc);

DWORD cubeid=0;
BOOL foundcube=FALSE;


// module info
DWORD   ModuleVersion=MAKELONG(1,0);
char    ModuleAuthor[]="Gayak";
char    ModuleWebsite[]="http://gayak.eha-l773.org";
char    ModuleDescription[]="stashcube module";
char    ModuleEmail[]="170@guyau.qc.ca";

// module commands
MODULECOMMANDSTRUCT ModuleCommands[]= {
        {       // The 'help' command is implemented in ClientCore.cpp and 
                // should not need to be changed.
                "help",OnGameCommandHelp,"helpc0 List commands available in this module.\n""<command> helpc0 Shows detailed help for <command> in this module."
        },
        {"open",OnCommandOpen,"openc0 Opens cube server-side even when it is in the stash."},
        {NULL}
};

BOOL PRIVATE OnCommandOpen(char **argv, int argc) {
	if (!foundcube){server->GamePrintInfo("c3The module didn't detect the cube id."); return true;}

	BYTE packet[13];
	packet[0]=0x20;
	memcpy(&packet[1],&cubeid,4);
	memcpy(&packet[5],&thisgame->player->PlayerPositionX,4);
	memcpy(&packet[9],&thisgame->player->PlayerPositionY,4);

	server->GamePrintInfo("c3Opening cube.");
	server->GameSendPacketToServer(packet,13);
    return true;
}

DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen) {
    ITEMSTRUCT *item;  

    // see if the packet is has the right messageID
    if (aPacket[0]==0x9c && aPacket[1]==0x04) {
        item = ParseItemDrop(aPacket+1,aLen-1);

        if(item==NULL) {return aLen;}
		
		if (item->ItemCode[0]=='b' && item->ItemCode[1]=='o' && item->ItemCode[2]=='x') {
			cubeid=item->ItemID;
			foundcube=TRUE;
		}
    }

    return aLen;
}


VOID EXPORT OnGameJoin(THISGAMESTRUCT* aThisgame) {
	thisgame = aThisgame;
}




// 
// stuff below here is from ClientCore.cpp
//////////////////////////////////////////////////////////////////////
// Dll entry/exit
//////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
        BOOL hResult = TRUE;
        char *t;
    switch (ul_reason_for_call)
        {
                case DLL_PROCESS_ATTACH:
                        
                        // Create server struct                 
                        server = new FUNCTIONENTRYPOINTS; 


                        // Bind exported functions from server
                        HMODULE hModule;
                        hModule = (HMODULE)GetModuleHandle("D2HackIt");
                        
                        // Macros make this look a lot nicer :)
                        BIND_TO_SERVER(GamePrintInfo);
                        BIND_TO_SERVER(GamePrintError);
                        BIND_TO_SERVER(GamePrintVerbose);
                        BIND_TO_SERVER(GamePrintString);
                        BIND_TO_SERVER(GameCommandLine);
                        BIND_TO_SERVER(GameSendPacketToServer);
                        BIND_TO_SERVER(GameSendPacketToGame);
                        BIND_TO_SERVER(GetFingerprint);
                        BIND_TO_SERVER(Intercept);
                        BIND_TO_SERVER(GetHackProfileString);
                        BIND_TO_SERVER(SetHackProfileString);
                        BIND_TO_SERVER(GetThisgameStruct);


                        // Get plugin path
                        t = ConfigPath;
                        if (GetModuleFileName((HINSTANCE)hModule, t, _MAX_PATH)) {
                                int p=strlen(ConfigPath);
                                while (p) {
                                                if (ConfigPath[p] == '\\')
                                                        { ConfigPath[p] = 0; p=0;}
                                                else
                                        p--;
                                }
                        }        
                        // initiate client
                        // hResult = OnClientStart();
                        break;


                case DLL_PROCESS_DETACH:
                        // kill client


                        // hResult = OnClientStop();


                        delete server;
                        break;
    } 
    return hResult;
}


//////////////////////////////////////////////////////////////////////
// Stubfunctions for 'property get' functions.
//////////////////////////////////////////////////////////////////////
LPCSTR  EXPORT GetModuleAuthor()                {return ModuleAuthor;}
LPCSTR  EXPORT GetModuleWebsite()               {return ModuleWebsite;}
DWORD   EXPORT GetModuleVersion()               {return ModuleVersion;}
LPCSTR  EXPORT GetModuleEmail()                 {return ModuleEmail;}
LPCSTR  EXPORT GetModuleDescription()   {return ModuleDescription;}


//////////////////////////////////////////////////////////////////////
// OnClientCommandLine
// -------------------------------------------------------------------
// The modules own extension of the command line interface. Any custom
// commands you add are parsed here.
//
// Return value should be TRUE, but it is not used at this 
// time.
//
// Arguments when we get here:
// argv[0]                      Name of module
// argv[1]                      Name of command (If supplied)
// argv[2 ... n]        The rest
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnGameCommandLine(char* argv[], int argc)
{
        // Check if user supplied anything at all, if not assume help...
        if (argc==1)
                argv[argc++]="help";



        MODULECOMMANDSTRUCT* mcs=ModuleCommands;


        while (mcs->szName) {
                if (!stricmp(mcs->szName, argv[1]))
                        break;
                mcs++;
        }


        char *p,*t,*msg,*fMsg;
        fMsg=new char[256];
        //
        // Is this a built-in function ?
        if (mcs->szName) {
                //
                // If functions returns false, show usage help
                if (!mcs->pFunc(argv, argc)) {
                        t=new char[strlen(mcs->szUsage)+1];
                        server->GamePrintInfo("Usage:");
                        sprintf((char*)t, "%s", mcs->szUsage);
                        if (strlen((char*)t))
                        {
                                msg=p=t;
                                while (*p != 0) {
                                        if (*p == '\n') 
                                        {
                                                *(p++) = 0;
                                                sprintf(fMsg, "c4.%s %s", argv[0], msg);
                                                server->GamePrintInfo((char*)fMsg);
                                        if (*p != 0)
                                                msg = p;
                                        } else
                                                p++;
                                        }
                                sprintf(fMsg, "c4.%s %s", argv[0], msg);
                                server->GamePrintInfo((char*)fMsg);
                        }
                        delete t;
                }
        } else {
        // Unknown command, show catch-all help phraze.
        t=new char[128];
        sprintf(t, "Unknown command c4'%s %s'c0 - try c4'.%s help'c0 to get help.",
                argv[0], argv[1], argv[0]);
        server->GamePrintError(t);
        delete t;
        }
        delete fMsg;
        return TRUE;
}



//////////////////////////////////////////////////////////////////////
// OnClientCommandHelp
// -------------------------------------------------------------------
// Our default help function.
//
// Syntax in the game: .<module> <arguments>
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandHelp(char** argv, int argc)
{
        // If command line is longer than 2, show usage for 'help'
        if (argc>2) return FALSE;


        char t[1024];
        sprintf(t, "Available commands for %s:", argv[0]);
        server->GamePrintInfo(t);


        // Loop through ModuleCommands[] and print their names
        for (int i=0; ModuleCommands[i].szName != NULL; i++)
        {
                sprintf(t, "c4.%s %s", argv[0], ModuleCommands[i].szName);
                server->GamePrintInfo(t);
        }


        sprintf(t, "For help on a specific command, type c4.%s <command> help", argv[0]);
        server->GamePrintInfo(t);
        return TRUE;
}


char *ReplaceString(char *source, char *old, char *newtext)
{
        char *original = new char[strlen(source)];
        strcpy(original, source);
        char *temp = new char[256];
        int old_length = strlen(old);
        int i, j, k, location = -1;
        for(i = 0; source[i] && (location == -1); ++i)
                for(j = i, k = 0; source[j] == old[k]; j++, k++)
                        if(!old[k+1])
                                location = i;
        if(location != -1)
        {
                for(j = 0; j < location; j++)
                        temp[j] = source[j];
                for(i = 0; newtext[i]; i++, j++)
                        temp[j] = newtext[i];
                for(k = location + old_length; source[k]; k++, j++)
                        temp[j] = source[k];
                temp[j] = NULL;
                for(i = 0; source[i] = temp[i]; i++);
        }       
        delete original;
        return temp;
}