/*
 *	WatchDog Module for D2Hackit
 *
 *	Copyright (c) 2002 Sherpya <sherpya@hotmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "../ClientCore.cpp"

///////////
extern "C" { DWORD EXPORT OnGameTimerTick(); }
BOOL PRIVATE OnGameCommandSet(char** argv, int argc);
BOOL PRIVATE OnGameCommandReset(char** argv, int argc);
BOOL PRIVATE OnGameCommandEnable(char** argv, int argc);
BOOL PRIVATE OnGameCommandDisable(char** argv, int argc);
BOOL PRIVATE OnGameCommandDebug(char** argv, int argc);

static int Timer_Max = 100;
static int Timer = 0;
static BOOL TimerEnabled = false;
static BOOL JoinEnabled = false;
static BOOL LeaveEnabled = false;
static char *Executable;
static char *Params; 
static char outstring[1024];

//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(0,1);
char	ModuleAuthor[]="sherpya";
char	ModuleWebsite[]="";
char	ModuleDescription[]="WatchDog Module";
char	ModuleEmail[]="sherpya@hotmail.com";

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
// To add your own commands, just add them to this list like:
//
//	{
//		"name"			// Name of the command
//		pFunction		// The function that handles command
//		"usage"			// Help text for the command
//	}
// 
// Functions should use following convention...
// BOOL PRIVATE OnGameCommandName(char** argv, int argc)
// ...and return TRUE on success or FALSE to show usage of the command.
//
// To use your commands in the game, just type 
// .modulename <command> [arguments]
//////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{
		"set",
		OnGameCommandSet,
		"set <timer> c0 Set Timer to n seconds."
	},
	{
		"enable",
		OnGameCommandEnable,
		"enablec0 Enable Timer."
	},
	{
		"disable",
		OnGameCommandDisable,
		"disablec0 Disable Timer."
	},
	{
		"reset",
		OnGameCommandReset,
		"resetc0 Reset Timer."
	},
	{
		"debug",
		OnGameCommandDebug,
		"debugc0 Show settings."
	},
	{NULL}	// No more commands
};

//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
// Runs *once* before client is loaded. Return FALSE to prevent from
// loading.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStart()
{

	char *retval;
	
	/* Exe */
	Executable=server->GetHackProfileString("watchdog", "Default", "Execute");
	if (Executable && strlen(Executable))
	{
		/* Params */
		Params=server->GetHackProfileString("watchdog", "Default", "Params");
		
		/* Timer */
		retval=server->GetHackProfileString("watchdog", "Default", "Timer");
		if (retval && strlen(retval))
		{
			int delay = atoi(retval);
			if ((delay < 1) || (delay > 900))
				server->GamePrintError("Delay must be between 1 and 900 seconds");
			else
			{
				Timer_Max = delay * 10;
				sprintf(outstring, "WatchDog Timer now is %d seconds", delay);
				server->GamePrintInfo(outstring);
			}
			
		}
		
		/* Leave Enabled */
		retval=server->GetHackProfileString("watchdog", "Default", "LeaveEnabled");
		if (retval && strlen(retval))
		{

			int lenabled = atoi(retval);
			if (lenabled)
				LeaveEnabled = true;
			else
				LeaveEnabled = false;
			
			
			/* Join Enabled */
			retval=server->GetHackProfileString("watchdog", "Default", "JoinEnabled");
			if (retval && strlen(retval))
			{
				int jenabled = atoi(retval);
				if (jenabled)
				{
					JoinEnabled = true;
					TimerEnabled = true;
				}
				else
				{
					JoinEnabled = false;
					TimerEnabled = false;
				}	
				
				
			}
			else
			{
				server->GamePrintError("Bad config Executable");
				TimerEnabled = false;
			}
			
			
		}
	}
	
	return true;
}


//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
// Runs *once* before client is unloaded. Return value should be TRUE,
// but it is not used at this time.
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStop()
{
	// Save delay
	sprintf(outstring, "%d", Timer_Max / 10);
	server->SetHackProfileString("watchdog", "Default", "Timer", outstring);
	TimerEnabled = false;	
	return true;
}


//////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// EVENTS
// -------------------------------------------------------------------
// The rest of this file are event functions, and they can safely be
// removed if the module makes no use of them.
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// OnGameJoin
// -------------------------------------------------------------------
// Executes when joining a game, and if loading the module while 
// inside a game.
//
// Refer to the documentation for the format of THISGAMESTRUCT.
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameJoin(THISGAMESTRUCT* thisgame)
{
	if (JoinEnabled)
		TimerEnabled = true;
	else
		TimerEnabled = false;
	return;
}

//////////////////////////////////////////////////////////////////////
// OnGameLeave
// -------------------------------------------------------------------
// Executes when leaving a game.
//
// Refer to the documentation for the format of THISGAMESTRUCT.
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameLeave(THISGAMESTRUCT* thisgame)
{
	if (LeaveEnabled)
		TimerEnabled = true;
	else
		TimerEnabled = false;
	return;
}


//////////////////////////////////////////////////////////////////////
// OnGameTimerTick
// -------------------------------------------------------------------
// This gets executed apx. every 1/10th of a second when in a game.
//
// You can use this to create custom timers.
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGameTimerTick(void)
{
	if (!TimerEnabled) return 0;

	if (Timer > Timer_Max)
	{
		/* Timer reached */ // Check if fails
		if (Executable && strlen(Executable))
			ShellExecute(NULL, "open", Executable, Params, NULL, SW_SHOWNORMAL);
		else
			TimerEnabled = false;
		Timer = 0;
	}
	else Timer++;

	return 0;
}

//////////////////////////////////////////////////////////////////////
// OnClientCommandSet
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandSet(char** argv, int argc)
{
	// If command line is shorter than 4 tokens, something is wrong
	if (argc<2) return false;
	int delay = atoi(argv[2]);
	if ((delay < 1) || (delay > 900))
		server->GamePrintError("Delay must be between 1 and 900 seconds");
	else
	{
		Timer_Max = delay * 10;
		sprintf(outstring, "WatchDog Timer now is %d seconds", delay);
		server->GamePrintInfo(outstring);
	}
	return true;
}

//////////////////////////////////////////////////////////////////////
// 
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandReset(char** argv, int argc)
{
	Timer = 0;
	server->GamePrintVerbose("WatchDog restarts");
	return true;
}

//////////////////////////////////////////////////////////////////////
// 
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandEnable(char** argv, int argc)
{
	TimerEnabled = true;
	server->GamePrintInfo("WatchDog Enabled");
	return true;
}
//////////////////////////////////////////////////////////////////////
// 
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandDisable(char** argv, int argc)
{
	TimerEnabled = false;
	Timer = 0;
	server->GamePrintInfo("WatchDog Disabled");
	return true;
}

BOOL PRIVATE OnGameCommandDebug(char** argv, int argc)
{
	server->GamePrintInfo("WatchDog Config");

	sprintf(outstring, "Timer Enabled = %d\n", TimerEnabled);
	server->GamePrintInfo(outstring);

	sprintf(outstring, "Timer JoinEnabled = %d\n", JoinEnabled);
	server->GamePrintInfo(outstring);

	sprintf(outstring, "Timer LeaveEnabled = %d\n", LeaveEnabled);
	server->GamePrintInfo(outstring);

	sprintf(outstring, "Timer Now (%d) = %d\n", Timer, Timer/10);
	server->GamePrintInfo(outstring);

	sprintf(outstring, "Timer Max = %d (%d)\n", Timer_Max, Timer_Max/10);
	server->GamePrintInfo(outstring);

	sprintf(outstring, "Exe = %s\n", Executable);
	server->GamePrintInfo(outstring);

	sprintf(outstring, "Params = %s\n", Params);
	server->GamePrintInfo(outstring);

	return true;
}
