#include "automation.h"
#include "logging.h"
#include "util.h"
#include "external/LinkedList/linkedlist.h"

// all screen X, Y coordinates passed to these functions must be relative 
// to FULLSCREEN mode
//
// Thanks to Gayak for the click functions
/*
int keydelay = 20;
BOOL fAccessingMq = FALSE;
BOOL fQueueing = FALSE;

KEYTABLE KeyTable[NUM_KEY_ENTRIES] = {
	"NUMPADSUB", VK_SUBTRACT,
	"TAB", VK_TAB,
	"ENTER", VK_RETURN,
	"ESC", VK_ESCAPE,
	"SPACE", ' ',
	"!", '!',
	"UP", VK_UP,
	"DOWN", VK_DOWN,
	"F1", VK_F1,
	"F2", VK_F2,
	"F3", VK_F3,
	"F4", VK_F4,
	"F5", VK_F5,
	"F6", VK_F6,
	"F7", VK_F7,
	"F8", VK_F8,
	"F9", VK_F9,
	"F10", VK_F10,
	"F11", VK_F11,
	"F12", VK_F12 };

VOID SetKeyDelay(int d) {
	keydelay = d;
	return; }

// FIXME: this should be generalized and moved to util.cpp
char tablelookup(char *k) {
	for (int i = 0; i < NUM_KEY_ENTRIES; i++) {
		if (!strcmp(k, KeyTable[i].string)) {
			return KeyTable[i].code; } }
	return FALSE; }

VOID EnQueue(MESSAGE *message) {
	while (fQueueing) {}
	fQueueing = TRUE;
	BOOL fAccessingMqOld = fAccessingMq;
	fAccessingMq = TRUE;
	mq->AddItem(message);
	fAccessingMq = fAccessingMqOld;
	fQueueing = FALSE; }

VOID SendString(char *string) {
	char SendStringBuf[64], keyname[64];
	int result = 0;
	int repeat = 1;
	
	for (int i = 0; i < strlen(string) && string[i] != '\0'; i++) {
		repeat = 1;
		int named = 0;
		
		switch (string[i]) {
		case '{':
			named = 1;
			sscanf(string+i+1, "%[^}]s", SendStringBuf);
			i += strlen(SendStringBuf) + 1;
			
			if (IsIn(' ', SendStringBuf)) {
				sscanf(SendStringBuf, "%s %d", keyname, &repeat); }
			else {
				strcpy(keyname, SendStringBuf); }
			
			if (strlen(keyname) == 1) {
				result = keyname[0]; }
			else {
				result = tablelookup(keyname); }
			
			break;
		default:
			result = string[i];
			break; }
		
		if (result != 0 && repeat > 0) {
			MESSAGE *message = new MESSAGE;
			message->Type = MESSAGE_KEY;
			if (named) {
				strcpy(message->KeyName, keyname); }
			else {
				strcpy(message->KeyName, ""); }
			memcpy(&message->KeyCode, &result, sizeof(int));
			memcpy(&message->Repeat, &repeat, sizeof(int));
			EnQueue(message); } } }

VOID PRIVATE RightClick(int x, int y) {
	//x += 3 * fWindowed;
	//y += 21 * fWindowed;
	MESSAGE *message = new MESSAGE;
	message->Type = MESSAGE_CLICK;
	message->Button = BUTTON_RIGHT;
	message->x = x;
	message->y = y;
	EnQueue(message); }

VOID PRIVATE LeftClick(int x, int y) {
	//x += 3 * fWindowed;
	//y += 21 * fWindowed;
	MESSAGE *message = new MESSAGE;
	message->Type = MESSAGE_CLICK;
	message->Button = BUTTON_LEFT;
	message->x = x;
	message->y = y;
	EnQueue(message); }
*/
VOID PRIVATE SendPacketToServer(LPBYTE aMsg, DWORD aLen) {
//	MESSAGE *message = new MESSAGE;
//	message->Type = MESSAGE_PACKET;
//	memcpy(message->PacketData, aMsg, aLen);
//	message->len = aLen;
//	EnQueue(message); }
	server->GameSendPacketToServer(aMsg, aLen); }
/*
VOID PRIVATE Pause(WORD length) {			// length in milliseconds
	MESSAGE *message = new MESSAGE;
	message->Type = MESSAGE_PAUSE;
	memcpy(&message->Pause, &length, sizeof(WORD));
	EnQueue(message); }

DWORD WINAPI ThreadProc(LPVOID lpParameter) {
    THREAD_DATA *td = (THREAD_DATA *)lpParameter;
	HWND h = td->hD2Window;
	LinkedItem *linkeditem;
	MESSAGE *message;
	int MaxLenMq = 0;

	//dprintf(DEBUG_AUTOMATION, "ThreadProc: entered ThreadProc");
	while (td->Active) {
		if (!fAccessingMq && (linkeditem = mq->GetFirstItem())) {
			fAccessingMq = 1;
			message = (MESSAGE *)linkeditem->lpData;
			Sleep(keydelay);
			if (mq->GetItemCount() > MaxLenMq) {
				MaxLenMq = mq->GetItemCount(); }
			switch (message->Type) {
				
			case MESSAGE_KEY: {
					int key = message->KeyCode;
					char keybuf[5];
					sprintf(keybuf, "%c", key);
					short vk = VkKeyScan(keybuf[0]) & 0xFF;
					if (strlen(message->KeyName) > 1) {
						vk = message->KeyCode; }
					short shiftkey = VkKeyScan(keybuf[0]) & 256;
					char oemchar[3] = "  ";				// 2 character buffer
					CharToOem(keybuf, &oemchar[0]);
					DWORD scan = OemKeyScan(oemchar[0]) & 0xFF;
					int upperkey = isalpha(key) ? toupper(key) : key;
					DWORD scancode = (MapVirtualKey(key, 0) << 16);
					for (int j = 0; j < message->Repeat; j++) {
						char *keybuf = new char[3];
						if (key == VK_RETURN || key == VK_ESCAPE) {
							// FIXME
							Sleep(50); }
						// FIXME:
						// shift up/down is not working, at least D2 doesn't see it
						if (isalpha(key) && isupper(key)) {
							PostMessage(h, WM_KEYDOWN, 0x00000010, 0x002a0001); }
						PostMessage(h, WM_KEYDOWN, (WPARAM)vk, (LPARAM)(scan | 0x00000001));
						//PostMessage(h, WM_CHAR, (WPARAM)key, (LPARAM)(scan | 0x00000001));
						PostMessage(h, WM_KEYUP, (WPARAM)vk, (LPARAM)(scan | 0xC0000001));
						if (isalpha(key) && isupper(key)) {
							PostMessage(h, WM_KEYUP, 0x00000010, 0xc02a0001); }
						if (key == VK_RETURN || key == VK_ESCAPE) {
							// FIXME
							Sleep(50); } }
				break; }

			case MESSAGE_CLICK: {
				int pos = ((short)message->y << 16) + (short)message->x;
				WPARAM down = (message->Button == BUTTON_RIGHT ? WM_RBUTTONDOWN : WM_LBUTTONDOWN);
				WPARAM up = (message->Button == BUTTON_RIGHT ? WM_RBUTTONUP : WM_LBUTTONUP);
				LPARAM mk = (message->Button == BUTTON_RIGHT ? MK_RBUTTON : MK_LBUTTON);
				PostMessage(h, WM_MOUSEMOVE, NULL, pos); Sleep(20);
				PostMessage(h, down, mk, (LPARAM)pos); Sleep(10);
				PostMessage(h, up, NULL, (LPARAM)pos); Sleep(10);
				// FIXME
				Sleep(50);
				break; }
				
			case MESSAGE_PACKET: {
				server->GameSendPacketToServer(message->PacketData, message->len);
				break; }

			case MESSAGE_PAUSE: {
				Sleep(message->Pause);
				break; }
				
			default: {
				break; } }
			
			mq->RemoveItem(linkeditem);
			fAccessingMq = 0; }
		else { 
			// FIXME
			Sleep(1); } }

	return 0; }

*/

/*
WM_KEYDOWN nVirtKey:'Q'  [wParam:00000051 lParam:00100001]
WM_CHAR chCharCode:'q' (113)  [wParam:00000071 lParam:00100001]
WM_KEYUP nVirtKey:'Q'  [wParam:00000051 lParam:C0100001]

WM_KEYDOWN nVirtKey:VK_SHIFT  [wParam:00000010 lParam:002A0001]
WM_KEYDOWN nVirtKey:'Q'  [wParam:00000051 lParam:00100001]
WM_CHAR chCharCode:'Q' (81)  [wParam:00000051 lParam:00100001]
WM_KEYUP nVirtKey:'Q'  [wParam:00000051 lParam:C0100001]
WM_KEYUP nVirtKey:VK_SHIFT  [wParam:00000010 lParam:C02A0001]
*/

/*
WM_LBUTTONDOWN fwKeys:MK_LBUTTON xPos:16 yPos:169 [wParam:00000001 lParam:00A90010]
WM_LBUTTONUP fwKeys:0000 xPos:16 yPos:169 [wParam:00000000 lParam:00A90010]
*/
