#include "util.h"
#include "dijkstra.h"
#include "mephbot.h"

class Vertex {
public:
	int Adjacent[MAX];				// adjacent vertices
	int NumAdjacencies;				// # of adjacent vertices
	double AdjacencyWeight[MAX];	// weights of adjacent vertices
	
	// these two will be undefined until dijkstra() is called
	int Previous;					// previous hop on path from source
	double Cost;					// Cost to here from source
	
	Vertex() {
		NumAdjacencies = 0; }

	void push(int neighbor, double Cost) {
		Adjacent[NumAdjacencies] = neighbor;
		AdjacencyWeight[NumAdjacencies] = Cost;
		NumAdjacencies++; } };

void dijkstra(Vertex *v, int size, int source) {
	double Cost[MAX];
	int done[MAX];
	int to_do = size;
	int i;
	for (i = 0; i < size; i++) {
		v[i].Cost = Cost[i] = INFINITY; v[i].Previous = -1; done[i] = 0; }
	Cost[source] = 0;
	while (to_do) {
		int iMin;
		for (i = 0; i < size; i++) {
			if (!done[i]) {
				iMin=i;
				break; } }
		for (i = iMin + 1; i < size; i++)
			if (!done[i] && Cost[i] < Cost[iMin]) {
				iMin = i; }
			done[iMin] = 1;
			to_do--;
			for (i = 0; i < v[iMin].NumAdjacencies; i++)
				if (Cost[iMin] + v[iMin].AdjacencyWeight[i] < Cost[v[iMin].Adjacent[i]]) {
					v[v[iMin].Adjacent[i]].Previous = iMin;
					v[v[iMin].Adjacent[i]].Cost = Cost[v[iMin].Adjacent[i]] =
						Cost[iMin] + v[iMin].AdjacencyWeight[i]; } } }

myPOINT Points[MAX];
int PointsIndex = 2;		// start at 2 to avoid PLAYER and STAIRS

WORD PortalPath[MAX][2];
int PortalPathIndex = 0;
int HopsToPortal = 0;

VOID CreatePath(Vertex *v, int source, int dest) {
	if (source == dest) {
		PortalPath[PortalPathIndex][0] = Points[dest].x;
		PortalPath[PortalPathIndex][1] = Points[dest].y;
		PortalPathIndex++; }
	else {
		if (v[dest].Previous != -1) {
			CreatePath(v, source, v[dest].Previous);
			PortalPath[PortalPathIndex][0] = Points[dest].x;
			PortalPath[PortalPathIndex][1] = Points[dest].y;
			PortalPathIndex++; }
		else {
			Tick1 = 0;} }
}

VOID FindPortalPath(VOID) {
	Vertex v[MAX];
	DWORD d;
	
	Points[PLAYER].x = PLAYERX;
	Points[PLAYER].y = PLAYERY;
	Points[PORTAL].x = PortalX;
	Points[PORTAL].y = PortalY;

	// Create the graph
	
	for (int i = 0; i < PointsIndex; i++) {
		for (int j = 0; j < PointsIndex; j++) {
			if (i != j) {
				d = Dist2(Points[i].x, Points[i].y, Points[j].x, Points[j].y);
				//dprintf(DEBUG_DIJKSTRA, "d = %d", (int)sqrt((double)d));
				if (d <= (DWORD)(2 * 60 * 60) /*&& (Points[i].x == Points[j].x || Points[i].y == Points[j].y)*/) {
					//dprintf(DEBUG_DIJKSTRA, "adding arc to %d (%.4X, %.4X) to Vertex %d (%.4X, %.4X)", j, Points[j].x, Points[j].y, i, Points[i].x, Points[i].y);
					v[i].push(j, sqrt((double)d)); } } } }
	
	dijkstra(v, PointsIndex, PLAYER);
	PortalPathIndex = 0;
	CreatePath(v, PLAYER, PORTAL);
	HopsToPortal = PortalPathIndex; 
}
